/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.a;
import com.rscja.deviceapi.b;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;

public class RFIDWithUHF706
extends a {
    private static RFIDWithUHF706 a = null;
    protected b config = b.e();

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.a();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHF706 getInstance() throws ConfigurationException {
        if (a != null) return a;
        Class<RFIDWithUHF706> clazz = RFIDWithUHF706.class;
        synchronized (RFIDWithUHF706.class) {
            if (a != null) return a;
            a = new RFIDWithUHF706();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    private RFIDWithUHF706() throws ConfigurationException {
    }

    public synchronized boolean init() {
        int n = this.getDeviceAPI().UHFInit(this.config.k());
        if (n >= 0) {
            n = this.getDeviceAPI().UHF706_OpenAndConnect(this.config.l());
            if (n >= 0) {
                this.setPowerOn(true);
                return true;
            }
            Log.e((String)"RFIDWithUHF706", (String)("init() err UHF706_OpenAndConnect result:" + n));
        } else {
            Log.e((String)"RFIDWithUHF706", (String)("init() err UHFInit result:" + n));
        }
        return false;
    }

    public synchronized boolean free() {
        this.getDeviceAPI().UHF706_CloseAndDisconnect();
        int n = this.getDeviceAPI().UHFFree(this.config.k());
        if (n == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)"RFIDWithUHF706", (String)("free() err UHFFree result:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int setRTC(long time) {
        void var1_1;
        return this.getDeviceAPI().Config_SetRTC(StringUtility.long2Bytes((long)var1_1));
    }

    public long getRTC() {
        byte[] byArray = this.getDeviceAPI().Config_ReadRTC();
        if (byArray[0] != 0) {
            Log.e((String)"RFIDWithUHF706", (String)("getRTC() err result[0]:" + byArray[0]));
            return -1L;
        }
        byte[] byArray2 = new byte[8];
        int n = 0;
        while (n < 8) {
            byArray2[n] = byArray[8 - n];
            ++n;
        }
        return StringUtility.byteArrayTolong(byArray2);
    }

    /*
     * WARNING - void declaration
     */
    public int setPara(int type, byte[] data) {
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Config_SetPara((int)var1_1, (byte)data.length, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getPara(int type) {
        void var1_1;
        return this.getDeviceAPI().Config_GetPara((int)var1_1);
    }

    public byte[] getAccess() {
        return this.getDeviceAPI().Config_GetAccess();
    }

    /*
     * WARNING - void declaration
     */
    public int setWorkMode(int nums, byte[] modebuf) {
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Config_SetWorkMode((byte)var1_1, (byte[])var2_2);
    }

    public int SetTestMode() {
        return this.getDeviceAPI().SetTestMode();
    }

    public byte[] requestRandom() {
        byte[] byArray = this.getDeviceAPI().Auth_RequestRandom();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[8];
            int n = 0;
            while (n < 8) {
                byArray2[n] = byArray[n + 1];
                ++n;
            }
            return byArray2;
        }
        Log.e((String)"RFIDWithUHF706", (String)("requestRandom() result = " + byArray[0]));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int sendAuthData(byte[] hrandom, byte[] srandom, byte[] devid, byte[] reserve, byte[] signature, byte[] certbuf) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Auth_SendData((byte[])var1_1, (byte[])var2_2, (byte[])var3_3, reserve, signature, certbuf.length, certbuf);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] sendUserInfo(byte[] province, byte[] city, byte[] jw, byte[] usage, byte[] type1, byte[] com_name, byte[] people, byte[] tel1, byte[] tel2, byte[] email, byte[] data, byte[] ps) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Auth_UserInfo((byte[])var1_1, (byte[])var2_2, (byte[])var3_3, usage, type1, com_name, people, tel1, tel2, email, data, ps);
    }

    /*
     * WARNING - void declaration
     */
    public int sendActiveFile(byte transmode, byte[] deviceid, byte[] reverse, byte[] transbuf) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Auth_ActiveFile((byte)var1_1, (byte[])var2_2, (byte[])var3_3, transbuf);
    }

    public byte[] readInfo() {
        return this.getDeviceAPI().Update_ReadInfo();
    }

    /*
     * WARNING - void declaration
     */
    public int requsetReadPart(byte speed, byte des, byte flag, byte partnum, byte ptr, byte len) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Requset_ReadPart((byte)var1_1, (byte)var2_2, (byte)var3_3, partnum, ptr, len);
    }

    /*
     * WARNING - void declaration
     */
    public int requsetWritePart(byte[] tid, byte num, byte startaddr, byte[] buf) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().Requset_WritePart((byte[])var1_1, (byte)var2_2, (byte)var3_3, (byte)buf.length, buf);
    }

    /*
     * WARNING - void declaration
     */
    public int writeSpecialPart(byte[] buf) {
        void var1_1;
        return this.getDeviceAPI().Request_WriteSpecialPart(buf.length, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] TransBuf(byte oper, byte[] buf) {
        void var2_2;
        void var1_1;
        return this.getDeviceAPI().TransBuf((byte)var1_1, buf.length, (byte[])var2_2);
    }

    public int configPower() {
        return this.getDeviceAPI().SetConfig();
    }

    public int SetInventorySper() {
        return this.getDeviceAPI().SetInventorySper();
    }

    public int EventReport() {
        return this.getDeviceAPI().EventReport();
    }
}

