/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.utility;

import android.util.Log;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class StringUtility {
    public static String byte2Bit(byte b2) {
        byte by;
        return "" + (byte)(b2 >> 7 & 1) + (byte)(b2 >> 6 & 1) + (byte)(b2 >> 5 & 1) + (byte)(b2 >> 4 & 1) + (byte)(b2 >> 3 & 1) + (byte)(b2 >> 2 & 1) + (byte)(b2 >> 1 & 1) + (byte)(by & 1);
    }

    public static byte BitToByte(String byteStr) {
        String string;
        if (byteStr == null) {
            return 0;
        }
        int n = byteStr.length();
        if (n != 4 && n != 8) {
            return 0;
        }
        int n2 = n == 8 && byteStr.charAt(0) != '0' ? Integer.parseInt(byteStr, 2) - 256 : Integer.parseInt(string, 2);
        return (byte)n2;
    }

    public static String bytes2HexString(byte[] b2, int size) {
        String string = "";
        try {
            int n = 0;
            while (n < size) {
                String string2 = Integer.toHexString(b2[n] & 0xFF);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = String.valueOf(string) + string2.toUpperCase();
                ++n;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String bytesToHexString(byte[] b2, int size) {
        String string = "";
        try {
            int n = 0;
            while (n < size) {
                String string2 = StringUtility.byte2HexString(b2[n]);
                string = String.valueOf(string) + string2;
                ++n;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String byte2HexString(byte b2) {
        String string = "";
        try {
            byte by;
            String string2 = Integer.toHexString(by & 0xFF);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            string = String.valueOf(string) + string2.toUpperCase();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String chars2HexString(char[] c2, int size) {
        String string = "";
        try {
            int n = 0;
            int n2 = 0;
            while (n2 < size) {
                n = c2[n2];
                String string2 = Integer.toHexString(n);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = String.valueOf(string) + string2.toUpperCase();
                ++n2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static byte[] long2Bytes(long num) {
        byte[] byArray = new byte[8];
        int n = 0;
        while (n < 8) {
            int n2 = 64 - (n + 1 << 3);
            byArray[n] = (byte)(num >> n2 & 0xFFL);
            ++n;
        }
        return byArray;
    }

    public static byte[] int2Bytes(int num) {
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            int n2 = 32 - (n + 1 << 3);
            byArray[n] = (byte)(num >> n2);
            ++n;
        }
        return byArray;
    }

    public static long byteArrayTolong(byte[] byteArray) {
        byte[] byArray = new byte[8];
        int n = byArray.length - 1;
        int n2 = byteArray.length - 1;
        while (n >= 0) {
            byArray[n] = n2 >= 0 ? byteArray[n2] : (byte)0;
            --n;
            --n2;
        }
        long l = (long)(byArray[0] & 0xFF) << 56;
        long l2 = (long)(byArray[1] & 0xFF) << 48;
        long l3 = (long)(byArray[2] & 0xFF) << 40;
        long l4 = (long)(byArray[3] & 0xFF) << 32;
        long l5 = (long)(byArray[4] & 0xFF) << 24;
        long l6 = (long)(byArray[5] & 0xFF) << 16;
        long l7 = (long)(byArray[6] & 0xFF) << 8;
        long l8 = byArray[7] & 0xFF;
        return l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
    }

    public static int bytesToInt(byte[] bytes) {
        byte[] byArray;
        int n = bytes[0] & 0xFF;
        n |= bytes[1] << 8 & 0xFF00;
        n |= bytes[2] << 16 & 0xFF0000;
        return n |= byArray[3] << 24 & 0xFF000000;
    }

    public static long charArrayTolong(char[] array) {
        char[] cArray = new char[8];
        int n = cArray.length - 1;
        int n2 = array.length - 1;
        while (n >= 0) {
            cArray[n] = n2 >= 0 ? array[n2] : (char)'\u0000';
            --n;
            --n2;
        }
        long l = (long)(cArray[0] & 0xFF) << 56;
        long l2 = (long)(cArray[1] & 0xFF) << 48;
        long l3 = (long)(cArray[2] & 0xFF) << 40;
        long l4 = (long)(cArray[3] & 0xFF) << 32;
        long l5 = (long)(cArray[4] & 0xFF) << 24;
        long l6 = (long)(cArray[5] & 0xFF) << 16;
        long l7 = (long)(cArray[6] & 0xFF) << 8;
        long l8 = cArray[7] & 0xFF;
        Log.i((String)"StringUtility", (String)(l + "@" + l2 + "@" + l3 + "@" + l4 + "@" + l5 + "@" + l6 + "@" + l7 + "@" + l8));
        return l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
    }

    public static byte[] reverse(byte[] b2) {
        byte[] byArray = new byte[b2.length];
        int n = 0;
        while (n < b2.length) {
            byArray[n] = b2[b2.length - 1 - n];
            ++n;
        }
        return byArray;
    }

    public static final BigInteger readUnsignedInt64(byte[] readBuffer) throws IOException {
        byte[] byArray;
        if (readBuffer == null || readBuffer.length < 8) {
            return new BigInteger("0");
        }
        byte[] byArray2 = new byte[9];
        byte[] byArray3 = byArray2;
        byArray2[8] = 0;
        System.arraycopy(byArray, 0, byArray3, 0, 8);
        return new BigInteger(StringUtility.reverse(byArray3));
    }

    public static long chars2Long(char[] c2, int n, int n2) {
        Object[] objectArray = StringUtility.getBytes(c2);
        n = 0;
        while (n < objectArray.length) {
            Log.i((String)"StringUtility", (String)("chars2Long bytes[i]:" + objectArray[n]));
            ++n;
        }
        return StringUtility.byteArrayTolong((byte[])objectArray);
    }

    public static String char2HexString(char c2) {
        char c3;
        char[] cArray = new char[1];
        char[] cArray2 = cArray;
        cArray[0] = c3;
        return StringUtility.chars2HexString(cArray2, 1);
    }

    public static boolean isOctNumber(String str) {
        boolean bl = false;
        int n = 0;
        int n2 = str.length();
        while (n < n2) {
            char c2 = str.charAt(n);
            if (c2 == '0' | c2 == '1' | c2 == '2' | c2 == '3' | c2 == '4' | c2 == '5' | c2 == '6' | c2 == '7' | c2 == '8' | c2 == '9') {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    @Deprecated
    public static boolean isHexNumber(String str) {
        boolean bl = false;
        int n = 0;
        while (n < str.length()) {
            char c2 = str.charAt(n);
            if (c2 == '0' || c2 == '1' || c2 == '2' || c2 == '3' || c2 == '4' || c2 == '5' || c2 == '6' || c2 == '7' || c2 == '8' || c2 == '9' || c2 == 'A' || c2 == 'B' || c2 == 'C' || c2 == 'D' || c2 == 'E' || c2 == 'F' || c2 == 'a' || c2 == 'b' || c2 == 'c' || c2 == 'c' || c2 == 'd' || c2 == 'e' || c2 == 'f') {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public static boolean isOctNumberRex(String str) {
        String string;
        String string2 = "\\d+";
        return string.matches(string2);
    }

    public static boolean isHexNumberRex(String str) {
        String string;
        String string2 = "(?i)[0-9a-f]+";
        return string.matches(string2);
    }

    public static char[] hexString2Chars(String s) {
        s = s.replace(" ", "");
        char[] cArray = new char[s.length() / 2];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = (char)Integer.parseInt(s.substring(2 * n, 2 * n + 2), 16);
            ++n;
        }
        return cArray;
    }

    public static byte[] getBytes(char[] chars) {
        Object object;
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = CharBuffer.allocate(chars.length);
        charBuffer.put((char[])object);
        charBuffer.flip();
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        object = byteBuffer;
        return byteBuffer.array();
    }

    public static char[] getChars(byte[] bytes) {
        Object object;
        Charset charset = Charset.forName("UTF-8");
        ByteBuffer byteBuffer = ByteBuffer.allocate(bytes.length);
        byteBuffer.put((byte[])object);
        byteBuffer.flip();
        CharBuffer charBuffer = charset.decode(byteBuffer);
        object = charBuffer;
        return charBuffer.array();
    }

    public static boolean isDecimal(String decimal) {
        int n = decimal.length();
        int n2 = 0;
        while (n2 < n) {
            char c2;
            if ((c2 = decimal.charAt(n2++)) >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public static byte[] hexString2Bytes(String s) {
        byte[] byArray = new byte[s.length() / 2];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)Integer.parseInt(s.substring(2 * n, 2 * n + 2), 16);
            ++n;
        }
        return byArray;
    }

    public static byte[] hexStringToBytes(String hexString) {
        Object object;
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int n = hexString.length() / 2;
        object = ((String)object).toCharArray();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 << 1;
            byArray[n2] = (byte)(StringUtility.a((char)object[n3]) << 4 | StringUtility.a((char)object[n3 + 1]));
            ++n2;
        }
        return byArray;
    }

    private static byte a(char c2) {
        return (byte)"0123456789ABCDEF".indexOf(c2);
    }

    public static boolean isEmpty(CharSequence cs) {
        CharSequence charSequence;
        return cs == null || charSequence.length() == 0;
    }

    public static boolean isNum(String str) {
        return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public static String int2HexString(int n) {
        String string = Integer.toHexString(n);
        int n2 = string.length();
        if (n2 == 1) {
            return "0" + string;
        }
        return string.substring(n2 - 2, n2);
    }

    public static String ints2HexString(int[] c2, int size) {
        String string = "";
        try {
            int n = 0;
            int n2 = 0;
            while (n2 < size) {
                n = c2[n2];
                String string2 = Integer.toHexString(n);
                if (string2.length() == 1) {
                    string2 = "0" + string2;
                }
                string = String.valueOf(string) + string2.toUpperCase();
                ++n2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static int string2Int(String str, int defValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            void var1_1;
            return (int)var1_1;
        }
    }
}

