/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.adc.decoder;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import com.rscja.deviceapi.ScanerLedLight;
import com.zebra.adc.decoder.BarCodeReader;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Barcode2DWithSoft {
    private static final String TAG = Barcode2DWithSoft.class.getSimpleName();
    private BarCodeReader bcr = null;
    private AtomicBoolean isIdle = new AtomicBoolean(true);
    protected boolean powerOn = false;
    private static Barcode2DWithSoft single;

    static {
        System.loadLibrary("IAL");
        System.loadLibrary("SDL");
        if (Build.VERSION.SDK_INT >= 19) {
            System.loadLibrary("barcodereader44");
        } else if (Build.VERSION.SDK_INT >= 18) {
            System.loadLibrary("barcodereader43");
        } else {
            System.loadLibrary("barcodereader");
        }
        single = null;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    /*
     * WARNING - void declaration
     */
    protected void setPowerOn(boolean on) {
        void var1_1;
        this.powerOn = var1_1;
    }

    private Barcode2DWithSoft() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Barcode2DWithSoft getInstance() {
        if (single != null) return single;
        Class<Barcode2DWithSoft> clazz = Barcode2DWithSoft.class;
        synchronized (Barcode2DWithSoft.class) {
            if (single != null) return single;
            single = new Barcode2DWithSoft();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean open(Context context) {
        block8: {
            void var1_1;
            block7: {
                try {
                    if (Build.VERSION.SDK_INT < 21) break block7;
                    Thread.currentThread();
                    Thread.sleep(500L);
                    int n = Barcode2DWithSoft.getScannerIdFromCamera2(context);
                    try {
                        this.bcr = BarCodeReader.open(n, context);
                        break block8;
                    }
                    catch (Exception exception) {
                        context = exception;
                        exception.printStackTrace();
                        return false;
                    }
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                    return false;
                }
            }
            this.bcr = Build.VERSION.SDK_INT >= 18 ? BarCodeReader.open((Context)var1_1) : BarCodeReader.open();
        }
        if (this.bcr == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.bcr.setParameter(765, 0);
        }
        Log.i((String)TAG, (String)"open() succ");
        ScanerLedLight.getInstance().init();
        this.isIdle.set(true);
        this.setPowerOn(true);
        return true;
    }

    public static int getScannerIdFromCamera(Context context) {
        int n = 0;
        try {
            n = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        Log.d((String)"getScannerIdFromCamera", (String)("all bcr Number=" + n));
        int n2 = -1;
        boolean bl = false;
        String string = "picture-size-values=752x480,720x480,640x480,352x288,320x240,176x144,160x120;preferred-preview-size-for-video=752x480;preview-size=752x480;preview-size-values=752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;raw-size=752x480;supported-live-snapshot-sizes=752x480,720x480,640x480,352x288,320x240,176x144,160x120;video-size=752x480;video-size-values=752x480,720x480,640x480,480x360,352x288,320x240,176x144,160x120";
        BarCodeReader.Parameters parameters = null;
        BarCodeReader barCodeReader = null;
        int n3 = 0;
        while (n3 < n) {
            try {
                barCodeReader = BarCodeReader.open(n3, context);
            }
            catch (Exception exception) {
                Exception exception3 = exception;
                exception.printStackTrace();
            }
            if (barCodeReader != null) {
                if (parameters == null) {
                    parameters = barCodeReader.getParametersFromString(string);
                }
                BarCodeReader.Parameters parameters2 = barCodeReader.getParameters();
                boolean bl2 = parameters.get("picture-size-values").equals(parameters2.get("picture-size-values")) && parameters.get("preferred-preview-size-for-video").equals(parameters2.get("preferred-preview-size-for-video")) && parameters.get("preview-size").equals(parameters2.get("preview-size")) && parameters.get("preview-size-values").equals(parameters2.get("preview-size-values")) && parameters.get("raw-size").equals(parameters2.get("raw-size")) && parameters.get("supported-live-snapshot-sizes").equals(parameters2.get("supported-live-snapshot-sizes")) && parameters.get("video-size").equals(parameters2.get("video-size")) && parameters.get("video-size-values").equals(parameters2.get("video-size-values"));
                if (bl2) {
                    n2 = n3;
                }
                barCodeReader.release();
            }
            ++n3;
        }
        Log.d((String)"getScannerIdFromCamera", (String)(" scannerid=" + n2));
        return n2;
    }

    public static int getScannerIdFromCamera2(Context context) {
        int n = 0;
        try {
            n = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        Log.d((String)"getScannerIdFromCamera2", (String)("all bcr Number=" + n));
        int n2 = -1;
        boolean bl = false;
        String string = "picture-size-values=752x480,720x480,640x480,352x288,320x240,176x144,160x120;preferred-preview-size-for-video=752x480;preview-size=752x480;preview-size-values=752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;raw-size=752x480;supported-live-snapshot-sizes=752x480,720x480,640x480,352x288,320x240,176x144,160x120;video-size=752x480;video-size-values=752x480,720x480,640x480,480x360,352x288,320x240,176x144,160x120";
        BarCodeReader.Parameters parameters = null;
        BarCodeReader barCodeReader = null;
        --n;
        while (n >= 0) {
            try {
                barCodeReader = BarCodeReader.open(n, context);
            }
            catch (Exception exception) {
                Exception exception3 = exception;
                exception.printStackTrace();
            }
            if (barCodeReader != null) {
                if (parameters == null) {
                    parameters = barCodeReader.getParametersFromString(string);
                }
                BarCodeReader.Parameters parameters2 = barCodeReader.getParameters();
                boolean bl2 = parameters.get("picture-size-values").equals(parameters2.get("picture-size-values")) && parameters.get("preferred-preview-size-for-video").equals(parameters2.get("preferred-preview-size-for-video")) && parameters.get("preview-size").equals(parameters2.get("preview-size")) && parameters.get("preview-size-values").equals(parameters2.get("preview-size-values")) && parameters.get("raw-size").equals(parameters2.get("raw-size")) && parameters.get("supported-live-snapshot-sizes").equals(parameters2.get("supported-live-snapshot-sizes")) && parameters.get("video-size").equals(parameters2.get("video-size")) && parameters.get("video-size-values").equals(parameters2.get("video-size-values"));
                barCodeReader.release();
                if (bl2) {
                    n2 = n;
                    break;
                }
            }
            --n;
        }
        Log.i((String)"getScannerIdFromCamera2", (String)(" scannerid=" + n2));
        return n2;
    }

    public synchronized void scan() {
        Log.i((String)TAG, (String)"scan() ok");
        if (this.bcr != null && this.isIdle.get()) {
            this.setNoDisplayMode();
            this.bcr.startDecode();
            this.isIdle.set(false);
        }
    }

    public synchronized void stopScan() {
        if (this.bcr != null) {
            this.bcr.stopDecode();
            this.isIdle.set(true);
            ScanerLedLight.getInstance().off();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setScanCallback(ScanCallback sc) {
        if (this.bcr != null) {
            void var1_1;
            this.bcr.setDecodeCallback(new BarCodeReader.DecodeCallback((ScanCallback)var1_1){
                private final /* synthetic */ ScanCallback val$sc;
                {
                    this.val$sc = scanCallback;
                }

                @Override
                public void onEvent(int n, int n2, byte[] byArray, BarCodeReader barCodeReader) {
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onDecodeComplete(int symbology, int length, byte[] data, BarCodeReader barCodeReader) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    Barcode2DWithSoft.this.isIdle.set(true);
                    if (length == -3) {
                        Log.i((String)TAG, (String)"onDecodeComplete() DECODE_STATUS_MULTI_DEC_COUNT ");
                        return;
                    }
                    if (data != null && data.length > 0 && length > 1) {
                        ScanerLedLight.getInstance().blink();
                    }
                    this.val$sc.onScanComplete((int)var1_1, (int)var2_2, (byte[])var3_3);
                }
            });
        }
    }

    public void setNoDisplayMode() {
        if (this.bcr != null) {
            this.bcr.setNoDisplayMode();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean setParameter(int paramNum, int paramVal) {
        void var2_2;
        void var1_1;
        return this.bcr != null && this.bcr.setParameter((int)var1_1, (int)var2_2) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean setParameter(int paramNum, String paramVal) {
        void var2_2;
        void var1_1;
        return this.bcr != null && this.bcr.setParameter((int)var1_1, (String)var2_2) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public int getNumParameter(int paramNum) {
        if (this.bcr != null) {
            void var1_1;
            return this.bcr.getNumParameter((int)var1_1);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public String getStrParameter(int paramNum) {
        if (this.bcr != null) {
            void var1_1;
            return this.bcr.getStrParameter((int)var1_1);
        }
        return "-1";
    }

    public void setDefaultParameters() {
        if (this.bcr != null) {
            this.bcr.setDefaultParameters();
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getNumProperty(int propNum) {
        if (this.bcr != null) {
            void var1_1;
            return this.bcr.getNumProperty((int)var1_1);
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public String getStrProperty(int propNum) {
        if (this.bcr != null) {
            void var1_1;
            return this.bcr.getStrProperty((int)var1_1);
        }
        return "-1";
    }

    public void enableAllCodeTypes() {
        if (this.bcr != null) {
            this.bcr.enableAllCodeTypes();
        }
    }

    public void disableAllCodeTypes() {
        if (this.bcr != null) {
            this.bcr.disableAllCodeTypes();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void takePicture(PictureCallback cb) {
        if (this.bcr != null) {
            void var1_1;
            this.bcr.takePicture(new BarCodeReader.PictureCallback((PictureCallback)var1_1){
                private final /* synthetic */ PictureCallback val$cb;
                {
                    this.val$cb = pictureCallback;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onPictureTaken(int format, int width, int height, byte[] data, BarCodeReader barCodeReader) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.val$cb.onPictureTaken((int)var1_1, (int)var2_2, (int)var3_3, data);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (this.bcr != null) {
            void var1_1;
            this.bcr.setPreviewDisplay((SurfaceHolder)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void startViewFinder(VideoCallback cb) {
        if (this.bcr != null) {
            void var1_1;
            this.bcr.startViewFinder(new BarCodeReader.VideoCallback((VideoCallback)var1_1){
                private final /* synthetic */ VideoCallback val$cb;
                {
                    this.val$cb = videoCallback;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onVideoFrame(int format, int width, int height, byte[] data, BarCodeReader barCodeReader) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.val$cb.onVideoFrame((int)var1_1, (int)var2_2, (int)var3_3, data);
                }
            });
        }
    }

    public void startPreview() {
        if (this.bcr != null) {
            this.bcr.startPreview();
        }
    }

    public void stopPreview() {
        if (this.bcr != null) {
            this.bcr.stopPreview();
        }
    }

    public synchronized boolean close() {
        if (this.bcr != null) {
            this.bcr.release();
            this.bcr = null;
            this.isIdle.set(true);
            this.setPowerOn(false);
            ScanerLedLight.getInstance().free();
            Log.i((String)TAG, (String)"close() succ");
        }
        return true;
    }

    public static interface PictureCallback {
        public void onPictureTaken(int var1, int var2, int var3, byte[] var4);
    }

    public static interface ScanCallback {
        public void onScanComplete(int var1, int var2, byte[] var3);
    }

    public static class ScanerParamNum
    extends BarCodeReader.ParamNum {
    }

    public static class ScanerParamVal
    extends BarCodeReader.ParamVal {
    }

    public static class ScanerPropertyNum
    extends BarCodeReader.PropertyNum {
    }

    public static interface VideoCallback {
        public void onVideoFrame(int var1, int var2, int var3, byte[] var4);
    }
}

