/*
 * Decompiled with CFR 0.152.
 */
package com.barcode;

import android.content.Context;
import android.content.Intent;

public class BarcodeUtility {
    private static BarcodeUtility single = null;
    private static final String ACTION_OPEN = "android.intent.action.OPEN_BARCODE_RFID";
    private static final String ACTION_CLOSE = "android.intent.action.CLOSE_BARCODE_RFID";
    private static final String ACTION_ENABLE_FUNCTION = "android.intent.action.ENABLE_FUNCTION_BARCODE_RFID";
    private static final String ACTION_DISABLE_FUNCTION = "android.intent.action.DISABLE_FUNCTION_BARCODE_RFID";
    private static final String ACTION_START = "android.intent.action.START_BARCODE_RFID";
    private static final String ACTION_STOP = "android.intent.action.STOP_BARCODE_RFID";
    private static final String ACTION_SUCCESS_SOUND = "android.intent.action.SUCCESS_SOUND_BARCODE_RFID";
    private static final String ACTION_FAIL_SOUND = "android.intent.action.FAIL_SOUND_BARCODE_RFID";
    private static final String ACTION_VIBRATE = "android.intent.action.VIBRATE_BARCODE_RFID";
    private static final String ACTION_OUTPUT = "android.intent.action.OUTPUT_BARCODE_RFID";
    private static final String ACTION_FORMAT_BARCODE = "android.intent.action.FORMAT_BARCODE";
    private static final String ACTION_FORMAT_RFID = "android.intent.action.FORMAT_RFID";
    private static final String ACTION_ENABLE_ENTER = "android.intent.action.ENABLE_ENTER_BARCODE_RFID";
    private static final String ACTION_ENABLE_TAB = "android.intent.action.ENABLE_TAB_BARCODE_RFID";
    private static final String ACTION_PREFIX_CHARACTER = "android.intent.action.PREFIX_CHARACTER_BARCODE_RFID";
    private static final String ACTION_SUFFIX_CHARACTER = "android.intent.action.SUFFIX_CHARACTER_BARCODE_RFID";
    private static final String ACTION_TRIM_LEFT_CHARACTER = "android.intent.action.TRIM_LEFT_CHARACTER_BARCODE_RFID";
    private static final String ACTION_TRIM_RIGHT_CHARACTER = "android.intent.action.TRIM_RIGHT_CHARACTER_BARCODE_RFID";
    private static final String ACTION_TIMEOUT = "android.intent.action.TIMEOUT_BARCODE_RFID";
    private static final String ACTION_FILTER_CHARACTER = "android.intent.action.FILTER_CHARACTER_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN = "android.intent.action.CONTINUOUS_SCAN_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN_INTERVAL_TIME = "android.intent.action.CONTINUOUS_SCAN_INTERVAL_TIME_BARCODE_RFID";
    private static final String ACTION_CONTINUOUS_SCAN_TIMEOUT = "android.intent.action.CONTINUOUS_SCAN_TIMEOUT_BARCODE_RFID";
    private static final String ACTION_SCAN_KEY_CONFIG = "android.intent.action.SCAN_KEY_CONFIG_BARCODE_RFID";
    private static final String ACTION_SCAN_FAILURE_BROADCAST = "android.intent.action.SCAN_FAILURE_BROADCAST";
    private static final String ACTION_SCAN_RESULT_BROADCAST = "android.intent.action.SCAN_RESULT_BROADCAST";
    private static final String ACTION_SCAN_RELEASESCAN = "android.intent.action.SCAN_RELEASESCAN";
    private static final String ACTION_SCAN_GROUPSEPARATOR = "android.intent.action.SCAN_GROUPSEPARATOR";
    private static final String ACTION_SCAN_AUXILIARYLIGHT = "android.intent.action.SCAN_AUXILIARYLIGHT";
    private static final String ACTION_SCAN_ZEBRA_PARAM_SET = "android.intent.action.SCAN_ZEBRA_PARAM_SET";
    private static final String ACTION_SCAN_KEYBOARD_HELPER_PARAM_REQUEST = "android.intent.action.SCAN_KEYBOARD_HELPER_PARAM_REQUEST";
    public static final String ACTION_SCAN_KEYBOARD_HELPER_PARAM_RESPONSE = "android.intent.action.SCAN_KEYBOARD_HELPER_PARAM_RESPONSE";
    public static final String SCANNER_RELEASESCAN = "scanner_cbERKOS";
    public static final String SCANNER_BROADCAST_ACTION = "scanner_etBroadcast";
    public static final String SCANNER_CONTINUOUS = "scanner_Continuous";
    public static final String SCANNER_CONTINUOUS_INTREVALTIME = "scanner_ContinuousIntervalTime";
    public static final String SCANNER_FORMAT_BARCODE = "scanner_format_barcode";
    public static final String SCANNER_BARCODENOTREPEAT = "scanner_BarcodeNotRepeat";
    public static final String SCANNER_BROADCAST_EXTRA = "scanner_etBroadcastKey";
    public static final String SCANNER_SCANKEYCODE_3 = "scanner_scanKeyCode_3";
    public static final String SCANNER_SCANKEYCODE_1 = "scanner_scanKeyCode_1";
    public static final String SCANNER_FILTERCHARS = "scanner_FilterChars";
    public static final String SCANNER_FAILUREBROADCAST = "scanner_failureBroadcast";
    public static final String SCANNER_BARCODE_1D = "scanner_cbBarcode1D";
    public static final String SCANNER_VIBRATE = "scanner_Vibrate";
    public static final String SCANNER_SUFFIX = "scanner_etSuffix";
    public static final String SCANNER_TAB = "scanner_cbTab";
    public static final String SCANNER_ENTER = "scanner_cbEnter";
    public static final String SCANNER_ENDINDEX = "scanner_etEndIndex";
    public static final String SCANNER_FAILURESOUND = "scanner_failureSound";
    public static final String SCANNER_OUTPUTMODE = "scanner_target";
    public static final String SCANNER_SOUND = "scanner_Sound";
    public static final String SCANNER_TIMEOUT = "scanner_TimeOut";
    public static final String SCANNER_PREFIX = "scanner_etPrefix";
    public static final String SCANNER_CONTINUOUSTIMEOUT = "scanner_ContinuousTimeOut";
    public static final String SCANNER_KEYBORADHELPER_OPEN = "scanner_cbOpen";
    public static final String SCANNER_CONTINUOUSMODE = "ContinuousMode";
    public static final String SCANNER_ILLUMINATIONPOWERLEVEL = "scanner_IlluminationPowerLevel";
    public static final String SCANNER_STARTINDEX = "scanner_etStartIndex";
    public static final String SCANNER_BARCODE_2D = "scanner_cbBarcode2D_s";

    private BarcodeUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized BarcodeUtility getInstance() {
        if (single != null) return single;
        Class<BarcodeUtility> clazz = BarcodeUtility.class;
        synchronized (BarcodeUtility.class) {
            if (single != null) return single;
            single = new BarcodeUtility();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void open(Context context, ModuleType modul) {
        if (context == null || modul == null) {
            return;
        }
        this.logD("\u6253\u5f00\u529f\u80fd\u6a21\u5757 function=" + modul.getValue());
        Intent intent = new Intent(ACTION_ENABLE_FUNCTION);
        intent.putExtra("function", modul.getValue());
        context.sendBroadcast(intent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void close(Context context, ModuleType modul) {
        if (context == null || modul == null) {
            return;
        }
        this.logD("\u5173\u95ed\u529f\u80fd\u6a21\u5757 function=" + modul.getValue());
        Intent intent = new Intent(ACTION_DISABLE_FUNCTION);
        intent.putExtra("function", modul.getValue());
        context.sendBroadcast(intent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void startScan(Context context, ModuleType modul) {
        if (context == null || modul == null) {
            return;
        }
        this.logD("\u5f00\u59cb\u626b\u63cf function=" + modul.getValue());
        Intent intent = new Intent(ACTION_START);
        intent.putExtra("function", modul.getValue());
        context.sendBroadcast(intent);
    }

    public synchronized void stopScan(Context context, ModuleType modul) {
        if (context == null || modul == null) {
            return;
        }
        this.logD("\u505c\u6b62\u626b\u63cf function=" + modul.getValue());
        Intent intent = new Intent(ACTION_STOP);
        intent.putExtra("function", modul.getValue());
        context.sendBroadcast(intent);
    }

    public synchronized void setOutputMode(Context context, int mode) {
        if (context == null) {
            return;
        }
        this.logD("\u8f93\u51fa\u6a21\u5f0f mode=" + mode);
        Intent intent = new Intent(ACTION_OUTPUT);
        intent.putExtra("mode", mode);
        context.sendBroadcast(intent);
    }

    public synchronized void setScanOutTime(Context context, int time) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4 time=" + time);
        Intent intent = new Intent(ACTION_TIMEOUT);
        intent.putExtra("time", time);
        context.sendBroadcast(intent);
    }

    public synchronized void setScanResultBroadcast(Context context, String broadcastAction, String extraName) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u63a5\u6536\u626b\u63cf\u6570\u636e\u7684\u5e7f\u64ad: broadcastAction=" + broadcastAction + "  extraName=" + extraName);
        Intent intent = new Intent(ACTION_SCAN_RESULT_BROADCAST);
        intent.putExtra("resultAction", broadcastAction);
        intent.putExtra("data", extraName);
        context.sendBroadcast(intent);
    }

    public synchronized void openKeyboardHelper(Context context) {
        if (context == null) {
            return;
        }
        this.logD("\u6253\u5f00\u952e\u76d8\u52a9\u624b\u603b\u5f00\u5173");
        Intent intent = new Intent();
        intent.setAction(ACTION_OPEN);
        context.sendBroadcast(intent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void closeKeyboardHelper(Context context) {
        if (context == null) {
            return;
        }
        this.logD("\u5173\u95ed\u952e\u76d8\u52a9\u624b\u603b\u5f00\u5173");
        Intent intent = new Intent();
        intent.setAction(ACTION_CLOSE);
        context.sendBroadcast(intent);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void enablePlaySuccessSound(Context context, boolean isSuccessSound) {
        if (context == null) {
            return;
        }
        this.logD("\u64ad\u653e\u63d0\u793a\u97f3 successSound=" + isSuccessSound);
        Intent intent = new Intent(ACTION_SUCCESS_SOUND);
        intent.putExtra("successSound", isSuccessSound);
        context.sendBroadcast(intent);
    }

    public synchronized void enablePlayFailureSound(Context context, boolean isFailureSound) {
        if (context == null) {
            return;
        }
        this.logD("\u64ad\u653e\u63d0\u793a\u97f3  failureSound=" + isFailureSound);
        Intent intent = new Intent(ACTION_FAIL_SOUND);
        intent.putExtra("failureSound", isFailureSound);
        context.sendBroadcast(intent);
    }

    public synchronized void enableVibrate(Context context, boolean isVibrate) {
        if (context == null) {
            return;
        }
        this.logD("\u626b\u63cf\u6210\u529f\u662f\u5426\u9707\u52a8\u63d0\u793a vibrate=" + isVibrate);
        Intent intent = new Intent(ACTION_VIBRATE);
        intent.putExtra("vibrate", isVibrate);
        context.sendBroadcast(intent);
    }

    public synchronized void enableEnter(Context context, boolean isEnter) {
        if (context == null) {
            return;
        }
        this.logD("\u662f\u5426\u542f\u7528\u56de\u8f66 enter=" + isEnter);
        Intent intent = new Intent(ACTION_ENABLE_ENTER);
        intent.putExtra("enter", isEnter);
        context.sendBroadcast(intent);
    }

    public synchronized void enableTAB(Context context, boolean isTab) {
        if (context == null) {
            return;
        }
        this.logD("\u662f\u5426\u542f\u7528TAB tab=" + isTab);
        Intent intent = new Intent(ACTION_ENABLE_TAB);
        intent.putExtra("tab", isTab);
        context.sendBroadcast(intent);
    }

    public synchronized void setSuffix(Context context, String suffix) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u540e\u7f00\u5b57\u7b26 suffix=" + suffix);
        Intent intent = new Intent(ACTION_SUFFIX_CHARACTER);
        intent.putExtra("suffix", suffix);
        context.sendBroadcast(intent);
    }

    public synchronized void setPrefix(Context context, String prefix) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u524d\u7f00\u5b57\u7b26 prefix=" + prefix);
        Intent intent = new Intent(ACTION_PREFIX_CHARACTER);
        intent.putExtra("prefix", prefix);
        context.sendBroadcast(intent);
    }

    public synchronized void interceptTrimLeft(Context context, int num) {
        if (context == null) {
            return;
        }
        this.logD("\u622a\u53d6\u5de6\u8fb9\u5b57\u7b26\u4e32 num=" + num);
        Intent intent = new Intent(ACTION_TRIM_LEFT_CHARACTER);
        intent.putExtra("num", num);
        context.sendBroadcast(intent);
    }

    public synchronized void interceptTrimRight(Context context, int num) {
        if (context == null) {
            return;
        }
        this.logD("\u622a\u53d6\u53f3\u8fb9\u5b57\u7b26\u4e32 num=" + num);
        Intent intent = new Intent(ACTION_TRIM_RIGHT_CHARACTER);
        intent.putExtra("num", num);
        context.sendBroadcast(intent);
    }

    public synchronized void filterCharacter(Context context, String chars) {
        if (context == null) {
            return;
        }
        this.logD("\u8fc7\u6ee4\u5b57\u7b26 chars=" + chars);
        Intent intent = new Intent(ACTION_FILTER_CHARACTER);
        intent.putExtra("chars", chars);
        context.sendBroadcast(intent);
    }

    public synchronized void setBarcodeEncodingFormat(Context context, int format) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u6761\u7801\u7f16\u7801\u683c\u5f0f format=" + format);
        Intent intent = new Intent(ACTION_FORMAT_BARCODE);
        intent.putExtra("format", format);
        context.sendBroadcast(intent);
    }

    public synchronized void enableContinuousScan(Context context, boolean isContinuous) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf isContinuous=" + isContinuous);
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN);
        intent.putExtra("isContinuous", isContinuous);
        context.sendBroadcast(intent);
    }

    public synchronized void setContinuousScanIntervalTime(Context context, int intervalTime) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf\u95f4\u9694\u65f6\u95f4 intervalTime=" + intervalTime);
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_INTERVAL_TIME);
        intent.putExtra("intervalTime", intervalTime);
        context.sendBroadcast(intent);
    }

    public synchronized void setContinuousScanTimeOut(Context context, int timeOut) {
        if (context == null) {
            return;
        }
        this.logD("\u8bbe\u7f6e\u8fde\u7eed\u626b\u63cf\u8d85\u65f6\u65f6\u95f4 intervalTime=" + timeOut);
        Intent intent = new Intent(ACTION_CONTINUOUS_SCAN_TIMEOUT);
        intent.putExtra("timeOut", timeOut);
        context.sendBroadcast(intent);
    }

    public synchronized void setScanFailureBroadcast(Context context, boolean enable) {
        if (context == null) {
            return;
        }
        this.logD("\u626b\u63cf\u5931\u8d25\u662f\u5426\u53d1\u9001\u5e7f\u64ad  enable" + enable);
        Intent intent = new Intent(ACTION_SCAN_FAILURE_BROADCAST);
        intent.putExtra("enable", enable);
        context.sendBroadcast(intent);
    }

    public synchronized void setReleaseScan(Context context, boolean enable) {
        if (context == null) {
            return;
        }
        this.logD("\u677e\u5f00\u626b\u63cf\u6309\u952e\u662f\u5426\u505c\u6b62\u626b\u63cf  enable" + enable);
        Intent intent = new Intent(ACTION_SCAN_RELEASESCAN);
        intent.putExtra("enable", enable);
        context.sendBroadcast(intent);
    }

    public synchronized void setParam_zebra(Context context, int paramId, int paramValue) {
        if (context == null) {
            return;
        }
        this.logD("setParam_zebra paramId=" + paramId + " ,paramValue=" + paramValue);
        Intent intent = new Intent(ACTION_SCAN_ZEBRA_PARAM_SET);
        intent.putExtra("paramId", paramId);
        intent.putExtra("paramValue", paramValue);
        context.sendBroadcast(intent);
    }

    public synchronized void getKeyboardHelperParam(Context context) {
        if (context == null) {
            return;
        }
        this.logD("getKeyboardHelperParam=");
        Intent intent = new Intent(ACTION_SCAN_KEYBOARD_HELPER_PARAM_REQUEST);
        context.sendBroadcast(intent);
    }

    public void logD(String log) {
    }

    public static enum ModuleType {
        BARCODE_1D(0),
        BARCODE_2D(2),
        AUTOMATIC_ADAPTATION(101);

        private final int value;

        public int getValue() {
            return this.value;
        }

        private ModuleType(int value) {
            this.value = value;
        }
    }
}

