/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.os.Environment;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.PSAM;
import com.rscja.deviceapi.RFIDWithISO14443A;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CardWithBYL
extends Device {
    private String TAG = String.valueOf(StringUtility.TAG) + "CardWithBYL";
    private boolean DEBUG = StringUtility.DEBUG;
    private boolean isLog = false;
    public RFIDWithISO14443A mRFID = RFIDWithISO14443A.getInstance();
    private PSAM mPSAM = PSAM.getInstance();
    private DeviceConfiguration config = DeviceConfiguration.builderRFIDConfiguration();
    private static CardWithBYL single = null;
    String log_path = "/storage/sdcard0/byllog/";
    String logfilePath = "";

    private CardWithBYL() throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized CardWithBYL getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<CardWithBYL> clazz = CardWithBYL.class;
        synchronized (CardWithBYL.class) {
            if (single != null) return single;
            single = new CardWithBYL();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    public synchronized boolean init() {
        Log.i((String)this.TAG, (String)"init()  ------mRFID.init()");
        boolean result = this.mRFID.init();
        if (result) {
            result = this.mPSAM.init();
            Log.i((String)this.TAG, (String)"init()  ------mPSAM.init()");
        }
        DeviceAPI.getInstance().setBYLUart(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate());
        return result;
    }

    public synchronized boolean free() {
        boolean result = this.mRFID.free();
        result = this.mPSAM.free();
        return result;
    }

    public String[] getBalance() {
        byte[] result = this.getDeviceAPI().CardBalance();
        if (result == null || result.length == 0) {
            return null;
        }
        if (result[0] != 0) {
            Log.e((String)this.TAG, (String)("init() err:" + result[0]));
            return null;
        }
        byte len = result[1];
        byte[] data = Arrays.copyOfRange(result, 2, 6);
        byte[] time = Arrays.copyOfRange(result, 6, 10);
        byte[] totime = Arrays.copyOfRange(result, 10, 14);
        String[] arr = new String[3];
        long value = StringUtility.byteArrayTolong(data);
        DecimalFormat fnum = new DecimalFormat("##0.00");
        arr[0] = fnum.format((float)value / 100.0f);
        arr[1] = StringUtility.bytes2HexString(time, time.length);
        arr[2] = StringUtility.bytes2HexString(totime, totime.length);
        return arr;
    }

    public String[] Consume(float money) {
        Log.i((String)this.TAG, (String)"Consume1111111111111111111111111111111111");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String now = sdf.format(new Date());
        int temp = (int)(money * 100.0f);
        String hexMoney = String.format("%08x", temp);
        byte[] bTime = new byte[8];
        int i = 0;
        while (i < 8) {
            bTime[i] = Byte.parseByte(now.substring(i, i + 1));
            ++i;
        }
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        this.writeLog("\r\n" + date);
        Log.i((String)this.TAG, (String)"Consume222222222222222222222222");
        int iLog = this.isLog ? 1 : 0;
        this.writeLog2();
        byte[] result = this.getDeviceAPI().CardConsume(StringUtility.hexString2Bytes(now), StringUtility.hexString2Chars(hexMoney), this.logfilePath, iLog);
        if (result == null || result.length == 0) {
            return null;
        }
        if (result[0] != 0 && result[0] != 1) {
            return new String[]{this.getMessage(result[0])};
        }
        int i2 = 0;
        while (i2 < result.length) {
            Log.i((String)this.TAG, (String)("Consume() result[" + i2 + "] = " + StringUtility.byte2HexString(result[i2])));
            ++i2;
        }
        byte[] time = Arrays.copyOfRange(result, 2, 9);
        byte[] pos = Arrays.copyOfRange(result, 9, 15);
        byte[] psam = Arrays.copyOfRange(result, 15, 19);
        byte[] card = Arrays.copyOfRange(result, 19, 27);
        byte[] id = Arrays.copyOfRange(card, card.length - 4, card.length);
        int[] id2 = this.reverse(String.valueOf(Long.parseLong(StringUtility.bytes2HexString(id), 16)));
        String strId = "";
        int i3 = 0;
        while (i3 < id2.length) {
            strId = String.valueOf(strId) + String.format("%02d", id2[i3]);
            ++i3;
        }
        byte[] cpu = Arrays.copyOfRange(result, 27, 29);
        byte[] city = Arrays.copyOfRange(result, 29, 31);
        byte[] old = Arrays.copyOfRange(result, 31, 35);
        byte[] consume = Arrays.copyOfRange(result, 35, 39);
        byte[] type = Arrays.copyOfRange(result, 39, 40);
        byte[] tac = Arrays.copyOfRange(result, 40, 44);
        byte[] hy = Arrays.copyOfRange(result, 44, 46);
        byte[] cardflag = Arrays.copyOfRange(result, 46, 47);
        byte[] valid_date = Arrays.copyOfRange(result, 47, 55);
        byte[] chiptype = Arrays.copyOfRange(result, 55, 56);
        byte[] dealflag = Arrays.copyOfRange(result, 56, 57);
        byte[] cardversion = Arrays.copyOfRange(result, 57, 58);
        if (result[0] == 0) {
            Log.i((String)this.TAG, (String)"CardWithBYL.java\u5f00\u59cb\u8bb0\u5f55\u65e5\u5fd7......");
            StringBuilder sb = new StringBuilder();
            sb.append("\r\nCardWithBYL.java------>");
            sb.append("\r\nTime:");
            sb.append(StringUtility.bytes2HexString(time, time.length));
            sb.append("\r\npos:");
            sb.append(StringUtility.bytes2HexString(pos));
            sb.append("\r\npsam:");
            sb.append(StringUtility.bytes2HexString(psam));
            sb.append("\r\ncard:");
            sb.append(StringUtility.bytes2HexString(card));
            sb.append("\r\ncpu:");
            sb.append(StringUtility.bytes2HexString(cpu));
            sb.append("\r\ncity:");
            sb.append(StringUtility.bytes2HexString(city));
            sb.append("\r\nold:");
            sb.append(String.valueOf((float)StringUtility.byteArrayTolong(old) / 100.0f));
            sb.append("\r\nconsume:");
            sb.append(String.valueOf((float)StringUtility.byteArrayTolong(consume) / 100.0f));
            sb.append("\r\ntype:");
            sb.append(StringUtility.bytes2HexString(type));
            sb.append("\r\ntac:");
            sb.append(StringUtility.bytes2HexString(tac));
            sb.append("\r\nhy:");
            sb.append(StringUtility.bytes2HexString(hy));
            sb.append("\r\ncardflag:");
            sb.append(StringUtility.bytes2HexString(cardflag));
            sb.append("\r\nvalid_date:");
            sb.append(StringUtility.bytes2HexString(valid_date));
            sb.append("\r\nchiptype:");
            sb.append(StringUtility.bytes2HexString(chiptype));
            sb.append("\r\ndealflag:");
            sb.append(StringUtility.bytes2HexString(dealflag));
            sb.append("\r\ncardversion:");
            sb.append(StringUtility.bytes2HexString(cardversion));
            sb.append("\r\nstrId:");
            sb.append("U" + this.doGetCheckCode(strId) + strId);
            sb.append("\r\n---------------------------------");
            this.writeLog(sb.toString());
        }
        return new String[]{StringUtility.bytes2HexString(time, time.length), StringUtility.bytes2HexString(pos), StringUtility.bytes2HexString(psam), StringUtility.bytes2HexString(card), StringUtility.bytes2HexString(cpu), StringUtility.bytes2HexString(city), String.valueOf((float)StringUtility.byteArrayTolong(old) / 100.0f), String.valueOf((float)StringUtility.byteArrayTolong(consume) / 100.0f), StringUtility.bytes2HexString(type), StringUtility.bytes2HexString(tac), StringUtility.bytes2HexString(hy), StringUtility.bytes2HexString(cardflag), StringUtility.bytes2HexString(valid_date), StringUtility.bytes2HexString(chiptype), StringUtility.bytes2HexString(dealflag), StringUtility.bytes2HexString(cardversion), "U" + this.doGetCheckCode(strId) + strId, String.valueOf(result[0])};
    }

    public String getPsamCardID() {
        byte[] result = this.getDeviceAPI().getPsamId();
        if (result == null || result.length == 0) {
            return null;
        }
        if (result[0] != 0) {
            Log.e((String)this.TAG, (String)("getPsamCardID() err:" + result[0]));
            return null;
        }
        byte[] data = Arrays.copyOfRange(result, 2, 9);
        return StringUtility.bytes2HexString(data, data.length - 1);
    }

    public void cleanFaultCard() {
        this.getDeviceAPI().CleanVar();
    }

    private int[] reverse(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int l = 10 - s.length();
        while (l > 0) {
            s = "0" + s;
            --l;
        }
        int len = s.length() / 2;
        int[] ints = new int[len];
        int i = 0;
        while (i < len) {
            ints[ints.length - 1 - i] = Integer.parseInt(s.substring(2 * i, 2 * i + 2), 10);
            Log.i((String)this.TAG, (String)("reverse() ints[" + (ints.length - 1 - i) + "] = " + ints[ints.length - 1 - i]));
            ++i;
        }
        return ints;
    }

    private String doGetCheckCode(String strID) {
        int idLen = strID.length();
        if (idLen < 8) {
            return null;
        }
        int[] id = new int[idLen];
        int i = 0;
        while (i < idLen) {
            id[i] = Integer.parseInt(strID.substring(i, i + 1), 10);
            ++i;
        }
        int all = 0;
        int i2 = 0;
        while (i2 < 10) {
            int x;
            all = i2 % 2 != 0 ? ((x = id[i2] * 2) >= 10 ? all + x / 10 + x % 10 : (all += x)) : (all += id[i2]);
            ++i2;
        }
        if (all > 10) {
            all %= 10;
            all = (10 - all) % 10;
        } else {
            all = 10 - all;
        }
        return String.valueOf(all);
    }

    public String getMessage(int code) {
        switch (code) {
            case -214: 
            case -213: 
            case -212: 
            case -211: 
            case -55: {
                return "\u4e0d\u5728\u6709\u6548\u671f(" + code + ")";
            }
            case -70: 
            case -50: {
                return "\u4f59\u989d\u4e0d\u8db3(" + code + ")";
            }
            case -84: 
            case -80: 
            case -45: 
            case -33: 
            case -31: 
            case -7: 
            case -5: 
            case -3: {
                return "\u8bf7\u91cd\u65b0\u5237\u5361(" + code + ")";
            }
            case -72: 
            case -71: 
            case -34: {
                return "\u65e0\u6548\u5361(" + code + ")";
            }
            case -61: {
                return "\u6263\u6b3e\u5931\u8d25\uff0c\u518d\u5237\u4e00\u6b21(" + code + ")";
            }
            case -62: {
                return "\u6263\u6b3e\u5931\u8d25\uff0c\u518d\u5237\u4e00\u6b21(" + code + ")";
            }
            case -65: 
            case -63: {
                return "\u6263\u6b3e\u5931\u8d25\uff0c\u8054\u7cfb\u516c\u5171\u4ea4\u901a\u5361\u5ba2\u670d(" + code + ")";
            }
            case -66: {
                return "\u8bf7\u91cd\u5237\u6545\u969c\u5361(" + code + ")";
            }
        }
        return "\u6263\u6b3e\u5931\u8d25(" + code + ")";
    }

    public String cardConsumeConfirm(String time, String dealnum, String cardnum) {
        byte[] result;
        Log.i((String)this.TAG, (String)("dealnum=" + dealnum));
        Log.i((String)this.TAG, (String)("cardnum=" + cardnum));
        Log.i((String)this.TAG, (String)("time=" + time));
        Log.i((String)this.TAG, (String)("new dealnum=" + dealnum));
        byte[] ctime = StringUtility.hexString2Bytes(time);
        char[] dealnum2 = StringUtility.hexString2Chars(dealnum);
        char[] cardnum2 = StringUtility.hexString2Chars(cardnum);
        int k = 0;
        while (k < ctime.length) {
            Log.i((String)this.TAG, (String)("ctime[" + k + "]=" + ctime[k]));
            ++k;
        }
        k = 0;
        while (k < 2) {
            Log.i((String)this.TAG, (String)("dealnum2[" + k + "]=" + dealnum2[k]));
            ++k;
        }
        k = 0;
        while (k < 8) {
            Log.i((String)this.TAG, (String)("cardnum2[" + k + "]=" + cardnum2[k]));
            ++k;
        }
        if (this.DEBUG) {
            Log.i((String)this.TAG, (String)"cardConsumeConfirm");
        }
        if ((result = this.getDeviceAPI().CardConsumeConfirm(ctime, dealnum2, cardnum2))[0] == 0) {
            byte[] data = new byte[result[1]];
            int k2 = 0;
            while (k2 < result[1]) {
                data[k2] = result[k2 + 2];
                ++k2;
            }
            return StringUtility.bytes2HexString(data);
        }
        return "(" + result[0] + ")";
    }

    private String getNewData(String hex) {
        int temp1 = Integer.parseInt(hex.substring(0, 2), 16);
        int temp2 = Integer.parseInt(hex.substring(2, 4), 16);
        int data = temp1 * 256 + temp2 + 1;
        byte[] byte_src = new byte[]{(byte)((data & 0xFF00) >> 8), (byte)(data & 0xFF)};
        return CardWithBYL.bytesToHexString(byte_src, byte_src.length);
    }

    public static String bytesToHexString(byte[] b, int size) {
        String ret = "";
        try {
            int i = 0;
            while (i < size) {
                String hex = CardWithBYL.byte2HexString(b[i]);
                ret = String.valueOf(ret) + hex;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String byte2HexString(byte b) {
        String ret = "";
        try {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret = String.valueOf(ret) + hex.toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public void setLog(boolean bool) {
    }

    private void writeLog2() {
        if (!this.isLog) {
            return;
        }
        String dateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String path = Environment.getExternalStorageDirectory() + File.separator + "api_log.txt";
        File file = new File(path);
        FileOutputStream outStream = null;
        if (!file.exists()) {
            try {
                file.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + file);
            }
            catch (Exception runtime) {
                // empty catch block
            }
        }
        try {
            try {
                outStream = new FileOutputStream(file, true);
                outStream.write(("\r\n\r\n==========" + dateTime + "========>").getBytes());
                Log.i((String)this.TAG, (String)"\u5199\u5165\u65e5\u5fd7ok");
            }
            catch (Exception e) {
                Log.i((String)this.TAG, (String)"\u5199\u5165\u65e5\u5fd7\u5f02\u5e38");
                e.printStackTrace();
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void writeLog(String data) {
        block20: {
            if (!this.isLog) {
                return;
            }
            Log.i((String)this.TAG, (String)("writeLog data=" + data));
            File filePath = new File(this.log_path);
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String date = new SimpleDateFormat("yyyyMMdd").format(new Date());
            this.logfilePath = String.valueOf(this.log_path) + date + ".txt";
            File file = new File(this.logfilePath);
            FileOutputStream outStream = null;
            if (!file.exists()) {
                try {
                    file.createNewFile();
                    Runtime runtime = Runtime.getRuntime();
                    runtime.exec("chmod 0666 " + file);
                }
                catch (Exception runtime) {
                    // empty catch block
                }
            }
            try {
                try {
                    if (!data.isEmpty()) {
                        outStream = new FileOutputStream(file, true);
                        outStream.write(data.getBytes());
                        Log.i((String)this.TAG, (String)"\u5199\u5165\u65e5\u5fd7ok");
                    }
                }
                catch (Exception e) {
                    Log.i((String)this.TAG, (String)"\u5199\u5165\u65e5\u5fd7\u5f02\u5e38");
                    e.printStackTrace();
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        break block20;
                    }
                    catch (Exception exception) {}
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.deleteFile();
    }

    private void deleteFile() {
        block6: {
            if (!this.isLog) {
                return;
            }
            try {
                File[] files;
                File file = new File(this.log_path);
                if (!file.exists() || (files = file.listFiles()).length <= 7) break block6;
                HashMap<Integer, File> map = new HashMap<Integer, File>();
                int k = 0;
                while (k < files.length) {
                    String fileName = files[k].getName();
                    int n = Integer.parseInt(fileName.substring(0, fileName.indexOf(".")));
                    map.put(n, files[k]);
                    ++k;
                }
                ArrayList list = new ArrayList(map.entrySet());
                Collections.sort(list, new Comparator<Map.Entry<Integer, File>>(){

                    @Override
                    public int compare(Map.Entry<Integer, File> o1, Map.Entry<Integer, File> o2) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                });
                int deleteCount = files.length - 7;
                for (Map.Entry entry : list) {
                    ((File)entry.getValue()).delete();
                    if (--deleteCount > 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                if (!this.DEBUG) break block6;
                Log.e((String)this.TAG, (String)"deleteFile   Exceptione");
            }
        }
    }
}

