/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.PrinterBarcodeInvalidException;
import com.rscja.utility.StringUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Printer
extends Device {
    private boolean isDebug = false;
    private static final String TAG = String.valueOf(StringUtility.TAG) + "Printer";
    protected DeviceConfiguration config;
    private static Printer single = null;
    private PrinterStatusCallBack msgCallBack = null;
    private static int count = 5;
    private static boolean isMsg = true;
    private static boolean isLeisure = true;
    private static boolean isLackofpaper = false;
    private static boolean runing = false;
    private static boolean temp = true;
    Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            if (Printer.this.msgCallBack != null) {
                PrinterStatus code = PrinterStatus.valueOf(msg.obj.toString());
                Printer.this.msgCallBack.message(code);
            }
        }
    };

    protected Printer() throws ConfigurationException {
        this.config = DeviceConfiguration.builderPrinterConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Printer getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<Printer> clazz = Printer.class;
        synchronized (Printer.class) {
            if (single != null) return single;
            single = new Printer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public void setPrinterStatusCallBackEnable(boolean b) {
        isMsg = b;
        if (!b) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public int receiveData(byte[] outData) {
        if (isMsg) {
            return -1;
        }
        return this.receive(outData);
    }

    public int sendData(byte[] sendData) {
        if (isMsg) {
            return -1;
        }
        return this.send(sendData);
    }

    public int sendAndReceiveData(byte[] sendData, byte[] outData) {
        if (isMsg) {
            return -1;
        }
        return this.sendAndReceive(sendData, outData);
    }

    public void setPrinterStatusCallBack(PrinterStatusCallBack callBack) {
        this.msgCallBack = callBack;
    }

    public synchronized boolean init() {
        int result = DeviceAPI.getInstance().PrinterInit(this.config.getDeviceName(), this.config.getUart(), this.config.getBaudrate());
        if (result == 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            int BaudRate = 115200;
            this.setBaudRate(BaudRate);
            int r = DeviceAPI.getInstance().PrinterSerialPortOpen(this.config.getDeviceName(), this.config.getUart(), BaudRate);
            if (r == -1) {
                return false;
            }
            isLeisure = true;
            this.setPowerOn(true);
            runing = true;
            new MeesageThread().start();
            return true;
        }
        Log.e((String)TAG, (String)("init() err:" + result));
        return false;
    }

    public synchronized boolean free() {
        temp = isMsg;
        isMsg = false;
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int result = DeviceAPI.getInstance().PrinterFree(this.config.getDeviceName());
        if (result == 0) {
            runing = false;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setPowerOn(false);
            isLeisure = true;
            isMsg = temp;
            return true;
        }
        Log.e((String)TAG, (String)("free() err:" + result));
        isMsg = temp;
        return false;
    }

    public void print(byte[] content) {
        if (content == null || content.length == 0) {
            Log.e((String)TAG, (String)"print() content is null");
            return;
        }
        this.send(content);
    }

    public void print(String content) {
        if (content == null || content.length() == 0) {
            Log.e((String)TAG, (String)"print() content is null");
            return;
        }
        this.print(content, "gbk");
    }

    public void print(String content, String charsetName) {
        if (content == null || content.length() == 0) {
            Log.e((String)TAG, (String)"print() content is null");
            return;
        }
        if (charsetName == null || charsetName.isEmpty()) {
            charsetName = "gbk";
        }
        try {
            byte[] send = content.getBytes(charsetName);
            this.send(send);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void print(Bitmap bitmap, int mode, int interval) {
        if (bitmap == null || mode != 0 && mode != 1 && mode != 32 && mode != 33) {
            return;
        }
        if (interval < 100) {
            return;
        }
        this.send(new byte[]{13});
        int size = 0;
        int width = bitmap.getWidth() > 384 ? 384 : bitmap.getWidth();
        int height = bitmap.getHeight();
        int row = 0;
        int number = 0;
        if (mode == 33 || mode == 32) {
            row = height / 24;
            number = 24;
            size = 3;
        } else if (mode == 0 || mode == 1) {
            row = height / 8;
            number = 8;
            size = 1;
        }
        byte[] head = new byte[]{27, 42, (byte)mode, (byte)(width % 256), (byte)(width / 256)};
        byte[] escData = new byte[width * size + 1 + head.length];
        int y = 0;
        while (y < row && runing) {
            int index = head.length;
            int x = 0;
            while (x < width && runing) {
                boolean t = false;
                if (runing && (!isLeisure || isLackofpaper)) {
                    if (isLackofpaper) {
                        Log.e((String)TAG, (String)"print(Bitmap bitmap,int mode) ==>\u7ec8\u6b62\u6253\u5370\u56fe\u7247! \u6253\u5370\u673a\u7f3a\u7eb8!");
                        this.clearCache();
                        return;
                    }
                    if (isLeisure) break;
                    Log.e((String)TAG, (String)"print(Bitmap bitmap,int mode) ==>\u6253\u5370\u56fe\u7247! \u6253\u5370\u673a\u5fd9!");
                }
                byte[] data = new byte[size];
                int m = 0;
                while (m < number) {
                    int x1 = x;
                    int y1 = y * number + m;
                    byte values = Printer.px2Byte(x1, y1, bitmap);
                    if (values == 1) {
                        int n = m / 8;
                        data[n] = (byte)(data[n] + (byte)(128 >> m % 8));
                    }
                    ++m;
                }
                int s = 0;
                while (s < data.length) {
                    escData[index] = data[s];
                    ++index;
                    ++s;
                }
                ++x;
            }
            int s = 0;
            while (s < head.length) {
                escData[s] = head[s];
                ++s;
            }
            escData[escData.length - 1] = 10;
            this.send(escData);
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++y;
        }
    }

    public void print(Bitmap bitmap, int interval) {
        this.print(bitmap, 33, interval);
    }

    public void print(Bitmap bitmap) {
        this.print(bitmap, 33, 500);
    }

    public void print(String barcodeData, BarcodeType barcodeType) throws PrinterBarcodeInvalidException {
        if (barcodeData == null || barcodeData.length() == 0) {
            return;
        }
        int type = 0;
        byte[] data = barcodeData.getBytes();
        int leng = data.length;
        switch (barcodeType) {
            case UPC_A: {
                if (leng != 11) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                if (!StringUtility.isDecimal(barcodeData)) {
                    throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                }
                type = 65;
                break;
            }
            case UPC_E: {
                if (leng != 6) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                if (!StringUtility.isDecimal(barcodeData)) {
                    throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                }
                type = 66;
                break;
            }
            case JAN13_EAN13: {
                if (leng != 12) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                if (!StringUtility.isDecimal(barcodeData)) {
                    throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                }
                type = 67;
                break;
            }
            case JAN8_EAN8: {
                if (leng != 7) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                if (!StringUtility.isDecimal(barcodeData)) {
                    throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                }
                type = 68;
                break;
            }
            case CODE39: {
                int d;
                int k = 0;
                while (k < data.length) {
                    d = data[k];
                    if (!(d >= 48 && d <= 57 || d >= 65 && d <= 90 || d == 32 || d == 36 || d == 37 || d >= 42 && d <= 47 && d != 44)) {
                        throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                    }
                    ++k;
                }
                type = 69;
                break;
            }
            case ITF_Interleaved_2_of_5: {
                if (leng < 2 || leng > 255 || leng % 2 != 0) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                if (!StringUtility.isDecimal(barcodeData)) {
                    throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                }
                type = 70;
                break;
            }
            case CODABAR_NW_7: {
                int d;
                if (leng < 3 || leng > 255) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                int k = 1;
                while (k < data.length - 1) {
                    d = data[k];
                    if (!(d >= 48 && d <= 57 || d >= 45 && d <= 47 || d == 36 || d == 43 || d == 58)) {
                        throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                    }
                    ++k;
                }
                if (data[0] < 65 || data[0] > 68 || data[data.length - 1] < 65 || data[data.length - 1] > 68) {
                    throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                }
                type = 71;
                break;
            }
            case CODE93: {
                if (leng < 1 || leng > 255) {
                    new PrinterBarcodeInvalidException("Barcode length is invalid!");
                    return;
                }
                int k = 0;
                while (k < data.length) {
                    if (data[k] < 0 || data[k] > 127) {
                        throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                    }
                    ++k;
                }
                type = 72;
                break;
            }
            case CODE128: {
                int d;
                if (leng < 1 || leng > 255) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                int k = 0;
                while (k < data.length) {
                    d = data[k] & 0xFF;
                    if (!(d >= 0 && d <= 127 || d >= 193 && d <= 196)) {
                        throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                    }
                    ++k;
                }
                type = 73;
                break;
            }
            case UCC_EAN128: {
                int d;
                if (leng < 1 || leng > 255) {
                    throw new PrinterBarcodeInvalidException("Barcode length is invalid!");
                }
                int k = 0;
                while (k < data.length) {
                    d = data[k] & 0xFF;
                    if (!(d >= 0 && d <= 127 || d >= 193 && d <= 196)) {
                        throw new PrinterBarcodeInvalidException("Barcode data is invalid!");
                    }
                    ++k;
                }
                type = 74;
            }
        }
        byte[] cmd = new byte[4 + leng];
        cmd[0] = 29;
        cmd[1] = 107;
        cmd[2] = (byte)type;
        cmd[3] = (byte)leng;
        int k = 0;
        while (k < leng) {
            cmd[4 + k] = data[k];
            ++k;
        }
        this.send(cmd);
    }

    public void setFeedRow(int n) {
        if (n >= 0 && n <= 255) {
            byte[] cmd = new byte[]{27, 100, (byte)n};
            this.send(cmd);
        }
    }

    public void setPrintRowSpacing(int spacing) {
        if (spacing >= 0 && spacing <= 255) {
            byte[] cmdSpeed = new byte[]{27, 51, (byte)spacing};
            this.send(cmdSpeed);
        }
    }

    public void setPrintLeftMargin(int margin) {
        if (margin >= 0 && margin <= 47) {
            byte[] cmdSpeed = new byte[]{27, 108, (byte)margin};
            this.send(cmdSpeed);
        }
    }

    public void setPrintRightMargin(int margin) {
        if (margin >= 0 && margin <= 47) {
            byte[] cmdSpeed = new byte[]{27, 81, (byte)margin};
            this.send(cmdSpeed);
        }
    }

    public void setPrintCharacterStyle(boolean italic, boolean frame, boolean bold, boolean doubleWidth, boolean doubleHigh, boolean white, boolean underline) {
        int Italics = 0;
        int Frame = 0;
        int Bold = 0;
        int height = 0;
        int width = 0;
        int White = 0;
        int Underline = 0;
        if (italic) {
            Italics = 1;
        }
        if (frame) {
            Frame = 1;
        }
        if (bold) {
            Bold = 1;
        }
        if (doubleHigh) {
            height = 1;
        }
        if (doubleWidth) {
            width = 1;
        }
        if (white) {
            White = 1;
        }
        if (underline) {
            Underline = 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Underline);
        sb.append(White);
        sb.append(width);
        sb.append(height);
        sb.append(Bold);
        sb.append(Frame);
        sb.append(Italics);
        sb.append(0);
        byte sytle = StringUtility.BitToByte(sb.toString());
        byte[] cmdSpeed = new byte[]{27, 33, sytle};
        this.send(cmdSpeed);
    }

    public void setPrintSpeed(int speed) {
        if (speed >= 0 && speed <= 2) {
            byte[] cmdSpeed = new byte[]{28, 115, (byte)speed};
            this.send(cmdSpeed);
        }
    }

    public void setPrintGrayLevel(int gray) {
        if (gray >= 1 && gray <= 8) {
            byte[] cmdSpeed = new byte[]{27, 109, (byte)gray};
            this.send(cmdSpeed);
        }
    }

    public void restoreDefault() {
        byte[] cmdSpeed = new byte[]{27, 64};
        this.send(cmdSpeed);
        try {
            Thread.sleep(800L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void clearCache() {
        byte[] cmd = new byte[]{16, 20, 8, 1, 3, 20, 1, 6, 2, 8};
        this.send(cmd);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setBarcodeHeight(int height) {
        if (height >= 1 && height <= 255) {
            byte[] cmdBarcodeHeight = new byte[]{29, 104, (byte)height};
            this.send(cmdBarcodeHeight);
        }
    }

    public void setBarcodeWidth(int width) {
        if (width >= 1 && width <= 6) {
            byte[] cmdBarcodeWidth = new byte[]{29, 119, (byte)width};
            this.send(cmdBarcodeWidth);
        }
    }

    public void setBarcodeHRI(int position) {
        if (position >= 0 && position <= 3) {
            byte[] cmdHRI = new byte[]{29, 72, String.valueOf(position).getBytes()[0]};
            this.send(cmdHRI);
        }
    }

    private void setFlowControl(int m) {
        if (m == 48 || m == 49) {
            byte[] byArray = new byte[8];
            byArray[0] = 29;
            byArray[1] = 40;
            byArray[2] = 69;
            byArray[3] = 3;
            byArray[5] = 11;
            byArray[6] = 3;
            byArray[7] = (byte)m;
            byte[] cmd = byArray;
            this.send(cmd);
        }
    }

    private void setBaudRate(int baudRate) {
        int tempLen = String.valueOf(baudRate).length();
        byte[] byArray = new byte[2];
        byArray[0] = (byte)(tempLen + 2);
        byte[] len = byArray;
        char[] data = String.valueOf(baudRate).toCharArray();
        byte[] cmdBaudRate = new byte[7 + data.length];
        cmdBaudRate[0] = 29;
        cmdBaudRate[1] = 40;
        cmdBaudRate[2] = 69;
        cmdBaudRate[3] = len[0];
        cmdBaudRate[4] = len[1];
        cmdBaudRate[5] = 11;
        cmdBaudRate[6] = 1;
        int k = 0;
        while (k < data.length) {
            cmdBaudRate[7 + k] = (byte)data[k];
            ++k;
        }
        if (this.isDebug) {
            k = 0;
            while (k < cmdBaudRate.length) {
                Log.e((String)TAG, (String)("cmdBaudRate[" + k + "]=" + cmdBaudRate[k]));
                ++k;
            }
        }
        this.send(cmdBaudRate);
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int receive(byte[] outData) {
        if (outData == null || outData.length <= 0) {
            return -1;
        }
        return DeviceAPI.getInstance().PrinterReceive(outData, outData.length);
    }

    private int send(byte[] sendData) {
        if (sendData == null || sendData.length <= 0) {
            return -1;
        }
        if (this.isDebug) {
            StringBuilder sb = new StringBuilder();
            sb.append("send==>   ");
            try {
                int i = 0;
                while (i < sendData.length) {
                    String hex = Integer.toHexString(sendData[i] & 0xFF);
                    if (hex.length() == 1) {
                        hex = "0" + hex;
                    }
                    sb.append(hex.toUpperCase());
                    sb.append(" ");
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)sb.toString());
        }
        return DeviceAPI.getInstance().PrinterSend(sendData, sendData.length);
    }

    private int sendAndReceive(byte[] sendData, byte[] outData) {
        if (sendData == null || sendData.length <= 0 || outData == null || outData.length <= 0) {
            return -1;
        }
        if (this.isDebug) {
            StringBuilder sb = new StringBuilder();
            sb.append("sendAndReceive==>   ");
            try {
                int i = 0;
                while (i < sendData.length) {
                    String hex = Integer.toHexString(sendData[i] & 0xFF);
                    if (hex.length() == 1) {
                        hex = "0" + hex;
                    }
                    sb.append(hex.toUpperCase());
                    sb.append(" ");
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Log.d((String)TAG, (String)sb.toString());
        }
        return DeviceAPI.getInstance().PrinterSendAndReceive(sendData, sendData.length, outData, outData.length);
    }

    private String checkBusy() {
        String strResult = "";
        OutputStream outputStream = null;
        BufferedReader successResult = null;
        String cmd = "cat /sys/bus/platform/drivers/pca953x/gpio_val";
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process su = runtime.exec("sh");
                outputStream = su.getOutputStream();
                successResult = new BufferedReader(new InputStreamReader(su.getInputStream()));
                if (outputStream != null && successResult != null) {
                    outputStream.write(cmd.getBytes());
                    outputStream.write("\n".getBytes());
                    outputStream.flush();
                    outputStream.write("exit\n".getBytes());
                    String data = successResult.readLine();
                    if (data != null && data.length() > 0) {
                        strResult = data;
                    }
                }
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)("IOException " + e.getMessage()));
                e.printStackTrace();
                try {
                    if (successResult != null) {
                        successResult.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (successResult != null) {
                    successResult.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return strResult;
    }

    private void sendPriterStatus(byte status) {
        Message msg;
        boolean isNORMAL = true;
        if (this.isDebug) {
            Log.e((String)TAG, (String)("sendPriterStatus==> status=" + status));
        }
        if ((status >> 0 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.OVERPRESSURE;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if ((status >> 1 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.PRESSUREAXISOPEN;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if ((status >> 2 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.LACKOFPAPER;
            this.handler.sendMessage(msg);
            isNORMAL = false;
            isLackofpaper = true;
        } else {
            isLackofpaper = false;
        }
        if ((status >> 3 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.OVERHEATING;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if ((status >> 4 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.PAPERSTUCK;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if ((status >> 5 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.SLICINGERROR;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if ((status >> 6 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.PAPERFINISH;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if ((status >> 7 & 1) == 1) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.CANCELPAPER;
            this.handler.sendMessage(msg);
            isNORMAL = false;
        }
        if (isNORMAL && isLeisure) {
            msg = Message.obtain();
            msg.obj = PrinterStatus.NORMAL;
            this.handler.sendMessage(msg);
        }
    }

    private static byte px2Byte(int x, int y, Bitmap bit) {
        int blue;
        int green;
        int pixel = bit.getPixel(x, y);
        int red = (pixel & 0xFF0000) >> 16;
        int gray = Printer.RGB2Gray(red, green = (pixel & 0xFF00) >> 8, blue = pixel & 0xFF);
        byte b = gray < 128 ? (byte)1 : 0;
        return b;
    }

    private static int RGB2Gray(int r, int g, int b) {
        int gray = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return gray;
    }

    public static enum BarcodeType {
        UPC_A,
        UPC_E,
        JAN13_EAN13,
        JAN8_EAN8,
        CODE39,
        ITF_Interleaved_2_of_5,
        CODABAR_NW_7,
        CODE93,
        CODE128,
        UCC_EAN128;

    }

    private class MeesageThread
    extends Thread {
        private MeesageThread() {
        }

        @Override
        public void run() {
            while (runing) {
                if (isMsg) {
                    byte[] outjdata = new byte[10];
                    int len = 0;
                    String data = Printer.this.checkBusy();
                    if (data != null && data.length() > 2) {
                        Message msg;
                        int leng = data.length();
                        String status = data.substring(leng - 2, leng);
                        byte btatus = StringUtility.hexString2Bytes(status)[0];
                        int busyStatus = btatus >> 2 & 1;
                        if (busyStatus == 1) {
                            if (Printer.this.isDebug) {
                                Log.d((String)TAG, (String)("\u6253\u5370\u673a\u72b6\u6001\u5fd9: data" + data + " count=" + count + "  isLeisure=false"));
                            }
                            msg = Message.obtain();
                            msg.obj = PrinterStatus.UNLEISURED;
                            Printer.this.handler.sendMessage(msg);
                            isLeisure = false;
                            count = 0;
                        } else {
                            if (Printer.this.isDebug) {
                                Log.d((String)TAG, (String)("\u6253\u5370\u673a\u72b6\u6001\u95f2: data" + data + " count=" + count + "  isLeisure=false"));
                            }
                            count = count + 1;
                            if (count == 3) {
                                isLeisure = true;
                                msg = Message.obtain();
                                msg.obj = PrinterStatus.LEISURE;
                                Printer.this.handler.sendMessage(msg);
                            }
                        }
                    }
                    if (!isMsg) continue;
                    if (!runing) {
                        return;
                    }
                    byte[] status_command = new byte[]{16, 4, 5};
                    outjdata = new byte[10];
                    len = Printer.this.sendAndReceive(status_command, outjdata);
                    if (len > 0) {
                        Printer.this.sendPriterStatus(outjdata[0]);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static enum PrinterStatus {
        NORMAL,
        OVERPRESSURE,
        LACKOFPAPER,
        OVERHEATING,
        PRESSUREAXISOPEN,
        PAPERSTUCK,
        SLICINGERROR,
        PAPERFINISH,
        CANCELPAPER,
        UNLEISURED,
        LEISURE;

    }

    public static interface PrinterStatusCallBack {
        public void message(PrinterStatus var1);
    }
}

