/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.utility.StringUtility;
import java.text.DecimalFormat;
import java.util.Arrays;

public class RFIDWithUHF
extends Device {
    private static final String TAG = String.valueOf(StringUtility.TAG) + "RFIDWithUHF";
    private static RFIDWithUHF single = null;
    private boolean DEBUG = StringUtility.DEBUG;
    protected DeviceConfiguration config;
    char[] uhfdata = new char[512];
    int mode = -1;

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHF getInstance() throws ConfigurationException {
        if (single != null) return single;
        Class<RFIDWithUHF> clazz = RFIDWithUHF.class;
        synchronized (RFIDWithUHF.class) {
            if (single != null) return single;
            single = new RFIDWithUHF();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    private RFIDWithUHF() throws ConfigurationException {
        this.config = DeviceConfiguration.builderUHFConfiguration();
    }

    public synchronized void setUart(String uart) {
        this.config.setUart(uart);
        this.config.setDeviceName("unknown");
    }

    public synchronized boolean init() {
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result > -1) {
            result = this.getDeviceAPI().UHFOpenAndConnect_Ex(this.config.getUart());
            Log.i((String)TAG, (String)("init() Uart = " + this.config.getUart()));
            if (result > -1) {
                this.setPowerOn(true);
                return true;
            }
            Log.e((String)TAG, (String)("init() err UHFOpenAndConnect result:" + result));
            String strName = this.config.getDeviceName();
            if (strName.equals(DeviceConfiguration.C4000_6577) || strName.equals(DeviceConfiguration.C4000_6582) || strName.equals(DeviceConfiguration.C4050_6582) || strName.equals(DeviceConfiguration.C4050_8909)) {
                this.getDeviceAPI().UHFCloseAndDisconnect();
                result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
                if (result > -1) {
                    this.setPowerOn(true);
                    return true;
                }
            }
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + result));
        }
        return false;
    }

    @Deprecated
    public synchronized boolean init_R2000() {
        int result = this.getDeviceAPI().UHFInit(this.config.getDeviceName());
        if (result > -1) {
            result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
            Log.i((String)TAG, (String)("init() Uart = " + this.config.getUart()));
            if (result > -1) {
                this.setPowerOn(true);
                return true;
            }
            Log.e((String)TAG, (String)("init() err UHFOpenAndConnect result:" + result));
            String strName = this.config.getDeviceName();
            if (strName.equals(DeviceConfiguration.C4000_6577) || strName.equals(DeviceConfiguration.C4000_6582) || strName.equals(DeviceConfiguration.C4050_6582) || strName.equals(DeviceConfiguration.C4050_8909)) {
                this.getDeviceAPI().UHFCloseAndDisconnect();
                result = this.getDeviceAPI().UHFOpenAndConnect(this.config.getUart());
                if (result > -1) {
                    this.setPowerOn(true);
                    return true;
                }
            }
        } else {
            Log.e((String)TAG, (String)("init() err UHFInit result:" + result));
        }
        return false;
    }

    public synchronized boolean free() {
        this.getDeviceAPI().UHFCloseAndDisconnect();
        int result = this.getDeviceAPI().UHFFree(this.config.getDeviceName());
        if (result == 0) {
            this.setPowerOn(false);
            return true;
        }
        Log.e((String)TAG, (String)("free() err UHFFree result:" + result));
        return false;
    }

    public synchronized void crcOn() {
        this.getDeviceAPI().UHFFlagCrcOn();
    }

    public synchronized void crcOff() {
        this.getDeviceAPI().UHFFlafCrcOff();
    }

    public String convertUiiToEPC(String uii) {
        if (StringUtility.isEmpty(uii)) {
            return "";
        }
        String sUii = uii.replace("-", "").toUpperCase();
        sUii = sUii.substring(4, sUii.length());
        return sUii;
    }

    public synchronized String getHardwareType() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] result = this.getDeviceAPI().UHFGetHwType();
        if (result != null && result[0] == '\u0000') {
            char[] arrs = Arrays.copyOfRange(result, 2, result[1] + 2);
            return new String(arrs);
        }
        Log.e((String)TAG, (String)("getHardwareType() err:" + result[0]));
        return null;
    }

    public synchronized int getPower() {
        char[] result = this.getDeviceAPI().UHFGetPower();
        if (result != null && result[0] == '\u0000') {
            return result[1];
        }
        Log.e((String)TAG, (String)("getPower() err :" + result[0]));
        return -1;
    }

    public synchronized boolean setPower(int power) {
        int result = this.getDeviceAPI().UHFSetPower((char)power);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPower() err :" + result));
        return false;
    }

    synchronized String getFrequency() {
        char bFreMode = '\u0000';
        char bFreBase = '\u0000';
        char[] bBaseFre = new char[2];
        char bChannNum = '\u0000';
        char bChannSpc = '\u0000';
        char bFreHop = '\u0000';
        String freStr = null;
        char[] result = this.getDeviceAPI().UHFGetFrequency();
        if (result != null && result[0] == '\u0000') {
            bFreMode = result[2];
            bFreBase = result[3];
            bBaseFre[0] = result[4];
            bBaseFre[1] = result[5];
            bChannNum = result[6];
            bChannSpc = result[7];
            bFreHop = result[8];
            int iFreBase0 = bBaseFre[0] & 0xFF;
            int iFreBase1 = bBaseFre[1] & 0xFF;
            int freI = (iFreBase0 << 3) + (iFreBase1 >> 5);
            int freD = 0;
            int eFreD = 0;
            int eFreI = 0;
            if (bFreBase == '\u0000') {
                freD = (iFreBase1 & 0x1F) * 50;
                eFreD = (freD + bChannSpc * 50 * (bChannNum - '\u0001')) % 1000;
                eFreI = freI + (freD + bChannSpc * 50 * (bChannNum - '\u0001')) / 1000;
            } else {
                freD = (iFreBase1 & 0x1F) * 125;
                eFreD = (freD + bChannSpc * 125 * (bChannNum - '\u0001')) % 1000;
                eFreI = freI + (freD + bChannSpc * 125 * (bChannNum - '\u0001')) / 1000;
            }
            freStr = String.valueOf(String.valueOf(freI)) + "." + String.valueOf(freD) + "~" + String.valueOf(eFreI) + "." + String.valueOf(eFreD) + "MHz";
            return freStr;
        }
        Log.e((String)TAG, (String)("getFrequency() err :" + result[0]));
        return null;
    }

    public synchronized int getFrequencyMode() {
        char[] result = this.getDeviceAPI().UHFGetFrequency_Ex();
        if (result != null && result[0] == '\u0000') {
            return result[1];
        }
        Log.e((String)TAG, (String)("getFrequencyMode() err :" + result[0]));
        return -1;
    }

    synchronized boolean setFrequency(byte uFreMode, byte uFreBase, byte[] uBaseFre, byte uChannNum, byte uChannSpc, byte uFreHop) {
        char[] cBaseFre = new char[]{(char)uBaseFre[0], (char)uBaseFre[1]};
        int result = this.getDeviceAPI().UHFSetFrequency((char)uFreMode, (char)uFreBase, cBaseFre, (char)uChannNum, (char)uChannSpc, (char)uFreHop);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFrequency() err :" + result));
        return false;
    }

    public synchronized boolean setFrequencyMode(byte freMode) {
        int result = this.getDeviceAPI().UHFSetFrequency_EX((char)freMode);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFrequencyMode() err :" + result));
        return false;
    }

    @Deprecated
    public synchronized boolean startInventory(int flagAnti, int initQ) {
        int result = this.getDeviceAPI().UHFInventory((char)flagAnti, (char)initQ);
        if (result == 0) {
            this.mode = -1;
            return true;
        }
        Log.e((String)TAG, (String)("startInventory() err :" + result));
        return false;
    }

    public synchronized boolean startInventoryTag(int flagAnti, int initQ) {
        return this.startInventoryTag((char)flagAnti, (char)initQ, 6);
    }

    public synchronized boolean startInventoryTag(int flagAnti, int initQ, int cnt) {
        int result = this.getDeviceAPI().UHFInventory_EX_cnt((char)flagAnti, (char)initQ, (char)cnt);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("startInventory() err :" + result));
        return false;
    }

    @Deprecated
    synchronized String readUidFormBuffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readUidFormBuffer() err :" + result[0]));
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uii, uii.length);
    }

    public synchronized String readUidFromBuffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readUidFormBuffer() err :" + result[0]));
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uii, uii.length);
    }

    @Deprecated
    synchronized String[] readTagFormBuffer() {
        return this.readTagFromBuffer();
    }

    public synchronized String[] readTagFromBuffer() {
        int k = 0;
        while (k < this.uhfdata.length) {
            this.uhfdata[k] = '\u0000';
            ++k;
        }
        int r = this.getDeviceAPI().UHFGetReceived_EX2(this.uhfdata);
        if (r == -1 || this.uhfdata[0] != '\u0000') {
            return null;
        }
        char[] uii = Arrays.copyOfRange(this.uhfdata, 3, 3 + this.uhfdata[2]);
        char[] tid = Arrays.copyOfRange(this.uhfdata, 3 + uii.length + 1, 4 + uii.length + this.uhfdata[3 + uii.length]);
        char[] rssi = Arrays.copyOfRange(this.uhfdata, (int)this.uhfdata[1], this.uhfdata[1] + 2);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f && dBm > 0.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        String[] res = new String[]{StringUtility.chars2HexString(tid, tid.length), StringUtility.chars2HexString(uii, uii.length), strdBm};
        return res;
    }

    @Deprecated
    public synchronized String[] readTagFromR2000Buffer() {
        char[] result = this.getDeviceAPI().UHFGetReceived_EX_R2000();
        if (result == null || result[0] != '\u0000') {
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 3, 3 + result[2]);
        char[] tid = Arrays.copyOfRange(result, 3 + uii.length + 1, 4 + uii.length + result[3 + uii.length]);
        char[] rssi = Arrays.copyOfRange(result, (int)result[1], result[1] + 2);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        float dBm = (float)(65536 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        String[] res = new String[]{StringUtility.chars2HexString(tid, tid.length), StringUtility.chars2HexString(uii, uii.length), strdBm};
        return res;
    }

    public synchronized boolean stopInventory() {
        int result = this.getDeviceAPI().UHFStopGet();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("stopInventory() err :" + result));
        return false;
    }

    public synchronized boolean setPwm(int WorkTime, int WaitTime) {
        int result = this.getDeviceAPI().UHFSetPwm(WorkTime, WaitTime);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setPwm() err :" + result));
        return false;
    }

    public synchronized int[] getPwm() {
        int[] result = this.getDeviceAPI().UHFGetPwm();
        if (result == null || result[0] != 0) {
            Log.e((String)TAG, (String)("getPwm() err :" + result[0]));
            return null;
        }
        int[] res = Arrays.copyOfRange(result, 1, 3);
        return res;
    }

    @Deprecated
    synchronized boolean setReadMode(SingelModeEnum mode) {
        int result = this.getDeviceAPI().UHFSetSingelMode((char)mode.value);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setReadMode() err :" + result));
        return false;
    }

    public synchronized boolean setReadMode(SingleModeEnum mode) {
        int result = this.getDeviceAPI().UHFSetSingelMode((char)mode.value);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setReadMode() err :" + result));
        return false;
    }

    public synchronized int getReadMode() {
        char[] result = this.getDeviceAPI().UHFGetSingelMode();
        if (result == null || result[0] != '\u0000') {
            Log.e((String)TAG, (String)("getReadMode() err :" + result[0]));
            return -1;
        }
        return result[1];
    }

    @Deprecated
    public synchronized String lockMem(String accessPwd, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        String uii = this.inventorySingleTag();
        if (this.lockMem(accessPwd, lockCode, uii)) {
            return uii;
        }
        return null;
    }

    @Deprecated
    public synchronized boolean lockMem(String accessPwd, String lockCode, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEpc = StringUtility.hexString2Chars(uii);
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        int result = this.getDeviceAPI().UHFLockMem(bAccessPwd, bLockData, bEpc);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("lockMem() err :" + result));
        return false;
    }

    public synchronized boolean lockMem(String accessPwd, BankEnum bank, int ptr, int cnt, String filterData, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(lockCode)) {
            return false;
        }
        if (cnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = cnt / 8 + (cnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] filter = StringUtility.hexString2Chars(filterData);
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        return DeviceAPI.getInstance().UHFLockMemEx(bAccessPwd, (char)bank.value, ptr, cnt, filter, bLockData) == 0;
    }

    public synchronized boolean lockMem_EX(String accessPwd, String lockCode) {
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEpc = new char[1];
        char[] bLockData = StringUtility.hexString2Chars(lockCode);
        boolean result = this.lockMem(accessPwd, BankEnum.UII, 0, 0, "", lockCode);
        if (result) {
            return true;
        }
        Log.e((String)TAG, (String)("lockMem() err :" + result));
        return false;
    }

    synchronized String[] getVersion() {
        if (!this.isPowerOn()) {
            return null;
        }
        char[] result = this.getDeviceAPI().UHFGetVersion();
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("getVersion() err :" + result[0]));
            return null;
        }
        char[] serialData = Arrays.copyOfRange(result, 3, result[2] + 3);
        char[] versionData = Arrays.copyOfRange(result, 4 + serialData.length, result[3 + serialData.length] + 4 + serialData.length);
        String[] res = new String[]{new String(serialData), new String(versionData)};
        return res;
    }

    public synchronized String inventorySingleTag() {
        char[] result = this.getDeviceAPI().UHFInventorySingle();
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("inventorySingleTag() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public synchronized String[] inventorySingleTagEPC_TID_USER() {
        String[] res = null;
        char[] uhfdata = this.getDeviceAPI().UHFInventorySingleEPCTIDUSER();
        if (uhfdata == null || uhfdata[0] != '\u0000') {
            return null;
        }
        char[] uii = Arrays.copyOfRange(uhfdata, 3, 3 + uhfdata[2]);
        String stid = "";
        if (uhfdata[1] - uii.length > 12) {
            int tidStart = 3 + uii.length + 1;
            int tidEnd = tidStart + uhfdata[3 + uii.length] - 1;
            char[] tid = Arrays.copyOfRange(uhfdata, tidStart, tidEnd);
            stid = StringUtility.chars2HexString(tid, tid.length);
        }
        String epc = StringUtility.chars2HexString(uii, uii.length);
        if (uii.length > 4) {
            epc = epc.substring(4, epc.length());
        }
        if (stid != null && stid.length() > 0) {
            if (stid.length() > 24) {
                String user = stid.substring(24, stid.length());
                stid = stid.substring(0, 24);
                res = new String[]{epc, stid, user};
            } else {
                res = new String[]{epc, stid};
            }
        } else {
            res = new String[]{epc};
        }
        return res;
    }

    public synchronized byte[] inventorySingleTagBytes() {
        char[] result = this.getDeviceAPI().UHFInventorySingle();
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("inventorySingleTag() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.charsTobytes(data, data.length);
    }

    @Deprecated
    public synchronized String[] inventorySingleTagWithR2000() {
        char[] result = this.getDeviceAPI().UHFInventorySingle_R2000();
        if (result == null || result[0] != '\u0000') {
            return null;
        }
        char[] uii = Arrays.copyOfRange(result, 3, 3 + result[2]);
        char[] tid = Arrays.copyOfRange(result, 3 + uii.length + 1, 4 + uii.length + result[3 + uii.length]);
        char[] rssi = Arrays.copyOfRange(result, (int)result[1], result[1] + 2);
        String strRssi = StringUtility.chars2HexString(rssi, rssi.length);
        float dBm = (float)(65535 - Integer.parseInt(strRssi, 16)) / 10.0f;
        String strdBm = "N/A";
        if (dBm < 200.0f && dBm > 0.0f) {
            DecimalFormat fnum = new DecimalFormat("##0.00");
            strdBm = "-" + fnum.format(dBm);
        }
        String[] res = new String[]{StringUtility.chars2HexString(tid, tid.length), StringUtility.chars2HexString(uii, uii.length), strdBm};
        return res;
    }

    public synchronized SimpleRFIDEntity readData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        SimpleRFIDEntity entity = null;
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] result = this.getDeviceAPI().UHFReadDataSingle(bAccessPwd, (char)bank.value, ptr, (char)cnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        String uii = this.inventorySingleTag();
        if (uii == null || uii.isEmpty()) {
            return null;
        }
        String readData = this.readData(accessPwd, bank, ptr, cnt, uii);
        entity = new SimpleRFIDEntity(uii, "UHF");
        entity.setData(readData);
        return entity;
    }

    @Deprecated
    public synchronized String readData(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] result = this.getDeviceAPI().UHFReadData(bAccessPwd, (char)bank.value, (char)ptr, (char)cnt, bEPC);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public synchronized String readData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return null;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return null;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return null;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return null;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank.value;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        char[] result = this.getDeviceAPI().UHFReadData_Ex2(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    @Deprecated
    public synchronized String writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        char[] cData = new char[cnt * 2];
        int i = 0;
        while (i < cData.length) {
            cData[i] = i < bWriteData.length ? bWriteData[i] : (char)'\u0000';
            ++i;
        }
        Object result = null;
        String uii = this.inventorySingleTag();
        if (uii == null || uii.isEmpty()) {
            return null;
        }
        if (this.writeData(accessPwd, bank, ptr, cnt, data, uii)) {
            return uii;
        }
        return null;
    }

    public synchronized boolean writeData_Ex(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        BankEnum filter_bank = BankEnum.UII;
        int filter_ptr = 32;
        int filter_cnt = 0;
        String filter_data = "00";
        boolean result = this.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, bank, ptr, cnt, data);
        return result;
    }

    @Deprecated
    public synchronized boolean writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        Log.i((String)TAG, (String)("writeData() bWriteData.length :" + bWriteData.length));
        int result = this.getDeviceAPI().UHFWriteData(bAccessPwd, (char)bank.value, ptr, (char)cnt, bEPC, bWriteData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeData() err :" + result));
        return false;
    }

    public synchronized boolean writeData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt, String writeData) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank.value;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        char[] ufData_write = StringUtility.hexString2Chars(writeData);
        int result = this.getDeviceAPI().UHFWriteData_Ex2(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write);
        return result == 0;
    }

    public synchronized String eraseData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] result = this.getDeviceAPI().UHFEraseDataSingle(bAccessPwd, (char)bank.value, ptr, (char)cnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("eraseData() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(uiiData, uiiData.length);
    }

    public synchronized boolean eraseData(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEpc = StringUtility.hexString2Chars(uii);
        int result = this.getDeviceAPI().UHFEraseData(bAccessPwd, (char)bank.value, ptr, (char)cnt, bEpc);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("eraseData() err :" + result));
        return false;
    }

    public synchronized boolean eraseData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank.value;
        int filter_ptr = filterPtr;
        char filter_cnt = (char)filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank.value;
        int uPtr = ptr;
        int uCnt = cnt;
        int result = this.getDeviceAPI().UHFEraseDataEx(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("eraseData() err :" + result));
        return false;
    }

    @Deprecated
    public synchronized boolean setFilter(int bank, int ptr, String data) {
        if (StringUtility.isEmpty(data)) {
            data = "";
        }
        char[] bData = StringUtility.hexString2Chars(data);
        int result = this.getDeviceAPI().UHFSetFilter('\u0001', (char)bank, ptr, bData.length, bData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFilter() err :" + result));
        return false;
    }

    public synchronized boolean setFilter(BankEnum bank, int ptr, int cnt, String data, boolean save) {
        if (cnt < 0 || ptr < 0) {
            return false;
        }
        if (cnt > 0) {
            if (StringUtility.isEmpty(data)) {
                return false;
            }
            int len = cnt / 8 + (cnt % 8 == 0 ? 0 : 1);
            int dataLen = data.replace(" ", "").length() / 2;
            if (dataLen < len) {
                return false;
            }
        } else {
            data = "00";
        }
        boolean flag = save;
        char[] bData = StringUtility.hexString2Chars(data);
        int result = this.getDeviceAPI().UHFSetFilter_Ex((char)(flag ? 1 : 0), (char)bank.value, ptr, cnt, bData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFilter() err :" + result));
        return false;
    }

    @Deprecated
    public synchronized boolean setFilter(int bank, byte ptr, String data) {
        if (StringUtility.isEmpty(data)) {
            data = "";
        }
        char[] bData = StringUtility.hexString2Chars(data);
        int result = this.getDeviceAPI().UHFSetFilter('\u0001', (char)bank, ptr, bData.length, bData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFilter() err :" + result));
        return false;
    }

    @Deprecated
    public synchronized String killTag(String killPwd) {
        if (StringUtility.isEmpty(killPwd)) {
            return null;
        }
        String uii = this.inventorySingleTag();
        if (uii == null || uii.isEmpty()) {
            return null;
        }
        if (this.killTag(killPwd, uii)) {
            return uii;
        }
        return null;
    }

    public synchronized boolean killTag_Ex(String killPwd) {
        if (StringUtility.isEmpty(killPwd)) {
            return false;
        }
        char[] bKillPwd = StringUtility.hexString2Chars(killPwd);
        char[] result = this.getDeviceAPI().UHFKillTagSingle(bKillPwd);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("killTag() err :" + result[0]));
            return false;
        }
        return true;
    }

    public synchronized boolean killTag(String killPwd, String uii) {
        if (StringUtility.isEmpty(killPwd) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bKillPwd = StringUtility.hexString2Chars(killPwd);
        char[] bEpc = StringUtility.hexString2Chars(uii);
        int result = this.getDeviceAPI().UHFKillTag(bKillPwd, bEpc);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("killTag() err :" + result));
        return false;
    }

    public synchronized boolean killTag(String accessPwd, BankEnum bank, int ptr, int cnt, String filterData) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (cnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = cnt / 8 + (cnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] filter = StringUtility.hexString2Chars(filterData);
        return DeviceAPI.getInstance().UHFKillTagEx(bAccessPwd, (char)bank.value, ptr, (char)cnt, filter) == 0;
    }

    @Deprecated
    public synchronized String generateLockCode(LockModeEnum killPwd, LockModeEnum accessPwd, LockModeEnum uii, LockModeEnum tid, LockModeEnum user) {
        byte bkill = killPwd.value;
        byte baccess = accessPwd.value;
        byte buii = uii.value;
        byte btid = tid.value;
        byte buser = user.value;
        byte[] LockCode = new byte[]{0, 0, 0};
        if (bkill == 1) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 2);
        } else if (bkill == 2) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 0);
        } else if (bkill == 3) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 3);
        } else if (bkill == 4) {
            LockCode[0] = (byte)(LockCode[0] | 0xC);
            LockCode[1] = (byte)(LockCode[1] | 1);
        } else {
            LockCode[0] = (byte)(LockCode[0] & 3);
            LockCode[1] = (byte)(LockCode[1] & 0xFC);
        }
        if (baccess == 1) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0x80);
        } else if (baccess == 2) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (baccess == 3) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0xC0);
        } else if (baccess == 4) {
            LockCode[0] = (byte)(LockCode[0] | 3);
            LockCode[2] = (byte)(LockCode[2] | 0x40);
        } else {
            LockCode[0] = (byte)(LockCode[0] & 0xC);
            LockCode[2] = (byte)(LockCode[2] & 0x3F);
        }
        if (buii == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x20);
        } else if (buii == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (buii == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x30);
        } else if (buii == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0xC0);
            LockCode[2] = (byte)(LockCode[2] | 0x10);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0x3F);
            LockCode[2] = (byte)(LockCode[2] & 0xCF);
        }
        if (btid == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 8);
        } else if (btid == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (btid == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 0xC);
        } else if (btid == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0x30);
            LockCode[2] = (byte)(LockCode[2] | 4);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0xCF);
            LockCode[2] = (byte)(LockCode[2] & 0xF3);
        }
        if (buser == 1) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 2);
        } else if (buser == 2) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 0);
        } else if (buser == 3) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 3);
        } else if (buser == 4) {
            LockCode[1] = (byte)(LockCode[1] | 0xC);
            LockCode[2] = (byte)(LockCode[2] | 1);
        } else {
            LockCode[1] = (byte)(LockCode[1] & 0xF3);
            LockCode[2] = (byte)(LockCode[2] & 0xFC);
        }
        return StringUtility.bytes2HexString(LockCode, LockCode.length);
    }

    public synchronized boolean setProtocol(int protocol) {
        int result = this.getDeviceAPI().Um7ProtocolConfig((char)protocol);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setProtocol() err :" + result));
        return false;
    }

    @Deprecated
    public synchronized boolean openInventoryEPCAndTIDMode() {
        int result = this.getDeviceAPI().R2000_OPENMODE();
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("openInventoryEPCAndTIDMode() err :" + result));
        return false;
    }

    public synchronized boolean setFreHop(float fre) {
        int ifre = (int)(fre * 1000.0f);
        int result = this.getDeviceAPI().R2000_FreHopSet(ifre);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFreHop() err :" + result));
        return false;
    }

    public synchronized SimpleRFIDEntity readDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        SimpleRFIDEntity entity = null;
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] result = this.getDeviceAPI().UHFReadQTDataSingle(bAccessPwd, (char)bank.value, ptr, (char)cnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] uiiData = Arrays.copyOfRange(result, 3, result[2] + 3);
        entity = new SimpleRFIDEntity(StringUtility.chars2HexString(uiiData, uiiData.length), "UHF");
        char[] data = Arrays.copyOfRange(result, 4 + uiiData.length, result[3 + uiiData.length] + 4 + uiiData.length);
        entity.setData(StringUtility.chars2HexString(data, cnt * 2));
        return entity;
    }

    @Deprecated
    public synchronized String readDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(uii)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] result = this.getDeviceAPI().UHFReadQTData(bAccessPwd, (char)bank.value, (char)ptr, (char)cnt, bEPC);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readDataWithQT() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public synchronized String readDataWithQT(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return null;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return null;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return null;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank.value;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        char[] result = this.getDeviceAPI().UHFReadQTData_Ex(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("readData() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    @Deprecated
    public synchronized String writeDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return null;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        char[] cData = new char[cnt * 2];
        int i = 0;
        while (i < cData.length) {
            cData[i] = i < bWriteData.length ? bWriteData[i] : (char)'\u0000';
            ++i;
        }
        char[] result = null;
        int i2 = 0;
        while (i2 < cnt) {
            char[] cwData = Arrays.copyOfRange(cData, i2 * 2, i2 * 2 + 2);
            result = this.getDeviceAPI().UHFWriteQTDataSingle(bAccessPwd, (char)bank.value, i2 + ptr, '\u0001', cwData);
            if (result[0] != '\u0000') {
                Log.e((String)TAG, (String)("writeData() err :" + result[0]));
                return null;
            }
            ++i2;
        }
        if (result != null) {
            char[] uiiData = Arrays.copyOfRange(result, 2, (int)(result[1] + 2));
            return StringUtility.chars2HexString(uiiData, uiiData.length);
        }
        return null;
    }

    public synchronized boolean writeDataWithQT_Ex(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        BankEnum filterBank = BankEnum.UII;
        int filterPtr = 32;
        int filterCnt = 0;
        String filterData = "00";
        return this.writeDataWithQT(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt, data);
    }

    @Deprecated
    public synchronized boolean writeDataWithQT(String accessPwd, BankEnum bank, int ptr, int cnt, String data, String uii) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data) || StringUtility.isEmpty(uii)) {
            return false;
        }
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        char[] bWriteData = StringUtility.hexString2Chars(data);
        Log.i((String)TAG, (String)("writeData() bWriteData.length :" + bWriteData.length));
        int result = this.getDeviceAPI().UHFWriteData(bAccessPwd, (char)bank.value, ptr, (char)cnt, bEPC, bWriteData);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("writeData() err :" + result));
        return false;
    }

    public synchronized boolean writeDataWithQT(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt, String writeData) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterCnt = 0;
            filterData = "00";
        }
        char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char filter_bank = (char)filterBank.value;
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char[] filter_data = StringUtility.hexString2Chars(filterData);
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        char[] ufData_write = StringUtility.hexString2Chars(writeData);
        int result = this.getDeviceAPI().UHFWriteQTData_Ex(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write);
        return result == 0;
    }

    public synchronized boolean setQTPara(boolean enable) {
        int result = this.getDeviceAPI().SetQTPara(enable ? (char)'\u0001' : '\u0000');
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setQTPara() err :" + result));
        return false;
    }

    public synchronized int[] getQTPara() {
        char[] result = this.getDeviceAPI().GetQTPara();
        int[] ires = new int[2];
        if (result != null && result[0] == '\u0000') {
            ires[0] = 1;
            ires[1] = result[1];
            return ires;
        }
        Log.e((String)TAG, (String)("getQTPara() err :" + result[0]));
        return ires;
    }

    public synchronized boolean setRFLink(int mode) {
        int result = this.getDeviceAPI().UHFSetRFLink((char)mode);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setRFLink() err :" + result));
        return false;
    }

    public synchronized int getRFLink() {
        byte[] result = this.getDeviceAPI().UHFGetRFLink();
        if (result == null || result[0] != 0) {
            Log.e((String)TAG, (String)("getRFLink() err :" + result[0]));
            return -1;
        }
        if (result.length > 1) {
            return result[1];
        }
        return -1;
    }

    public synchronized boolean setFastID(boolean enalbe) {
        int result = this.getDeviceAPI().UHFSetFastID((char)(enalbe ? 1 : 0));
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setFastID() err :" + result));
        return false;
    }

    public synchronized boolean setTagFocus(boolean enalbe) {
        int result = this.getDeviceAPI().UHFSetTagFocus((char)(enalbe ? 1 : 0));
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setTagFocus() err :" + result));
        return false;
    }

    public synchronized boolean setEPCTIDMode(boolean enalbe) {
        int result = this.getDeviceAPI().UHFSetEPCTIDMode((char)(enalbe ? 1 : 0));
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCTIDMode() err :" + result));
        return false;
    }

    public synchronized boolean setEPCTIDUserMode(boolean enalbe, int prt, int len) {
        int save = 0;
        int result = this.getDeviceAPI().UHFSetEPCUserMode((char)(enalbe ? 2 : 0), prt, len, save);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setEPCUSERMode() err :" + result));
        return false;
    }

    public synchronized int getTemperature() {
        char[] result = this.getDeviceAPI().GetTemperature();
        if (result == null || result[0] != '\u0000') {
            return -1;
        }
        String hex = StringUtility.chars2HexString(new char[]{result[1], result[2]}, 2);
        return Integer.valueOf(hex, 16) / 100;
    }

    public synchronized boolean setParam(char type, char[] id, char[] data) {
        int result = this.getDeviceAPI().UHFSetParam(type, id, data);
        return result == 0;
    }

    public synchronized char[] getParam(char type, char[] id) {
        char[] result = this.getDeviceAPI().UHFGetParam(type, id);
        if (result == null || result[0] != '\u0000') {
            return null;
        }
        char[] param = Arrays.copyOfRange(result, 1, 5);
        return param;
    }

    public synchronized boolean setMode(int mode) {
        int result = this.getDeviceAPI().UHFSetMode((char)mode);
        if (result == 0) {
            return true;
        }
        Log.e((String)TAG, (String)("setMode() err :" + result));
        return false;
    }

    public synchronized int getMode() {
        byte[] result = this.getDeviceAPI().UHFGetMode();
        if (result == null || result[0] != 0) {
            Log.e((String)TAG, (String)("getMode() err :" + result[0]));
            return -1;
        }
        if (result.length > 1) {
            return result[1];
        }
        return -1;
    }

    public String UHFBlockPermalock(String accessPwd, int bank, int ptr, int datalen, String uii, int readlock, int MB, int blockptr, int blockrange, String jucpmask) {
        char[] mask = StringUtility.hexString2Chars(jucpmask);
        char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
        char[] bEPC = StringUtility.hexString2Chars(uii);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("bAccessPwd=" + bAccessPwd + " bank=" + bank + " ptr=" + ptr + " datalen=" + datalen + " bEPC=" + uii + " readlock=" + readlock + " MB=" + MB + " blockptr=" + blockptr + " jucpmask=" + jucpmask));
        }
        char[] result = this.getDeviceAPI().UHFBlockPermalock(bAccessPwd, (char)bank, (char)ptr, (char)datalen, bEPC, (char)readlock, (char)MB, (char)blockptr, (char)blockrange, mask);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("UHFBlockPermalock rsult=" + result[0]));
        }
        String hex = StringUtility.chars2HexString(result, result.length);
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("UHFBlockPermalock rsultData=" + hex));
        }
        if (result[0] == '\u0000') {
            if (readlock == 1) {
                return "0";
            }
            char[] data = Arrays.copyOfRange(result, 2, 2 + result[1]);
            if (this.DEBUG) {
                int k = 0;
                while (k < data.length) {
                    Log.i((String)TAG, (String)("UHFBlockPermalock data[" + k + "]=" + data[k]));
                    ++k;
                }
            }
            return StringUtility.chars2HexString(data, data.length);
        }
        return null;
    }

    public boolean SetGen2(int target, int action, int t, int q, int startQ, int minQ, int maxQ, int dr, int coding, int p, int Sel, int Session, int g, int linkFrequency) {
        int result;
        if (this.DEBUG) {
            StringBuilder sb = new StringBuilder();
            sb.append("target=");
            sb.append(String.valueOf(target));
            sb.append(",action=");
            sb.append(String.valueOf(action));
            sb.append(",t=");
            sb.append(String.valueOf(t));
            sb.append(",q=");
            sb.append(String.valueOf(q));
            sb.append(",startQ=");
            sb.append(String.valueOf(startQ));
            sb.append(",minQ=");
            sb.append(String.valueOf(minQ));
            sb.append(",maxQ=");
            sb.append(String.valueOf(maxQ));
            sb.append(",dr=");
            sb.append(String.valueOf(dr));
            sb.append(",coding=");
            sb.append(String.valueOf(coding));
            sb.append(", p=");
            sb.append(String.valueOf(p));
            sb.append(",Sel=");
            sb.append(String.valueOf(Sel));
            sb.append(",Session=");
            sb.append(String.valueOf(Session));
            sb.append(",g=");
            sb.append(String.valueOf(g));
            sb.append(",linkFrequency=");
            sb.append(String.valueOf(linkFrequency));
            Log.i((String)TAG, (String)sb.toString());
        }
        return (result = this.getDeviceAPI().SetGen2((char)target, (char)action, (char)t, (char)q, (char)startQ, (char)minQ, (char)maxQ, (char)dr, (char)coding, (char)p, (char)Sel, (char)Session, (char)g, (char)linkFrequency)) == 0;
    }

    public char[] GetGen2() {
        char[] data;
        if (this.DEBUG) {
            Log.i((String)TAG, (String)"GetGen2()=========");
        }
        if ((data = this.getDeviceAPI().GetGen2())[0] == '\u0000') {
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("result data[0]=");
                sb.append(String.valueOf((int)data[0]));
                sb.append("leng data[1]=");
                sb.append(String.valueOf((int)data[1]));
                sb.append("target data[2]=");
                sb.append(String.valueOf((int)data[2]));
                sb.append(",action data[3]=");
                sb.append(String.valueOf((int)data[3]));
                sb.append(",t data[4]=");
                sb.append(String.valueOf((int)data[4]));
                sb.append(",q data[5]=");
                sb.append(String.valueOf((int)data[5]));
                sb.append(",startQ data[6]=");
                sb.append(String.valueOf((int)data[6]));
                sb.append(",minQ data[7]=");
                sb.append(String.valueOf((int)data[7]));
                sb.append(",maxQ data[8]=");
                sb.append(String.valueOf((int)data[8]));
                sb.append(",dr data[9]=");
                sb.append(String.valueOf((int)data[9]));
                sb.append(",coding data[10]=");
                sb.append(String.valueOf((int)data[10]));
                sb.append(", p data[11]=");
                sb.append(String.valueOf((int)data[11]));
                sb.append(",Sel data[12]=");
                sb.append(String.valueOf((int)data[12]));
                sb.append(",Session data[13]=");
                sb.append(String.valueOf((int)data[13]));
                sb.append(",g data[14]=");
                sb.append(String.valueOf((int)data[14]));
                sb.append(",linkFrequency data[15]=");
                sb.append(String.valueOf((int)data[15]));
                Log.i((String)TAG, (String)sb.toString());
            }
            return Arrays.copyOfRange(data, 2, 2 + data[1]);
        }
        if (this.DEBUG) {
            Log.i((String)TAG, (String)("error=" + data[0]));
        }
        return data;
    }

    public synchronized boolean uhfJump2Boot() {
        return DeviceAPI.getInstance().UHFJump2Boot() == 0;
    }

    public synchronized boolean uhfStartUpdate() {
        return DeviceAPI.getInstance().UHFStartUpdate() == 0;
    }

    public synchronized boolean uhfUpdating(byte[] buff) {
        byte[] data = new byte[64];
        if (buff.length < 64) {
            int k = 0;
            while (k < buff.length) {
                data[k] = buff[k];
                ++k;
            }
        } else {
            int k = 0;
            while (k < 64) {
                data[k] = buff[k];
                ++k;
            }
        }
        return DeviceAPI.getInstance().UHFUpdating(data) == 0;
    }

    public synchronized boolean uhfStopUpdate() {
        return DeviceAPI.getInstance().UHFStopUpdate() == 0;
    }

    public synchronized String inventorySingleTag_tc(int mode) {
        char cMode = (char)mode;
        char[] result = this.getDeviceAPI().UHFInventorySingle_tc(cMode);
        if (result[0] != '\u0000') {
            Log.e((String)TAG, (String)("inventorySingleTag() err :" + result[0]));
            return null;
        }
        char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
        return StringUtility.chars2HexString(data, data.length);
    }

    public boolean setInventoryBID(boolean save, int mode) {
        int result;
        char isave = '\u0000';
        if (save) {
            isave = '\u0001';
        }
        return (result = DeviceAPI.getInstance().UHFInventoryBID(isave, (char)mode)) == 0;
    }

    public int[] getInventoryBID() {
        int[] re = new int[]{-1, -1};
        char[] result = DeviceAPI.getInstance().UHFGetBID();
        if (result[0] == '\u0000') {
            re[0] = 0;
            re[1] = result[1];
        } else {
            re[0] = result[0];
        }
        return re;
    }

    public synchronized boolean uhfDeactivate(String hexCmd, String pszuAccessPwd, BankEnum uBank, int uPtr, int cnt, String pszuUii) {
        if (hexCmd == null || hexCmd.length() != 4 || !StringUtility.isHexNumberRex(hexCmd)) {
            return false;
        }
        if (pszuAccessPwd == null || pszuAccessPwd.length() != 8 || !StringUtility.isHexNumberRex(pszuAccessPwd)) {
            return false;
        }
        if (cnt > 0) {
            if (pszuUii == null || pszuUii.length() == 0 || !StringUtility.isHexNumberRex(pszuUii)) {
                return false;
            }
        } else {
            pszuUii = "00";
        }
        int cmd = Integer.parseInt(hexCmd, 16);
        char[] pwd = StringUtility.hexString2Chars(pszuAccessPwd);
        char[] uii = StringUtility.hexString2Chars(pszuUii);
        return DeviceAPI.getInstance().UHFDeactivate(cmd, pwd, (char)uBank.value, uPtr, cnt, uii) == 0;
    }

    public synchronized int startInventory_BankPtrCnt(int flagAnti, int initQ, int bank, int ptr, int cnt) {
        return DeviceAPI.getInstance().UHFInventory_EX_BankPtrCnt((char)flagAnti, (char)initQ, (char)bank, (char)ptr, (char)cnt);
    }

    public synchronized boolean uhfDwell(int dwell, int count) {
        return DeviceAPI.getInstance().UHFDwell(dwell, count) == 0;
    }

    public synchronized boolean inventoryBank_sf(String pwdData, char bank, int ptr, int len) {
        if (pwdData != null && pwdData.length() == 8) {
            char[] bAccessPwd = StringUtility.hexString2Chars(pwdData);
            if (DeviceAPI.getInstance().UHFInventoryBank(bAccessPwd, bank, ptr, len) == 0) {
                this.mode = bank;
                return true;
            }
        }
        return false;
    }

    public synchronized String[] readTagData_sf() {
        if (this.mode == -1) {
            return null;
        }
        char[] result = this.getDeviceAPI().UHFGetReceived_EX();
        if (result == null || result[0] != '\u0000') {
            return null;
        }
        return this.getData(result);
    }

    public synchronized String[] inventorySingleTag_sf() {
        char[] result = this.getDeviceAPI().UHFInventorySingle_sf();
        if (result == null || result[0] != '\u0000') {
            return null;
        }
        return this.getData(result);
    }

    private String[] getData(char[] result) {
        if (result == null || result.length < 2) {
            return null;
        }
        char len = result[1];
        int epclen = 0;
        char[] pc = null;
        char[] tid = null;
        char[] epc = null;
        char[] user = null;
        char[] reversed = null;
        String[] res = null;
        if (result.length < 2 + len - 3) {
            return null;
        }
        switch (this.mode) {
            case 1: {
                pc = Arrays.copyOfRange(result, 2, 4);
                epclen = (result[2] >> 3) * 2;
                epc = Arrays.copyOfRange(result, 4, 4 + epclen);
                res = new String[]{StringUtility.chars2HexString(epc, epc.length)};
                break;
            }
            case 2: {
                pc = Arrays.copyOfRange(result, 2, 4);
                epclen = (result[2] >> 3) * 2;
                tid = Arrays.copyOfRange(result, 4, 4 + epclen);
                res = new String[]{StringUtility.chars2HexString(tid, tid.length)};
                break;
            }
            case 3: {
                pc = Arrays.copyOfRange(result, 2, 4);
                epclen = (result[2] >> 3) * 2;
                user = Arrays.copyOfRange(result, 4, 4 + epclen);
                res = new String[]{StringUtility.chars2HexString(user, user.length)};
                break;
            }
            case 4: {
                pc = Arrays.copyOfRange(result, 2, 4);
                epclen = (result[2] >> 3) * 2;
                reversed = Arrays.copyOfRange(result, 4, 4 + epclen);
                res = new String[]{StringUtility.chars2HexString(reversed, reversed.length)};
                break;
            }
            case 5: {
                epclen = (result[2] >> 3) * 2;
                pc = Arrays.copyOfRange(result, 2, 4);
                epc = Arrays.copyOfRange(result, 4, 4 + epclen);
                tid = Arrays.copyOfRange(result, 4 + epclen, 2 + len - 3);
                res = new String[]{StringUtility.chars2HexString(epc, epc.length), StringUtility.chars2HexString(tid, tid.length)};
                break;
            }
            case 6: {
                epclen = (result[2] >> 3) * 2;
                pc = Arrays.copyOfRange(result, 2, 4);
                epc = Arrays.copyOfRange(result, 4, 4 + epclen);
                user = Arrays.copyOfRange(result, 4 + epclen, 2 + len - 3);
                res = new String[]{StringUtility.chars2HexString(epc, epc.length), StringUtility.chars2HexString(user, user.length)};
                break;
            }
            case 7: {
                epclen = (result[2] >> 3) * 2;
                pc = Arrays.copyOfRange(result, 2, 4);
                epc = Arrays.copyOfRange(result, 4, 4 + epclen);
                tid = Arrays.copyOfRange(result, 4 + epclen, 4 + epclen + 12);
                user = Arrays.copyOfRange(result, 4 + epclen + 12, 2 + len - 3);
                res = new String[]{StringUtility.chars2HexString(epc, epc.length), StringUtility.chars2HexString(tid, tid.length), StringUtility.chars2HexString(user, user.length)};
            }
        }
        return res;
    }

    public static enum BankEnum {
        RESERVED(0),
        UII(1),
        TID(2),
        USER(3),
        DIGITAL_SIGNATURE(4);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private BankEnum(byte value) {
            this.value = value;
        }
    }

    @Deprecated
    public static enum LockModeEnum {
        HOLD(0),
        LOCK(1),
        UNLOCK(2),
        PLOCK(3),
        PUNLOCK(4);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private LockModeEnum(byte value) {
            this.value = value;
        }
    }

    @Deprecated
    static enum SingelModeEnum {
        SINGEL(0),
        MORE(1);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private SingelModeEnum(byte value) {
            this.value = value;
        }
    }

    public static enum SingleModeEnum {
        SINGEL(0),
        MORE(1);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private SingleModeEnum(byte value) {
            this.value = value;
        }
    }
}

