/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.util.Log;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.RFIDWithUHF;
import com.rscja.deviceapi.entity.UHFTAGInfo;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.service.BTService;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;

public class RFIDWithUHFBluetooth {
    private static RFIDWithUHFBluetooth single = null;
    private BTService mService = null;
    private BluetoothAdapter mBtAdapter = null;
    private String TAG = "DeviceAPI_UHFBluetooth";
    private boolean isDebug = true;
    private ScanBTCallback scanBTCallback = null;
    private BTStatusCallback btStatusCallback = null;
    public static String deviceAddress;
    public static byte[] tempData;
    public static int wIndex;
    public static int rIndex;
    public static boolean isStop;
    KeyEventCallback KeyEventCallback = null;
    DataReceiveBTData datareceive = new DataReceiveBTData();
    public static byte[] tempDataTAG;
    public static int wIndexTAG;
    public static int rIndexTAG;
    private Context context = null;
    private static boolean isBluetooth;
    private RFIDWithUHF rfidWithUHF = null;
    boolean isFlag = false;
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder rawBinder) {
            RFIDWithUHFBluetooth.this.mService = ((BTService.LocalBinder)rawBinder).getService();
            if (RFIDWithUHFBluetooth.this.mService.initialize()) {
                if (RFIDWithUHFBluetooth.this.isDebug) {
                    Log.d((String)RFIDWithUHFBluetooth.this.TAG, (String)"mService.initialize   ok");
                }
            } else if (RFIDWithUHFBluetooth.this.isDebug) {
                Log.d((String)RFIDWithUHFBluetooth.this.TAG, (String)"mService.initialize   fail");
            }
        }

        public void onServiceDisconnected(ComponentName classname) {
            RFIDWithUHFBluetooth.this.mService.disconnect();
            RFIDWithUHFBluetooth.this.mService = null;
            if (RFIDWithUHFBluetooth.this.isDebug) {
                Log.d((String)RFIDWithUHFBluetooth.this.TAG, (String)"mService.disconnect()");
            }
        }
    };

    static {
        tempData = new byte[1024];
        wIndex = 0;
        rIndex = 0;
        isStop = false;
        tempDataTAG = new byte[1024];
        wIndexTAG = 0;
        rIndexTAG = 0;
        isBluetooth = true;
    }

    private RFIDWithUHFBluetooth() {
    }

    protected DeviceAPI getDeviceAPI() {
        return DeviceAPI.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithUHFBluetooth getInstance() {
        if (single != null) return single;
        Class<RFIDWithUHFBluetooth> clazz = RFIDWithUHFBluetooth.class;
        synchronized (RFIDWithUHFBluetooth.class) {
            if (single != null) return single;
            single = new RFIDWithUHFBluetooth();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void init(Context context) {
        if (isBluetooth) {
            rIndex = 0;
            this.context = context;
            this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
            if (this.mBtAdapter == null) {
                return;
            }
            Log.d((String)this.TAG, (String)"----init------");
            this.service_init(this.context);
        } else if (this.rfidWithUHF == null) {
            try {
                this.rfidWithUHF = RFIDWithUHF.getInstance();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void free() {
        if (isBluetooth) {
            rIndex = 0;
            if (this.mService != null) {
                this.mService.stoptBTScan();
                this.mService.close();
            }
            if (this.context != null) {
                this.context.unbindService(this.mServiceConnection);
            }
            if (this.mService != null) {
                this.mService.stopSelf();
            }
            this.mService = null;
        } else {
            if (this.rfidWithUHF != null) {
                this.rfidWithUHF.free();
            }
            if (this.btStatusCallback != null) {
                this.btStatusCallback.getStatus(StatusEnum.DISCONNECTED, null);
            }
        }
    }

    public void scanBTDevices(ScanBTCallback scanBTCallback) {
        if (isBluetooth) {
            this.scanBTCallback = scanBTCallback;
            if (this.mService != null) {
                this.mService.startBTScan(scanBTCallback);
            }
        }
    }

    public void stopScanBTDevices() {
        if (isBluetooth && this.mService != null) {
            this.mService.stoptBTScan();
        }
    }

    public synchronized void connect(String address, BTStatusCallback btStatusCallback) {
        if (isBluetooth) {
            if (address != null && this.mService != null && btStatusCallback != null) {
                deviceAddress = address;
                this.btStatusCallback = btStatusCallback;
                this.mService.connect(deviceAddress, btStatusCallback);
                this.mService.setKeyEventCallback(this.KeyEventCallback);
                this.mService.setDataCallBack(this.datareceive);
            }
        } else {
            if (this.rfidWithUHF == null) {
                try {
                    this.rfidWithUHF = RFIDWithUHF.getInstance();
                }
                catch (ConfigurationException e) {
                    e.printStackTrace();
                }
            }
            this.btStatusCallback = btStatusCallback;
            if (this.rfidWithUHF != null) {
                if (this.btStatusCallback != null) {
                    this.btStatusCallback.getStatus(StatusEnum.CONNECTING, null);
                }
                if (this.rfidWithUHF.init_R2000()) {
                    if (this.btStatusCallback != null) {
                        this.btStatusCallback.getStatus(StatusEnum.CONNECTED, null);
                    }
                } else {
                    this.rfidWithUHF.free();
                    if (this.btStatusCallback != null) {
                        this.btStatusCallback.getStatus(StatusEnum.DISCONNECTED, null);
                    }
                }
            }
        }
    }

    public synchronized void setKeyEventCallback(KeyEventCallback KeyEventCallback2) {
        if (isBluetooth) {
            if (this.mService != null) {
                this.mService.setKeyEventCallback(KeyEventCallback2);
            }
            this.KeyEventCallback = KeyEventCallback2;
        }
    }

    public synchronized void disconnect() {
        if (isBluetooth) {
            if (this.mService != null) {
                this.mService.disconnect();
            }
        } else {
            if (this.rfidWithUHF != null) {
                this.rfidWithUHF.free();
            }
            if (this.btStatusCallback != null) {
                this.btStatusCallback.getStatus(StatusEnum.DISCONNECTED, null);
            }
        }
    }

    public synchronized StatusEnum getConnectStatus() {
        if (isBluetooth) {
            if (this.mService != null) {
                return this.mService.getBTConnectStatus();
            }
            return StatusEnum.DISCONNECTED;
        }
        if (this.rfidWithUHF != null && this.rfidWithUHF.powerOn) {
            return StatusEnum.CONNECTED;
        }
        return StatusEnum.DISCONNECTED;
    }

    public synchronized int getBattery() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTGetBattery();
        }
        return -1;
    }

    public synchronized String scanBarcode() {
        if (isBluetooth) {
            char[] barcode = new char[512];
            int len = this.getDeviceAPI().UHFBTGetBarcode(barcode);
            if (len <= 0) {
                return "";
            }
            return new String(barcode, 0, len);
        }
        return "";
    }

    private void cleanData() {
        if (isBluetooth) {
            wIndex = 0;
            rIndex = 0;
            int k = 0;
            while (k < tempData.length) {
                RFIDWithUHFBluetooth.tempData[k] = 0;
                ++k;
            }
        }
    }

    private void cleanDataTAG() {
        if (isBluetooth) {
            wIndexTAG = 0;
            rIndexTAG = 0;
            int k = 0;
            while (k < tempDataTAG.length) {
                RFIDWithUHFBluetooth.tempDataTAG[k] = 0;
                ++k;
            }
        }
    }

    int sendAndReceiveData(byte[] sendData, int sendDataLen, int timeOut, byte[] outData) {
        if (isBluetooth) {
            if (timeOut < 10) {
                timeOut = 10;
            }
            if (this.mService != null) {
                this.isFlag = false;
                this.cleanData();
                byte[] tempSend = Arrays.copyOf(sendData, sendDataLen);
                if (this.mService.writeRXCharacteristic(tempSend)) {
                    int k = 0;
                    while (k < timeOut) {
                        if (this.isFlag) break;
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++k;
                    }
                    if (wIndex > 0) {
                        byte[] result = Arrays.copyOf(tempData, wIndex);
                        int index = 0;
                        while (index < wIndex) {
                            if (outData.length > index) {
                                outData[index] = tempData[index];
                            }
                            ++index;
                        }
                        this.cleanData();
                        return index;
                    }
                    return 0;
                }
                Log.e((String)this.TAG, (String)"sendAndReceiveData  ==> \u53d1\u9001\u6570\u636e\u5931\u8d25!");
                return -1;
            }
        }
        return -1;
    }

    boolean sendData(byte[] data, int len) {
        Log.d((String)this.TAG, (String)"sendData");
        if (isBluetooth) {
            this.isFlag = false;
            if (this.mService != null) {
                this.cleanData();
                byte[] tempSend = Arrays.copyOf(data, len);
                if (this.mService.writeRXCharacteristic(tempSend)) {
                    return true;
                }
            }
        }
        return false;
    }

    byte[] receiveData() {
        if (isBluetooth) {
            int len = wIndex;
            if (len > rIndex) {
                byte[] result = Arrays.copyOfRange(tempData, rIndex, len);
                Log.d((String)this.TAG, (String)("\u8fd4\u56de\u7684\u6570\u636e receiveData ===> receiveData:" + StringUtility.bytes2HexString2(result, result.length)));
                rIndex = len;
                return result;
            }
            return null;
        }
        return null;
    }

    byte[] receiveDataTAG() {
        if (isBluetooth) {
            int len = wIndexTAG;
            if (len > rIndexTAG) {
                byte[] result = Arrays.copyOfRange(tempDataTAG, rIndexTAG, len);
                Log.d((String)this.TAG, (String)("\u8fd4\u56de\u7684\u6570\u636e receiveData ===> receiveData:" + StringUtility.bytes2HexString2(result, result.length)));
                rIndexTAG = len;
                return result;
            }
            return null;
        }
        return null;
    }

    private void receiveData(byte[] txValue, boolean flag) {
        if (isBluetooth) {
            if (txValue != null) {
                int k = 0;
                while (k < txValue.length) {
                    if (wIndex >= tempData.length) break;
                    RFIDWithUHFBluetooth.tempData[RFIDWithUHFBluetooth.wIndex] = txValue[k];
                    ++wIndex;
                    ++k;
                }
                k = 0;
                while (k < txValue.length) {
                    if (wIndexTAG >= tempDataTAG.length) break;
                    RFIDWithUHFBluetooth.tempDataTAG[RFIDWithUHFBluetooth.wIndexTAG] = txValue[k];
                    ++wIndexTAG;
                    ++k;
                }
            }
            this.isFlag = flag;
        }
    }

    private void service_init(Context context) {
        Intent bindIntent = new Intent(context, BTService.class);
        context.bindService(bindIntent, this.mServiceConnection, 1);
    }

    public synchronized boolean uhfEncryptSM4(String pszdata, StringBuilder outdata) {
        if (pszdata == null || pszdata.isEmpty()) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszdata)) {
            Log.e((String)this.TAG, (String)"uhfEncryptSM4 error pszkeydata fail!");
            return false;
        }
        int len = pszdata.length() / 2;
        byte[] newData = new byte[len];
        if (isBluetooth) {
            char[] oldData = StringUtility.hexString2Chars(pszdata);
            if (this.getDeviceAPI().UHFEncryptSM4((char)len, oldData, newData) == 0) {
                if (outdata != null) {
                    outdata.append(StringUtility.bytes2HexString(newData));
                }
                return true;
            }
            return false;
        }
        byte[] oldData = StringUtility.hexString2Bytes(pszdata);
        newData = this.getDeviceAPI().UHFEncSM4(oldData, len);
        if (newData != null && newData[0] == 0) {
            if (outdata != null) {
                int datalen = newData[1] & 0xFF;
                byte[] temp = Arrays.copyOfRange(newData, 2, 2 + datalen);
                outdata.append(StringUtility.bytes2HexString(temp));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfDecryptSM4(String pszdata, StringBuilder outdata) {
        if (pszdata == null || pszdata.isEmpty()) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszdata)) {
            Log.e((String)this.TAG, (String)"uhfDecryptSM4 error pszkeydata fail!");
            return false;
        }
        int len = pszdata.length() / 2;
        byte[] newData = new byte[len];
        if (isBluetooth) {
            char[] oldData = StringUtility.hexString2Chars(pszdata);
            if (this.getDeviceAPI().UHFDecryptSM4((char)len, oldData, newData) == 0) {
                if (outdata != null) {
                    outdata.append(StringUtility.bytes2HexString(newData));
                }
                return true;
            }
            return false;
        }
        byte[] oldData = StringUtility.hexString2Bytes(pszdata);
        newData = this.getDeviceAPI().UHFDecSM4(oldData, len);
        if (newData != null && newData[0] == 0) {
            if (outdata != null) {
                int datalen = newData[1] & 0xFF;
                byte[] temp = Arrays.copyOfRange(newData, 2, 2 + datalen);
                outdata.append(StringUtility.bytes2HexString(temp));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfGetSMKey(byte[] mode, StringBuilder keydata, StringBuilder lvdata) {
        if (mode == null || mode.length == 0) {
            return false;
        }
        byte[] bKeyData = new byte[16];
        byte[] blvData = new byte[16];
        if (isBluetooth) {
            if (this.getDeviceAPI().UHFGETSM4(mode, bKeyData, blvData) == 0) {
                if (keydata != null) {
                    keydata.append(StringUtility.bytes2HexString(bKeyData));
                }
                if (lvdata != null) {
                    lvdata.append(StringUtility.bytes2HexString(blvData));
                }
                return true;
            }
            return false;
        }
        byte[] data = this.getDeviceAPI().UHFGetSM4();
        if (data != null && data[0] == 0) {
            if (mode != null && mode.length > 0) {
                mode[0] = data[2];
            }
            if (keydata != null) {
                bKeyData = Arrays.copyOfRange(data, 3, 19);
                keydata.append(StringUtility.bytes2HexString(bKeyData));
            }
            if (lvdata != null) {
                blvData = Arrays.copyOfRange(data, 19, 35);
                lvdata.append(StringUtility.bytes2HexString(blvData));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfSetSM4Key(int mode, String pszkeydata, String pszlvdata) {
        if (mode != 0 && mode != 2 && mode != 4 && mode != 6) {
            Log.e((String)this.TAG, (String)("uhfSetSM4Key error  mode=" + mode));
            return false;
        }
        if (pszkeydata == null || pszkeydata.isEmpty() || pszlvdata == null || pszlvdata.isEmpty()) {
            Log.e((String)this.TAG, (String)"uhfSetSM4Key error 1");
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszlvdata) || !StringUtility.isHexNumberRex(pszkeydata)) {
            Log.e((String)this.TAG, (String)"uhfSetSM4Key error 2!");
            return false;
        }
        if (isBluetooth) {
            char[] ckeyData = StringUtility.hexString2Chars(pszkeydata);
            char[] cpszlvData = StringUtility.hexString2Chars(pszlvdata);
            if (ckeyData.length != 16 || cpszlvData.length != 16) {
                Log.e((String)this.TAG, (String)"uhfSetSM4Key error 3!");
                return false;
            }
            return this.getDeviceAPI().UHFSETSM4((char)mode, ckeyData, cpszlvData) == 0;
        }
        byte[] ckeyData = StringUtility.hexString2Bytes(pszkeydata);
        byte[] cpszlvData = StringUtility.hexString2Bytes(pszlvdata);
        if (ckeyData.length != 16 || cpszlvData.length != 16) {
            Log.e((String)this.TAG, (String)"uhfSetSM4Key error 3!");
            return false;
        }
        return this.getDeviceAPI().UHFSetSM4((char)mode, ckeyData, cpszlvData) == 0;
    }

    public synchronized boolean uhfEncWriteUser(int ptr, int len, String pszdata) {
        if (ptr < 0 || pszdata == null || pszdata.isEmpty()) {
            return false;
        }
        if (!StringUtility.isHexNumberRex(pszdata)) {
            Log.e((String)this.TAG, (String)"uhfEncWriteUser error pszkeydata fail!");
            return false;
        }
        byte[] data = StringUtility.hexString2Bytes(pszdata);
        if (data.length < len) {
            Log.e((String)this.TAG, (String)"uhfEncWriteUser  len  error!");
            return false;
        }
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTEncWriteUser(ptr, len, data) == 0;
        }
        return this.getDeviceAPI().UHFEncUSER(ptr, len, data) == 0;
    }

    public synchronized boolean uhfEncReadUser(int ptr, int len, StringBuilder outdata) {
        if (ptr < 0 || len <= 0) {
            return false;
        }
        byte[] newData = new byte[len];
        if (isBluetooth) {
            if (this.getDeviceAPI().UHFBTEncReadUser(ptr, len, newData) == 0) {
                if (outdata != null) {
                    outdata.append(StringUtility.bytes2HexString(newData));
                }
                return true;
            }
            return false;
        }
        newData = this.getDeviceAPI().UHFDecUSER(ptr, len);
        if (newData != null && newData[0] == 0) {
            if (outdata != null) {
                int datalen = newData[1] & 0xFF;
                byte[] temp = Arrays.copyOfRange(newData, 2, 2 + datalen);
                outdata.append(StringUtility.bytes2HexString(temp));
            }
            return true;
        }
        return false;
    }

    public synchronized boolean uhfReBoot(int flag) {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTReBootAPP((char)flag) == 0;
        }
        if (flag == 0) {
            if (this.rfidWithUHF == null) {
                return false;
            }
            return this.rfidWithUHF.uhfJump2Boot();
        }
        return this.getDeviceAPI().UHFJump2BootSTM32() == 0;
    }

    public synchronized boolean uhfStartUpdate() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTStartUpdate() == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.uhfStartUpdate();
    }

    public synchronized boolean uhfUpdateData(byte[] buff) {
        if (buff == null || buff.length == 0) {
            return false;
        }
        byte[] data = new byte[64];
        if (buff.length < 64) {
            int k = 0;
            while (k < buff.length) {
                data[k] = buff[k];
                ++k;
            }
        } else {
            int k = 0;
            while (k < 64) {
                data[k] = buff[k];
                ++k;
            }
        }
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTUpdateData(data) == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.uhfUpdating(data);
    }

    public synchronized boolean uhfEndUpdate() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTEndUpdate() == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.uhfStopUpdate();
    }

    public synchronized boolean writeData(String accessPwd, BankEnum bank, int ptr, int cnt, String data) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        int filter_ptr = 32;
        int filter_cnt = 0;
        String filter_data = "00";
        if (isBluetooth) {
            BankEnum filter_bank = BankEnum.EPC;
            boolean result = this.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, bank, ptr, cnt, data);
            return result;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        boolean result = this.rfidWithUHF.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uhfbank, ptr, cnt, data);
        return result;
    }

    public synchronized boolean writeData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt, String writeData) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        if (isBluetooth) {
            char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter_data = StringUtility.hexString2Chars(filterData);
            char[] ufData_write = StringUtility.hexString2Chars(writeData);
            char filter_bank = (char)filterBank.value;
            int result = this.getDeviceAPI().UHFBTWriteData(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write);
            return result == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            filter_bank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            filter_bank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            filter_bank = RFIDWithUHF.BankEnum.USER;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        boolean result = this.rfidWithUHF.writeData(accessPwd, filter_bank, filter_ptr, filter_cnt, filterData, uhfbank, uPtr, uCnt, writeData);
        return result;
    }

    public synchronized boolean authentication(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt, String writeData, StringBuffer rev) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(writeData) || !StringUtility.isHexNumberRex(writeData)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        char uBank = (char)bank.value;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        if (isBluetooth) {
            char[] crev = new char[60];
            char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter_data = StringUtility.hexString2Chars(filterData);
            char[] ufData_write = StringUtility.hexString2Chars(writeData);
            char filter_bank = (char)filterBank.value;
            int len = this.getDeviceAPI().UHFBTAuthentication(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt, ufData_write, crev);
            if (len > 0) {
                if (rev != null) {
                    rev.append(StringUtility.chars2HexString(crev, len));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public synchronized boolean authentication(String accessPwd, BankEnum bank, int ptr, int cnt, String data, StringBuffer rev) {
        if (StringUtility.isEmpty(accessPwd) || StringUtility.isEmpty(data)) {
            return false;
        }
        int filter_ptr = 32;
        int filter_cnt = 0;
        String filter_data = "00";
        if (isBluetooth) {
            BankEnum filter_bank = BankEnum.EPC;
            boolean result = this.authentication(accessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, bank, ptr, cnt, data, rev);
            return result;
        }
        return false;
    }

    public synchronized boolean uhfKeydataMac(byte[] keyData, byte[] mac) {
        if (isBluetooth) {
            if (keyData == null || keyData.length != 16) {
                return false;
            }
            if (mac == null || mac.length != 4) {
                return false;
            }
            return this.getDeviceAPI().UHFBTKeydataMac(keyData, mac) == 0;
        }
        return false;
    }

    public synchronized String readData(String accessPwd, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd)) {
            return null;
        }
        int filterPtr = 0;
        int filterCnt = 0;
        String filterData = "00";
        if (isBluetooth) {
            BankEnum filterBank = BankEnum.EPC;
            return this.readData(accessPwd, filterBank, filterPtr, filterCnt, filterData, bank, ptr, cnt);
        }
        if (this.rfidWithUHF == null) {
            return "";
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.readData(accessPwd, filter_bank, filterPtr, filterCnt, filterData, uhfbank, ptr, cnt);
    }

    public synchronized String readData(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, BankEnum bank, int ptr, int cnt) {
        if (StringUtility.isEmpty(accessPwd) || !StringUtility.isHexNumberRex(accessPwd)) {
            return null;
        }
        if (StringUtility.isEmpty(filterData) || !StringUtility.isHexNumberRex(filterData)) {
            return null;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return null;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return null;
            }
        } else {
            filterData = "00";
            filterCnt = 0;
        }
        int filter_ptr = filterPtr;
        int filter_cnt = filterCnt;
        int uPtr = ptr;
        char uCnt = (char)cnt;
        if (isBluetooth) {
            char filter_bank = (char)filterBank.value;
            char uBank = (char)bank.value;
            char[] pszuAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter_data = StringUtility.hexString2Chars(filterData);
            char[] result = this.getDeviceAPI().UHFBTReadData(pszuAccessPwd, filter_bank, filter_ptr, filter_cnt, filter_data, uBank, uPtr, uCnt);
            if (result[0] != '\u0000') {
                Log.e((String)this.TAG, (String)("readData() err :" + result[0]));
                return null;
            }
            char[] data = Arrays.copyOfRange(result, 2, result[1] + 2);
            return StringUtility.chars2HexString(data, data.length);
        }
        if (this.rfidWithUHF == null) {
            return "";
        }
        RFIDWithUHF.BankEnum filter_bank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            filter_bank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            filter_bank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            filter_bank = RFIDWithUHF.BankEnum.USER;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (bank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (bank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (bank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.readData(accessPwd, filter_bank, filter_ptr, filter_cnt, filterData, uhfbank, uPtr, uCnt);
    }

    public synchronized boolean lockMem(String accessPwd, String lockCode) {
        boolean result = false;
        if (isBluetooth) {
            result = this.lockMem(accessPwd, BankEnum.EPC, 0, 0, "00", lockCode);
        } else {
            if (this.rfidWithUHF == null) {
                return false;
            }
            result = this.rfidWithUHF.lockMem(accessPwd, RFIDWithUHF.BankEnum.UII, 0, 0, "00", lockCode);
        }
        if (result) {
            return true;
        }
        Log.e((String)this.TAG, (String)("lockMem() err :" + result));
        return false;
    }

    public synchronized boolean lockMem(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData, String lockCode) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (StringUtility.isEmpty(lockCode)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        if (isBluetooth) {
            char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter = StringUtility.hexString2Chars(filterData);
            char[] bLockData = StringUtility.hexString2Chars(lockCode);
            return DeviceAPI.getInstance().UHFBTLockMemEx(bAccessPwd, (char)filterBank.value, filterPtr, filterCnt, filter, bLockData) == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.lockMem(accessPwd, uhfbank, filterPtr, filterCnt, filterData, lockCode);
    }

    public synchronized boolean kill(String accessPwd) {
        boolean filterPtr = false;
        boolean filterCnt = false;
        String filterData = "00";
        if (isBluetooth) {
            BankEnum filterBank = BankEnum.EPC;
            return this.kill(accessPwd, filterBank, 0, 0, filterData);
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.killTag_Ex(accessPwd);
    }

    public synchronized boolean kill(String accessPwd, BankEnum filterBank, int filterPtr, int filterCnt, String filterData) {
        if (StringUtility.isEmpty(accessPwd)) {
            return false;
        }
        if (filterCnt > 0) {
            if (StringUtility.isEmpty(filterData)) {
                return false;
            }
            int tempLen = filterCnt / 8 + (filterCnt % 8 == 0 ? 0 : 1);
            int tempdataLen = filterData.replace(" ", "").length() / 2;
            if (tempdataLen < tempLen) {
                return false;
            }
        } else {
            filterData = "00";
        }
        if (isBluetooth) {
            char[] bAccessPwd = StringUtility.hexString2Chars(accessPwd);
            char[] filter = StringUtility.hexString2Chars(filterData);
            return DeviceAPI.getInstance().UHFBTKill(bAccessPwd, (char)filterBank.value, filterPtr, filterCnt, filter) == 0;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        RFIDWithUHF.BankEnum uhfbank = RFIDWithUHF.BankEnum.UII;
        if (filterBank == BankEnum.RESERVED) {
            uhfbank = RFIDWithUHF.BankEnum.RESERVED;
        } else if (filterBank == BankEnum.TID) {
            uhfbank = RFIDWithUHF.BankEnum.TID;
        } else if (filterBank == BankEnum.USER) {
            uhfbank = RFIDWithUHF.BankEnum.USER;
        }
        return this.rfidWithUHF.killTag(accessPwd, uhfbank, filterPtr, filterCnt, filterData);
    }

    public synchronized int getFrequencyMode() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFGetBTFrequency();
        }
        if (this.rfidWithUHF == null) {
            return -1;
        }
        int mode = this.rfidWithUHF.getFrequencyMode();
        switch (mode) {
            case 0: {
                mode = 2;
                break;
            }
            case 1: {
                mode = 1;
                break;
            }
            case 2: {
                mode = 4;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                mode = 8;
                break;
            }
            case 5: {
                mode = 22;
                break;
            }
            case 6: {
                mode = 50;
                break;
            }
            case 7: {
                mode = 128;
            }
        }
        return mode;
    }

    public synchronized boolean setFreHop(float fre) {
        int result;
        int ifre = (int)(fre * 1000.0f);
        if (isBluetooth) {
            result = this.getDeviceAPI().UHFBTFreHopSet(ifre);
            if (result == 0) {
                return true;
            }
        } else {
            if (this.rfidWithUHF == null) {
                return false;
            }
            return this.rfidWithUHF.setFreHop(fre);
        }
        Log.e((String)this.TAG, (String)("setFreHop() err :" + result));
        return false;
    }

    public synchronized boolean setFrequencyMode(byte freMode) {
        if (isBluetooth) {
            int result = this.getDeviceAPI().UHFSetBTFrequency(freMode);
            if (result == 0) {
                return true;
            }
            Log.e((String)this.TAG, (String)("setFrequencyMode() err :" + result));
            return false;
        }
        switch (freMode & 0xFF) {
            case 1: {
                freMode = 1;
                break;
            }
            case 2: {
                freMode = 0;
                break;
            }
            case 4: {
                freMode = (byte)2;
                break;
            }
            case 8: {
                freMode = (byte)4;
                break;
            }
            case 22: {
                freMode = (byte)5;
                break;
            }
            case 50: {
                freMode = (byte)6;
                break;
            }
            case 128: {
                freMode = (byte)7;
            }
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        Log.e((String)this.TAG, (String)("setFrequencyMode() freMode :" + freMode));
        return this.rfidWithUHF.setFrequencyMode(freMode);
    }

    public synchronized int getPower() {
        if (isBluetooth) {
            return this.getDeviceAPI().UHFBTGetPower();
        }
        if (this.rfidWithUHF == null) {
            return -1;
        }
        return this.rfidWithUHF.getPower();
    }

    public synchronized boolean setPower(int power) {
        if (isBluetooth) {
            int result = this.getDeviceAPI().UHFBTSetPower((byte)power);
            if (result == 0) {
                return true;
            }
            Log.e((String)this.TAG, (String)("setPower() err :" + result));
            return false;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.setPower(power);
    }

    public synchronized String getR2000Version() {
        if (isBluetooth) {
            byte[] version = new byte[256];
            Log.d((String)"DeviceAPI", (String)"getVersion");
            int len = this.getDeviceAPI().UHFBTR2000Version(version);
            if (len > 0) {
                Log.d((String)"DeviceAPI", (String)("UHFBTR2000Version result ver=" + StringUtility.bytes2HexString2(version, len)));
                String ver = new String(version, 0, len);
                return ver;
            }
            return "";
        }
        if (this.rfidWithUHF == null) {
            return "";
        }
        return this.rfidWithUHF.getHardwareType();
    }

    public synchronized String getSTM32Version() {
        if (isBluetooth) {
            byte[] version = new byte[256];
            Log.d((String)"DeviceAPI", (String)"getSTM32Version");
            int len = this.getDeviceAPI().UHFBTSTM32Version(version);
            if (len > 0) {
                Log.d((String)"DeviceAPI", (String)("getSTM32Version result ver=" + StringUtility.bytes2HexString2(version, len)));
                String ver = new String(version, 0, len);
                return ver;
            }
            return "";
        }
        char[] result = this.getDeviceAPI().UHFGetHwTypeM3();
        if (result != null && result[0] == '\u0000') {
            char[] arrs = Arrays.copyOfRange(result, 2, result[1] + 2);
            return new String(arrs);
        }
        return "";
    }

    public synchronized boolean startInventoryTag() {
        if (isBluetooth) {
            if (this.getDeviceAPI().UHFBTStartInventory() == 0) {
                isStop = false;
                return true;
            }
            return false;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.startInventoryTag(0, 0, 4);
    }

    public synchronized boolean stopInventoryTag() {
        if (isBluetooth) {
            isStop = true;
            boolean result = false;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            rIndex = 0;
            result = this.getDeviceAPI().UHFBTStopInventory() == 0;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            isStop = false;
            return result;
        }
        if (this.rfidWithUHF == null) {
            return false;
        }
        return this.rfidWithUHF.stopInventory();
    }

    public synchronized ArrayList<UHFTAGInfo> readTagFromBuffer() {
        if (isBluetooth) {
            if (!isStop) {
                this.cleanDataTAG();
                String hexCmd = "A55A0008E0E80D0A";
                byte[] cmd = StringUtility.hexString2Bytes(hexCmd);
                if (this.mService.writeRXCharacteristic(cmd)) {
                    Log.d((String)"DeviceAPI", (String)"readTagFromBuffer \u53d1\u9001\u6570\u636e\u6210\u529f(A55A0008E0E80D0A)!");
                    byte[] data = new byte[1024];
                    int len = this.getDeviceAPI().UHFBTGetTag(data);
                    Log.d((String)"DeviceAPI", (String)("\u8bfb\u53d6\u6807\u7b7e\u8fd4\u56de\u957f\u5ea6:" + len));
                    if (len > 2) {
                        byte[] result = Arrays.copyOf(data, len);
                        ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
                        if (result != null) {
                            String strData = StringUtility.bytes2HexString2(result, result.length);
                            int count = result[2];
                            int begin = 6;
                            int end = 0;
                            int k = 0;
                            while (k < count) {
                                String strEPCLen;
                                int epcLen;
                                UHFTAGInfo tag = new UHFTAGInfo();
                                end = begin + 2;
                                if (end > strData.length() || (end = (begin = end) + (epcLen = Integer.parseInt(strEPCLen = strData.substring(begin, end), 16)) * 2) > strData.length()) break;
                                String epc = strData.substring(begin, end);
                                tag.setEPC(epc);
                                list.add(tag);
                                begin = end;
                                ++k;
                            }
                        }
                        if (list.size() > 0) {
                            return list;
                        }
                        return null;
                    }
                } else {
                    Log.d((String)"DeviceAPI", (String)"readTagFromBuffer \u53d1\u9001\u6570\u636e\u5931\u8d25(A55A0008E0E80D0A)!");
                }
            }
            return null;
        }
        if (this.rfidWithUHF == null) {
            return null;
        }
        String[] data = this.rfidWithUHF.readTagFromBuffer();
        if (data != null) {
            ArrayList<UHFTAGInfo> list = new ArrayList<UHFTAGInfo>();
            String epc = this.rfidWithUHF.convertUiiToEPC(data[1]);
            UHFTAGInfo uhfINfo = new UHFTAGInfo();
            uhfINfo.setEPC(epc);
            list.add(uhfINfo);
            return list;
        }
        return null;
    }

    public boolean getBluetoothMode() {
        return isBluetooth;
    }

    public void setBluetoothMode(boolean isBluetoothMode) {
        isBluetooth = isBluetoothMode;
    }

    public static interface BTStatusCallback {
        public void getStatus(StatusEnum var1, BluetoothDevice var2);
    }

    public static enum BankEnum {
        RESERVED(0),
        EPC(1),
        TID(2),
        USER(3);

        private final byte value;

        public byte getValue() {
            return this.value;
        }

        private BankEnum(byte value) {
            this.value = value;
        }
    }

    class DataReceiveBTData
    implements BTService.IDataCallBack {
        DataReceiveBTData() {
        }

        @Override
        public void receiveBTData(byte[] txValue, boolean flag) {
            RFIDWithUHFBluetooth.this.receiveData(txValue, flag);
        }
    }

    public static interface KeyEventCallback {
        public void getKeyEvent(int var1);
    }

    public static interface ScanBTCallback {
        public void getDevices(BluetoothDevice var1, int var2, byte[] var3);
    }

    public static enum StatusEnum {
        CONNECTED,
        DISCONNECTED,
        CONNECTING;

    }
}

