/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.rscja.deviceapi.Device;
import com.rscja.deviceapi.DeviceAPI;
import com.rscja.deviceapi.DeviceConfiguration;
import java.util.Timer;
import java.util.TimerTask;

public class ScanerLedLight
extends Device {
    private static final String TAG = ScanerLedLight.class.getSimpleName();
    private static boolean DEBUG = false;
    private static ScanerLedLight single = null;
    private static long lastTime = System.currentTimeMillis();
    private Timer mTimer = null;
    private static String curModel = DeviceConfiguration.getModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ScanerLedLight getInstance() {
        if (single != null) return single;
        Class<ScanerLedLight> clazz = ScanerLedLight.class;
        synchronized (ScanerLedLight.class) {
            if (single != null) return single;
            single = new ScanerLedLight();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized void init() {
        Log.d((String)"DeviceAPI_ScanerLed", (String)("init()  Model=" + curModel));
        if (this.isQualcomm()) {
            DeviceAPI.getInstance().ScanerLed_Init(curModel);
            this.mTimer = new Timer();
        }
        if (this.isMTK()) {
            this.mTimer = new Timer();
        }
    }

    public synchronized void free() {
        if (this.isQualcomm()) {
            DeviceAPI.getInstance().ScanerLed_Free(curModel);
            this.setPowerOn(false);
            this.mTimer = null;
        }
        if (this.isMTK()) {
            this.mTimer = null;
        }
    }

    public synchronized void On(Context context) {
        if (this.isQualcomm()) {
            if (!this.isPowerOn()) {
                if (DEBUG) {
                    Log.d((String)"DeviceAPI_ScanerLed", (String)"--------On()------------");
                }
                DeviceAPI.getInstance().ScanerLed_On(curModel);
                this.setPowerOn(true);
            }
        } else if (this.isMTK()) {
            this.ScanLED(true, context);
        }
    }

    public synchronized void off(Context context) {
        if (this.isQualcomm()) {
            if (this.isPowerOn()) {
                if (DEBUG) {
                    Log.d((String)"DeviceAPI_ScanerLed", (String)"--------off()------------");
                }
                DeviceAPI.getInstance().ScanerLed_Off(curModel);
                this.setPowerOn(false);
            }
        } else {
            this.ScanLED(false, context);
        }
    }

    public synchronized void blink(Context context) {
        if (this.isQualcomm() && this.isPowerOn()) {
            return;
        }
        ScanerLedLight.getInstance().On(context);
        if (this.mTimer != null) {
            this.mTimer.schedule((TimerTask)new OffTask(context), 500L);
        }
    }

    public synchronized void blink(Context context, int lightTime, int interval) {
        if (this.isQualcomm() && this.isPowerOn()) {
            return;
        }
        if (interval < 50) {
            interval = 50;
        }
        if (lightTime < 50) {
            lightTime = 50;
        }
        if (System.currentTimeMillis() - lastTime < (long)(interval += lightTime)) {
            return;
        }
        ScanerLedLight.getInstance().On(context);
        lastTime = System.currentTimeMillis();
        if (this.mTimer != null) {
            this.mTimer.schedule((TimerTask)new OffTask(context), lightTime);
        }
    }

    private void ScanLED(boolean on, Context context) {
        if (this.isMTK() && context != null) {
            Intent mScanIntent = new Intent("com.chengwei.scanled.statuschanged");
            if (on) {
                mScanIntent.putExtra("value", 255);
            } else {
                mScanIntent.putExtra("value", 0);
            }
            context.sendBroadcast(mScanIntent);
        }
    }

    public void openAuxiliaryLight(Context context) {
        if (this.isMTK()) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"scanAuxiliaryLight begin");
            }
            if (context != null) {
                Intent intent = new Intent("com.chengwei.pupilled.statuschanged");
                intent.putExtra("value", 255);
                context.sendBroadcast(intent);
            }
        }
    }

    public void closeAuxiliaryLight(Context context) {
        if (this.isMTK()) {
            if (DEBUG) {
                Log.d((String)TAG, (String)"scanAuxiliaryLight begin");
            }
            if (context != null) {
                Intent intent = new Intent("com.chengwei.pupilled.statuschanged");
                intent.putExtra("value", 0);
                context.sendBroadcast(intent);
            }
        }
    }

    private boolean isQualcomm() {
        String model = curModel;
        return DeviceConfiguration.C6000_8909.equals(model) || "H100_8953".equals(model) || "P80_8953".equals(model);
    }

    private boolean isMTK() {
        String model = curModel;
        return DeviceConfiguration.C6000_6735.equals(model) || DeviceConfiguration.H100_6735.equals(model) || DeviceConfiguration.C70_6735.equals(model) || DeviceConfiguration.C72_6735.equals(model);
    }

    private class OffTask
    extends TimerTask {
        Context context;

        public OffTask(Context context) {
            this.context = context;
        }

        @Override
        public void run() {
            if (DEBUG) {
                Log.d((String)"ScanerLedLight", (String)"OffTask off");
            }
            ScanerLedLight.getInstance().off(this.context);
            this.cancel();
        }
    }
}

