/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.utility;

import android.util.Log;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public class StringUtility {
    public static boolean DEBUG = false;
    public static String TAG = "DeviceAPI_";

    public static String byte2Bit(byte b) {
        return "" + (byte)(b >> 7 & 1) + (byte)(b >> 6 & 1) + (byte)(b >> 5 & 1) + (byte)(b >> 4 & 1) + (byte)(b >> 3 & 1) + (byte)(b >> 2 & 1) + (byte)(b >> 1 & 1) + (byte)(b >> 0 & 1);
    }

    public static byte BitToByte(String byteStr) {
        if (byteStr == null) {
            return 0;
        }
        int len = byteStr.length();
        if (len != 4 && len != 8) {
            return 0;
        }
        int re = len == 8 ? (byteStr.charAt(0) == '0' ? Integer.parseInt(byteStr, 2) : Integer.parseInt(byteStr, 2) - 256) : Integer.parseInt(byteStr, 2);
        return (byte)re;
    }

    public static String bytes2HexString(byte[] b, int size) {
        String ret = "";
        try {
            int i = 0;
            while (i < size) {
                String hex = Integer.toHexString(b[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                ret = String.valueOf(ret) + hex.toUpperCase();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String bytes2HexString2(byte[] b, int size) {
        StringBuffer sb = new StringBuffer();
        try {
            int i = 0;
            while (i < size) {
                String hex = Integer.toHexString(b[i] & 0xFF);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                sb.append(hex.toUpperCase());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String bytes2HexString(byte[] b) {
        return StringUtility.bytes2HexString(b, b.length);
    }

    public static String bytesToHexString(byte[] b, int size) {
        String ret = "";
        try {
            int i = 0;
            while (i < size) {
                String hex = StringUtility.byte2HexString(b[i]);
                ret = String.valueOf(ret) + hex;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static byte[] charsTobytes(char[] c, int size) {
        if (c == null || c.length == 0) {
            return null;
        }
        byte[] b = new byte[size];
        try {
            int i = 0;
            while (i < size) {
                b[i] = (byte)c[i];
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static char[] bytesTochars(byte[] c, int size) {
        if (c == null || c.length == 0) {
            return null;
        }
        char[] b = new char[size];
        try {
            int i = 0;
            while (i < size) {
                b[i] = (char)(c[i] & 0xFF);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static String byte2HexString(byte b) {
        String ret = "";
        try {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret = String.valueOf(ret) + hex.toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static String chars2HexString(char[] c, int size) {
        StringBuffer sb = new StringBuffer();
        try {
            int j = 0;
            int i = 0;
            while (i < size) {
                j = c[i];
                String hex = Integer.toHexString(j);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                sb.append(hex.toUpperCase());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static byte[] long2Bytes(long num) {
        byte[] byteNum = new byte[8];
        int ix = 0;
        while (ix < 8) {
            int offset = 64 - (ix + 1) * 8;
            byteNum[ix] = (byte)(num >> offset & 0xFFL);
            ++ix;
        }
        return byteNum;
    }

    public static byte[] int2Bytes(int num) {
        byte[] byteNum = new byte[4];
        int ix = 0;
        while (ix < 4) {
            int offset = 32 - (ix + 1) * 8;
            byteNum[ix] = (byte)(num >> offset & 0xFF);
            ++ix;
        }
        return byteNum;
    }

    public static long byteArrayTolong(byte[] byteArray) {
        byte[] a = new byte[8];
        int i = a.length - 1;
        int j = byteArray.length - 1;
        while (i >= 0) {
            a[i] = j >= 0 ? byteArray[j] : (byte)0;
            --i;
            --j;
        }
        long v0 = (long)(a[0] & 0xFF) << 56;
        long v1 = (long)(a[1] & 0xFF) << 48;
        long v2 = (long)(a[2] & 0xFF) << 40;
        long v3 = (long)(a[3] & 0xFF) << 32;
        long v4 = (long)(a[4] & 0xFF) << 24;
        long v5 = (long)(a[5] & 0xFF) << 16;
        long v6 = (long)(a[6] & 0xFF) << 8;
        long v7 = a[7] & 0xFF;
        return v0 | v1 | v2 | v3 | v4 | v5 | v6 | v7;
    }

    public static int bytesToInt(byte[] bytes) {
        int addr = bytes[0] & 0xFF;
        addr |= bytes[1] << 8 & 0xFF00;
        addr |= bytes[2] << 16 & 0xFF0000;
        return addr |= bytes[3] << 24 & 0xFF000000;
    }

    public static byte[] Int2bytes(int value) {
        byte[] bytes = new byte[]{(byte)Integer.parseInt(String.valueOf(value >> 24 & 0xFF), 16), (byte)Integer.parseInt(String.valueOf(value >> 16 & 0xFF), 16), (byte)Integer.parseInt(String.valueOf(value >> 8 & 0xFF), 16), (byte)Integer.parseInt(String.valueOf(value & 0xFF), 16)};
        int i = 0;
        while (i < 4) {
            Log.i((String)"StringUtility", (String)("Int2bytes() bytes = " + String.format("%02x", bytes[i])));
            ++i;
        }
        return bytes;
    }

    public static long charArrayTolong(char[] array) {
        char[] a = new char[8];
        int i = a.length - 1;
        int j = array.length - 1;
        while (i >= 0) {
            a[i] = j >= 0 ? array[j] : (char)'\u0000';
            --i;
            --j;
        }
        long v0 = (long)(a[0] & 0xFF) << 56;
        long v1 = (long)(a[1] & 0xFF) << 48;
        long v2 = (long)(a[2] & 0xFF) << 40;
        long v3 = (long)(a[3] & 0xFF) << 32;
        long v4 = (long)(a[4] & 0xFF) << 24;
        long v5 = (long)(a[5] & 0xFF) << 16;
        long v6 = (long)(a[6] & 0xFF) << 8;
        long v7 = a[7] & 0xFF;
        Log.i((String)"StringUtility", (String)(v0 + "@" + v1 + "@" + v2 + "@" + v3 + "@" + v4 + "@" + v5 + "@" + v6 + "@" + v7));
        return v0 | v1 | v2 | v3 | v4 | v5 | v6 | v7;
    }

    public static byte[] reverse(byte[] b) {
        byte[] temp = new byte[b.length];
        int i = 0;
        while (i < b.length) {
            temp[i] = b[b.length - 1 - i];
            ++i;
        }
        return temp;
    }

    private static final BigInteger readUnsignedShort(byte[] readBuffer) throws IOException {
        if (readBuffer == null || readBuffer.length < 2) {
            return new BigInteger("0");
        }
        byte[] uint64 = new byte[3];
        uint64[2] = 0;
        System.arraycopy(readBuffer, 0, uint64, 0, 2);
        return new BigInteger(StringUtility.reverse(uint64));
    }

    public static final BigInteger readUnsignedInt64(byte[] readBuffer) throws IOException {
        if (readBuffer == null || readBuffer.length < 8) {
            return new BigInteger("0");
        }
        byte[] uint64 = new byte[9];
        uint64[8] = 0;
        System.arraycopy(readBuffer, 0, uint64, 0, 8);
        return new BigInteger(StringUtility.reverse(uint64));
    }

    public static long chars2Long(char[] c, int start, int len) {
        byte[] bytes = StringUtility.getBytes(c);
        int i = 0;
        while (i < bytes.length) {
            Log.i((String)"StringUtility", (String)("chars2Long bytes[i]:" + bytes[i]));
            ++i;
        }
        return StringUtility.byteArrayTolong(bytes);
    }

    public static String char2HexString(char c) {
        char[] cs = new char[]{c};
        return StringUtility.chars2HexString(cs, 1);
    }

    public static boolean isOctNumber(String str) {
        boolean flag = false;
        int i = 0;
        int n = str.length();
        while (i < n) {
            char c = str.charAt(i);
            if (c == '0' | c == '1' | c == '2' | c == '3' | c == '4' | c == '5' | c == '6' | c == '7' | c == '8' | c == '9') {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    @Deprecated
    public static boolean isHexNumber(String str) {
        boolean flag = false;
        int i = 0;
        while (i < str.length()) {
            char cc = str.charAt(i);
            if (cc == '0' || cc == '1' || cc == '2' || cc == '3' || cc == '4' || cc == '5' || cc == '6' || cc == '7' || cc == '8' || cc == '9' || cc == 'A' || cc == 'B' || cc == 'C' || cc == 'D' || cc == 'E' || cc == 'F' || cc == 'a' || cc == 'b' || cc == 'c' || cc == 'c' || cc == 'd' || cc == 'e' || cc == 'f') {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public static boolean isOctNumberRex(String str) {
        String validate = "\\d+";
        return str.matches(validate);
    }

    public static boolean isHexNumberRex(String str) {
        String validate = "(?i)[0-9a-f]+";
        return str.matches(validate);
    }

    public static char[] hexString2Chars(String s) {
        s = s.replace(" ", "");
        char[] bytes = new char[s.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (char)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bytes;
    }

    public static byte[] getBytes(char[] chars) {
        Charset cs = Charset.forName("UTF-8");
        CharBuffer cb = CharBuffer.allocate(chars.length);
        cb.put(chars);
        cb.flip();
        ByteBuffer bb = cs.encode(cb);
        return bb.array();
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes);
        bb.flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public static boolean isDecimal(String decimal) {
        int len = decimal.length();
        int i = 0;
        while (i < len) {
            char ch;
            if ((ch = decimal.charAt(i++)) >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public static byte[] hexString2Bytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            ++i;
        }
        return bytes;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        int i = 0;
        while (i < length) {
            int pos = i * 2;
            d[i] = (byte)(StringUtility.charToByte(hexChars[pos]) << 4 | StringUtility.charToByte(hexChars[pos + 1]));
            ++i;
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNum(String str) {
        return str.matches("^[-+]?(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)$");
    }

    public static String int2HexString(int n) {
        String str = Integer.toHexString(n);
        int l = str.length();
        if (l == 1) {
            return "0" + str;
        }
        return str.substring(l - 2, l);
    }

    public static String ints2HexString(int[] c, int size) {
        String ret = "";
        try {
            int j = 0;
            int i = 0;
            while (i < size) {
                j = c[i];
                String hex = Integer.toHexString(j);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                ret = String.valueOf(ret) + hex.toUpperCase();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static int string2Int(String str, int defValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception exception) {
            return defValue;
        }
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }
}

