/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.adc.decoder;

import android.os.Environment;
import android.util.Log;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.utility.StringUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

class Barcode2DSoftCommon {
    private static boolean debug = StringUtility.DEBUG;
    private static String TAG = String.valueOf(StringUtility.TAG) + "SoftCommon";
    public static HARDWARE_TYPE currentHardwareType = HARDWARE_TYPE.MOTOROLA_4500;
    public static boolean isMTK = true;
    public static int CameraID = 1;
    public static boolean isIris = false;
    public static String ScannerCameraIdFile = Environment.getExternalStorageDirectory() + File.separator + ".2DScannerId";
    public static String CameraStateFile = Environment.getExternalStorageDirectory() + File.separator + ".2DScannerCameraState";
    public static String ScannerStateFile = Environment.getExternalStorageDirectory() + File.separator + ".2DScannerState";

    Barcode2DSoftCommon() {
    }

    public static String getBarcodeHardwareType() {
        String type;
        block14: {
            type = "MOTOROLA";
            try {
                if (DeviceConfiguration.getPlatform() == 1) {
                    Log.i((String)TAG, (String)"2D-------MTK----------");
                    File file = new File("/proc/wtk_cameraInfo");
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream("/proc/wtk_cameraInfo");
                        InputStreamReader isr = new InputStreamReader(fis);
                        BufferedReader br = new BufferedReader(isr, 4096);
                        String ch = null;
                        ch = br.readLine();
                        if (ch != null && ch.contains("6603")) {
                            type = "H_6003";
                            if (ch.contains("NoBackCamera")) {
                                CameraID = 0;
                            }
                            currentHardwareType = HARDWARE_TYPE.H_6603;
                        }
                        if (ch != null && ch.contains("FrontCamera:ialengmipiraw")) {
                            currentHardwareType = HARDWARE_TYPE.IA400S;
                        }
                        if (ch != null && (ch.contains("BackIris:imx132") || ch.contains("FrontIris:imx132"))) {
                            isIris = true;
                        }
                        fis.close();
                        isr.close();
                        br.close();
                    }
                } else {
                    Log.d((String)TAG, (String)"2D ------------qcomm----------------");
                    isMTK = false;
                    int id = Barcode2DSoftCommon.readScannerCameraId();
                    Log.i((String)TAG, (String)("Qualcomm   scannerid=" + id));
                    if (id == 5) {
                        currentHardwareType = HARDWARE_TYPE.H_6603;
                    } else if (id >= 0) {
                        currentHardwareType = HARDWARE_TYPE.MOTOROLA_4500;
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (debug) {
                    Log.i((String)TAG, (String)"No cameraInfo file found");
                }
            }
            catch (IOException e) {
                if (!debug) break block14;
                Log.w((String)TAG, (String)("Error reading cameraInfo file:" + e.getMessage()));
            }
        }
        return type;
    }

    public static void writeScannerCameraId(int id) {
        File scannerCameraIdFile = new File(ScannerCameraIdFile);
        FileOutputStream scannerCameraIdOps = null;
        if (!scannerCameraIdFile.exists()) {
            try {
                scannerCameraIdFile.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + ScannerCameraIdFile);
            }
            catch (Exception ex) {
                if (debug) {
                    Log.w((String)TAG, (String)("writeScannerCameraId  error: " + ex.getMessage()));
                }
                ex.printStackTrace();
            }
        }
        try {
            try {
                scannerCameraIdOps = new FileOutputStream(scannerCameraIdFile);
                String sid = String.valueOf(id) + "\n";
                scannerCameraIdOps.write(sid.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    scannerCameraIdOps.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                scannerCameraIdOps.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int readScannerCameraId() {
        File scannerCameraIdFile = new File(ScannerCameraIdFile);
        int result = -2;
        if (!scannerCameraIdFile.exists()) {
            return -3;
        }
        FileInputStream fis = null;
        InputStreamReader inputreader = null;
        BufferedReader buffreader = null;
        try {
            try {
                fis = new FileInputStream(scannerCameraIdFile);
                inputreader = new InputStreamReader(fis);
                buffreader = new BufferedReader(inputreader);
                String cameraId = buffreader.readLine();
                result = Integer.parseInt(cameraId);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fis.close();
                    inputreader.close();
                    buffreader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fis.close();
                inputreader.close();
                buffreader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void writeScannerState(int id) {
        File scannerStateFile = new File(ScannerStateFile);
        FileOutputStream ops = null;
        if (!scannerStateFile.exists()) {
            try {
                scannerStateFile.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + ScannerStateFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            try {
                ops = new FileOutputStream(scannerStateFile);
                String sid = String.valueOf(id) + "\n";
                ops.write(sid.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ops.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ops.close();
            }
            catch (Exception exception) {}
        }
    }

    public static int readCameraState() {
        File cameraStateFile = new File(CameraStateFile);
        int result = -1;
        if (!cameraStateFile.exists()) {
            return result;
        }
        FileInputStream fis = null;
        InputStreamReader inputreader = null;
        BufferedReader buffreader = null;
        try {
            try {
                fis = new FileInputStream(cameraStateFile);
                inputreader = new InputStreamReader(fis);
                buffreader = new BufferedReader(inputreader);
                String state = buffreader.readLine();
                result = Integer.parseInt(state);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    fis.close();
                    inputreader.close();
                    buffreader.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                fis.close();
                inputreader.close();
                buffreader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void writeCameraState(int id) {
        File cameraStateFile = new File(CameraStateFile);
        FileOutputStream ops = null;
        if (!cameraStateFile.exists()) {
            try {
                cameraStateFile.createNewFile();
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("chmod 0666 " + CameraStateFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            try {
                ops = new FileOutputStream(cameraStateFile);
                String sid = String.valueOf(id) + "\n";
                ops.write(sid.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    ops.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                ops.close();
            }
            catch (Exception exception) {}
        }
    }

    public static enum HARDWARE_TYPE {
        H_6603,
        MOTOROLA_4500,
        MOTOROLA_4750,
        IA400S;

    }
}

