/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.adc.decoder;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.SurfaceHolder;
import com.barcode.BarcodeUtility;
import com.hsm.barcode.DecodeOptions;
import com.hsm.barcode.DecodeResult;
import com.hsm.barcode.Decoder;
import com.hsm.barcode.DecoderException;
import com.hsm.barcode.DecoderListener;
import com.hsm.barcode.HalInterface;
import com.hsm.barcode.SymbologyConfig;
import com.imagealgorithmlab.barcode.DecodeEngine;
import com.imagealgorithmlab.barcode.SymbologyData;
import com.imagealgorithmlab.barcode.SymbologySettingItem;
import com.imagealgorithmlab.barcode.camera.DecoderLibrary;
import com.rscja.deviceapi.DeviceConfiguration;
import com.rscja.deviceapi.ScanerLedLight;
import com.rscja.utility.StringUtility;
import com.zebra.adc.decoder.BarCodeReader;
import com.zebra.adc.decoder.Barcode2DSoftCommon;
import com.zebra.adc.decoder.Config;
import com.zebra.adc.decoder.SymbologyConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Barcode2DWithSoft {
    private static final String TAG = String.valueOf(StringUtility.TAG) + "Barcode2DS";
    private static String License_IA400S = "3daa70ec65914767afbb73fb1a2bc831";
    private BarCodeReader bcr = null;
    private int timeOut = 10000;
    private AtomicBoolean isIdle = new AtomicBoolean(true);
    private static HardwareType hardwareType = HardwareType.MOTO;
    protected boolean powerOn = false;
    private static boolean DEBUG = StringUtility.DEBUG;
    private Context context;
    private Decoder decoder = new Decoder();
    private HalInterface halinterface = new HalInterface();
    private DecodeResult decodeResult = new DecodeResult();
    private ThreadScan threadScan = null;
    private SymbologyConfiguration symbology = new SymbologyConfiguration();
    private ScanCallback scanCallback;
    private ThreadGC threadScanGC = null;
    private Object objectLock = new Object();
    private static Barcode2DWithSoft single;
    private static BarcodeUtility sBarcodeUtility;
    private static final String ACTION_SCAN_ON_DECODE_COMPLETE = "com.scanner.broadcast";
    private static final String SCAN_ON_DECODE_COMPLETE_KEY = "data";
    private BroadcastReceiver mResultDataBroadcastRecevier = null;

    static {
        if (!Barcode2DWithSoft.isUpAndroid7()) {
            Barcode2DSoftCommon.getBarcodeHardwareType();
            if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
                hardwareType = HardwareType.IA400S;
            } else if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
                hardwareType = HardwareType.HONEYWELL_6603;
                if (Barcode2DSoftCommon.isMTK) {
                    if (DEBUG) {
                        Log.d((String)TAG, (String)"2D-------------H_6003  library MTK  HsmKil");
                    }
                } else if (DEBUG) {
                    Log.d((String)TAG, (String)"2D-------------H_6003  library HsmKil_qcomm");
                }
                System.loadLibrary("HsmKil");
                System.loadLibrary("HHPScanInterface");
                System.loadLibrary("HSMDecoderAPI");
            } else {
                System.loadLibrary("IAL");
                System.loadLibrary("SDL");
                if (Build.VERSION.SDK_INT >= 26) {
                    Log.d((String)TAG, (String)"2D------------- library  barcodereader80 being");
                    System.loadLibrary("barcodereader80");
                    Log.d((String)TAG, (String)"2D------------- library  barcodereader80 end");
                } else if (Build.VERSION.SDK_INT >= 24) {
                    Log.d((String)TAG, (String)"2D------------- library  barcodereader70 being");
                    System.loadLibrary("barcodereader70");
                    Log.d((String)TAG, (String)"2D------------- library  barcodereader70 end");
                } else if (Build.VERSION.SDK_INT >= 19) {
                    System.loadLibrary("barcodereader44");
                } else if (Build.VERSION.SDK_INT >= 18) {
                    System.loadLibrary("barcodereader43");
                } else {
                    System.loadLibrary("barcodereader");
                }
                if (DEBUG) {
                    Log.d((String)TAG, (String)"2D-------------M_4750  library");
                }
            }
        }
        single = null;
        sBarcodeUtility = null;
    }

    public boolean isPowerOn() {
        return this.powerOn;
    }

    protected void setPowerOn(boolean on) {
        this.powerOn = on;
    }

    private Barcode2DWithSoft() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized Barcode2DWithSoft getInstance() {
        if (single != null) return single;
        Class<Barcode2DWithSoft> clazz = Barcode2DWithSoft.class;
        synchronized (Barcode2DWithSoft.class) {
            if (single != null) return single;
            single = new Barcode2DWithSoft();
            if (Barcode2DWithSoft.isUpAndroid7()) {
                sBarcodeUtility = BarcodeUtility.getInstance();
            }
            if (!DEBUG) return single;
            Log.d((String)TAG, (String)"\u6ca1\u67092DS\u5b9e\u4f8b new Barcode2DWithSoft()");
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public synchronized boolean open(Context context) {
        block33: {
            block34: {
                block32: {
                    if (Barcode2DWithSoft.isUpAndroid7()) {
                        if (context == null) {
                            return false;
                        }
                        sBarcodeUtility.open(context, BarcodeUtility.ModuleType.BARCODE_2D);
                        this.setPowerOn(true);
                        this.context = context;
                        sBarcodeUtility.setScanFailureBroadcast(context, true);
                        sBarcodeUtility.setReleaseScan(context, false);
                        sBarcodeUtility.enablePlaySuccessSound(context, false);
                        sBarcodeUtility.enablePlayFailureSound(context, false);
                        sBarcodeUtility.enableVibrate(context, false);
                        sBarcodeUtility.setOutputMode(context, 2);
                        sBarcodeUtility.enableEnter(context, false);
                        sBarcodeUtility.enableTAB(context, false);
                        sBarcodeUtility.setBarcodeEncodingFormat(context, 0);
                        sBarcodeUtility.setPrefix(context, "");
                        sBarcodeUtility.setSuffix(context, "");
                        sBarcodeUtility.interceptTrimLeft(context, 0);
                        sBarcodeUtility.interceptTrimRight(context, 0);
                        sBarcodeUtility.filterCharacter(context, "");
                        sBarcodeUtility.enableContinuousScan(context, false);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        this.isIdle.set(true);
                        return true;
                    }
                    this.context = context;
                    ScanerLedLight.getInstance().init();
                    if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
                        Log.d((String)TAG, (String)"open -------IA400S-------");
                        if (this.isPowerOn()) {
                            return true;
                        }
                        if (this.threadScanGC == null) {
                            this.threadScanGC = new ThreadGC(context);
                            new Thread(this.threadScanGC).start();
                        }
                        this.threadScanGC.waitOpen();
                        this.setPowerOn(this.threadScanGC.openSuccess);
                        return this.threadScanGC.openSuccess;
                    }
                    if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
                        try {
                            String PackageName = context.getPackageName();
                            if (DEBUG) {
                                Log.d((String)TAG, (String)("open H_6003  PackageName=" + PackageName));
                            }
                            int count = Camera.getNumberOfCameras();
                            if (Barcode2DSoftCommon.isIris) {
                                --count;
                            }
                            Barcode2DSoftCommon.CameraID = count > 2 ? 2 : (count > 1 ? 1 : 0);
                            Log.d((String)TAG, (String)("open H_6003  Barcode2DSoftCommon.CameraID=" + Barcode2DSoftCommon.CameraID));
                            if (Barcode2DSoftCommon.isMTK) {
                                this.halinterface.SetPackageName(PackageName);
                                this.halinterface.SetCamera_ID(Barcode2DSoftCommon.CameraID);
                            }
                            this.decoder.connectDecoderLibrary();
                            this.enableAllCodeTypes();
                            this.enableCheckBarcode();
                            if (this.threadScan == null) {
                                this.threadScan = new ThreadScan(context);
                                new Thread(this.threadScan).start();
                            }
                            if (DEBUG) {
                                Log.i((String)TAG, (String)"open ok");
                            }
                            this.decoder.setDecoderListeners(new DecoderListener(){

                                @Override
                                public boolean onKeepGoingCallback() {
                                    if (Barcode2DWithSoft.this.threadScan != null) {
                                        if (DEBUG) {
                                            Log.i((String)TAG, (String)("isScan=" + Barcode2DWithSoft.this.threadScan.isScan));
                                        }
                                        return Barcode2DWithSoft.this.threadScan.isScan;
                                    }
                                    return true;
                                }

                                @Override
                                public boolean onMultiReadCallback() {
                                    if (Barcode2DWithSoft.this.threadScan != null) {
                                        if (DEBUG) {
                                            Log.i((String)TAG, (String)("isScan=" + Barcode2DWithSoft.this.threadScan.isScan));
                                        }
                                        return Barcode2DWithSoft.this.threadScan.isScan;
                                    }
                                    return true;
                                }
                            });
                            this.setPowerOn(true);
                            this.isIdle.set(true);
                            return true;
                        }
                        catch (Exception ex) {
                            this.setPowerOn(false);
                            Log.e((String)TAG, (String)ex.getMessage());
                            return false;
                        }
                    }
                    try {
                        if (Build.VERSION.SDK_INT <= 22) break block32;
                        try {
                            int var2 = BarCodeReader.getNumberOfReaders();
                            if (Barcode2DSoftCommon.isIris) {
                                --var2;
                            }
                            Log.d((String)TAG, (String)("[open] all bcr Number=" + var2));
                            if (var2 > 2) {
                                this.bcr = BarCodeReader.open(2, context);
                            } else if (var2 > 1) {
                                this.bcr = BarCodeReader.open(1, context);
                            } else if (var2 == 1) {
                                this.bcr = BarCodeReader.open(0, context);
                            }
                            break block33;
                        }
                        catch (Exception var4) {
                            var4.printStackTrace();
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                if (Build.VERSION.SDK_INT < 21) break block34;
                int mScannerId = Barcode2DWithSoft.getScannerIdFromCamera2(context);
                try {
                    Log.i((String)TAG, (String)("mScannerId=" + mScannerId));
                    this.bcr = BarCodeReader.open(mScannerId, context);
                    break block33;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            this.bcr = Build.VERSION.SDK_INT >= 18 ? BarCodeReader.open(context) : BarCodeReader.open();
        }
        if (this.bcr == null) {
            return false;
        }
        if (DeviceConfiguration.getPlatform() == 1) {
            this.bcr.setParameter(765, 0);
            Log.i((String)TAG, (String)"bcr.setParameter(765, 0)");
        }
        Log.i((String)TAG, (String)"open() succ");
        this.isIdle.set(true);
        this.setPowerOn(true);
        if (Barcode2DSoftCommon.readScannerCameraId() < 0) {
            Barcode2DSoftCommon.writeScannerCameraId(1);
        }
        return true;
    }

    public static int getScannerIdFromCamera(Context context) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return -1;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 || Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            return -1;
        }
        int n = 0;
        try {
            n = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (DEBUG) {
            Log.i((String)TAG, (String)("all bcr Number=" + n));
        }
        int scannerid = -1;
        boolean isScanner = false;
        String scannerParameters = "picture-size-values=752x480,720x480,640x480,352x288,320x240,176x144,160x120;preferred-preview-size-for-video=752x480;preview-size=752x480;preview-size-values=752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;raw-size=752x480;supported-live-snapshot-sizes=752x480,720x480,640x480,352x288,320x240,176x144,160x120;video-size=752x480;video-size-values=752x480,720x480,640x480,480x360,352x288,320x240,176x144,160x120";
        BarCodeReader.Parameters scannerPar = null;
        BarCodeReader bcr = null;
        int i = 0;
        while (i < n) {
            try {
                bcr = BarCodeReader.open(i, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bcr != null) {
                if (scannerPar == null) {
                    scannerPar = bcr.getParametersFromString(scannerParameters);
                }
                BarCodeReader.Parameters bcrPar = bcr.getParameters();
                boolean bl = isScanner = scannerPar.get("picture-size-values").equals(bcrPar.get("picture-size-values")) && scannerPar.get("preferred-preview-size-for-video").equals(bcrPar.get("preferred-preview-size-for-video")) && scannerPar.get("preview-size").equals(bcrPar.get("preview-size")) && scannerPar.get("preview-size-values").equals(bcrPar.get("preview-size-values")) && scannerPar.get("raw-size").equals(bcrPar.get("raw-size")) && scannerPar.get("supported-live-snapshot-sizes").equals(bcrPar.get("supported-live-snapshot-sizes")) && scannerPar.get("video-size").equals(bcrPar.get("video-size")) && scannerPar.get("video-size-values").equals(bcrPar.get("video-size-values"));
                if (isScanner) {
                    scannerid = i;
                }
                bcr.release();
            }
            ++i;
        }
        if (DEBUG) {
            Log.i((String)TAG, (String)(" scannerid=" + scannerid));
        }
        return scannerid;
    }

    public static int getScannerIdFromCamera2(Context context) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return -1;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 || Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            return -1;
        }
        int n = 0;
        try {
            n = BarCodeReader.getNumberOfReaders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (DEBUG) {
            Log.i((String)TAG, (String)("all bcr Number=" + n));
        }
        int scannerid = -1;
        boolean isScanner = false;
        String scannerParameters = "picture-size-values=752x480,720x480,640x480,352x288,320x240,176x144,160x120;preferred-preview-size-for-video=752x480;preview-size=752x480;preview-size-values=752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;raw-size=752x480;supported-live-snapshot-sizes=752x480,720x480,640x480,352x288,320x240,176x144,160x120;video-size=752x480;video-size-values=752x480,720x480,640x480,480x360,352x288,320x240,176x144,160x120";
        String scannerParameters_4750 = "preview-size-values=1360x960,1360x800,1280x960,1280x720,864x480,800x480,768x432,752x480,720x480,640x480,576x432,480x360,384x288,352x288,320x240,240x160,176x144,160x120,144x176;preferred-preview-size-for-video=1360x960";
        BarCodeReader.Parameters scannerPar = null;
        BarCodeReader bcr = null;
        int i = n - 1;
        while (i > -1) {
            try {
                bcr = BarCodeReader.open(i, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (bcr != null) {
                if (scannerPar == null) {
                    scannerPar = bcr.getParametersFromString(scannerParameters);
                }
                BarCodeReader.Parameters bcrPar = bcr.getParameters();
                isScanner = scannerPar.get("preview-size-values").equals(bcrPar.get("preview-size-values"));
                if (!isScanner && (isScanner = (scannerPar = bcr.getParametersFromString(scannerParameters_4750)).get("preview-size-values").equals(bcrPar.get("preview-size-values")))) {
                    Barcode2DSoftCommon.currentHardwareType = Barcode2DSoftCommon.HARDWARE_TYPE.MOTOROLA_4750;
                }
                bcr.release();
                if (isScanner) {
                    scannerid = i;
                    break;
                }
            }
            --i;
        }
        if (DEBUG) {
            Log.i((String)TAG, (String)("scannerid=" + scannerid));
        }
        return scannerid;
    }

    public synchronized void scan() {
        if (DEBUG) {
            Log.i((String)TAG, (String)"scan()");
        }
        if (Barcode2DWithSoft.isUpAndroid7()) {
            if (this.isIdle.get()) {
                sBarcodeUtility.startScan(this.context, BarcodeUtility.ModuleType.BARCODE_2D);
                this.isIdle.set(false);
            }
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (this.threadScanGC != null) {
                this.threadScanGC.scanBarcode();
            }
        } else if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
            if (this.threadScan != null && this.isIdle.get()) {
                this.threadScan.scanBarcode();
                this.isIdle.set(false);
            }
        } else if (this.bcr != null && this.isIdle.get()) {
            if (DEBUG) {
                Log.i((String)TAG, (String)"moto scan()");
            }
            this.bcr.startDecode();
            this.isIdle.set(false);
        }
    }

    public synchronized void stopScan() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            sBarcodeUtility.stopScan(this.context, BarcodeUtility.ModuleType.BARCODE_2D);
            this.isIdle.set(true);
            return;
        }
        ScanerLedLight.getInstance().off(this.context);
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (this.threadScanGC != null) {
                this.threadScanGC.stopBarcode();
            }
        } else if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
            if (this.threadScan != null) {
                this.threadScan.stopBarcode();
                this.isIdle.set(true);
            }
            Log.i((String)TAG, (String)"stopScan ");
        } else if (this.bcr != null) {
            this.bcr.stopDecode();
            this.isIdle.set(true);
        }
    }

    public synchronized void setScanCallback(final ScanCallback sc) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            sBarcodeUtility.setScanResultBroadcast(this.context, ACTION_SCAN_ON_DECODE_COMPLETE, SCAN_ON_DECODE_COMPLETE_KEY);
            if (this.context != null && this.mResultDataBroadcastRecevier == null) {
                this.mResultDataBroadcastRecevier = new ResultDataBroadcastReceiver();
                IntentFilter filter = new IntentFilter();
                filter.addAction(ACTION_SCAN_ON_DECODE_COMPLETE);
                this.context.registerReceiver(this.mResultDataBroadcastRecevier, filter);
            }
            this.scanCallback = sc;
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 || Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (sc != null) {
                this.scanCallback = sc;
            }
        } else if (this.bcr != null) {
            this.bcr.setDecodeCallback(new BarCodeReader.DecodeCallback(){

                @Override
                public void onEvent(int event, int info, byte[] data, BarCodeReader reader) {
                }

                @Override
                public void onDecodeComplete(int symbology, int length, byte[] data, BarCodeReader reader) {
                    Barcode2DWithSoft.this.isIdle.set(true);
                    if (length == -3) {
                        Log.i((String)TAG, (String)"onDecodeComplete() DECODE_STATUS_MULTI_DEC_COUNT ");
                        return;
                    }
                    if (data != null && data.length > 0 && length > 1) {
                        ScanerLedLight.getInstance().blink(Barcode2DWithSoft.this.context);
                    }
                    sc.onScanComplete(symbology, length, data);
                }
            });
        }
    }

    public void setNoDisplayMode() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            this.bcr.setNoDisplayMode();
        }
    }

    public synchronized boolean setParameter(int paramNum, int paramVal) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            sBarcodeUtility.setParam_zebra(this.context, paramNum, paramVal);
            return true;
        }
        return Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.IA400S && this.bcr != null && this.bcr.setParameter(paramNum, paramVal) == 0;
    }

    public boolean setParameter(int paramNum, String paramVal) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return false;
        }
        return Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.IA400S && this.bcr != null && this.bcr.setParameter(paramNum, paramVal) == 0;
    }

    public int getNumParameter(int paramNum) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return -1;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.IA400S && this.bcr != null) {
            return this.bcr.getNumParameter(paramNum);
        }
        return -1;
    }

    public String getStrParameter(int paramNum) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return "-1";
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 || Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            return "-2";
        }
        if (this.bcr != null) {
            return this.bcr.getStrParameter(paramNum);
        }
        return "-1";
    }

    public void setDefaultParameters() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.IA400S && this.bcr != null) {
            this.bcr.setDefaultParameters();
        }
    }

    public int getNumProperty(int propNum) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return -1;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            return this.bcr.getNumProperty(propNum);
        }
        return -1;
    }

    public String getStrProperty(int propNum) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return "-1";
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 || Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (this.isPowerOn()) {
                return "10";
            }
        } else if (this.bcr != null) {
            return this.bcr.getStrProperty(propNum);
        }
        return "-1";
    }

    public void enableAllCodeTypes() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
                try {
                    this.decoder.enableSymbology(100);
                }
                catch (DecoderException e) {
                    e.printStackTrace();
                }
            } else if (this.bcr != null) {
                this.bcr.enableAllCodeTypes();
            }
        }
    }

    public void disableAllCodeTypes() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
                try {
                    this.decoder.disableSymbology(100);
                }
                catch (DecoderException e) {
                    e.printStackTrace();
                }
            } else if (this.bcr != null) {
                this.bcr.disableAllCodeTypes();
            }
        }
    }

    public boolean enableBarcode(SymbologyConfiguration.BarcodeSymbologyID symbologyID, SymbologyConfig symbolog) {
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
            if (DEBUG) {
                Log.i((String)TAG, (String)"enableBarcode");
            }
            return this.symbology.SetSymbologySettings(this.decoder, symbologyID, symbolog);
        }
        return false;
    }

    public void takePicture(final PictureCallback cb) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            this.bcr.takePicture(new BarCodeReader.PictureCallback(){

                @Override
                public void onPictureTaken(int format, int width, int height, byte[] data, BarCodeReader reader) {
                    cb.onPictureTaken(format, width, height, data);
                }
            });
        }
    }

    public void setPreviewDisplay(SurfaceHolder holder) throws IOException {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            this.bcr.setPreviewDisplay(holder);
        }
    }

    public void startViewFinder(final VideoCallback cb) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            this.bcr.startViewFinder(new BarCodeReader.VideoCallback(){

                @Override
                public void onVideoFrame(int format, int width, int height, byte[] data, BarCodeReader reader) {
                    cb.onVideoFrame(format, width, height, data);
                }
            });
        }
    }

    public void startPreview() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            this.bcr.startPreview();
        }
    }

    public void stopPreview() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (Barcode2DSoftCommon.currentHardwareType != Barcode2DSoftCommon.HARDWARE_TYPE.H_6603 && this.bcr != null) {
            this.bcr.stopPreview();
        }
    }

    public synchronized boolean close() {
        if (DEBUG) {
            Log.d((String)TAG, (String)"close() begin");
        }
        if (Barcode2DWithSoft.isUpAndroid7()) {
            if (this.mResultDataBroadcastRecevier != null && this.context != null) {
                this.context.unregisterReceiver(this.mResultDataBroadcastRecevier);
                this.mResultDataBroadcastRecevier = null;
            }
            sBarcodeUtility.close(this.context, BarcodeUtility.ModuleType.BARCODE_2D);
            this.setPowerOn(false);
            if (this.context != null) {
                this.context = null;
            }
            this.isIdle.set(false);
            return true;
        }
        ScanerLedLight.getInstance().free();
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            if (this.threadScanGC != null) {
                this.threadScanGC.closeScan();
                this.threadScanGC.exitThread();
                this.threadScanGC = null;
            }
            this.setPowerOn(false);
        } else if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
            if (this.threadScan != null) {
                this.threadScan.exitThread();
                int k = 0;
                while (k < 100) {
                    try {
                        if (!this.threadScan.getIsScaning()) break;
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    ++k;
                }
                this.threadScan = null;
            }
            if (this.decoder != null) {
                try {
                    this.decoder.disconnectDecoderLibrary();
                    if (DEBUG) {
                        Log.d((String)TAG, (String)"close() succ");
                    }
                }
                catch (DecoderException e) {
                    if (DEBUG) {
                        Log.e((String)TAG, (String)e.getMessage());
                    }
                    e.printStackTrace();
                }
            }
            this.isIdle.set(false);
            this.setPowerOn(false);
        } else if (this.bcr != null) {
            this.bcr.release();
            this.bcr = null;
            this.isIdle.set(false);
            this.setPowerOn(false);
            if (DEBUG) {
                Log.i((String)TAG, (String)"close() succ");
            }
        }
        return true;
    }

    public void writeScannerState(int status) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        Barcode2DSoftCommon.writeScannerState(status);
    }

    public void writeCameraState(int status) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        Barcode2DSoftCommon.writeCameraState(status);
    }

    public int readCameraState() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return -1;
        }
        return Barcode2DSoftCommon.readCameraState();
    }

    public void writeScannerCameraId(int id) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        if (!Barcode2DSoftCommon.isMTK) {
            Barcode2DSoftCommon.writeScannerCameraId(id);
        }
    }

    public Decoder getDecoder() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return null;
        }
        if (this.decoder != null) {
            return this.decoder;
        }
        return null;
    }

    public void setTimeOut(int time) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            sBarcodeUtility.setScanOutTime(this.context, time / 1000);
            return;
        }
        this.timeOut = time > 10000 ? 10000 : (time < 500 ? 500 : time);
    }

    private void enableCheckBarcode() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return;
        }
        ArrayList<SymbologyConfiguration.BarcodeSymbologyID> list = new ArrayList<SymbologyConfiguration.BarcodeSymbologyID>();
        list.add(SymbologyConfiguration.BarcodeSymbologyID.SYM_EAN8);
        list.add(SymbologyConfiguration.BarcodeSymbologyID.SYM_EAN13);
        list.add(SymbologyConfiguration.BarcodeSymbologyID.SYM_MSI);
        list.add(SymbologyConfiguration.BarcodeSymbologyID.SYM_CODABAR);
        list.add(SymbologyConfiguration.BarcodeSymbologyID.SYM_UPCE0);
        int k = 0;
        while (k < list.size()) {
            SymbologyConfiguration.BarcodeSymbologyID id = (SymbologyConfiguration.BarcodeSymbologyID)((Object)list.get(k));
            SymbologyConfig sym = new SymbologyConfig();
            switch (id) {
                case SYM_EAN8: 
                case SYM_EAN13: 
                case SYM_MSI: {
                    sym.Flags |= 1;
                    sym.Flags |= 4;
                    this.enableBarcode(id, sym);
                    break;
                }
                case SYM_CODABAR: {
                    sym.Flags |= 1;
                    sym.Flags |= 8;
                    this.enableBarcode(id, sym);
                    break;
                }
                case SYM_UPCE0: {
                    sym.Flags |= 1;
                    sym.Flags |= 4;
                    sym.Flags |= 0x40;
                    this.enableBarcode(id, sym);
                }
            }
            ++k;
        }
    }

    public int readScannerCameraId() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return -1;
        }
        return Barcode2DSoftCommon.readScannerCameraId();
    }

    public boolean startHandsFree() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return false;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
            return false;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            return false;
        }
        if (this.bcr != null) {
            int ret = this.bcr.startHandsFreeDecode(7);
            if (DEBUG) {
                Log.d((String)TAG, (String)("startHandsFree ret= " + ret));
            }
            if (ret == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean stopHandsFree() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return false;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.H_6603) {
            return false;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            return false;
        }
        int ret = this.bcr.setParameter(138, 0);
        if (DEBUG) {
            Log.d((String)TAG, (String)("stopHandsFree ret= " + ret));
        }
        return ret == 0;
    }

    public SymbologySettingItem[] getCodeTypeList() {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return null;
        }
        if (Barcode2DSoftCommon.currentHardwareType == Barcode2DSoftCommon.HARDWARE_TYPE.IA400S) {
            return DecodeEngine.GetCodeTypeList();
        }
        return null;
    }

    public boolean setCodeTypeOnAndOff_IA400S(CODETYPE codetype, boolean enable) {
        if (Barcode2DWithSoft.isUpAndroid7()) {
            return false;
        }
        String code = codetype.getValue();
        return DecodeEngine.setCodeTypeOnAndOff((String)code, (int)(enable ? 1 : 0));
    }

    public void setLicense_IA400S(String license_IA400S) {
        License_IA400S = license_IA400S;
    }

    public HardwareType getHardwareType() {
        return hardwareType;
    }

    public static boolean isUpAndroid7() {
        if (Config.getFlag()) {
            return false;
        }
        return Build.VERSION.SDK_INT >= 24;
    }

    public static enum CODETYPE {
        UPC("UPC"),
        C39("C39"),
        C128("C128"),
        I25("I25"),
        C93("C93"),
        GS1_DATABAR("GS1 DATABAR"),
        MSI("MSI"),
        CODEBLOCK_F("CODEBLOCK F"),
        PDF417("PDF417"),
        MICROPDF("MICROPDF"),
        MAXICODE("MAXICODE"),
        QR_CODE("QR CODE"),
        DATA_MATRIX("DATA MATRIX"),
        AZTEC("AZTEC"),
        HAXIN("HAXIN"),
        MATRIX_25("MATRIX 25"),
        TRIOPTIC("TRIOPTIC"),
        STRAIGHT_25("STRAIGHT 25"),
        TELEPEN("TELEPEN"),
        C11("C11");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private CODETYPE(String value) {
            this.value = value;
        }
    }

    public static enum HardwareType {
        MOTO,
        HONEYWELL_6603,
        IA400S;

    }

    public static interface PictureCallback {
        public void onPictureTaken(int var1, int var2, int var3, byte[] var4);
    }

    class ResultDataBroadcastReceiver
    extends BroadcastReceiver {
        ResultDataBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String data = intent.getStringExtra(Barcode2DWithSoft.SCAN_ON_DECODE_COMPLETE_KEY);
            String status = intent.getStringExtra("SCAN_STATE");
            if (Barcode2DWithSoft.this.scanCallback == null) {
                Barcode2DWithSoft.this.isIdle.set(true);
                return;
            }
            if (data != null) {
                if (status == null || !status.equals("cancel")) {
                    Barcode2DWithSoft.this.scanCallback.onScanComplete(-1, data.length(), data.getBytes());
                }
            } else {
                Barcode2DWithSoft.this.scanCallback.onScanComplete(-1, -2, null);
            }
            Barcode2DWithSoft.this.isIdle.set(true);
        }
    }

    public static interface ScanCallback {
        public void onScanComplete(int var1, int var2, byte[] var3);
    }

    public static class ScanerParamNum
    extends BarCodeReader.ParamNum {
    }

    public static class ScanerParamVal
    extends BarCodeReader.ParamVal {
    }

    public static class ScanerPropertyNum
    extends BarCodeReader.PropertyNum {
    }

    private class ThreadGC
    implements Runnable {
        private Object object = new Object();
        private Handler handler;
        private Context context1;
        private volatile boolean isRuning = false;
        private volatile boolean isScan = false;
        private volatile boolean isScaning = false;
        private DecoderLibrary mDecodeLibrary;
        boolean openSuccess = false;

        public ThreadGC(Context context) {
            this.context1 = context;
            this.isRuning = true;
            this.isScan = false;
            this.isScaning = false;
            this.handler = new Handler(this.context1.getMainLooper()){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            ThreadGC.this.initScanGC();
                            break;
                        }
                        case 1: {
                            ThreadGC.this.isScaning = false;
                            SymbologyData symbologyData = (SymbologyData)msg.obj;
                            byte[] datas = symbologyData.getBytes();
                            Barcode2DWithSoft.this.scanCallback.onScanComplete(1, datas.length, datas);
                            break;
                        }
                        case 2: {
                            if (Barcode2DWithSoft.this.scanCallback == null) break;
                            ThreadGC.this.isScaning = false;
                            Barcode2DWithSoft.this.scanCallback.onScanComplete(-1, -2, "scan failed".getBytes());
                            break;
                        }
                        case 3: {
                            if (Barcode2DWithSoft.this.scanCallback == null) break;
                            ThreadGC.this.isScaning = false;
                            Barcode2DWithSoft.this.scanCallback.onScanComplete(-1, -1, "scan Canceled".getBytes());
                        }
                    }
                }
            };
            this.handler.sendEmptyMessage(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isRuning) {
                Object object = this.object;
                synchronized (object) {
                    try {
                        this.object.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (DEBUG) {
                    Log.i((String)TAG, (String)"waitScanBarcode");
                }
                this.waitScanBarcode();
            }
        }

        private void waitScanBarcode() {
            if (this.isScan) {
                this.isScaning = true;
                this.mDecodeLibrary.setTimeout((long)Barcode2DWithSoft.this.timeOut);
                this.mDecodeLibrary.startDecoding();
                this.isScan = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanBarcode() {
            if (DEBUG) {
                Log.i((String)TAG, (String)"scanBarcode");
            }
            if (!this.isScaning) {
                this.isScan = true;
                Object object = this.object;
                synchronized (object) {
                    this.object.notifyAll();
                }
            }
        }

        private void stopBarcode() {
            if (DEBUG) {
                Log.i((String)TAG, (String)"stopBarcode");
            }
            this.mDecodeLibrary.stopDecoding();
            if (this.isScaning) {
                this.handler.sendEmptyMessage(3);
            }
            this.isScan = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exitThread() {
            this.notifyOpen();
            if (DEBUG) {
                Log.i((String)TAG, (String)"exitThread");
            }
            this.isScan = false;
            this.isRuning = false;
            Object object = this.object;
            synchronized (object) {
                this.object.notifyAll();
            }
        }

        public boolean getIsScaning() {
            return this.isScaning;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitOpen() {
            Object object = Barcode2DWithSoft.this.objectLock;
            synchronized (object) {
                try {
                    Barcode2DWithSoft.this.objectLock.wait(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyOpen() {
            Object object = Barcode2DWithSoft.this.objectLock;
            synchronized (object) {
                Barcode2DWithSoft.this.objectLock.notifyAll();
            }
        }

        public void closeScan() {
            if (this.mDecodeLibrary != null) {
                this.mDecodeLibrary.stopDecoding();
                this.mDecodeLibrary.stopCameraPreview();
                this.mDecodeLibrary.closeCamera();
                ((Barcode2DWithSoft)Barcode2DWithSoft.this).threadScanGC.mDecodeLibrary.closeSharedObject();
            }
        }

        private void initScanGC() {
            Log.i((String)TAG, (String)("License\u6fc0\u6d3b\u7801:" + License_IA400S));
            DecodeEngine.init((Context)Barcode2DWithSoft.this.context, (String)License_IA400S);
            try {
                this.mDecodeLibrary = DecoderLibrary.sharedObject((Context)Barcode2DWithSoft.this.context.getApplicationContext());
            }
            catch (Exception e) {
                e.printStackTrace();
                Barcode2DWithSoft.this.setPowerOn(false);
                this.openSuccess = false;
                this.notifyOpen();
                return;
            }
            this.mDecodeLibrary.setCallback(new DecoderLibrary.DecoderLibraryCallBack(){

                public void receivedDecodedData(SymbologyData symbologyData) {
                    if (Barcode2DWithSoft.this.scanCallback != null) {
                        Message message = Message.obtain();
                        message.obj = symbologyData;
                        message.what = 1;
                        ThreadGC.this.handler.sendMessage(message);
                    }
                }
            });
            this.mDecodeLibrary.setTimeoutCallback(new DecoderLibrary.DecodeLibraryTimeoutCallBack(){

                public void timeoutCallBack() {
                    ThreadGC.this.handler.sendEmptyMessage(2);
                }
            });
            this.mDecodeLibrary.setSingleScan();
            this.mDecodeLibrary.setAE(true);
            this.mDecodeLibrary.setTorch(true);
            this.mDecodeLibrary.setLogMode(true);
            this.mDecodeLibrary.setAimer(true);
            List cameras = this.mDecodeLibrary.getCameras();
            if (cameras != null && cameras.size() > 0) {
                int size = cameras.size();
                if (Barcode2DSoftCommon.isIris) {
                    --size;
                }
                if (size > 2) {
                    this.mDecodeLibrary.setCameraType(DecoderLibrary.CameraType.Camera2);
                } else if (size > 1) {
                    this.mDecodeLibrary.setCameraType(DecoderLibrary.CameraType.Camera1);
                } else {
                    this.mDecodeLibrary.setCameraType(DecoderLibrary.CameraType.Camera0);
                }
            }
            this.mDecodeLibrary.startCameraPreview();
            this.openSuccess = true;
            this.notifyOpen();
        }
    }

    private class ThreadScan
    implements Runnable {
        private boolean isRuning = false;
        private boolean isScan = false;
        private boolean isScaning = false;
        private Object object = new Object();
        private Handler handler;
        private Context context1;

        public ThreadScan(Context context) {
            this.context1 = context;
            this.isRuning = true;
            this.isScan = false;
            this.isScaning = false;
            this.handler = new Handler(this.context1.getMainLooper()){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 1: {
                            if (Barcode2DWithSoft.this.scanCallback == null) break;
                            byte[] barcode = (byte[])msg.obj;
                            if (DEBUG) {
                                Log.i((String)TAG, (String)("handleMessage barcode[]=" + barcode.length + " barcodeID=" + msg.arg1));
                            }
                            Barcode2DWithSoft.this.scanCallback.onScanComplete(msg.arg1, barcode.length, barcode);
                            ScanerLedLight.getInstance().blink(ThreadScan.this.context1);
                            break;
                        }
                        case 2: {
                            if (Barcode2DWithSoft.this.scanCallback == null) break;
                            byte[] temp = new byte[1];
                            Barcode2DWithSoft.this.scanCallback.onScanComplete(-1, msg.arg1, temp);
                            break;
                        }
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isRuning) {
                Object object = this.object;
                synchronized (object) {
                    try {
                        this.object.wait(10000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (DEBUG) {
                    Log.i((String)TAG, (String)"waitScanBarcode");
                }
                this.waitScanBarcode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitScanBarcode() {
            if (this.isScan) {
                int what;
                int ErrorCode;
                boolean fail;
                block21: {
                    this.isScaning = true;
                    fail = true;
                    ErrorCode = -2;
                    what = 2;
                    try {
                        if (DEBUG) {
                            Log.i((String)TAG, (String)("decoder.waitForDecodeTwo(timeOut,decodeResult) timeOut=" + Barcode2DWithSoft.this.timeOut));
                        }
                        Barcode2DWithSoft.this.decoder.waitForDecode(Barcode2DWithSoft.this.timeOut);
                        byte[] data = Barcode2DWithSoft.this.decoder.getBarcodeByteData();
                        int leng = Barcode2DWithSoft.this.decoder.getBarcodeLength();
                        byte barcodeId = Barcode2DWithSoft.this.decoder.getBarcodeCodeID();
                        if (DEBUG) {
                            Log.i((String)TAG, (String)("scan resultLeng=" + leng));
                        }
                        if (leng > 0 && Barcode2DWithSoft.this.scanCallback != null && leng > 0 && data != null && data.length > 0 && this.handler != null) {
                            this.handler.sendMessage(Message.obtain((Handler)this.handler, (int)1, (int)barcodeId, (int)-1, (Object)data));
                            fail = false;
                        }
                    }
                    catch (DecoderException e) {
                        if (DEBUG) {
                            Log.i((String)TAG, (String)("\u970d\u5c3c\u626b\u63cf\u5934\u51fa\u73b0\u5f02\u5e38 DecoderException " + e.getErrorCode()));
                        }
                        if (e.getErrorCode() == 5) {
                            ErrorCode = 0;
                            what = 2;
                        }
                        if (e.getErrorCode() == 11) {
                            ErrorCode = -1;
                            what = 2;
                        }
                        if (e.getErrorCode() != 6) break block21;
                        ErrorCode = -3;
                        what = 2;
                        try {
                            if (DEBUG) {
                                Log.i((String)TAG, (String)"\u51fa\u73b0 RESULT_ERR_NOIMAGE \u5f02\u5e38\uff0c\u91cd\u65b0\u5173\u95ed\u626b\u63cf\u5934\u6253\u5f00\u626b\u63cf\u5934 begin");
                            }
                            Barcode2DWithSoft.this.decoder.disconnectDecoderLibrary();
                            Thread.sleep(100L);
                            if (DEBUG) {
                                Log.i((String)TAG, (String)"\u51fa\u73b0 RESULT_ERR_NOIMAGE \u5f02\u5e38\uff0c\u91cd\u65b0\u6253\u5f00\u626b\u63cf\u5934\u6253\u5f00\u626b\u63cf\u5934 begin");
                            }
                            Barcode2DWithSoft.this.decoder.connectDecoderLibrary();
                            if (DEBUG) {
                                Log.i((String)TAG, (String)"\u51fa\u73b0 RESULT_ERR_NOIMAGE \u5f02\u5e38\uff0c\u91cd\u65b0\u6253\u5f00\u626b\u63cf\u5934\u6253\u5f00\u626b\u63cf\u5934 end");
                            }
                            Barcode2DWithSoft.this.enableAllCodeTypes();
                        }
                        catch (DecoderException e1) {
                            if (DEBUG) {
                                Log.i((String)TAG, (String)("\u91cd\u65b0\u6253\u5f00\u970d\u5c3c\u626b\u63cf\u5934\u51fa\u73b0\u5f02\u5e38:" + e1.getErrorCode()));
                            }
                            e1.printStackTrace();
                        }
                        catch (Exception ex) {
                            if (!DEBUG) break block21;
                            Log.i((String)TAG, (String)"\u91cd\u65b0\u6253\u5f00\u970d\u5c3c\u626b\u63cf\u5934\u51fa\u73b0\u5f02\u5e382:Exception");
                        }
                    }
                }
                if (fail) {
                    Object object = this.object;
                    synchronized (object) {
                        this.object.notifyAll();
                    }
                    if (this.handler != null) {
                        this.handler.sendMessage(Message.obtain((Handler)this.handler, (int)what, (int)ErrorCode, (int)-1));
                    }
                }
                this.isScan = false;
                this.isScaning = false;
                Barcode2DWithSoft.this.isIdle.set(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scanBarcode() {
            if (DEBUG) {
                Log.i((String)TAG, (String)"scanBarcode");
            }
            if (!this.isScaning) {
                this.isScan = true;
                Object object = this.object;
                synchronized (object) {
                    this.object.notifyAll();
                }
            }
        }

        private void stopBarcode() {
            if (DEBUG) {
                Log.i((String)TAG, (String)"stopBarcode");
            }
            this.isScan = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exitThread() {
            if (DEBUG) {
                Log.i((String)TAG, (String)"exitThread");
            }
            this.isScan = false;
            this.isRuning = false;
            Object object = this.object;
            synchronized (object) {
                this.object.notifyAll();
            }
        }

        public boolean getIsScaning() {
            return this.isScaning;
        }

        public void SetDecodingSettings() {
            if (DEBUG) {
                Log.i((String)TAG, (String)"SetDecodingSettings()");
            }
            int nMode = 0;
            try {
                if (DEBUG) {
                    Log.d((String)TAG, (String)("set mode=" + nMode));
                }
                Barcode2DWithSoft.this.decoder.setDecodeWindowMode(nMode);
                if (DEBUG) {
                    Log.d((String)TAG, (String)"set Limit=800");
                }
                Barcode2DWithSoft.this.decoder.setDecodeAttemptLimit(800);
                DecodeOptions decOpt = new DecodeOptions();
                decOpt.DecAttemptLimit = -1;
                decOpt.VideoReverse = -1;
                decOpt.MultiReadCount = 2;
                if (DEBUG) {
                    Log.d((String)TAG, (String)"set setDecodeOptions");
                }
                Barcode2DWithSoft.this.decoder.setDecodeOptions(decOpt);
            }
            catch (DecoderException e) {
                if (DEBUG) {
                    Log.e((String)TAG, (String)("SetDecodingSettings() exception= " + e.getErrorCode()));
                }
                e.printStackTrace();
            }
        }

        public void SetScanningSettings() {
            try {
                if (DEBUG) {
                    Log.d((String)TAG, (String)("SetScanningSettings getLightsMode() myLightsMode = " + Barcode2DWithSoft.this.decoder.getLightsMode()));
                }
                int myLightsMode = 3;
                if (DEBUG) {
                    Log.d((String)TAG, (String)("SetScanningSettings myLightsMode = " + myLightsMode));
                }
                Barcode2DWithSoft.this.decoder.setLightsMode(myLightsMode);
            }
            catch (DecoderException e) {
                if (DEBUG) {
                    Log.d((String)TAG, (String)("SetScanningSettings exception=" + e.getErrorCode()));
                }
                e.printStackTrace();
            }
        }
    }

    public static interface VideoCallback {
        public void onVideoFrame(int var1, int var2, int var3, byte[] var4);
    }
}

