/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Build;
import android.support.annotation.RestrictTo;
import android.support.v7.appcompat.R;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.DrawableUtils;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AppCompatImageHelper {
    private final ImageView mView;

    public AppCompatImageHelper(ImageView view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TintTypedArray a = null;
        try {
            int id2;
            Drawable drawable2 = this.mView.getDrawable();
            if (drawable2 == null && (id2 = (a = TintTypedArray.obtainStyledAttributes(this.mView.getContext(), attrs, R.styleable.AppCompatImageView, defStyleAttr, 0)).getResourceId(R.styleable.AppCompatImageView_srcCompat, -1)) != -1 && (drawable2 = AppCompatResources.getDrawable(this.mView.getContext(), id2)) != null) {
                this.mView.setImageDrawable(drawable2);
            }
            if (drawable2 != null) {
                DrawableUtils.fixDrawable(drawable2);
            }
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            Drawable d = AppCompatResources.getDrawable(this.mView.getContext(), resId);
            if (d != null) {
                DrawableUtils.fixDrawable(d);
            }
            this.mView.setImageDrawable(d);
        } else {
            this.mView.setImageDrawable(null);
        }
    }

    boolean hasOverlappingRendering() {
        Drawable background = this.mView.getBackground();
        return Build.VERSION.SDK_INT < 21 || !(background instanceof RippleDrawable);
    }
}

