/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.Resources;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.content.res.ConfigurationHelperJellybeanMr1;

public final class ConfigurationHelper {
    private static final ConfigurationHelperBaseImpl IMPL = Build.VERSION.SDK_INT >= 17 ? new ConfigurationHelperApi17Impl() : new ConfigurationHelperBaseImpl();

    private ConfigurationHelper() {
    }

    @Deprecated
    public static int getScreenHeightDp(@NonNull Resources resources) {
        return resources.getConfiguration().screenHeightDp;
    }

    @Deprecated
    public static int getScreenWidthDp(@NonNull Resources resources) {
        return resources.getConfiguration().screenWidthDp;
    }

    @Deprecated
    public static int getSmallestScreenWidthDp(@NonNull Resources resources) {
        return resources.getConfiguration().smallestScreenWidthDp;
    }

    public static int getDensityDpi(@NonNull Resources resources) {
        return IMPL.getDensityDpi(resources);
    }

    @RequiresApi(value=17)
    private static class ConfigurationHelperApi17Impl
    extends ConfigurationHelperBaseImpl {
        private ConfigurationHelperApi17Impl() {
        }

        @Override
        public int getDensityDpi(@NonNull Resources resources) {
            return ConfigurationHelperJellybeanMr1.getDensityDpi(resources);
        }
    }

    private static class ConfigurationHelperBaseImpl {
        private ConfigurationHelperBaseImpl() {
        }

        public int getDensityDpi(@NonNull Resources resources) {
            return resources.getDisplayMetrics().densityDpi;
        }
    }
}

