/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.os.Build;

public final class BitmapCompat {
    static final BitmapCompatBaseImpl IMPL;

    public static boolean hasMipMap(Bitmap bitmap) {
        return IMPL.hasMipMap(bitmap);
    }

    public static void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
        IMPL.setHasMipMap(bitmap, hasMipMap);
    }

    public static int getAllocationByteCount(Bitmap bitmap) {
        return IMPL.getAllocationByteCount(bitmap);
    }

    private BitmapCompat() {
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 19 ? new BitmapCompatApi19Impl() : (version >= 18 ? new BitmapCompatApi18Impl() : new BitmapCompatBaseImpl());
    }

    @TargetApi(value=19)
    static class BitmapCompatApi19Impl
    extends BitmapCompatApi18Impl {
        BitmapCompatApi19Impl() {
        }

        @Override
        public int getAllocationByteCount(Bitmap bitmap) {
            return bitmap.getAllocationByteCount();
        }
    }

    @TargetApi(value=18)
    static class BitmapCompatApi18Impl
    extends BitmapCompatBaseImpl {
        BitmapCompatApi18Impl() {
        }

        @Override
        public boolean hasMipMap(Bitmap bitmap) {
            return bitmap.hasMipMap();
        }

        @Override
        public void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
            bitmap.setHasMipMap(hasMipMap);
        }
    }

    static class BitmapCompatBaseImpl {
        BitmapCompatBaseImpl() {
        }

        public boolean hasMipMap(Bitmap bitmap) {
            return false;
        }

        public void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
        }

        public int getAllocationByteCount(Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }
}

