/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.net;

import android.annotation.TargetApi;
import android.net.TrafficStats;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.v4.net.DatagramSocketWrapper;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;

public final class TrafficStatsCompat {
    private static final TrafficStatsCompatBaseImpl IMPL = Build.VERSION.SDK_INT >= 24 ? new TrafficStatsCompatApi24Impl() : new TrafficStatsCompatBaseImpl();

    @Deprecated
    public static void clearThreadStatsTag() {
        TrafficStats.clearThreadStatsTag();
    }

    @Deprecated
    public static int getThreadStatsTag() {
        return TrafficStats.getThreadStatsTag();
    }

    @Deprecated
    public static void incrementOperationCount(int operationCount) {
        TrafficStats.incrementOperationCount((int)operationCount);
    }

    @Deprecated
    public static void incrementOperationCount(int tag, int operationCount) {
        TrafficStats.incrementOperationCount((int)tag, (int)operationCount);
    }

    @Deprecated
    public static void setThreadStatsTag(int tag) {
        TrafficStats.setThreadStatsTag((int)tag);
    }

    @Deprecated
    public static void tagSocket(Socket socket) throws SocketException {
        TrafficStats.tagSocket((Socket)socket);
    }

    @Deprecated
    public static void untagSocket(Socket socket) throws SocketException {
        TrafficStats.untagSocket((Socket)socket);
    }

    public static void tagDatagramSocket(DatagramSocket socket) throws SocketException {
        IMPL.tagDatagramSocket(socket);
    }

    public static void untagDatagramSocket(DatagramSocket socket) throws SocketException {
        IMPL.untagDatagramSocket(socket);
    }

    private TrafficStatsCompat() {
    }

    @TargetApi(value=24)
    static class TrafficStatsCompatApi24Impl
    extends TrafficStatsCompatBaseImpl {
        TrafficStatsCompatApi24Impl() {
        }

        @Override
        public void tagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStats.tagDatagramSocket((DatagramSocket)socket);
        }

        @Override
        public void untagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStats.untagDatagramSocket((DatagramSocket)socket);
        }
    }

    static class TrafficStatsCompatBaseImpl {
        TrafficStatsCompatBaseImpl() {
        }

        public void tagDatagramSocket(DatagramSocket socket) throws SocketException {
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket((DatagramSocket)socket);
            TrafficStats.tagSocket((Socket)new DatagramSocketWrapper(socket, pfd.getFileDescriptor()));
            pfd.detachFd();
        }

        public void untagDatagramSocket(DatagramSocket socket) throws SocketException {
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket((DatagramSocket)socket);
            TrafficStats.untagSocket((Socket)new DatagramSocketWrapper(socket, pfd.getFileDescriptor()));
            pfd.detachFd();
        }
    }
}

