/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.support.annotation.RequiresApi;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityManagerCompat;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;

@RequiresApi(value=14)
class ViewCompatICS {
    ViewCompatICS() {
    }

    public static void setTooltipText(View view, CharSequence tooltipText) {
        if (TextUtils.isEmpty((CharSequence)tooltipText)) {
            view.setOnLongClickListener(null);
            view.setLongClickable(false);
            view.setOnHoverListener(null);
        } else {
            new TooltipHandler(view, tooltipText);
        }
    }

    private static class TooltipHandler
    implements View.OnLongClickListener,
    View.OnHoverListener {
        private final View mAnchor;
        private final CharSequence mTooltipText;
        private final Runnable mShowRunnable = new Runnable(){

            @Override
            public void run() {
                TooltipHandler.this.show(1);
            }
        };
        private Toast mTooltip;

        TooltipHandler(View anchor, CharSequence tooltipText) {
            this.mAnchor = anchor;
            this.mTooltipText = tooltipText;
            this.mAnchor.setOnLongClickListener((View.OnLongClickListener)this);
            this.mAnchor.setOnHoverListener((View.OnHoverListener)this);
        }

        public boolean onLongClick(View v) {
            this.show(0);
            return true;
        }

        public boolean onHover(View v, MotionEvent event) {
            AccessibilityManager manager = (AccessibilityManager)this.mAnchor.getContext().getSystemService("accessibility");
            if (manager.isEnabled() && AccessibilityManagerCompat.isTouchExplorationEnabled(manager)) {
                return false;
            }
            int action = event.getAction();
            if (action == 7) {
                this.hide();
                this.mAnchor.getHandler().postDelayed(this.mShowRunnable, (long)ViewConfiguration.getLongPressTimeout());
            } else if (action == 10) {
                this.hide();
            }
            return false;
        }

        private void show(int duration) {
            Context context = this.mAnchor.getContext();
            Resources resources = context.getResources();
            int screenWidth = resources.getDisplayMetrics().widthPixels;
            int screenHeight = resources.getDisplayMetrics().heightPixels;
            Rect displayFrame = new Rect();
            this.mAnchor.getWindowVisibleDisplayFrame(displayFrame);
            if (displayFrame.left < 0 && displayFrame.top < 0) {
                int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
                int statusBarHeight = resourceId > 0 ? resources.getDimensionPixelSize(resourceId) : 0;
                displayFrame.set(0, statusBarHeight, screenWidth, screenHeight);
            }
            int[] anchorPos = new int[2];
            this.mAnchor.getLocationOnScreen(anchorPos);
            int referenceX = anchorPos[0] + this.mAnchor.getWidth() / 2;
            if (ViewCompat.getLayoutDirection(this.mAnchor) == 0) {
                referenceX = screenWidth - referenceX;
            }
            int anchorTop = anchorPos[1];
            this.hide();
            this.mTooltip = Toast.makeText((Context)context, (CharSequence)this.mTooltipText, (int)duration);
            if ((double)anchorTop < (double)displayFrame.height() * 0.8) {
                this.mTooltip.setGravity(8388661, referenceX, anchorTop + this.mAnchor.getHeight() - displayFrame.top);
            } else {
                this.mTooltip.setGravity(0x800055, referenceX, displayFrame.bottom - anchorTop);
            }
            this.mTooltip.show();
        }

        private void hide() {
            if (this.mTooltip != null) {
                this.mTooltip.cancel();
                this.mTooltip = null;
            }
            this.mAnchor.getHandler().removeCallbacks(this.mShowRunnable);
        }
    }
}

