/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.rule.logging;

import android.os.Trace;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.test.annotation.Beta;
import android.support.test.rule.logging.LoggingBaseRule;
import android.support.test.rule.logging.RuleLoggingUtils;
import android.util.Log;
import java.io.File;
import java.io.IOException;

@Beta
public class LogNetStatsRule
extends LoggingBaseRule {
    private static final String TAG = "LogNetStatsRule";

    public LogNetStatsRule() {
    }

    public LogNetStatsRule(@NonNull File logFileOutputDirectory, @Nullable String fileName) {
        super(logFileOutputDirectory, fileName);
    }

    @Override
    String getDefaultLogFileName() {
        return "netstats.dumpsys.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeTest() {
        Process process = null;
        try {
            process = RuleLoggingUtils.startProcess(new String[]{"dumpsys", "netstats", "--reset", this.getPackageNameUnderTest()});
            process.waitFor();
        }
        catch (IOException | InterruptedException exception) {
            Log.e((String)TAG, (String)"Unable to reset netstats", (Throwable)exception);
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterTest() {
        String[] commandParts = new String[]{"dumpsys", "netstats"};
        try {
            Trace.beginSection((String)"Netstats dumpsys");
            RuleLoggingUtils.startProcessAndLogToFile(commandParts, this.getLogFile(), this.getAndroidRuntimeVersion());
        }
        finally {
            Trace.endSection();
        }
    }
}

