/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import com.google.android.gms.common.api.BatchResult;
import com.google.android.gms.common.api.BatchResultToken;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzb;
import java.util.ArrayList;
import java.util.List;

public final class Batch
extends zzb<BatchResult> {
    private int zzafZ;
    private boolean zzaga;
    private boolean zzagb;
    private final PendingResult<?>[] zzagc;
    private final Object zzpV = new Object();

    private Batch(List<PendingResult<?>> pendingResultList, GoogleApiClient apiClient) {
        super(apiClient);
        this.zzafZ = pendingResultList.size();
        this.zzagc = new PendingResult[this.zzafZ];
        if (pendingResultList.isEmpty()) {
            this.zza(new BatchResult(Status.zzagC, this.zzagc));
            return;
        }
        for (int i = 0; i < pendingResultList.size(); ++i) {
            PendingResult<?> pendingResult = pendingResultList.get(i);
            this.zzagc[i] = pendingResult;
            pendingResult.zza(new PendingResult.zza(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void zzu(Status status) {
                    Object object = Batch.this.zzpV;
                    synchronized (object) {
                        if (Batch.this.isCanceled()) {
                            return;
                        }
                        if (status.isCanceled()) {
                            Batch.this.zzagb = true;
                        } else if (!status.isSuccess()) {
                            Batch.this.zzaga = true;
                        }
                        Batch.this.zzafZ--;
                        if (Batch.this.zzafZ == 0) {
                            if (Batch.this.zzagb) {
                                Batch.super.cancel();
                            } else {
                                Status status2 = Batch.this.zzaga ? new Status(13) : Status.zzagC;
                                Batch.this.zza(new BatchResult(status2, Batch.this.zzagc));
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        for (PendingResult<?> pendingResult : this.zzagc) {
            pendingResult.cancel();
        }
    }

    public BatchResult createFailedResult(Status status) {
        return new BatchResult(status, this.zzagc);
    }

    @Override
    public /* synthetic */ Result zzc(Status status) {
        return this.createFailedResult(status);
    }

    public static final class Builder {
        private List<PendingResult<?>> zzage = new ArrayList();
        private GoogleApiClient zzaaj;

        public Builder(GoogleApiClient googleApiClient) {
            this.zzaaj = googleApiClient;
        }

        public <R extends Result> BatchResultToken<R> add(PendingResult<R> pendingResult) {
            BatchResultToken batchResultToken = new BatchResultToken(this.zzage.size());
            this.zzage.add(pendingResult);
            return batchResultToken;
        }

        public Batch build() {
            return new Batch(this.zzage, this.zzaaj);
        }
    }
}

