/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzk;
import com.google.android.gms.common.api.internal.zzl;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import com.google.android.gms.signin.internal.SignInResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzh
implements zzk {
    private final zzl zzahj;
    private final Lock zzXG;
    private final Context mContext;
    private final com.google.android.gms.common.zzc zzags;
    private ConnectionResult zzahm;
    private int zzahn;
    private int zzaho = 0;
    private int zzahp;
    private final Bundle zzahq = new Bundle();
    private final Set<Api.zzc> zzahr = new HashSet<Api.zzc>();
    private zzrn zzahs;
    private int zzaht;
    private boolean zzahu;
    private boolean zzahv;
    private zzp zzahw;
    private boolean zzahx;
    private boolean zzahy;
    private final com.google.android.gms.common.internal.zzf zzahz;
    private final Map<Api<?>, Integer> zzahA;
    private final Api.zza<? extends zzrn, zzro> zzagt;
    private ArrayList<Future<?>> zzahB = new ArrayList();

    public zzh(zzl zzl2, com.google.android.gms.common.internal.zzf zzf2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzrn, zzro> zza2, Lock lock, Context context) {
        this.zzahj = zzl2;
        this.zzahz = zzf2;
        this.zzahA = map;
        this.zzags = zzc2;
        this.zzagt = zza2;
        this.zzXG = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.zzahj.zzaio.clear();
        this.zzahu = false;
        this.zzahm = null;
        this.zzaho = 0;
        this.zzaht = 2;
        this.zzahv = false;
        this.zzahx = false;
        boolean bl = false;
        HashMap<Api.zzb, GoogleApiClient.zza> hashMap = new HashMap<Api.zzb, GoogleApiClient.zza>();
        for (Api<?> api : this.zzahA.keySet()) {
            Api.zzb zzb2 = this.zzahj.zzahT.get(api.zzoR());
            int n = this.zzahA.get(api);
            bl |= api.zzoP().getPriority() == 1;
            if (zzb2.zzmE()) {
                this.zzahu = true;
                if (n < this.zzaht) {
                    this.zzaht = n;
                }
                if (n != 0) {
                    this.zzahr.add(api.zzoR());
                }
            }
            hashMap.put(zzb2, new zza(this, api, n));
        }
        if (bl) {
            this.zzahu = false;
        }
        if (this.zzahu) {
            this.zzahz.zza(this.zzahj.zzagW.getSessionId());
            zze zze2 = new zze();
            this.zzahs = this.zzagt.zza(this.mContext, this.zzahj.zzagW.getLooper(), this.zzahz, this.zzahz.zzqy(), zze2, zze2);
        }
        this.zzahp = this.zzahj.zzahT.size();
        this.zzahB.add(zzm.zzpN().submit(new zzb(hashMap)));
    }

    private boolean zzpu() {
        --this.zzahp;
        if (this.zzahp > 0) {
            return false;
        }
        if (this.zzahp < 0) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzahj.zzagW.zzpH());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzahm != null) {
            this.zzahj.zzair = this.zzahn;
            this.zzg(this.zzahm);
            return false;
        }
        return true;
    }

    private void zza(SignInResponse signInResponse) {
        if (!this.zzbz(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.zzqY();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.zzFP();
            ConnectionResult connectionResult2 = resolveAccountResponse.zzqY();
            if (!connectionResult2.isSuccess()) {
                Log.wtf((String)"GoogleApiClientConnecting", (String)("Sign-in succeeded with resolve account failure: " + connectionResult2), (Throwable)new Exception());
                this.zzg(connectionResult2);
                return;
            }
            this.zzahv = true;
            this.zzahw = resolveAccountResponse.zzqX();
            this.zzahx = resolveAccountResponse.zzqZ();
            this.zzahy = resolveAccountResponse.zzra();
            this.zzpv();
        } else if (this.zzf(connectionResult)) {
            this.zzpy();
            this.zzpv();
        } else {
            this.zzg(connectionResult);
        }
    }

    private void zzpv() {
        if (this.zzahp != 0) {
            return;
        }
        if (!this.zzahu || this.zzahv) {
            this.zzpw();
        }
    }

    private void zzpw() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzaho = 1;
        this.zzahp = this.zzahj.zzahT.size();
        for (Api.zzc<?> zzc2 : this.zzahj.zzahT.keySet()) {
            if (this.zzahj.zzaio.containsKey(zzc2)) {
                if (!this.zzpu()) continue;
                this.zzpx();
                continue;
            }
            arrayList.add(this.zzahj.zzahT.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzahB.add(zzm.zzpN().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (!this.zzbz(1)) {
            return;
        }
        if (connectionHint != null) {
            this.zzahq.putAll(connectionHint);
        }
        if (this.zzpu()) {
            this.zzpx();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzbz(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzpu()) {
            this.zzpx();
        }
    }

    private void zzpx() {
        this.zzahj.zzpL();
        zzm.zzpN().execute(new Runnable(){

            @Override
            public void run() {
                zzh.this.zzags.zzal(zzh.this.mContext);
            }
        });
        if (this.zzahs != null) {
            if (this.zzahx) {
                this.zzahs.zza(this.zzahw, this.zzahy);
            }
            this.zzZ(false);
        }
        for (Api.zzc<?> zzc2 : this.zzahj.zzaio.keySet()) {
            Api.zzb zzb2 = this.zzahj.zzahT.get(zzc2);
            zzb2.disconnect();
        }
        Bundle bundle = this.zzahq.isEmpty() ? null : this.zzahq;
        this.zzahj.zzais.zzi(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zza.zza<R, A>> T zza(T t) {
        this.zzahj.zzagW.zzahN.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zza.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzpz();
        this.zzZ(true);
        this.zzahj.zzh(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int cause) {
        this.zzg(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzoP().getPriority(), n, connectionResult)) {
            this.zzahm = connectionResult;
            this.zzahn = n2;
        }
        this.zzahj.zzaio.put(api.zzoR(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zze(connectionResult)) {
            return false;
        }
        return this.zzahm == null || n < this.zzahn;
    }

    private boolean zze(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzags.zzbu(connectionResult.getErrorCode()) != null;
    }

    private void zzpy() {
        this.zzahu = false;
        this.zzahj.zzagW.zzahU = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzahr) {
            if (this.zzahj.zzaio.containsKey(zzc2)) continue;
            this.zzahj.zzaio.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zzf(ConnectionResult connectionResult) {
        return this.zzaht == 2 || this.zzaht == 1 && !connectionResult.hasResolution();
    }

    private void zzg(ConnectionResult connectionResult) {
        this.zzpz();
        this.zzZ(!connectionResult.hasResolution());
        this.zzahj.zzh(connectionResult);
        this.zzahj.zzais.zzd(connectionResult);
    }

    private void zzZ(boolean bl) {
        if (this.zzahs != null) {
            if (this.zzahs.isConnected() && bl) {
                this.zzahs.zzFG();
            }
            this.zzahs.disconnect();
            this.zzahw = null;
        }
    }

    private void zzpz() {
        for (Future<?> future : this.zzahB) {
            future.cancel(true);
        }
        this.zzahB.clear();
    }

    private Set<Scope> zzpA() {
        if (this.zzahz == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzahz.zzqs());
        Map<Api<?>, zzf.zza> map = this.zzahz.zzqu();
        for (Api<?> api : map.keySet()) {
            if (this.zzahj.zzaio.containsKey(api.zzoR())) continue;
            hashSet.addAll(map.get(api).zzXf);
        }
        return hashSet;
    }

    private boolean zzbz(int n) {
        if (this.zzaho != n) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzahj.zzagW.zzpH());
            Log.wtf((String)"GoogleApiClientConnecting", (String)("GoogleApiClient connecting is in step " + this.zzbA(this.zzaho) + " but received callback for step " + this.zzbA(n)), (Throwable)new Exception());
            this.zzg(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzbA(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzh> zzahD;

        zzd(zzh zzh2) {
            this.zzahD = new WeakReference<zzh>(zzh2);
        }

        @Override
        @BinderThread
        public void zzb(final SignInResponse signInResponse) {
            final zzh zzh2 = (zzh)this.zzahD.get();
            if (zzh2 == null) {
                return;
            }
            zzh2.zzahj.zza(new zzl.zza(zzh2){

                @Override
                public void zzpt() {
                    zzh2.zza(signInResponse);
                }
            });
        }
    }

    private static class zza
    implements GoogleApiClient.zza {
        private final WeakReference<zzh> zzahD;
        private final Api<?> zzagT;
        private final int zzagU;

        public zza(zzh zzh2, Api<?> api, int n) {
            this.zzahD = new WeakReference<zzh>(zzh2);
            this.zzagT = api;
            this.zzagU = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(@NonNull ConnectionResult connectionResult) {
            zzh zzh2 = (zzh)this.zzahD.get();
            if (zzh2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == ((zzh)zzh2).zzahj.zzagW.getLooper(), (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzh2.zzXG.lock();
            try {
                if (!zzh2.zzbz(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzh2.zzb(connectionResult, this.zzagT, this.zzagU);
                }
                if (zzh2.zzpu()) {
                    zzh2.zzpv();
                }
            }
            finally {
                zzh2.zzXG.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            zzh.this.zzahs.zza(new zzd(zzh.this));
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(@NonNull ConnectionResult result) {
            zzh.this.zzXG.lock();
            try {
                if (zzh.this.zzf(result)) {
                    zzh.this.zzpy();
                    zzh.this.zzpv();
                } else {
                    zzh.this.zzg(result);
                }
            }
            finally {
                zzh.this.zzXG.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zzb> zzahH;

        public zzc(ArrayList<Api.zzb> arrayList) {
            this.zzahH = arrayList;
        }

        @Override
        @WorkerThread
        public void zzpt() {
            ((zzh)zzh.this).zzahj.zzagW.zzahU = zzh.this.zzpA();
            for (Api.zzb zzb2 : this.zzahH) {
                zzb2.zza(zzh.this.zzahw, ((zzh)zzh.this).zzahj.zzagW.zzahU);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zzb, GoogleApiClient.zza> zzahE;

        public zzb(Map<Api.zzb, GoogleApiClient.zza> map) {
            this.zzahE = map;
        }

        @Override
        @WorkerThread
        public void zzpt() {
            int n = zzh.this.zzags.isGooglePlayServicesAvailable(zzh.this.mContext);
            if (n != 0) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzh.this.zzahj.zza(new zzl.zza(zzh.this){

                    @Override
                    public void zzpt() {
                        zzh.this.zzg(connectionResult);
                    }
                });
                return;
            }
            if (zzh.this.zzahu) {
                zzh.this.zzahs.connect();
            }
            for (Api.zzb zzb2 : this.zzahE.keySet()) {
                zzb2.zza(this.zzahE.get(zzb2));
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void run() {
            zzh.this.zzXG.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzpt();
            }
            catch (RuntimeException runtimeException) {
                zzh.this.zzahj.zza(runtimeException);
            }
            finally {
                zzh.this.zzXG.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzpt();
    }
}

