/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzk
implements Handler.Callback {
    private final zza zzalQ;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> zzalR = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> zzalS = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> zzalT = new ArrayList();
    private volatile boolean zzalU = false;
    private final AtomicInteger zzalV = new AtomicInteger(0);
    private boolean zzalW = false;
    private final Handler mHandler;
    private final Object zzpV = new Object();

    public zzk(Looper looper, zza zza2) {
        this.zzalQ = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzqQ() {
        this.zzalU = false;
        this.zzalV.incrementAndGet();
    }

    public void zzqR() {
        this.zzalU = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzk(Bundle bundle) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzpV;
        synchronized (object) {
            zzx.zzab(!this.zzalW);
            this.mHandler.removeMessages(1);
            this.zzalW = true;
            zzx.zzab(this.zzalS.size() == 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzalR);
            int n = this.zzalV.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzalU || !this.zzalQ.isConnected() || this.zzalV.get() != n) break;
                if (this.zzalS.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.zzalS.clear();
            this.zzalW = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzbT(int n) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpV;
        synchronized (object) {
            this.zzalW = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.zzalR);
            int n2 = this.zzalV.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.zzalU || this.zzalV.get() != n2) break;
                if (!this.zzalR.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.zzalS.clear();
            this.zzalW = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzk(ConnectionResult connectionResult) {
        zzx.zza(Looper.myLooper() == this.mHandler.getLooper(), (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzpV;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.zzalT);
            int n = this.zzalV.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.zzalU || this.zzalV.get() != n) {
                    return;
                }
                if (!this.zzalT.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzz(listener);
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzalR.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                this.zzalR.add(listener);
            }
        }
        if (this.zzalQ.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzz(listener);
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzalR.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks listener) {
        zzx.zzz(listener);
        Object object = this.zzpV;
        synchronized (object) {
            boolean bl = this.zzalR.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
            } else if (this.zzalW) {
                this.zzalS.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzz(listener);
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzalT.contains(listener)) {
                Log.w((String)"GmsClientEvents", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                this.zzalT.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzz(listener);
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzalT.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener listener) {
        zzx.zzz(listener);
        Object object = this.zzpV;
        synchronized (object) {
            boolean bl = this.zzalT.remove(listener);
            if (!bl) {
                Log.w((String)"GmsClientEvents", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)msg.obj;
            Object object = this.zzpV;
            synchronized (object) {
                if (this.zzalU && this.zzalQ.isConnected() && this.zzalR.contains(connectionCallbacks)) {
                    Bundle bundle = this.zzalQ.zzoi();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        Log.wtf((String)"GmsClientEvents", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzoi();
    }
}

