/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final zzc zzbgP = zzc.zzoK();
    private static final Object zzqy = new Object();
    private static Method zzbgQ = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zzx.zzb(context, (Object)"Context must not be null");
        zzbgP.zzak(context);
        Context context2 = zze.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = zzqy;
        synchronized (object) {
            try {
                if (zzbgQ == null) {
                    ProviderInstaller.zzaV(context2);
                }
                zzbgQ.invoke(null, context2);
            }
            catch (Exception exception) {
                Log.e((String)"ProviderInstaller", (String)("Failed to install provider: " + exception.getMessage()));
                throw new GooglePlayServicesNotAvailableException(8);
            }
        }
    }

    public static void installIfNeededAsync(final Context context, final ProviderInstallListener listener) {
        zzx.zzb(context, (Object)"Context must not be null");
        zzx.zzb(listener, (Object)"Listener must not be null");
        zzx.zzcD("Must be called on the UI thread");
        AsyncTask<Void, Void, Integer> asyncTask = new AsyncTask<Void, Void, Integer>(){

            protected Integer zzc(Void ... voidArray) {
                try {
                    ProviderInstaller.installIfNeeded(context);
                }
                catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
                    return googlePlayServicesRepairableException.getConnectionStatusCode();
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    return googlePlayServicesNotAvailableException.errorCode;
                }
                return 0;
            }

            protected void zze(Integer n) {
                if (n == 0) {
                    listener.onProviderInstalled();
                } else {
                    Intent intent = zzbgP.zza(context, n, "pi");
                    listener.onProviderInstallFailed(n, intent);
                }
            }

            protected /* synthetic */ void onPostExecute(Object object) {
                this.zze((Integer)object);
            }

            protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                return this.zzc((Void[])objectArray);
            }
        };
        asyncTask.execute((Object[])new Void[0]);
    }

    private static void zzaV(Context context) throws ClassNotFoundException, NoSuchMethodException {
        ClassLoader classLoader = context.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
        Class[] classArray = new Class[]{Context.class};
        zzbgQ = clazz.getMethod("insertProvider", classArray);
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

