/*
 * Decompiled with CFR 0.152.
 */
package com.rscja.deviceapi;

import android.util.Log;
import com.rscja.deviceapi.c;
import com.rscja.deviceapi.entity.DESFireFile;
import com.rscja.deviceapi.entity.SimpleRFIDEntity;
import com.rscja.deviceapi.exception.ConfigurationException;
import com.rscja.deviceapi.exception.RFIDNotFoundException;
import com.rscja.deviceapi.exception.RFIDReadFailureException;
import com.rscja.deviceapi.exception.RFIDVerificationException;
import com.rscja.utility.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RFIDWithISO14443A
extends c {
    private static RFIDWithISO14443A a = null;

    protected RFIDWithISO14443A() throws ConfigurationException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized RFIDWithISO14443A getInstance() throws ConfigurationException {
        if (a != null) return a;
        Class<RFIDWithISO14443A> clazz = RFIDWithISO14443A.class;
        synchronized (RFIDWithISO14443A.class) {
            if (a != null) return a;
            a = new RFIDWithISO14443A();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public synchronized SimpleRFIDEntity request() {
        byte[] byArray = this.getDeviceAPI().ISO14443A_request(this.config.k(), 1);
        if (byArray == null || byArray[0] != 0 || byArray[4] == 0) {
            return null;
        }
        byte[] byArray2 = new byte[byArray[4]];
        TagType tagType = TagType.Unknow;
        TagType tagType2 = TagType.Unknow;
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = byArray[n + 5];
            ++n;
        }
        byte by = byArray[5 + byArray2.length];
        n = by >> 2 & 1;
        int n2 = by >> 3 & 1;
        int n3 = by >> 4 & 1;
        int n4 = by >> 5 & 1;
        if (byArray[2] == 68 && byArray[3] == 0) {
            n = byArray[byArray[1] + 1];
            tagType2 = n == 0 ? TagType.Ultra_light : TagType.Mifare_plus;
            tagType = by == 0 ? TagType.Ultra_light : TagType.Mifare_plus;
        } else if (byArray[2] == 4 && byArray[3] == 0) {
            if (n2 == 1 || by == 0) {
                tagType = TagType.S50;
            }
        } else if (byArray[2] == 2 && byArray[3] == 0) {
            if (n2 == 1 && n3 == 1 || by == 0) {
                tagType = TagType.S70;
            }
        } else if (byArray[2] == 68 && byArray[3] == 3) {
            if (n4 == 1 || n4 == 1 && n == 1 || by == 0) {
                tagType = TagType.Mifare_DESFire;
            }
        } else {
            tagType = byArray[2] == 8 && byArray[3] == 0 ? TagType.Mifare_Pro : (byArray[2] == 4 && byArray[3] == 3 ? TagType.Mifare_ProX : TagType.Unknow);
        }
        String string = tagType2 != tagType && tagType2 != TagType.Unknow ? String.valueOf(tagType2.toString()) + " or " + tagType.toString() : tagType.toString();
        return new SimpleRFIDEntity(StringUtility.bytes2HexString(byArray2, byArray2.length), string);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized SimpleRFIDEntity read(String key, KeyType keyType, int sector, int block) throws RFIDVerificationException, RFIDReadFailureException {
        void var2_2;
        Object object;
        SimpleRFIDEntity simpleRFIDEntity = this.request();
        if (simpleRFIDEntity == null) {
            return null;
        }
        if (this.a(sector, (String)object, (KeyType)var2_2)) {
            Object object2;
            int n;
            void v0 = n;
            n = block;
            int n2 = v0;
            object = this;
            if (n2 < 0 || n2 > 40) {
                object2 = null;
            } else {
                n2 = n2 > 31 && n2 < 40 ? 128 + (n2 - 32 << 4) : (n2 <<= 2);
                char[] cArray = ((c)object).getDeviceAPI().ISO14443A_read((int)(n2 + n));
                object = cArray;
                if (cArray[0] != '\u0000') {
                    Log.e((String)"RFIDWithISO1443A", (String)("M1_ReadData() err:" + Integer.valueOf((int)object[0])));
                    throw new RFIDReadFailureException();
                }
                char[] cArray2 = new char[object[1]];
                n = 0;
                while (n < object[1]) {
                    cArray2[n] = (char)object[n + 2];
                    ++n;
                }
                object = cArray2;
                object2 = object;
            }
            if (object2 != null) {
                simpleRFIDEntity.setData(StringUtility.chars2HexString((char[])object, ((RFIDWithISO14443A)object).length));
            }
        } else {
            throw new RFIDVerificationException();
        }
        return simpleRFIDEntity;
    }

    public synchronized SimpleRFIDEntity readAllData(String key, TagType tagType) throws RFIDVerificationException, RFIDReadFailureException {
        char[] cArray;
        char[] cArray2;
        SimpleRFIDEntity simpleRFIDEntity = this.request();
        if (simpleRFIDEntity == null) {
            return null;
        }
        cArray2 = this.getDeviceAPI().ISO14443A_mifareone_alldata_read(tagType.ordinal(), StringUtility.hexString2Chars((String)cArray2));
        if (cArray2[0] != '\u0000') {
            Log.e((String)"RFIDWithISO1443A", (String)("readAllData() err:" + Integer.valueOf(cArray2[0])));
            throw new RFIDReadFailureException();
        }
        int n = 4096;
        if (cArray == TagType.S50) {
            n = 1024;
        }
        cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = cArray2[n2 + 1];
            ++n2;
        }
        simpleRFIDEntity.setData(StringUtility.chars2HexString(cArray, cArray.length));
        return simpleRFIDEntity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized SimpleRFIDEntity read(int block) throws RFIDReadFailureException {
        void var1_1;
        SimpleRFIDEntity simpleRFIDEntity = this.request();
        if (simpleRFIDEntity == null) {
            return null;
        }
        void var3_4 = var1_1;
        Object object = this;
        char[] cArray = ((c)object).getDeviceAPI().ISO14443A_ul_read((int)var3_4);
        object = cArray;
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithISO1443A", (String)("M1_ReadData() err:" + (char)object[0]));
            throw new RFIDReadFailureException();
        }
        char[] cArray2 = new char[object[1]];
        int n = 0;
        while (n < object[1]) {
            cArray2[n] = (char)object[n + 2];
            ++n;
        }
        object = cArray2;
        if (cArray2 != null) {
            simpleRFIDEntity.setData(StringUtility.chars2HexString((char[])object, ((Object)object).length));
        }
        return simpleRFIDEntity;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean write(String key, KeyType keyType, int sector, int block, String hexData) throws RFIDVerificationException, RFIDNotFoundException {
        void var2_2;
        RFIDWithISO14443A rFIDWithISO14443A;
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        this.request();
        if (this.a(sector, (String)((Object)rFIDWithISO14443A), (KeyType)var2_2)) {
            int n;
            void v0 = n;
            Object object = hexData;
            n = block;
            int n2 = v0;
            rFIDWithISO14443A = this;
            if (n2 < 0 || n2 > 40) {
                return false;
            }
            char[] cArray = StringUtility.hexString2Chars((String)object);
            object = cArray;
            int n3 = cArray.length > 16 ? 16 : ((Object)object).length;
            char[] cArray2 = new char[16];
            int n4 = 0;
            while (n4 < 16) {
                cArray2[n4] = '\u0000';
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                cArray2[n4] = (char)object[n4];
                ++n4;
            }
            n2 = n2 > 31 && n2 < 40 ? 128 + (n2 - 32 << 4) : (n2 <<= 2);
            n4 = rFIDWithISO14443A.getDeviceAPI().ISO14443A_write((int)(n2 + n), cArray2, cArray2.length);
            if (n4 == 0) {
                return true;
            }
            Log.e((String)"RFIDWithISO1443A", (String)("M1_WriteData() err:" + n4));
            return false;
        }
        throw new RFIDVerificationException();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean write(int block, String hexData) throws RFIDNotFoundException {
        void var1_1;
        void var2_3;
        if (StringUtility.isEmpty(hexData)) {
            return false;
        }
        Object object = this.request();
        if (object == null) {
            throw new RFIDNotFoundException();
        }
        object = var2_3;
        void var2_4 = var1_1;
        RFIDWithISO14443A rFIDWithISO14443A = this;
        char[] cArray = StringUtility.hexString2Chars((String)object);
        object = cArray;
        int n = cArray.length > 4 ? 4 : ((Object)object).length;
        char[] cArray2 = new char[4];
        int n2 = 0;
        while (n2 < 4) {
            cArray2[n2] = '\u0000';
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            cArray2[n2] = (char)object[n2];
            ++n2;
        }
        n2 = rFIDWithISO14443A.getDeviceAPI().ISO14443A_ul_write((int)var2_4, cArray2, cArray2.length);
        if (n2 == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("M1_WriteData() err:" + n2));
        return false;
    }

    private synchronized boolean a(int n, String string, KeyType keyType) {
        n = n > 31 && n < 40 ? 128 + (n - 32 << 4) : (n <<= 2);
        n = this.getDeviceAPI().ISO14443A_authentication(keyType.ordinal(), n, StringUtility.hexString2Chars(string), 6);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("VerifySector() err:" + n));
        return false;
    }

    public synchronized boolean DESFire_RatsAndPss() {
        int n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_RatPss();
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_RatsAndPss() err:" + n));
        return false;
    }

    public synchronized int[] DESFire_GetKeySetting() {
        Object[] objectArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetKeySetting();
        if (objectArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_GetKeySetting() err:result==null");
            return null;
        }
        if (objectArray[0] != '\u0000') {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_GetKeySetting() err:" + Character.getNumericValue(objectArray[0])));
            return null;
        }
        int[] nArray = new int[]{objectArray[2], objectArray[3]};
        objectArray = nArray;
        return nArray;
    }

    public synchronized boolean DESFire_ChangeKeySetting(int keySetting) {
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ChangeKeySetting(n);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_ChangeKeySetting() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntegerSomeBit(int resource, int mask) {
        void var2_2;
        return resource >> var2_2 & 1;
    }

    public synchronized boolean DESFire_SelApp(String hexAppId) {
        byte[] byArray;
        if (StringUtility.isEmpty(hexAppId)) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_SelApp() err:hexAppId==null");
            return false;
        }
        byArray = StringUtility.hexString2Bytes((String)byArray);
        int n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_SelApp(byArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_SelApp() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_Auth(int keyNo, String key) {
        int n;
        void var2_2;
        if (StringUtility.isEmpty(key)) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_Auth() key==null");
            return false;
        }
        char[] cArray = StringUtility.hexString2Chars(key);
        Log.i((String)"RFIDWithISO1443A", (String)("DESFire_Auth() key:" + (String)var2_2));
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_Auth(n, cArray, cArray.length);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_Auth() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void DESFire_selCpy(int cpyType) {
        void var1_1;
        this.getDeviceAPI().RF_ISO14443A_DESFIRE_Cpysel((int)var1_1);
    }

    public synchronized boolean DESFire_ChangeKey(int keyNo, String newKey) {
        int n;
        char[] cArray;
        if (StringUtility.isEmpty(newKey)) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_ChangeKey() newKey==null");
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ChangeKey(n, cArray, cArray.length);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_ChangeKey() err:" + n));
        return false;
    }

    public synchronized String[] DESFire_GetApps() {
        byte[] byArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetApps();
        if (byArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_GetApps() err:result==null");
            return null;
        }
        if (byArray[0] != 0) {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_GetApps() err:" + Integer.valueOf(byArray[0])));
            return null;
        }
        int n = byArray[2];
        String[] stringArray = new String[n];
        byte[] byArray2 = null;
        int n2 = 0;
        while (n2 < n) {
            byArray2 = Arrays.copyOfRange(byArray, 3 + n2 * 3, 6 + n2 * 3);
            stringArray[n2] = StringUtility.bytes2HexString(byArray2, byArray2.length);
            ++n2;
        }
        return stringArray;
    }

    public synchronized boolean DESFire_DelApp(String hexAppId) {
        char[] cArray;
        if (StringUtility.isEmpty(hexAppId)) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_DelApp() err:hexAppId==null");
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        int n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_DelApp(cArray);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_DelApp() err:" + n));
        return false;
    }

    public synchronized boolean DESFire_FormatCard() {
        int n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_FormatCard();
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_FormatCard() err:" + n));
        return false;
    }

    public synchronized String[] DESFire_GetPiccInfo() {
        char[] cArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetPiccInfo();
        if (cArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_GetPiccInfo() err:result==null");
            return null;
        }
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() err:" + Character.getNumericValue(cArray[0])));
            return null;
        }
        int n = cArray[1];
        Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() len=" + n));
        cArray = Arrays.copyOfRange(cArray, 2, n + 2);
        n = 0;
        while (n < cArray.length) {
            Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() result[" + n + "]=" + StringUtility.char2HexString(cArray[n])));
            ++n;
        }
        n = cArray[0];
        char c2 = cArray[n + '\u0001'];
        char c3 = cArray[n + c2 + 2];
        Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() infoLenPart1=" + n + " infoLenPart2=" + c2 + " infoLenPart3=" + c3));
        char[] cArray2 = Arrays.copyOfRange(cArray, 1, n + 1);
        char[] cArray3 = Arrays.copyOfRange(cArray, n + 2, c2 + n + 2);
        cArray = Arrays.copyOfRange(cArray, n + 3 + c2, c3 + n + c2 + 3);
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        stringArray[0] = StringUtility.chars2HexString(cArray2, cArray2.length);
        stringArray2[1] = StringUtility.chars2HexString(cArray3, cArray3.length);
        stringArray2[2] = StringUtility.chars2HexString(cArray, cArray.length);
        Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() infos[0]=" + stringArray2[0]));
        Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() infos[1]=" + stringArray2[1]));
        Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetPiccInfo() infos[2]=" + stringArray2[2]));
        return stringArray2;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_AddApp(String hexAppId, int keySetting, int fileNums) {
        void var3_4;
        void var2_3;
        char[] cArray;
        if (StringUtility.isEmpty(hexAppId)) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_AddApp() err:hexAppId==null");
            return false;
        }
        cArray = StringUtility.hexString2Chars((String)cArray);
        int n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_AddApp(cArray, (int)var2_3, (int)var3_4);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_AddApp() err:" + n));
        return false;
    }

    public synchronized int[] DESFire_GetFileIds() {
        byte[] byArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetFileIds();
        if (byArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_GetFileIds() err:result==null");
            return null;
        }
        if (byArray[0] != 0) {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_GetFileIds() err:" + byArray[0]));
            return null;
        }
        int[] nArray = new int[byArray[2]];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = byArray[n + 3];
            ++n;
        }
        return nArray;
    }

    public synchronized List<DESFireFile> DESFire_GetFiles() {
        Object object = this.DESFire_GetFileIds();
        if (object == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_GetFiles() ids==null");
            return null;
        }
        ArrayList<DESFireFile> arrayList = new ArrayList<DESFireFile>();
        int[] nArray = object;
        int n = ((int[])object).length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            Object var5_11 = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            var5_11 = null;
            string = null;
            boolean bl = false;
            Object object2 = null;
            boolean bl2 = false;
            bl = false;
            byte[] byArray = this.DESFire_GetFileSetting(n3);
            if (byArray == null) {
                object = new DESFireFile(n3, DESFireFileTypekEnum.Unknown, DESFireEncryptionTypekEnum.Unknown, null, null, null, null);
            } else {
                Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetFiles() setting[0]=" + byArray[0]));
                switch (byArray[0]) {
                    case 0: {
                        object2 = DESFireFileTypekEnum.StandardDataFile;
                        break;
                    }
                    case 1: {
                        object2 = DESFireFileTypekEnum.BackupDataFile;
                        break;
                    }
                    case 2: {
                        object2 = DESFireFileTypekEnum.ValueFile;
                        break;
                    }
                    case 3: {
                        object2 = DESFireFileTypekEnum.LinearRecordFile;
                        break;
                    }
                    case 4: {
                        object2 = DESFireFileTypekEnum.CyclicRecordFile;
                        break;
                    }
                    default: {
                        object2 = DESFireFileTypekEnum.Unknown;
                    }
                }
                switch (byArray[1]) {
                    case 0: {
                        object = (Object)DESFireEncryptionTypekEnum.Transparent;
                        break;
                    }
                    case 3: {
                        object = (Object)DESFireEncryptionTypekEnum.DES;
                        break;
                    }
                    default: {
                        object = (Object)DESFireEncryptionTypekEnum.Unknown;
                    }
                }
                String string4 = StringUtility.byte2HexString(byArray[2]);
                string = StringUtility.byte2HexString(byArray[3]);
                string2 = string4.substring(0, 1);
                string3 = string4.substring(1, 2);
                string4 = string.substring(0, 1);
                string = string.substring(1, 2);
                object = new DESFireFile(n3, (DESFireFileTypekEnum)((Object)object2), (DESFireEncryptionTypekEnum)((Object)object), string4, string, string2, string3);
                if (object2 == DESFireFileTypekEnum.StandardDataFile || object2 == DESFireFileTypekEnum.BackupDataFile) {
                    byte[] byArray2 = new byte[4];
                    byArray2[0] = byArray[4];
                    byArray2[1] = byArray[5];
                    byArray2[2] = byArray[6];
                    object2 = byArray2;
                    int n4 = StringUtility.bytesToInt(byArray2);
                    object.setFileSize(n4);
                } else if (object2 == DESFireFileTypekEnum.ValueFile) {
                    byte[] byArray3 = new byte[]{byArray[4], byArray[5], byArray[6], byArray[7]};
                    object2 = byArray3;
                    int n5 = StringUtility.bytesToInt(byArray3);
                    byte[] byArray4 = new byte[]{byArray[8], byArray[9], byArray[10], byArray[11]};
                    object2 = byArray4;
                    int n6 = StringUtility.bytesToInt(byArray4);
                    object.setMaxValue(n6);
                    object.setMinValue(n5);
                }
            }
            arrayList.add((DESFireFile)object);
            ++n2;
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized byte[] DESFire_GetFileSetting(int fileNo) {
        void var1_1;
        byte[] byArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetFileSetting((int)var1_1);
        if (byArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_GetFileSetting() err:result==null");
            return null;
        }
        if (byArray[0] != 0) {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_GetFileSetting() err:" + byArray[0]));
            return null;
        }
        byte[] byArray2 = new byte[byArray[1]];
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = byArray[n + 2];
            Log.i((String)"RFIDWithISO1443A", (String)("DESFire_GetFileSetting() ids[i]=" + byArray2[n]));
            ++n;
        }
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_ChangeFileSetting(int fileNo, int commSet, char[] accessRights) {
        void var3_3;
        void var2_2;
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ChangeFileSetting(n, (int)var2_2, (char[])var3_3);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_ChangeFileSetting() err:" + n));
        return false;
    }

    public synchronized boolean DESFire_DelFile(int fileNo) {
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_DelFile(n);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_DelFile() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_AddStdFile(int fileNo, int commSet, char[] accessRight, int fileSize) {
        void var3_3;
        void var2_2;
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_AddStdFile(n, (int)var2_2, (char[])var3_3, fileSize);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_AddStdFile() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_WriteStdFile(int fileNo, int offSet, int dataSize, char[] dataBuf) {
        void var3_3;
        void var2_2;
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_WriteStdFile(n, (int)var2_2, (int)var3_3, dataBuf);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_WriteStdFile() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized char[] DESFire_ReadStdFile(int fileNo, int offSet, int dataSize) {
        void var3_4;
        void var2_3;
        void var1_1;
        char[] cArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_ReadStdFile((int)var1_1, (int)var2_3, (int)var3_4);
        if (cArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_ReadStdFile() err:result==null");
            return null;
        }
        if (cArray[0] != '\u0000') {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_ReadStdFile() err:" + Character.getNumericValue(cArray[0])));
            return null;
        }
        cArray = Arrays.copyOfRange(cArray, 2, cArray[1] + 2);
        return cArray;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_AddValueFile(int fileNo, int commSet, char[] accessRights, int minValue, int maxValue, int initValue) {
        void var3_3;
        void var2_2;
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_AddValueFile(n, (int)var2_2, (char[])var3_3, minValue, maxValue, initValue);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_AddValueFile() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int[] DESFire_ReadValueFile(int fileNo) {
        void var1_1;
        int[] nArray = this.getDeviceAPI().RF_ISO14443A_DESFIRE_GetValueFile((int)var1_1);
        if (nArray == null) {
            Log.e((String)"RFIDWithISO1443A", (String)"DESFire_ReadValueFile() err:result==null");
            return null;
        }
        if (nArray[0] != 0) {
            Log.e((String)"RFIDWithISO1443A", (String)("DESFire_ReadValueFile() err:" + Character.getNumericValue(nArray[0])));
            return null;
        }
        nArray = new int[]{nArray[2]};
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_CreditValueFile(int fileNo, int value) {
        void var2_2;
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_CreditValueFile(n, (int)var2_2);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_CreditValueFile() err:" + n));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean DESFire_DebitValueFile(int fileNo, int value) {
        void var2_2;
        int n;
        n = this.getDeviceAPI().RF_ISO14443A_DESFIRE_DebitValueFile(n, (int)var2_2);
        if (n == 0) {
            return true;
        }
        Log.e((String)"RFIDWithISO1443A", (String)("DESFire_DebitValueFile() err:" + n));
        return false;
    }

    public static /* bridge */ /* synthetic */ c getInstance() throws ConfigurationException {
        return RFIDWithISO14443A.getInstance();
    }

    public static enum DESFireEncryptionTypekEnum {
        Unknown(0),
        Transparent(1),
        DES(2);

        private final byte a;

        public final byte getValue() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        private DESFireEncryptionTypekEnum(byte value) {
            void var3_3;
            this.a = var3_3;
        }
    }

    public static enum DESFireFileTypekEnum {
        Unknown(0),
        StandardDataFile(1),
        BackupDataFile(2),
        ValueFile(3),
        LinearRecordFile(4),
        CyclicRecordFile(5);

        private final byte a;

        public final byte getValue() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        private DESFireFileTypekEnum(byte value) {
            void var3_3;
            this.a = var3_3;
        }
    }

    public static enum KeyType {
        TypeA,
        TypeB,
        TypeDes;

    }

    public static enum TagType {
        Ultra_light,
        S50,
        S70,
        Mifare_DESFire,
        Mifare_Pro,
        Mifare_ProX,
        Mifare_plus,
        Mifare_plus_4k,
        Mifare_plus_2k,
        Mifare_Mini,
        Unknow;

    }
}

