/*
 * Decompiled with CFR 0.152.
 */
package com.ab.activity;

import android.app.AlertDialog;
import android.app.Application;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Toast;
import com.ab.global.AbAppData;
import com.ab.util.AbStrUtil;
import com.ab.view.app.AbMonitorView;
import com.ab.view.ioc.AbIocSelect;
import com.ab.view.ioc.AbIocView;
import com.ab.view.listener.AbIocEventListener;
import com.ab.view.titlebar.AbBottomBar;
import com.ab.view.titlebar.AbTitleBar;
import java.lang.reflect.Field;

public abstract class AbActivity
extends FragmentActivity {
    private String TAG = AbActivity.class.getSimpleName();
    private boolean D = AbAppData.DEBUG;
    private String mProgressMessage = "\u8bf7\u7a0d\u5019...";
    public LayoutInflater mInflater;
    public ProgressDialog mProgressDialog;
    private Dialog mBottomDialog;
    private Dialog mCenterDialog;
    private Dialog mTopDialog;
    private View mBottomDialogView = null;
    private View mCenterDialogView = null;
    private View mTopDialogView = null;
    private int dialogPadding = 40;
    public Application abApplication = null;
    public SharedPreferences abSharedPreferences = null;
    public LinearLayout.LayoutParams layoutParamsFF = null;
    public LinearLayout.LayoutParams layoutParamsFW = null;
    public LinearLayout.LayoutParams layoutParamsWF = null;
    public LinearLayout.LayoutParams layoutParamsWW = null;
    public RelativeLayout ab_base = null;
    protected AbTitleBar mAbTitleBar = null;
    protected AbBottomBar mAbBottomBar = null;
    protected RelativeLayout contentLayout = null;
    public int diaplayWidth = 320;
    public int diaplayHeight = 480;
    private AbMonitorView mAbMonitorView = null;
    private Handler mMonitorHandler = new Handler();
    private Runnable mMonitorRunnable = null;
    private WindowManager mWindowManager = null;
    private WindowManager.LayoutParams mMonitorParams = null;
    private Handler baseHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AbActivity.this.showToast(msg.getData().getString("Msg"));
                    break;
                }
                case 1: {
                    AbActivity.this.showProgressDialog(AbActivity.this.mProgressMessage);
                    break;
                }
                case 2: {
                    AbActivity.this.removeProgressDialog();
                    break;
                }
                case 3: {
                    AbActivity.this.removeDialog(1);
                }
                case 4: {
                    AbActivity.this.removeDialog(2);
                }
                case 5: {
                    AbActivity.this.removeDialog(3);
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.mInflater = LayoutInflater.from((Context)this);
        this.mWindowManager = this.getWindowManager();
        Display display = this.mWindowManager.getDefaultDisplay();
        this.diaplayWidth = display.getWidth();
        this.diaplayHeight = display.getHeight();
        this.layoutParamsFF = new LinearLayout.LayoutParams(-1, -1);
        this.layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.layoutParamsWF = new LinearLayout.LayoutParams(-2, -1);
        this.layoutParamsWW = new LinearLayout.LayoutParams(-2, -2);
        this.mAbTitleBar = new AbTitleBar((Context)this);
        this.ab_base = new RelativeLayout((Context)this);
        this.ab_base.setBackgroundColor(Color.rgb((int)255, (int)255, (int)255));
        this.contentLayout = new RelativeLayout((Context)this);
        this.contentLayout.setPadding(0, 0, 0, 0);
        this.mAbBottomBar = new AbBottomBar((Context)this);
        this.ab_base.addView((View)this.mAbTitleBar, (ViewGroup.LayoutParams)this.layoutParamsFW);
        RelativeLayout.LayoutParams layoutParamsFW2 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParamsFW2.addRule(12, -1);
        this.ab_base.addView((View)this.mAbBottomBar, (ViewGroup.LayoutParams)layoutParamsFW2);
        RelativeLayout.LayoutParams layoutParamsFW1 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParamsFW1.addRule(3, this.mAbTitleBar.getId());
        layoutParamsFW1.addRule(2, this.mAbBottomBar.getId());
        this.ab_base.addView((View)this.contentLayout, (ViewGroup.LayoutParams)layoutParamsFW1);
        this.abApplication = this.getApplication();
        this.abSharedPreferences = this.getSharedPreferences("app_share", 0);
        this.setContentView((View)this.ab_base, (ViewGroup.LayoutParams)this.layoutParamsFF);
        if (this.diaplayWidth < 400) {
            this.dialogPadding = 30;
        } else if (this.diaplayWidth > 700) {
            this.dialogPadding = 50;
        }
    }

    public void showToast(String text) {
        Toast.makeText((Context)this, (CharSequence)text, (int)0).show();
    }

    public void showToast(int resId) {
        Toast.makeText((Context)this, (CharSequence)("" + this.getResources().getText(resId)), (int)0).show();
    }

    public void setAbContentView(View contentView) {
        this.contentLayout.removeAllViews();
        this.contentLayout.addView(contentView, (ViewGroup.LayoutParams)this.layoutParamsFF);
        AbActivity.initIocView(this);
    }

    public void setAbContentView(int resId) {
        this.setAbContentView(this.mInflater.inflate(resId, null));
    }

    public void showToastInThread(int resId) {
        Message msg = this.baseHandler.obtainMessage(0);
        Bundle bundle = new Bundle();
        bundle.putString("Msg", this.getResources().getString(resId));
        msg.setData(bundle);
        this.baseHandler.sendMessage(msg);
    }

    public void showToastInThread(String toast) {
        Message msg = this.baseHandler.obtainMessage(0);
        Bundle bundle = new Bundle();
        bundle.putString("Msg", toast);
        msg.setData(bundle);
        this.baseHandler.sendMessage(msg);
    }

    public void showProgressDialog() {
        this.showProgressDialog(null);
    }

    public void showProgressDialog(String message) {
        if (!AbStrUtil.isEmpty(message)) {
            this.mProgressMessage = message;
        }
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog((Context)this);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
        }
        this.mProgressDialog.setMessage((CharSequence)this.mProgressMessage);
        this.showDialog(0);
    }

    public void showDialog(int id, View view) {
        if (id == 1) {
            this.mBottomDialogView = view;
            if (this.mBottomDialog == null) {
                this.mBottomDialog = new Dialog((Context)this);
                this.setDialogLayoutParams(this.mBottomDialog, this.dialogPadding, 80);
            }
            this.mBottomDialog.setContentView(this.mBottomDialogView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.diaplayWidth - this.dialogPadding, -2));
            this.showDialog(id);
        } else if (id == 2) {
            this.mCenterDialogView = view;
            if (this.mCenterDialog == null) {
                this.mCenterDialog = new Dialog((Context)this);
                this.setDialogLayoutParams(this.mCenterDialog, this.dialogPadding, 17);
            }
            this.mCenterDialog.setContentView(this.mCenterDialogView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.diaplayWidth - this.dialogPadding, -2));
            this.showDialog(id);
        } else if (id == 3) {
            this.mTopDialogView = view;
            if (this.mTopDialog == null) {
                this.mTopDialog = new Dialog((Context)this);
                this.setDialogLayoutParams(this.mTopDialog, this.dialogPadding, 48);
            }
            this.mTopDialog.setContentView(this.mTopDialogView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.diaplayWidth - this.dialogPadding, -2));
            this.showDialog(id);
        } else {
            Log.i((String)this.TAG, (String)"Dialog\u7684ID\u4f20\u9519\u4e86\uff0c\u8bf7\u53c2\u8003AbConstant\u7c7b\u5b9a\u4e49");
        }
    }

    public void showDialog(String title, String msg, DialogInterface.OnClickListener mOkOnClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)msg);
        builder.setTitle((CharSequence)title);
        builder.setPositiveButton((CharSequence)"\u786e\u8ba4", mOkOnClickListener);
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public AlertDialog showDialog(String title, View view, DialogInterface.OnClickListener mOkOnClickListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)title);
        builder.setView(view);
        builder.setPositiveButton((CharSequence)"\u786e\u8ba4", mOkOnClickListener);
        builder.setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog mAlertDialog = builder.create();
        mAlertDialog.show();
        return mAlertDialog;
    }

    public AlertDialog showDialog(String title, String msg) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setMessage((CharSequence)msg);
        builder.setTitle((CharSequence)title);
        builder.create();
        AlertDialog mAlertDialog = builder.create();
        mAlertDialog.show();
        return mAlertDialog;
    }

    public AlertDialog showDialog(String title, View view) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)title);
        builder.setView(view);
        builder.create();
        AlertDialog mAlertDialog = builder.create();
        mAlertDialog.show();
        return mAlertDialog;
    }

    private void setDialogLayoutParams(Dialog dialog, int dialogPadding, int gravity) {
        dialog.requestWindowFeature(1);
        Window window = dialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        window.setGravity(gravity);
        lp.width = this.diaplayWidth - dialogPadding;
        lp.type = 1003;
        lp.alpha = 0.8f;
        lp.dimAmount = 0.0f;
        window.setAttributes(lp);
        window.setWindowAnimations(16973826);
        dialog.setCanceledOnTouchOutside(false);
    }

    protected Dialog onCreateDialog(int id) {
        this.closeMonitor();
        Dialog dialog = null;
        switch (id) {
            case 0: {
                if (this.mProgressDialog == null) {
                    Log.i((String)this.TAG, (String)"Dialog\u65b9\u6cd5\u8c03\u7528\u9519\u8bef,\u8bf7\u8c03\u7528showProgressDialog()!");
                }
                return this.mProgressDialog;
            }
            case 1: {
                if (this.mBottomDialog == null) {
                    Log.i((String)this.TAG, (String)"Dialog\u65b9\u6cd5\u8c03\u7528\u9519\u8bef,\u8bf7\u8c03\u7528showDialog(int id,View view)!");
                }
                return this.mBottomDialog;
            }
            case 2: {
                if (this.mCenterDialog == null) {
                    Log.i((String)this.TAG, (String)"Dialog\u65b9\u6cd5\u8c03\u7528\u9519\u8bef,\u8bf7\u8c03\u7528showDialog(int id,View view)!");
                }
                return this.mCenterDialog;
            }
            case 3: {
                if (this.mTopDialog == null) {
                    Log.i((String)this.TAG, (String)"Dialog\u65b9\u6cd5\u8c03\u7528\u9519\u8bef,\u8bf7\u8c03\u7528showDialog(int id,View view)!");
                }
                return this.mTopDialog;
            }
        }
        return dialog;
    }

    public void removeProgressDialog() {
        this.removeDialog(0);
    }

    public void removeDialogInThread(int id) {
        this.baseHandler.sendEmptyMessage(id);
    }

    public AbTitleBar getTitleBar() {
        return this.mAbTitleBar;
    }

    public AbBottomBar getAbBottomBar() {
        return this.mAbBottomBar;
    }

    public void openMonitor() {
        if (!AbAppData.mMonitorOpened) {
            if (this.mAbMonitorView == null) {
                this.mAbMonitorView = new AbMonitorView((Context)this);
                this.mMonitorParams = new WindowManager.LayoutParams();
                this.mMonitorParams.type = 2003;
                this.mMonitorParams.format = 1;
                this.mMonitorParams.flags = 40;
                this.mMonitorParams.width = 60;
                this.mMonitorParams.height = 30;
            }
            this.mWindowManager.addView((View)this.mAbMonitorView, (ViewGroup.LayoutParams)this.mMonitorParams);
            AbAppData.mMonitorOpened = true;
            this.mMonitorRunnable = new Runnable(){

                @Override
                public void run() {
                    AbActivity.this.mAbMonitorView.postInvalidate();
                    AbActivity.this.mMonitorHandler.postDelayed((Runnable)this, 0L);
                }
            };
            this.mMonitorHandler.postDelayed(this.mMonitorRunnable, 0L);
            this.mAbMonitorView.setOnTouchListener(new View.OnTouchListener(){
                int lastX;
                int lastY;
                int paramX;
                int paramY;

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: {
                            this.lastX = (int)event.getRawX();
                            this.lastY = (int)event.getRawY();
                            this.paramX = ((AbActivity)AbActivity.this).mMonitorParams.x;
                            this.paramY = ((AbActivity)AbActivity.this).mMonitorParams.y;
                            break;
                        }
                        case 2: {
                            int dx = (int)event.getRawX() - this.lastX;
                            int dy = (int)event.getRawY() - this.lastY;
                            ((AbActivity)AbActivity.this).mMonitorParams.x = this.paramX + dx > AbActivity.this.diaplayWidth / 2 ? AbActivity.this.diaplayWidth : 0;
                            ((AbActivity)AbActivity.this).mMonitorParams.x = this.paramX + dx;
                            ((AbActivity)AbActivity.this).mMonitorParams.y = this.paramY + dy;
                            AbActivity.this.mWindowManager.updateViewLayout((View)AbActivity.this.mAbMonitorView, (ViewGroup.LayoutParams)AbActivity.this.mMonitorParams);
                        }
                    }
                    return true;
                }
            });
        }
    }

    public void closeMonitor() {
        if (AbAppData.mMonitorOpened) {
            if (this.mAbMonitorView != null) {
                this.mWindowManager.removeView((View)this.mAbMonitorView);
            }
            AbAppData.mMonitorOpened = false;
            if (this.mMonitorHandler != null && this.mMonitorRunnable != null) {
                this.mMonitorHandler.removeCallbacks(this.mMonitorRunnable);
            }
        }
    }

    public void setDialogPadding(int dialogPadding) {
        this.dialogPadding = dialogPadding;
    }

    public String getProgressMessage() {
        return this.mProgressMessage;
    }

    public void setProgressMessage(String message) {
        this.mProgressMessage = message;
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
    }

    public void finish() {
        this.closeMonitor();
        super.finish();
    }

    public Dialog getBottomDialog() {
        return this.mBottomDialog;
    }

    public Dialog getCenterDialog() {
        return this.mCenterDialog;
    }

    public Dialog getTopDialog() {
        return this.mTopDialog;
    }

    public void setTitleBarAbove(boolean above) {
        this.ab_base.removeAllViews();
        if (above) {
            RelativeLayout.LayoutParams layoutParamsFW1 = new RelativeLayout.LayoutParams(-1, -2);
            layoutParamsFW1.addRule(2, this.mAbBottomBar.getId());
            this.ab_base.addView((View)this.contentLayout, (ViewGroup.LayoutParams)layoutParamsFW1);
            RelativeLayout.LayoutParams layoutParamsFW2 = new RelativeLayout.LayoutParams(-1, -2);
            layoutParamsFW2.addRule(10, -1);
            this.ab_base.addView((View)this.mAbTitleBar, (ViewGroup.LayoutParams)layoutParamsFW2);
            RelativeLayout.LayoutParams layoutParamsFW3 = new RelativeLayout.LayoutParams(-1, -2);
            layoutParamsFW3.addRule(12, -1);
            this.ab_base.addView((View)this.mAbBottomBar, (ViewGroup.LayoutParams)layoutParamsFW3);
        } else {
            this.ab_base.addView((View)this.mAbTitleBar, (ViewGroup.LayoutParams)this.layoutParamsFW);
            RelativeLayout.LayoutParams layoutParamsFW2 = new RelativeLayout.LayoutParams(-1, -2);
            layoutParamsFW2.addRule(12, -1);
            this.ab_base.addView((View)this.mAbBottomBar, (ViewGroup.LayoutParams)layoutParamsFW2);
            RelativeLayout.LayoutParams layoutParamsFW1 = new RelativeLayout.LayoutParams(-1, -2);
            layoutParamsFW1.addRule(3, this.mAbTitleBar.getId());
            layoutParamsFW1.addRule(2, this.mAbBottomBar.getId());
            this.ab_base.addView((View)this.contentLayout, (ViewGroup.LayoutParams)layoutParamsFW1);
        }
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        AbActivity.initIocView(this);
    }

    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        AbActivity.initIocView(this);
    }

    public void setContentView(View view) {
        super.setContentView(view);
        AbActivity.initIocView(this);
    }

    public static void initIocView(FragmentActivity activity) {
        AbActivity.initIocView(activity, activity.getWindow().getDecorView());
    }

    public static void initIocView(Object injectedSource, View sourceView) {
        Log.i((String)"AbActivity", (String)"initIocView()");
        Field[] fields = injectedSource.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                try {
                    AbIocView viewInject;
                    field.setAccessible(true);
                    if (field.get(injectedSource) == null && (viewInject = field.getAnnotation(AbIocView.class)) != null) {
                        int viewId = viewInject.id();
                        Log.i((String)"AbActivity", (String)"initIocView() 22222222");
                        field.set(injectedSource, sourceView.findViewById(viewId));
                        AbActivity.setListener(injectedSource, field, viewInject.click(), Method.Click);
                        AbActivity.setListener(injectedSource, field, viewInject.longClick(), Method.LongClick);
                        AbActivity.setListener(injectedSource, field, viewInject.itemClick(), Method.ItemClick);
                        AbActivity.setListener(injectedSource, field, viewInject.itemLongClick(), Method.itemLongClick);
                        AbIocSelect select = viewInject.select();
                        if (!TextUtils.isEmpty((CharSequence)select.selected())) {
                            AbActivity.setViewSelectListener(injectedSource, field, select.selected(), select.noSelected());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private static void setViewSelectListener(Object injectedSource, Field field, String select, String noSelect) throws Exception {
        Object obj = field.get(injectedSource);
        if (obj instanceof View) {
            ((AbsListView)obj).setOnItemSelectedListener((AdapterView.OnItemSelectedListener)new AbIocEventListener(injectedSource).select(select).noSelect(noSelect));
        }
    }

    private static void setListener(Object injectedSource, Field field, String methodName, Method method) throws Exception {
        if (methodName == null || methodName.trim().length() == 0) {
            return;
        }
        Object obj = field.get(injectedSource);
        switch (method) {
            case Click: {
                if (!(obj instanceof View)) break;
                ((View)obj).setOnClickListener((View.OnClickListener)new AbIocEventListener(injectedSource).click(methodName));
                break;
            }
            case ItemClick: {
                if (!(obj instanceof AbsListView)) break;
                ((AbsListView)obj).setOnItemClickListener((AdapterView.OnItemClickListener)new AbIocEventListener(injectedSource).itemClick(methodName));
                break;
            }
            case LongClick: {
                if (!(obj instanceof View)) break;
                ((View)obj).setOnLongClickListener((View.OnLongClickListener)new AbIocEventListener(injectedSource).longClick(methodName));
                break;
            }
            case itemLongClick: {
                if (!(obj instanceof AbsListView)) break;
                ((AbsListView)obj).setOnItemLongClickListener((AdapterView.OnItemLongClickListener)new AbIocEventListener(injectedSource).itemLongClick(methodName));
                break;
            }
        }
    }

    public static enum Method {
        Click,
        LongClick,
        ItemClick,
        itemLongClick;

    }
}

