/*
 * Decompiled with CFR 0.152.
 */
package com.ab.bitmap;

import com.ab.global.AbAppData;
import com.ab.util.AbFileUtil;
import com.ab.util.AbStrUtil;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;

public class AbFileCache {
    private static String TAG = "AbFileCache";
    private static final boolean D = AbAppData.DEBUG;
    public static int maxCacheSize = 0xA00000;
    public static int cacheSize = 0;
    private static final HashMap<String, File> fileCache = new HashMap();
    public static final ReentrantLock lock = new ReentrantLock();

    static {
        AbFileUtil.initFileCache();
    }

    public static File getFileFromCache(String name) {
        return fileCache.get(name);
    }

    public static void addFileToCache(String name, File file) {
        try {
            lock.lock();
            if (AbStrUtil.isEmpty(name)) {
                return;
            }
            try {
                if (AbFileCache.getFileFromCache(name) == null && file != null) {
                    fileCache.put(name, file);
                }
                if (cacheSize > maxCacheSize) {
                    AbFileUtil.freeCacheFiles();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeFileFromCache(String name) {
        try {
            try {
                lock.lock();
                if (AbFileCache.getFileFromCache(name) != null) {
                    fileCache.remove(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                lock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeAllFileFromCache() {
        AbFileUtil.removeAllFileCache();
        fileCache.clear();
    }

    public static void setMaxCacheSize(int cacheSize) {
        maxCacheSize = cacheSize;
    }

    public static int getCacheSize() {
        return cacheSize;
    }
}

