/*
 * Decompiled with CFR 0.152.
 */
package com.ab.bitmap;

import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import android.util.Log;
import com.ab.global.AbAppData;
import com.ab.util.AbMd5;
import com.ab.util.AbStrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class AbImageCache {
    private static String TAG = "AbImageCache";
    private static final boolean D = AbAppData.DEBUG;
    public static int cacheSize = 0x800000;
    private static final LruCache<String, Bitmap> bitmapCache = new LruCache<String, Bitmap>(cacheSize){

        protected int sizeOf(String key, Bitmap bitmap) {
            return bitmap.getRowBytes() * bitmap.getHeight();
        }

        protected void entryRemoved(boolean evicted, String key, Bitmap oldValue, Bitmap newValue) {
            if (D) {
                Log.d((String)TAG, (String)("LruCache:\u79fb\u9664\u4e86" + key));
            }
        }
    };
    private static final HashMap<String, Runnable> runRunnableCache = new HashMap();
    private static final List<HashMap<String, Runnable>> waitRunnableList = new ArrayList<HashMap<String, Runnable>>();
    public static final ReentrantLock lock = new ReentrantLock();

    public static Bitmap getBitmapFromCache(String key) {
        return (Bitmap)bitmapCache.get((Object)key);
    }

    public static void addBitmapToCache(String key, Bitmap bitmap) {
        try {
            if (D) {
                Log.d((String)TAG, (String)("\u56fe\u7247\u4e0b\u8f7d\u5b8c\u6210:" + key));
            }
            lock.lock();
            if (AbStrUtil.isEmpty(key)) {
                return;
            }
            try {
                if (AbImageCache.getBitmapFromCache(key) == null && bitmap != null) {
                    bitmapCache.put((Object)key, (Object)bitmap);
                    if (D) {
                        Log.d((String)TAG, (String)("\u5b58\u5165\u7f13\u5b58:" + key + "," + bitmap));
                    }
                    if (D) {
                        Log.d((String)TAG, (String)("\u6d4b\u8bd5\u5b58\u5165\u7f13\u5b58\u662f\u5426\u6210\u529f:" + key + "," + AbImageCache.getBitmapFromCache(key)));
                    }
                }
                AbImageCache.removeRunRunnableFromCache(key);
                if (D) {
                    Log.d((String)TAG, (String)("\u68c0\u67e5\u6302\u8d77\u7ebf\u7a0b:" + waitRunnableList.size()));
                }
                AbImageCache.removeWaitRunnableFromCache(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeBitmapFromCache(String key) {
        try {
            try {
                lock.lock();
                if (AbImageCache.getBitmapFromCache(key) != null) {
                    bitmapCache.remove((Object)key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                lock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeAllBitmapFromCache() {
        bitmapCache.evictAll();
    }

    public static String getCacheKey(String url, int width, int height, int type) {
        return AbMd5.MD5(new StringBuilder(url.length() + 12).append("#W").append(width).append("#H").append(height).append("#T").append(type).append(url).toString());
    }

    public static Runnable getRunRunnableFromCache(String key) {
        return runRunnableCache.get(key);
    }

    public static void addToRunRunnableCache(String key, Runnable runnable) {
        try {
            lock.lock();
            if (AbStrUtil.isEmpty(key) || runnable == null) {
                return;
            }
            try {
                if (AbImageCache.getRunRunnableFromCache(key) == null) {
                    runRunnableCache.put(key, runnable);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void removeRunRunnableFromCache(String key) {
        if (AbImageCache.getRunRunnableFromCache(key) != null) {
            runRunnableCache.remove(key);
        }
    }

    public static Runnable getWaitRunnableFromCache(String key) {
        return runRunnableCache.get(key);
    }

    public static void addToWaitRunnableCache(String key, Runnable runnable) {
        try {
            lock.lock();
            if (AbStrUtil.isEmpty(key) || runnable == null) {
                return;
            }
            try {
                HashMap<String, Runnable> runnableMap = new HashMap<String, Runnable>();
                runnableMap.put(key, runnable);
                waitRunnableList.add(runnableMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeWaitRunnableFromCache(String key) {
        try {
            try {
                lock.lock();
                int i = 0;
                while (i < waitRunnableList.size()) {
                    HashMap<String, Runnable> runnableMap = waitRunnableList.get(i);
                    Runnable runnable = runnableMap.get(key);
                    if (runnable != null) {
                        if (D) {
                            Log.d((String)TAG, (String)("\u4ece\u7f13\u5b58\u5220\u9664\u5e76\u5524\u9192:" + runnable));
                        }
                        Runnable runnable2 = runnable;
                        synchronized (runnable2) {
                            runnable.notify();
                        }
                        waitRunnableList.remove(runnableMap);
                        --i;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                lock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }
}

