/*
 * Decompiled with CFR 0.152.
 */
package com.ab.bitmap;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ab.bitmap.AbImageCache;
import com.ab.bitmap.AbImageDownloadItem;
import com.ab.global.AbAppData;
import com.ab.util.AbAppUtil;
import com.ab.util.AbFileUtil;
import com.ab.util.AbStrUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AbImageDownloadPool {
    private static String TAG = "AbImageDownloadPool";
    private static final boolean D = AbAppData.DEBUG;
    private static AbImageDownloadPool imageDownload = null;
    private static int nThreads = 3;
    private ExecutorService executorService = null;
    private static Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            AbImageDownloadItem item = (AbImageDownloadItem)msg.obj;
            item.listener.update(item.bitmap, item.imageUrl);
        }
    };

    protected AbImageDownloadPool(int nThreads) {
        this.executorService = Executors.newFixedThreadPool(nThreads);
    }

    public static AbImageDownloadPool getInstance() {
        if (imageDownload == null) {
            nThreads = AbAppUtil.getNumCores();
            imageDownload = new AbImageDownloadPool(nThreads * 3);
        }
        return imageDownload;
    }

    public void download(final AbImageDownloadItem item) {
        String imageUrl = item.imageUrl;
        if (AbStrUtil.isEmpty(imageUrl)) {
            if (D) {
                Log.d((String)TAG, (String)"\u56fe\u7247URL\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5224\u65ad");
            }
        } else {
            imageUrl = imageUrl.trim();
        }
        final String cacheKey = AbImageCache.getCacheKey(imageUrl, item.width, item.height, item.type);
        item.bitmap = AbImageCache.getBitmapFromCache(cacheKey);
        if (item.bitmap == null) {
            this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block16: {
                        block15: {
                            try {
                                try {
                                    Runnable runnable = AbImageCache.getRunRunnableFromCache(cacheKey);
                                    if (runnable != null) {
                                        if (D) {
                                            Log.d((String)TAG, (String)("\u7b49\u5f85:" + cacheKey + "," + item.imageUrl));
                                        }
                                        AbImageCache.addToWaitRunnableCache(cacheKey, this);
                                        2 var2_3 = this;
                                        synchronized (var2_3) {
                                            this.wait();
                                        }
                                        if (D) {
                                            Log.d((String)TAG, (String)("\u6211\u9192\u4e86:" + item.imageUrl));
                                        }
                                        item.bitmap = AbImageCache.getBitmapFromCache(cacheKey);
                                        break block15;
                                    }
                                    if (D) {
                                        Log.d((String)TAG, (String)("\u589e\u52a0\u56fe\u7247\u4e0b\u8f7d\u4e2d:" + cacheKey + "," + item.imageUrl));
                                    }
                                    AbImageCache.addToRunRunnableCache(cacheKey, this);
                                    item.bitmap = AbFileUtil.getBitmapFromSDCache(item.imageUrl, item.type, item.width, item.height);
                                    AbImageCache.addBitmapToCache(cacheKey, item.bitmap);
                                }
                                catch (Exception e) {
                                    if (D) {
                                        Log.d((String)TAG, (String)("error:" + item.imageUrl));
                                    }
                                    e.printStackTrace();
                                    if (item.listener != null) {
                                        Message msg = handler.obtainMessage();
                                        msg.obj = item;
                                        handler.sendMessage(msg);
                                    }
                                    break block16;
                                }
                            }
                            catch (Throwable throwable) {
                                if (item.listener != null) {
                                    Message msg = handler.obtainMessage();
                                    msg.obj = item;
                                    handler.sendMessage(msg);
                                }
                                throw throwable;
                            }
                        }
                        if (item.listener != null) {
                            Message msg = handler.obtainMessage();
                            msg.obj = item;
                            handler.sendMessage(msg);
                        }
                    }
                }
            });
        } else {
            if (D) {
                Log.d((String)TAG, (String)("\u4ece\u5185\u5b58\u7f13\u5b58\u4e2d\u5f97\u5230\u56fe\u7247:" + cacheKey + "," + item.bitmap));
            }
            if (item.listener != null) {
                Message msg = handler.obtainMessage();
                msg.obj = item;
                handler.sendMessage(msg);
            }
        }
    }

    public void shutdownNow() {
        if (!this.executorService.isTerminated()) {
            this.executorService.shutdownNow();
            this.listenShutdown();
        }
    }

    public void shutdown() {
        if (!this.executorService.isTerminated()) {
            this.executorService.shutdown();
            this.listenShutdown();
        }
    }

    public void listenShutdown() {
        try {
            while (!this.executorService.awaitTermination(1L, TimeUnit.MILLISECONDS)) {
                if (!D) continue;
                Log.d((String)TAG, (String)"\u7ebf\u7a0b\u6c60\u672a\u5173\u95ed");
            }
            if (D) {
                Log.d((String)TAG, (String)"\u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

