/*
 * Decompiled with CFR 0.152.
 */
package com.ab.bitmap;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ab.bitmap.AbImageCache;
import com.ab.bitmap.AbImageDownloadItem;
import com.ab.global.AbAppData;
import com.ab.util.AbFileUtil;
import com.ab.util.AbStrUtil;
import java.util.ArrayList;
import java.util.List;

public class AbImageDownloadQueue
extends Thread {
    private static String TAG = "AbImageDownloadQueue";
    private static final boolean D = AbAppData.DEBUG;
    private List<AbImageDownloadItem> queue;
    private static AbImageDownloadQueue imageDownloadThread = null;
    private static boolean stop = false;
    private static Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            AbImageDownloadItem item = (AbImageDownloadItem)msg.obj;
            item.listener.update(item.bitmap, item.imageUrl);
        }
    };

    private AbImageDownloadQueue() {
        stop = false;
        this.queue = new ArrayList<AbImageDownloadItem>();
    }

    public static AbImageDownloadQueue getInstance() {
        if (imageDownloadThread == null) {
            imageDownloadThread = new AbImageDownloadQueue();
            imageDownloadThread.setName("AbImageDownloadQueue-1");
            imageDownloadThread.start();
        }
        return imageDownloadThread;
    }

    public void download(AbImageDownloadItem item) {
        String imageUrl = item.imageUrl;
        if (AbStrUtil.isEmpty(imageUrl)) {
            if (D) {
                Log.d((String)TAG, (String)"\u56fe\u7247URL\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5224\u65ad");
            }
        } else {
            imageUrl = imageUrl.trim();
        }
        String cacheKey = AbImageCache.getCacheKey(imageUrl, item.width, item.height, item.type);
        item.bitmap = AbImageCache.getBitmapFromCache(cacheKey);
        if (item.bitmap == null) {
            this.addDownloadItem(item);
        } else {
            if (D) {
                Log.d((String)TAG, (String)("\u4ece\u5185\u5b58\u7f13\u5b58\u4e2d\u5f97\u5230\u56fe\u7247:" + cacheKey + "," + item.bitmap));
            }
            if (item.listener != null) {
                Message msg = handler.obtainMessage();
                msg.obj = item;
                handler.sendMessage(msg);
            }
        }
    }

    private synchronized void addDownloadItem(AbImageDownloadItem item) {
        this.queue.add(item);
        this.notify();
    }

    public void downloadBeforeClean(AbImageDownloadItem item) {
        this.queue.clear();
        this.addDownloadItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!stop) {
            try {
                Object item;
                if (D) {
                    Log.d((String)TAG, (String)("\u56fe\u7247\u4e0b\u8f7d\u961f\u5217\u5927\u5c0f\uff1a" + this.queue.size()));
                }
                while (this.queue.size() > 0) {
                    item = this.queue.remove(0);
                    String cacheKey = AbImageCache.getCacheKey(((AbImageDownloadItem)item).imageUrl, ((AbImageDownloadItem)item).width, ((AbImageDownloadItem)item).height, ((AbImageDownloadItem)item).type);
                    Runnable runnable = AbImageCache.getRunRunnableFromCache(cacheKey);
                    if (runnable != null) {
                        if (D) {
                            Log.d((String)TAG, (String)("\u7b49\u5f85:" + cacheKey + "," + ((AbImageDownloadItem)item).imageUrl));
                        }
                        AbImageCache.addToWaitRunnableCache(cacheKey, this);
                        AbImageDownloadQueue abImageDownloadQueue = this;
                        synchronized (abImageDownloadQueue) {
                            this.wait();
                        }
                        if (D) {
                            Log.d((String)TAG, (String)("\u6211\u9192\u4e86:" + ((AbImageDownloadItem)item).imageUrl));
                        }
                        ((AbImageDownloadItem)item).bitmap = AbImageCache.getBitmapFromCache(cacheKey);
                    } else {
                        if (D) {
                            Log.d((String)TAG, (String)("\u589e\u52a0\u56fe\u7247\u4e0b\u8f7d\u4e2d:" + cacheKey + "," + ((AbImageDownloadItem)item).imageUrl));
                        }
                        AbImageCache.addToRunRunnableCache(cacheKey, this);
                        ((AbImageDownloadItem)item).bitmap = AbFileUtil.getBitmapFromSDCache(((AbImageDownloadItem)item).imageUrl, ((AbImageDownloadItem)item).type, ((AbImageDownloadItem)item).width, ((AbImageDownloadItem)item).height);
                        AbImageCache.addBitmapToCache(cacheKey, ((AbImageDownloadItem)item).bitmap);
                    }
                    if (((AbImageDownloadItem)item).listener == null) continue;
                    Message msg = handler.obtainMessage();
                    msg.obj = item;
                    handler.sendMessage(msg);
                }
                if (stop) {
                    this.queue.clear();
                    return;
                }
                item = this;
                synchronized (item) {
                    this.wait();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopQueue() {
        try {
            stop = true;
            imageDownloadThread = null;
            this.interrupt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

