/*
 * Decompiled with CFR 0.152.
 */
package com.ab.bitmap;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ab.bitmap.AbImageCache;
import com.ab.bitmap.AbImageDownloadItem;
import com.ab.global.AbAppData;
import com.ab.util.AbFileUtil;
import com.ab.util.AbStrUtil;

public class AbImageDownloadTask
extends AsyncTask<AbImageDownloadItem, Integer, AbImageDownloadItem> {
    private static String TAG = "AbImageDownloadTask";
    private static final boolean D = AbAppData.DEBUG;
    private static Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            AbImageDownloadItem item = (AbImageDownloadItem)msg.obj;
            item.listener.update(item.bitmap, item.imageUrl);
        }
    };

    protected AbImageDownloadItem doInBackground(AbImageDownloadItem ... items) {
        AbImageDownloadItem item = items[0];
        String url = item.imageUrl;
        if (AbStrUtil.isEmpty(url)) {
            if (D) {
                Log.d((String)TAG, (String)"\u56fe\u7247URL\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5224\u65ad");
            }
        } else {
            url = url.trim();
        }
        String cacheKey = AbImageCache.getCacheKey(url, item.width, item.height, item.type);
        item.bitmap = AbImageCache.getBitmapFromCache(cacheKey);
        if (item.bitmap == null) {
            item.bitmap = AbFileUtil.getBitmapFromSDCache(item.imageUrl, item.type, item.width, item.height);
            AbImageCache.addBitmapToCache(cacheKey, item.bitmap);
            if (item.listener != null) {
                Message msg = handler.obtainMessage();
                msg.obj = item;
                handler.sendMessage(msg);
            }
        } else {
            if (D) {
                Log.d((String)TAG, (String)("\u4ece\u5185\u5b58\u7f13\u5b58\u4e2d\u5f97\u5230\u56fe\u7247:" + cacheKey + "," + item.bitmap));
            }
            if (item.listener != null) {
                Message msg = handler.obtainMessage();
                msg.obj = item;
                handler.sendMessage(msg);
            }
        }
        return item;
    }

    protected void onCancelled() {
        super.onCancelled();
    }

    protected void onPostExecute(AbImageDownloadItem item) {
        if (item.listener != null) {
            item.listener.update(item.bitmap, item.imageUrl);
        }
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
    }
}

