/*
 * Decompiled with CFR 0.152.
 */
package com.ab.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.view.View;
import android.widget.ImageView;
import com.ab.bitmap.AbImageCache;
import com.ab.bitmap.AbImageDownloadItem;
import com.ab.bitmap.AbImageDownloadListener;
import com.ab.bitmap.AbImageDownloadPool;
import com.ab.global.AbAppData;
import com.ab.util.AbImageUtil;
import com.ab.util.AbStrUtil;

public class AbImageDownloader {
    private static String TAG = "AbImageDownloader";
    private static final boolean D = AbAppData.DEBUG;
    private static Context context = null;
    private int width;
    private int height;
    private int type = 2;
    private Drawable loadingImage;
    private View loadingView;
    private Drawable errorImage;
    private Drawable noImage;
    private AbImageDownloadPool mAbImageDownloadPool = null;
    private boolean animation;

    public AbImageDownloader(Context context) {
        AbImageDownloader.context = context;
        this.mAbImageDownloadPool = AbImageDownloadPool.getInstance();
    }

    public void display(final ImageView imageView, String url) {
        if (AbStrUtil.isEmpty(url)) {
            if (this.noImage != null) {
                if (this.loadingView != null) {
                    this.loadingView.setVisibility(4);
                    imageView.setVisibility(0);
                }
                imageView.setImageDrawable(this.noImage);
            }
            return;
        }
        AbImageDownloadItem item = new AbImageDownloadItem();
        item.width = this.width;
        item.height = this.height;
        item.type = this.type;
        item.imageUrl = url;
        String cacheKey = AbImageCache.getCacheKey(item.imageUrl, item.width, item.height, item.type);
        item.bitmap = AbImageCache.getBitmapFromCache(cacheKey);
        if (item.bitmap == null) {
            if (this.loadingView != null) {
                this.loadingView.setVisibility(0);
                imageView.setVisibility(4);
            } else if (this.loadingImage != null) {
                if (this.animation) {
                    TransitionDrawable td = AbImageUtil.drawableToTransitionDrawable(this.loadingImage);
                    imageView.setImageDrawable((Drawable)td);
                    td.startTransition(200);
                } else {
                    imageView.setImageDrawable(this.loadingImage);
                }
            }
            item.listener = new AbImageDownloadListener(){

                @Override
                public void update(Bitmap bitmap, String imageUrl) {
                    if (AbImageDownloader.this.loadingView != null) {
                        AbImageDownloader.this.loadingView.setVisibility(4);
                        imageView.setVisibility(0);
                    }
                    if (bitmap != null) {
                        if (AbImageDownloader.this.animation) {
                            TransitionDrawable td = AbImageUtil.bitmapToTransitionDrawable(bitmap);
                            imageView.setImageDrawable((Drawable)td);
                            td.startTransition(200);
                        } else {
                            imageView.setImageBitmap(bitmap);
                        }
                    } else if (AbImageDownloader.this.errorImage != null) {
                        if (AbImageDownloader.this.animation) {
                            TransitionDrawable td = AbImageUtil.drawableToTransitionDrawable(AbImageDownloader.this.errorImage);
                            imageView.setImageDrawable((Drawable)td);
                            td.startTransition(200);
                        } else {
                            imageView.setImageDrawable(AbImageDownloader.this.errorImage);
                        }
                    }
                }
            };
            this.mAbImageDownloadPool.download(item);
        } else {
            if (this.loadingView != null) {
                this.loadingView.setVisibility(4);
                imageView.setVisibility(0);
            }
            imageView.setImageBitmap(item.bitmap);
        }
    }

    public void setLoadingImage(int resID) {
        this.loadingImage = context.getResources().getDrawable(resID);
    }

    public void setLoadingView(View view) {
        this.loadingView = view;
    }

    public void setErrorImage(int resID) {
        this.errorImage = context.getResources().getDrawable(resID);
    }

    public void setNoImage(int resID) {
        this.noImage = context.getResources().getDrawable(resID);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setAnimation(boolean animation) {
        this.animation = animation;
    }
}

