/*
 * Decompiled with CFR 0.152.
 */
package com.ab.db.orm;

import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.ab.db.orm.annotation.Column;
import com.ab.db.orm.annotation.Id;
import com.ab.db.orm.annotation.Relations;
import com.ab.db.orm.annotation.Table;
import com.ab.util.AbStrUtil;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class AbTableHelper {
    private static final String TAG = "AbTableHelper";

    public static <T> void createTablesByClasses(SQLiteDatabase db, Class<?>[] clazzs) {
        Class<?>[] classArray = clazzs;
        int n = clazzs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            AbTableHelper.createTable(db, clazz);
            ++n2;
        }
    }

    public static <T> void dropTablesByClasses(SQLiteDatabase db, Class<?>[] clazzs) {
        Class<?>[] classArray = clazzs;
        int n = clazzs.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            AbTableHelper.dropTable(db, clazz);
            ++n2;
        }
    }

    public static <T> void createTable(SQLiteDatabase db, Class<T> clazz) {
        String tableName = "";
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            tableName = table.name();
        }
        if (AbStrUtil.isEmpty(tableName)) {
            Log.d((String)TAG, (String)("\u60f3\u8981\u6620\u5c04\u7684\u5b9e\u4f53[" + clazz.getName() + "],\u672a\u6ce8\u89e3@Table(name=\"?\"),\u88ab\u8df3\u8fc7"));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(tableName).append(" (");
        List<Field> allFields = AbTableHelper.joinFieldsOnlyColumn(clazz.getDeclaredFields(), clazz.getSuperclass().getDeclaredFields());
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            Column column = field.getAnnotation(Column.class);
            String columnType = "";
            columnType = column.type().equals("") ? AbTableHelper.getColumnType(field.getType()) : column.type();
            sb.append(String.valueOf(column.name()) + " " + columnType);
            if (column.length() != 0) {
                sb.append("(" + column.length() + ")");
            }
            if (field.isAnnotationPresent(Id.class) && (field.getType() == Integer.TYPE || field.getType() == Integer.class)) {
                sb.append(" primary key autoincrement");
            } else if (field.isAnnotationPresent(Id.class)) {
                sb.append(" primary key");
            }
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        sb.append(")");
        String sql = sb.toString();
        Log.d((String)TAG, (String)("create table [" + tableName + "]: " + sql));
        db.execSQL(sql);
    }

    public static <T> void dropTable(SQLiteDatabase db, Class<T> clazz) {
        String tableName = "";
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            tableName = table.name();
        }
        String sql = "DROP TABLE IF EXISTS " + tableName;
        Log.d((String)TAG, (String)("dropTable[" + tableName + "]:" + sql));
        db.execSQL(sql);
    }

    private static String getColumnType(Class<?> fieldType) {
        if (String.class == fieldType) {
            return "TEXT";
        }
        if (Integer.TYPE == fieldType || Integer.class == fieldType) {
            return "INTEGER";
        }
        if (Long.TYPE == fieldType || Long.class == fieldType) {
            return "BIGINT";
        }
        if (Float.TYPE == fieldType || Float.class == fieldType) {
            return "FLOAT";
        }
        if (Short.TYPE == fieldType || Short.class == fieldType) {
            return "INT";
        }
        if (Double.TYPE == fieldType || Double.class == fieldType) {
            return "DOUBLE";
        }
        if (Blob.class == fieldType) {
            return "BLOB";
        }
        return "TEXT";
    }

    public static List<Field> joinFieldsOnlyColumn(Field[] fields1, Field[] fields2) {
        Column column;
        Field field;
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        Field[] fieldArray = fields1;
        int n = fields1.length;
        int n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
                map.put(column.name(), field);
            }
            ++n2;
        }
        fieldArray = fields2;
        n = fields2.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            if (field.isAnnotationPresent(Column.class) && !map.containsKey((column = field.getAnnotation(Column.class)).name())) {
                map.put(column.name(), field);
            }
            ++n2;
        }
        ArrayList<Field> list = new ArrayList<Field>();
        for (String key : map.keySet()) {
            Field tempField = (Field)map.get(key);
            if (tempField.isAnnotationPresent(Id.class)) {
                list.add(0, tempField);
                continue;
            }
            list.add(tempField);
        }
        return list;
    }

    public static List<Field> joinFields(Field[] fields1, Field[] fields2) {
        Relations relations;
        Column column;
        Field field;
        LinkedHashMap<String, Field> map = new LinkedHashMap<String, Field>();
        Field[] fieldArray = fields1;
        int n = fields1.length;
        int n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
                map.put(column.name(), field);
            } else if (field.isAnnotationPresent(Relations.class)) {
                relations = field.getAnnotation(Relations.class);
                map.put(relations.name(), field);
            }
            ++n2;
        }
        fieldArray = fields2;
        n = fields2.length;
        n2 = 0;
        while (n2 < n) {
            field = fieldArray[n2];
            if (field.isAnnotationPresent(Column.class)) {
                column = field.getAnnotation(Column.class);
                if (!map.containsKey(column.name())) {
                    map.put(column.name(), field);
                }
            } else if (field.isAnnotationPresent(Relations.class) && !map.containsKey((relations = field.getAnnotation(Relations.class)).name())) {
                map.put(relations.name(), field);
            }
            ++n2;
        }
        ArrayList<Field> list = new ArrayList<Field>();
        for (String key : map.keySet()) {
            Field tempField = (Field)map.get(key);
            if (tempField.isAnnotationPresent(Id.class)) {
                list.add(0, tempField);
                continue;
            }
            list.add(tempField);
        }
        return list;
    }
}

