/*
 * Decompiled with CFR 0.152.
 */
package com.ab.db.storage;

import android.content.Context;
import com.ab.db.orm.dao.AbDBDaoImpl;
import com.ab.db.storage.AbSqliteStorageListener;
import com.ab.db.storage.AbStorageQuery;
import com.ab.task.AbTaskItem;
import com.ab.task.AbTaskListListener;
import com.ab.task.AbTaskListener;
import com.ab.task.AbTaskQueue;
import java.util.List;

public class AbSqliteStorage {
    private static Context mContext;
    private static AbSqliteStorage mSqliteStorage;
    private static AbTaskQueue mAbTaskQueue;
    private int errorCode100 = 100;
    private String errorMessage100 = "\u53c2\u6570\u9519\u8bef";
    private int errorCode101 = 101;
    private String errorMessage101 = "\u6267\u884c\u65f6\u9519\u8bef";
    private long retValue = -1L;

    static {
        mSqliteStorage = null;
        mAbTaskQueue = null;
    }

    public static AbSqliteStorage getInstance(Context context) {
        mContext = context;
        if (mSqliteStorage == null) {
            mSqliteStorage = new AbSqliteStorage(context);
        }
        mAbTaskQueue = AbTaskQueue.getInstance();
        return mSqliteStorage;
    }

    private AbSqliteStorage(Context context) {
    }

    public <T> void insertData(final T entity, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataInsertListener paramDataInsertListener) {
        if (entity != null) {
            AbTaskItem item = new AbTaskItem();
            item.listener = new AbTaskListener(){

                @Override
                public void update() {
                    if (AbSqliteStorage.this.retValue >= 0L) {
                        if (paramDataInsertListener != null) {
                            paramDataInsertListener.onSuccess(AbSqliteStorage.this.retValue);
                        }
                    } else if (paramDataInsertListener != null) {
                        paramDataInsertListener.onFailure(AbSqliteStorage.this.errorCode101, AbSqliteStorage.this.errorMessage101);
                    }
                }

                @Override
                public void get() {
                    dao.startWritableDatabase(false);
                    AbSqliteStorage.this.retValue = dao.insert(entity);
                    dao.closeDatabase(false);
                }
            };
            mAbTaskQueue.execute(item);
        } else if (paramDataInsertListener != null) {
            paramDataInsertListener.onFailure(this.errorCode100, this.errorMessage100);
        }
    }

    public <T> void insertData(final List<T> entityList, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataInsertListener paramDataInsertListener) {
        if (entityList != null) {
            AbTaskItem item = new AbTaskItem();
            item.listener = new AbTaskListener(){

                @Override
                public void update() {
                    if (AbSqliteStorage.this.retValue >= 0L) {
                        if (paramDataInsertListener != null) {
                            paramDataInsertListener.onSuccess(AbSqliteStorage.this.retValue);
                        }
                    } else if (paramDataInsertListener != null) {
                        paramDataInsertListener.onFailure(AbSqliteStorage.this.errorCode101, AbSqliteStorage.this.errorMessage101);
                    }
                }

                @Override
                public void get() {
                    dao.startWritableDatabase(false);
                    AbSqliteStorage.this.retValue = dao.insertList(entityList);
                    dao.closeDatabase(false);
                }
            };
            mAbTaskQueue.execute(item);
        } else if (paramDataInsertListener != null) {
            paramDataInsertListener.onFailure(this.errorCode100, this.errorMessage100);
        }
    }

    public <T> void findData(final AbStorageQuery storageQuery, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataInfoListener paramDataInsertListener) {
        final AbTaskItem item = new AbTaskItem();
        item.listener = new AbTaskListListener(){

            @Override
            public void update(List<?> paramList) {
                if (paramDataInsertListener != null) {
                    paramDataInsertListener.onSuccess(paramList);
                }
            }

            @Override
            public void get() {
                List list = null;
                dao.startReadableDatabase(false);
                list = storageQuery.getLimit() != -1 && storageQuery.getOffset() != -1 ? dao.queryList(null, storageQuery.getWhereClause(), storageQuery.getWhereArgs(), storageQuery.getGroupBy(), storageQuery.getHaving(), String.valueOf(storageQuery.getOrderBy()) + " limit " + storageQuery.getLimit() + " offset " + storageQuery.getOffset(), null) : dao.queryList(null, storageQuery.getWhereClause(), storageQuery.getWhereArgs(), storageQuery.getGroupBy(), storageQuery.getHaving(), storageQuery.getOrderBy(), null);
                dao.closeDatabase(false);
                item.setResult(list);
            }
        };
        mAbTaskQueue.execute(item);
    }

    public <T> void updateData(final T entity, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataOperationListener paramDataInsertListener) {
        if (entity != null) {
            AbTaskItem item = new AbTaskItem();
            item.listener = new AbTaskListListener(){

                @Override
                public void update(List<?> paramList) {
                    if (AbSqliteStorage.this.retValue >= 0L) {
                        if (paramDataInsertListener != null) {
                            paramDataInsertListener.onSuccess(AbSqliteStorage.this.retValue);
                        }
                    } else if (paramDataInsertListener != null) {
                        paramDataInsertListener.onFailure(AbSqliteStorage.this.errorCode101, AbSqliteStorage.this.errorMessage101);
                    }
                }

                @Override
                public void get() {
                    dao.startWritableDatabase(false);
                    AbSqliteStorage.this.retValue = dao.update(entity);
                    dao.closeDatabase(false);
                }
            };
            mAbTaskQueue.execute(item);
        } else if (paramDataInsertListener != null) {
            paramDataInsertListener.onFailure(this.errorCode100, this.errorMessage100);
        }
    }

    public <T> void updateData(final List<T> entityList, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataOperationListener paramDataInsertListener) {
        if (entityList != null) {
            AbTaskItem item = new AbTaskItem();
            item.listener = new AbTaskListener(){

                @Override
                public void update() {
                    if (AbSqliteStorage.this.retValue >= 0L) {
                        if (paramDataInsertListener != null) {
                            paramDataInsertListener.onSuccess(AbSqliteStorage.this.retValue);
                        }
                    } else if (paramDataInsertListener != null) {
                        paramDataInsertListener.onFailure(AbSqliteStorage.this.errorCode101, AbSqliteStorage.this.errorMessage101);
                    }
                }

                @Override
                public void get() {
                    dao.startWritableDatabase(false);
                    AbSqliteStorage.this.retValue = dao.updateList(entityList);
                    dao.closeDatabase(false);
                }
            };
            mAbTaskQueue.execute(item);
        } else if (paramDataInsertListener != null) {
            paramDataInsertListener.onFailure(this.errorCode100, this.errorMessage100);
        }
    }

    public <T> void deleteData(final AbStorageQuery storageQuery, final AbDBDaoImpl<T> dao, final AbSqliteStorageListener.AbDataOperationListener paramDataInsertListener) {
        AbTaskItem item = new AbTaskItem();
        item.listener = new AbTaskListener(){

            @Override
            public void update() {
                if (AbSqliteStorage.this.retValue >= 0L) {
                    if (paramDataInsertListener != null) {
                        paramDataInsertListener.onSuccess(AbSqliteStorage.this.retValue);
                    }
                } else if (paramDataInsertListener != null) {
                    paramDataInsertListener.onFailure(AbSqliteStorage.this.errorCode101, AbSqliteStorage.this.errorMessage101);
                }
            }

            @Override
            public void get() {
                dao.startWritableDatabase(false);
                AbSqliteStorage.this.retValue = dao.delete(storageQuery.getWhereClause(), storageQuery.getWhereArgs());
                dao.closeDatabase(false);
            }
        };
        mAbTaskQueue.execute(item);
    }

    public void release() {
        if (mAbTaskQueue != null) {
            mAbTaskQueue.quit();
        }
    }
}

