/*
 * Decompiled with CFR 0.152.
 */
package com.ab.download;

import android.util.Log;
import com.ab.download.AbFileDownloader;
import com.ab.download.DownFile;
import com.ab.global.AbAppData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;

public class AbDownloadThread
extends Thread {
    private static final String TAG = "DownloadThread";
    private static final boolean D = AbAppData.DEBUG;
    private File saveFile;
    private DownFile mDownFile = null;
    private boolean finish = false;
    private boolean flag = false;
    private AbFileDownloader downloader;

    public AbDownloadThread(AbFileDownloader downloader, DownFile downFile, File saveFile) {
        this.saveFile = saveFile;
        this.downloader = downloader;
        this.mDownFile = downFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.flag = true;
        InputStream inStream = null;
        RandomAccessFile threadfile = null;
        if (this.mDownFile.getDownLength() >= this.mDownFile.getTotalLength()) return;
        try {
            try {
                block19: {
                    URL mUrl = new URL(this.mDownFile.getDownUrl());
                    HttpURLConnection http = (HttpURLConnection)mUrl.openConnection();
                    http.setConnectTimeout(5000);
                    http.setRequestMethod("GET");
                    http.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
                    http.setRequestProperty("Accept-Language", "zh-CN");
                    http.setRequestProperty("Referer", this.mDownFile.getDownUrl());
                    http.setRequestProperty("Charset", "UTF-8");
                    http.setRequestProperty("Range", "bytes=" + this.mDownFile.getDownLength() + "-" + this.mDownFile.getTotalLength());
                    http.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
                    http.setRequestProperty("Connection", "Keep-Alive");
                    inStream = http.getInputStream();
                    byte[] buffer = new byte[1024];
                    int offset = 0;
                    threadfile = new RandomAccessFile(this.saveFile, "rwd");
                    threadfile.seek(this.mDownFile.getDownLength());
                    while (this.flag) {
                        offset = inStream.read(buffer, 0, 1024);
                        if (offset == -1) {
                            return;
                        }
                        if (D) {
                            Log.d((String)TAG, (String)("offset:" + offset));
                        }
                        if (offset == 0) continue;
                        threadfile.write(buffer, 0, offset);
                        this.mDownFile.setDownLength(this.mDownFile.getDownLength() + (long)offset);
                        offset = 0;
                        if (D) {
                            Log.d((String)TAG, (String)("DownLength:" + this.mDownFile.getDownLength() + "/" + this.mDownFile.getTotalLength()));
                        }
                        this.downloader.update(this.mDownFile);
                        if (this.mDownFile.getDownLength() != this.mDownFile.getTotalLength()) {
                            continue;
                        }
                        break block19;
                    }
                    return;
                }
                this.finish = true;
                this.flag = false;
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mDownFile.setDownLength(-1L);
                try {
                    if (threadfile != null) {
                        threadfile.close();
                    }
                    if (inStream == null) return;
                    inStream.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        finally {
            try {
                if (threadfile != null) {
                    threadfile.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isFinish() {
        return this.finish;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }
}

