/*
 * Decompiled with CFR 0.152.
 */
package com.ab.download;

import android.content.Context;
import android.os.Environment;
import android.util.Log;
import com.ab.download.AbDownloadProgressListener;
import com.ab.download.AbDownloadThread;
import com.ab.download.DownFile;
import com.ab.download.DownFileDao;
import com.ab.global.AbAppData;
import com.ab.util.AbFileUtil;
import java.io.File;
import java.net.HttpURLConnection;
import java.util.LinkedHashMap;
import java.util.Map;

public class AbFileDownloader {
    private static final String TAG = "FileDownloader";
    private static final boolean D = AbAppData.DEBUG;
    private Context context;
    private AbDownloadThread threads;
    private DownFileDao mDownFileDao;
    private File saveFile;
    private DownFile mDownFile = null;
    private int mThreadNum = 1;
    private boolean flag = true;

    protected synchronized void update(DownFile downFile) {
        this.mDownFileDao.update(downFile);
    }

    public AbFileDownloader(Context context, DownFile downFile, int threadNum) {
        try {
            this.context = context;
            this.mDownFile = downFile;
            this.mThreadNum = threadNum;
            this.mDownFileDao = new DownFileDao(context);
            String fileName = AbFileUtil.getFileNameFromUrl(this.mDownFile.getDownUrl());
            this.saveFile = new File(String.valueOf(Environment.getExternalStorageDirectory().getPath()) + File.separator + AbFileUtil.getDownPathFileDir() + fileName);
            if (!this.saveFile.getParentFile().exists()) {
                this.saveFile.getParentFile().mkdirs();
            }
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
                this.mDownFileDao.delete(downFile.getDownUrl());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void download(AbDownloadProgressListener listener) throws Exception {
        try {
            this.threads = new AbDownloadThread(this, this.mDownFile, this.saveFile);
            this.threads.setPriority(7);
            this.threads.start();
            this.mDownFileDao.save(this.mDownFile);
            while (this.flag && this.mDownFile.getDownLength() <= this.mDownFile.getTotalLength()) {
                Thread.sleep(2000L);
                if (this.mDownFile.getDownLength() == -1L) {
                    return;
                }
                if (listener != null) {
                    listener.onDownloadSize(this.mDownFile.getDownLength());
                }
                if (this.mDownFile.getDownLength() != this.mDownFile.getTotalLength()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, String> getHttpResponseHeader(HttpURLConnection http) {
        String mine;
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        int i = 0;
        while ((mine = http.getHeaderField(i)) != null) {
            header.put(http.getHeaderFieldKey(i), mine);
            ++i;
        }
        return header;
    }

    public static void printResponseHeader(HttpURLConnection http) {
        Map<String, String> header = AbFileDownloader.getHttpResponseHeader(http);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            String key = entry.getKey() != null ? String.valueOf(entry.getKey()) + ":" : "";
            Log.i((String)TAG, (String)(String.valueOf(key) + entry.getValue()));
        }
    }

    public AbDownloadThread getThreads() {
        return this.threads;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public boolean getFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }
}

