/*
 * Decompiled with CFR 0.152.
 */
package com.ab.http;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ab.global.AbAppException;
import com.ab.http.AbBinaryHttpResponseListener;
import com.ab.http.AbFileHttpResponseListener;
import com.ab.http.AbHttpResponseListener;
import com.ab.http.AbRequestParams;
import com.ab.http.AbStringHttpResponseListener;
import com.ab.task.AbTaskPool;
import com.ab.util.AbAppUtil;
import com.ab.util.AbFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;

public class AbHttpClient {
    private static final String TAG = "AbHttpClient";
    private Context mContext;
    private static ExecutorService executorService = null;
    private static final int DEFAULT_MAX_CONNECTIONS = 10;
    private static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    private static final int BUFFER_SIZE = 4096;
    protected static final int SUCCESS_MESSAGE = 0;
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int START_MESSAGE = 2;
    protected static final int FINISH_MESSAGE = 3;
    protected static final int PROGRESS_MESSAGE = 4;
    protected static final int RETRY_MESSAGE = 5;
    private int timeout = 10000;
    private boolean debug = false;

    public AbHttpClient(Context context) {
        executorService = AbTaskPool.getExecutorService();
        this.mContext = context;
    }

    public void get(String url, AbHttpResponseListener responseListener) {
        this.get(url, null, responseListener);
    }

    public void get(final String url, final AbRequestParams params, final AbHttpResponseListener responseListener) {
        responseListener.setHandler(new ResponderHandler(responseListener));
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AbHttpClient.this.doGet(url, params, responseListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void post(String url, AbHttpResponseListener responseListener) {
        this.post(url, null, responseListener);
    }

    public void post(final String url, final AbRequestParams params, final AbHttpResponseListener responseListener) {
        responseListener.setHandler(new ResponderHandler(responseListener));
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    AbHttpClient.this.doPost(url, params, responseListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void doGet(String url, AbRequestParams params, AbHttpResponseListener responseListener) {
        block14: {
            try {
                responseListener.sendStartMessage();
                if (!this.debug && !AbAppUtil.isNetworkAvailable(this.mContext)) {
                    responseListener.sendFailureMessage(600, "\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc", new AbAppException("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc"));
                    return;
                }
                try {
                    if (params != null) {
                        url = String.valueOf(url) + params.getParamString();
                    }
                    HttpGet httpRequest = new HttpGet(url);
                    BasicHttpParams httpParams = new BasicHttpParams();
                    ConnManagerParams.setTimeout((HttpParams)httpParams, (long)10000L);
                    ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(10));
                    ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)10);
                    HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)10000);
                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)10000);
                    HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
                    HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
                    HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
                    HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)String.format("andbase-http/%s (http://www.418log.org/)", 1.0));
                    httpRequest.setParams((HttpParams)httpParams);
                    DefaultHttpClient httpClient = new DefaultHttpClient();
                    HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity mHttpEntity = httpResponse.getEntity();
                    if (statusCode == 200) {
                        if (responseListener instanceof AbStringHttpResponseListener) {
                            String content = EntityUtils.toString((HttpEntity)mHttpEntity);
                            ((AbStringHttpResponseListener)responseListener).sendSuccessMessage(statusCode, content);
                        } else if (responseListener instanceof AbBinaryHttpResponseListener) {
                            this.readResponseData(mHttpEntity, (AbBinaryHttpResponseListener)responseListener);
                        } else if (responseListener instanceof AbFileHttpResponseListener) {
                            String fileName = AbFileUtil.getFileNameFromUrl(url, httpResponse);
                            this.writeResponseData(mHttpEntity, fileName, (AbFileHttpResponseListener)responseListener);
                        }
                        break block14;
                    }
                    String content = EntityUtils.toString((HttpEntity)mHttpEntity);
                    responseListener.sendFailureMessage(statusCode, content, new AbAppException("\u8fde\u63a5\u8fdc\u7a0b\u5730\u5740\u5931\u8d25"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    responseListener.sendFailureMessage(900, e.getMessage(), new AbAppException(e));
                }
            }
            finally {
                responseListener.sendFinishMessage();
            }
        }
    }

    private void doPost(String url, AbRequestParams params, AbHttpResponseListener responseListener) {
        block14: {
            try {
                responseListener.sendStartMessage();
                if (!this.debug && !AbAppUtil.isNetworkAvailable(this.mContext)) {
                    responseListener.sendFailureMessage(600, "\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc", new AbAppException("\u65e0\u6cd5\u8fde\u63a5\u5230\u7f51\u7edc"));
                    return;
                }
                try {
                    HttpPost httpRequest = new HttpPost(url);
                    if (params != null) {
                        HttpEntity httpentity = params.getEntity(responseListener);
                        httpRequest.setEntity(httpentity);
                    }
                    BasicHttpParams httpParams = new BasicHttpParams();
                    ConnManagerParams.setTimeout((HttpParams)httpParams, (long)this.timeout);
                    ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)httpParams, (ConnPerRoute)new ConnPerRouteBean(10));
                    ConnManagerParams.setMaxTotalConnections((HttpParams)httpParams, (int)10);
                    HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.timeout);
                    HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.timeout);
                    HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams, (boolean)true);
                    HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams, (int)8192);
                    HttpProtocolParams.setVersion((HttpParams)httpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
                    HttpProtocolParams.setUserAgent((HttpParams)httpParams, (String)String.format("andbase-http/%s (http://www.418log.org/)", 1.0));
                    httpRequest.setParams((HttpParams)httpParams);
                    DefaultHttpClient httpclient = new DefaultHttpClient();
                    HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpRequest);
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    HttpEntity mHttpEntity = httpResponse.getEntity();
                    if (statusCode == 200) {
                        if (responseListener instanceof AbStringHttpResponseListener) {
                            String content = EntityUtils.toString((HttpEntity)mHttpEntity);
                            ((AbStringHttpResponseListener)responseListener).sendSuccessMessage(statusCode, content);
                        } else if (responseListener instanceof AbBinaryHttpResponseListener) {
                            this.readResponseData(mHttpEntity, (AbBinaryHttpResponseListener)responseListener);
                        } else if (responseListener instanceof AbFileHttpResponseListener) {
                            String fileName = AbFileUtil.getFileNameFromUrl(url, httpResponse);
                            this.writeResponseData(mHttpEntity, fileName, (AbFileHttpResponseListener)responseListener);
                        }
                        break block14;
                    }
                    String content = EntityUtils.toString((HttpEntity)mHttpEntity);
                    responseListener.sendFailureMessage(statusCode, content, new AbAppException("\u8fde\u63a5\u8fdc\u7a0b\u5730\u5740\u5931\u8d25"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    responseListener.sendFailureMessage(900, e.getMessage(), new AbAppException(e));
                }
            }
            finally {
                responseListener.sendFinishMessage();
            }
        }
    }

    public void writeResponseData(HttpEntity entity, String name, AbFileHttpResponseListener responseListener) {
        if (entity == null) {
            return;
        }
        if (responseListener.getFile() == null) {
            responseListener.setFile(name);
        }
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            try {
                inStream = entity.getContent();
                long contentLength = entity.getContentLength();
                outStream = new FileOutputStream(responseListener.getFile());
                if (inStream != null) {
                    int l;
                    byte[] tmp = new byte[4096];
                    int count = 0;
                    while ((l = inStream.read(tmp)) != -1 && !Thread.currentThread().isInterrupted()) {
                        ((FileOutputStream)outStream).write(tmp, 0, l);
                        responseListener.sendProgressMessage(count += l, (int)contentLength);
                    }
                }
                responseListener.sendSuccessMessage(200);
            }
            catch (Exception e) {
                e.printStackTrace();
                responseListener.sendFailureMessage(602, "\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5", e);
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.flush();
                        ((FileOutputStream)outStream).close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.flush();
                    ((FileOutputStream)outStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void readResponseData(HttpEntity entity, AbBinaryHttpResponseListener responseListener) {
        if (entity == null) {
            return;
        }
        InputStream inStream = null;
        ByteArrayOutputStream outSteam = null;
        try {
            try {
                inStream = entity.getContent();
                outSteam = new ByteArrayOutputStream();
                long contentLength = entity.getContentLength();
                if (inStream != null) {
                    int l;
                    int count = 0;
                    byte[] tmp = new byte[4096];
                    while ((l = inStream.read(tmp)) != -1) {
                        outSteam.write(tmp, 0, l);
                        responseListener.sendProgressMessage(count += l, (int)contentLength);
                    }
                }
                responseListener.sendSuccessMessage(200, outSteam.toByteArray());
            }
            catch (Exception e) {
                e.printStackTrace();
                responseListener.sendFailureMessage(602, "\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u91cd\u8bd5", e);
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outSteam != null) {
                        outSteam.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outSteam != null) {
                    outSteam.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private static class ResponderHandler
    extends Handler {
        private Object[] response;
        private AbHttpResponseListener responseListener;

        public ResponderHandler(AbHttpResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    this.response = (Object[])msg.obj;
                    if (this.response == null) break;
                    if (this.responseListener instanceof AbStringHttpResponseListener) {
                        if (this.response.length >= 2) {
                            ((AbStringHttpResponseListener)this.responseListener).onSuccess((Integer)this.response[0], (String)this.response[1]);
                            break;
                        }
                        Log.e((String)AbHttpClient.TAG, (String)"SUCCESS_MESSAGE \u53c2\u6570\u6ca1\u6709\u5305\u542b\u8db3\u591f\u7684\u503c");
                        break;
                    }
                    if (this.responseListener instanceof AbBinaryHttpResponseListener) {
                        if (this.response.length >= 2) {
                            ((AbBinaryHttpResponseListener)this.responseListener).onSuccess((Integer)this.response[0], (byte[])this.response[1]);
                            break;
                        }
                        Log.e((String)AbHttpClient.TAG, (String)"SUCCESS_MESSAGE \u53c2\u6570\u6ca1\u6709\u5305\u542b\u8db3\u591f\u7684\u503c");
                        break;
                    }
                    if (!(this.responseListener instanceof AbFileHttpResponseListener)) break;
                    if (this.response.length >= 1) {
                        AbFileHttpResponseListener mAbFileHttpResponseListener = (AbFileHttpResponseListener)this.responseListener;
                        mAbFileHttpResponseListener.onSuccess((Integer)this.response[0], mAbFileHttpResponseListener.getFile());
                        break;
                    }
                    Log.e((String)AbHttpClient.TAG, (String)"SUCCESS_MESSAGE \u53c2\u6570\u6ca1\u6709\u5305\u542b\u8db3\u591f\u7684\u503c");
                    break;
                }
                case 1: {
                    this.response = (Object[])msg.obj;
                    if (this.response != null && this.response.length >= 3) {
                        AbAppException exception = new AbAppException((Exception)this.response[2]);
                        this.responseListener.onFailure((Integer)this.response[0], (String)this.response[1], exception);
                        break;
                    }
                    Log.e((String)AbHttpClient.TAG, (String)"FAILURE_MESSAGE \u53c2\u6570\u6ca1\u6709\u5305\u542b\u8db3\u591f\u7684\u503c");
                    break;
                }
                case 2: {
                    this.responseListener.onStart();
                    break;
                }
                case 3: {
                    this.responseListener.onFinish();
                    break;
                }
                case 4: {
                    this.response = (Object[])msg.obj;
                    if (this.response != null && this.response.length >= 2) {
                        this.responseListener.onProgress((Integer)this.response[0], (Integer)this.response[1]);
                        break;
                    }
                    Log.e((String)AbHttpClient.TAG, (String)"PROGRESS_MESSAGE \u53c2\u6570\u6ca1\u6709\u5305\u542b\u8db3\u591f\u7684\u503c");
                    break;
                }
                case 5: {
                    this.responseListener.onRetry();
                    break;
                }
            }
        }
    }
}

