/*
 * Decompiled with CFR 0.152.
 */
package com.ab.http;

import android.util.Log;
import com.ab.http.AbHttpResponseListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class AbMultipartEntity
implements HttpEntity {
    private static final String TAG = "AbMultipartEntity";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final byte[] CR_LF = "\r\n".getBytes();
    private static final byte[] TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: binary\r\n".getBytes();
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private String boundary;
    private byte[] boundaryLine;
    private byte[] boundaryEnd;
    private List<FilePart> fileParts = new ArrayList<FilePart>();
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private AbHttpResponseListener responseListener;
    private int bytesWritten;
    private int totalSize;

    public AbMultipartEntity(AbHttpResponseListener responseListener) {
        StringBuilder buf = new StringBuilder();
        Random rand = new Random();
        int i = 0;
        while (i < 30) {
            buf.append(MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)]);
            ++i;
        }
        this.boundary = buf.toString();
        this.boundaryLine = ("--" + this.boundary + "\r\n").getBytes();
        this.boundaryEnd = ("--" + this.boundary + "--\r\n").getBytes();
        this.responseListener = responseListener;
    }

    public void addPart(String key, String value, String contentType) {
        try {
            this.out.write(this.boundaryLine);
            this.out.write(this.createContentDisposition(key));
            this.out.write(this.createContentType(contentType));
            this.out.write(CR_LF);
            this.out.write(value.getBytes());
            this.out.write(CR_LF);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"addPart ByteArrayOutputStream exception", (Throwable)e);
        }
    }

    public void addPart(String key, String value) {
        this.addPart(key, value, "text/plain; charset=UTF-8");
    }

    public void addPart(String key, File file) {
        this.addPart(key, file, null);
    }

    public void addPart(String key, File file, String type) {
        if (type == null) {
            type = APPLICATION_OCTET_STREAM;
        }
        this.fileParts.add(new FilePart(key, file, type));
    }

    public void addPart(String key, String streamName, InputStream inputStream, String type) throws IOException {
        int l;
        if (type == null) {
            type = APPLICATION_OCTET_STREAM;
        }
        this.out.write(this.boundaryLine);
        this.out.write(this.createContentDisposition(key, streamName));
        this.out.write(this.createContentType(type));
        this.out.write(TRANSFER_ENCODING_BINARY);
        this.out.write(CR_LF);
        byte[] tmp = new byte[4096];
        while ((l = inputStream.read(tmp)) != -1) {
            this.out.write(tmp, 0, l);
        }
        this.out.write(CR_LF);
        this.out.flush();
        try {
            inputStream.close();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Cannot close input stream", (Throwable)e);
        }
    }

    private byte[] createContentType(String type) {
        String result = "Content-Type: " + type + "\r\n";
        return result.getBytes();
    }

    private byte[] createContentDisposition(String key) {
        return ("Content-Disposition: form-data; name=\"" + key + "\"\r\n").getBytes();
    }

    private byte[] createContentDisposition(String key, String fileName) {
        return ("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + fileName + "\"\r\n").getBytes();
    }

    private void updateProgress(int count) {
        this.bytesWritten += count;
        this.responseListener.sendProgressMessage(this.bytesWritten, this.totalSize);
    }

    public long getContentLength() {
        long contentLen = this.out.size();
        for (FilePart filePart : this.fileParts) {
            long len = filePart.getTotalLength();
            if (len < 0L) {
                return -1L;
            }
            contentLen += len;
        }
        return contentLen += (long)this.boundaryEnd.length;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        this.bytesWritten = 0;
        this.totalSize = (int)this.getContentLength();
        this.out.writeTo(outstream);
        this.updateProgress(this.out.size());
        for (FilePart filePart : this.fileParts) {
            filePart.writeTo(outstream);
        }
        outstream.write(this.boundaryEnd);
        this.updateProgress(this.boundaryEnd.length);
    }

    public Header getContentEncoding() {
        return null;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getContent() is not supported. Use writeTo() instead.");
    }

    private class FilePart {
        public File file;
        public byte[] header;

        public FilePart(String key, File file, String type) {
            this.header = this.createHeader(key, file.getName(), type);
            this.file = file;
        }

        private byte[] createHeader(String key, String filename, String type) {
            ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
            try {
                headerStream.write(AbMultipartEntity.this.boundaryLine);
                headerStream.write(AbMultipartEntity.this.createContentDisposition(key, filename));
                headerStream.write(AbMultipartEntity.this.createContentType(type));
                headerStream.write(TRANSFER_ENCODING_BINARY);
                headerStream.write(CR_LF);
            }
            catch (IOException e) {
                Log.e((String)AbMultipartEntity.TAG, (String)"createHeader ByteArrayOutputStream exception", (Throwable)e);
            }
            return headerStream.toByteArray();
        }

        public long getTotalLength() {
            long streamLength = this.file.length();
            return (long)this.header.length + streamLength;
        }

        public void writeTo(OutputStream out) throws IOException {
            int l;
            out.write(this.header);
            AbMultipartEntity.this.updateProgress(this.header.length);
            FileInputStream inputStream = new FileInputStream(this.file);
            byte[] tmp = new byte[4096];
            while ((l = inputStream.read(tmp)) != -1) {
                out.write(tmp, 0, l);
                AbMultipartEntity.this.updateProgress(l);
            }
            out.write(CR_LF);
            AbMultipartEntity.this.updateProgress(CR_LF.length);
            out.flush();
            try {
                inputStream.close();
            }
            catch (IOException e) {
                Log.w((String)AbMultipartEntity.TAG, (String)"Cannot close input stream", (Throwable)e);
            }
        }
    }
}

