/*
 * Decompiled with CFR 0.152.
 */
package com.ab.task;

import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.ab.global.AbAppData;
import com.ab.task.AbTaskItem;
import com.ab.task.AbTaskListListener;
import com.ab.task.AbTaskObjectListener;
import com.ab.util.AbAppUtil;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class AbTaskPool {
    private static String TAG = "AbTaskPool";
    private static final boolean D = AbAppData.DEBUG;
    private static AbTaskPool mAbTaskPool = null;
    private static int nThreads = 5;
    private static ExecutorService executorService = null;
    private static Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            AbTaskItem item = (AbTaskItem)msg.obj;
            if (item.getListener() instanceof AbTaskListListener) {
                ((AbTaskListListener)item.listener).update((List)item.getResult());
            } else if (item.getListener() instanceof AbTaskObjectListener) {
                ((AbTaskObjectListener)item.listener).update(item.getResult());
            } else {
                item.listener.update();
            }
        }
    };

    static {
        nThreads = AbAppUtil.getNumCores();
        mAbTaskPool = new AbTaskPool(nThreads * 5);
    }

    protected AbTaskPool(int nThreads) {
        executorService = Executors.newFixedThreadPool(nThreads);
    }

    public static AbTaskPool getInstance() {
        return mAbTaskPool;
    }

    public void execute(final AbTaskItem item) {
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (item.listener != null) {
                        item.listener.get();
                        Message msg = handler.obtainMessage();
                        msg.obj = item;
                        handler.sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public void shutdownNow() {
        if (!executorService.isTerminated()) {
            executorService.shutdownNow();
            this.listenShutdown();
        }
    }

    public void shutdown() {
        if (!executorService.isTerminated()) {
            executorService.shutdown();
            this.listenShutdown();
        }
    }

    public void listenShutdown() {
        try {
            while (!executorService.awaitTermination(1L, TimeUnit.MILLISECONDS)) {
                if (!D) continue;
                Log.d((String)TAG, (String)"\u7ebf\u7a0b\u6c60\u672a\u5173\u95ed");
            }
            if (D) {
                Log.d((String)TAG, (String)"\u7ebf\u7a0b\u6c60\u5df2\u5173\u95ed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

