/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.ab.global.AbAppData;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;

public class AbAppUtil {
    public static void installApk(Context context, File file) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    public static void uninstallApk(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.DELETE");
        Uri packageURI = Uri.parse((String)("package:" + packageName));
        intent.setData(packageURI);
        context.startActivity(intent);
    }

    public static boolean isServiceRunning(Context ctx, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        List servicesList = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo si : servicesList) {
            if (!className.equals(si.service.getClassName())) continue;
            isRunning = true;
        }
        return isRunning;
    }

    public static boolean stopRunningService(Context ctx, String className) {
        Intent intent_service = null;
        boolean ret = false;
        try {
            intent_service = new Intent(ctx, Class.forName(className));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (intent_service != null) {
            ret = ctx.stopService(intent_service);
        }
        return ret;
    }

    public static int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            File[] files = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            });
            return files.length;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            NetworkInfo info;
            ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
            return connectivity != null && (info = connectivity.getActiveNetworkInfo()) != null && info.isConnected() && info.getState() == NetworkInfo.State.CONNECTED;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isGpsEnabled(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm.isProviderEnabled("gps");
    }

    public static boolean isWifiEnabled(Context context) {
        ConnectivityManager mgrConn = (ConnectivityManager)context.getSystemService("connectivity");
        TelephonyManager mgrTel = (TelephonyManager)context.getSystemService("phone");
        return mgrConn.getActiveNetworkInfo() != null && mgrConn.getActiveNetworkInfo().getState() == NetworkInfo.State.CONNECTED || mgrTel.getNetworkType() == 3;
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static boolean is3G(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 0;
    }

    public static void setDebug(boolean debug) {
        AbAppData.DEBUG = debug;
    }

    public static void prepareStartTime() {
        Calendar current = Calendar.getInstance();
        AbAppData.startLogTimeInMillis = current.getTimeInMillis();
    }

    public static void logEndTime(boolean D, String tag, String msg) {
        Calendar current = Calendar.getInstance();
        long endLogTimeInMillis = current.getTimeInMillis();
        if (D) {
            Log.d((String)tag, (String)(String.valueOf(msg) + ":" + (endLogTimeInMillis - AbAppData.startLogTimeInMillis) + "ms"));
        }
    }

    public static boolean importDatabase(Context context, String dbName, int rawRes) {
        boolean flag;
        block23: {
            int buffer_size = 1024;
            InputStream is = null;
            FileOutputStream fos = null;
            flag = false;
            try {
                try {
                    String dbPath = "/data/data/" + context.getPackageName() + "/databases/" + dbName;
                    File dbfile = new File(dbPath);
                    if (!dbfile.exists()) {
                        if (!dbfile.getParentFile().exists()) {
                            dbfile.getParentFile().mkdirs();
                        }
                        dbfile.createNewFile();
                        is = context.getResources().openRawResource(rawRes);
                        fos = new FileOutputStream(dbfile);
                        byte[] buffer = new byte[buffer_size];
                        int count = 0;
                        while ((count = is.read(buffer)) > 0) {
                            fos.write(buffer, 0, count);
                        }
                        fos.flush();
                    }
                    flag = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (is == null) break block23;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return flag;
    }
}

