/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import com.ab.bitmap.AbFileCache;
import com.ab.bitmap.AbImageCache;
import com.ab.global.AbAppData;
import com.ab.util.AbImageUtil;
import com.ab.util.AbMd5;
import com.ab.util.AbStrUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class AbFileUtil {
    private static String TAG = "AbFileUtil";
    private static final boolean D = AbAppData.DEBUG;
    private static String downPathRootDir = String.valueOf(File.separator) + "download" + File.separator;
    private static String downPathImageDir = String.valueOf(downPathRootDir) + "cache_images" + File.separator;
    private static String downPathFileDir = String.valueOf(downPathRootDir) + "cache_files" + File.separator;
    private static int MB = 0x100000;
    private static int freeSdSpaceNeededToCache = 200 * MB;

    public static String downFileToSD(String url, String name) {
        InputStream in = null;
        FileOutputStream fileOutputStream = null;
        HttpURLConnection con = null;
        String downFilePath = null;
        File file = null;
        try {
            if (!AbFileUtil.isCanUseSD()) {
                return null;
            }
            File path = Environment.getExternalStorageDirectory();
            File fileDirectory = new File(String.valueOf(path.getAbsolutePath()) + downPathImageDir);
            if (!fileDirectory.exists()) {
                fileDirectory.mkdirs();
            }
            if ((file = new File(fileDirectory, name)).exists()) {
                String string = file.getPath();
                return string;
            }
            file.createNewFile();
            try {
                downFilePath = file.getPath();
                URL mUrl = new URL(url);
                con = (HttpURLConnection)mUrl.openConnection();
                con.connect();
                in = con.getInputStream();
                fileOutputStream = new FileOutputStream(file);
                byte[] b = new byte[1024];
                int temp = 0;
                while ((temp = in.read(b)) != -1) {
                    fileOutputStream.write(b, 0, temp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (con != null) {
                    con.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (file.length() == 0L) {
                    Log.d((String)TAG, (String)"\u4e0b\u8f7d\u51fa\u9519\u4e86\uff0c\u6587\u4ef6\u5927\u5c0f\u4e3a0");
                    file.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return downFilePath;
    }

    public static Bitmap getBitmapFromSDCache(String url, int type, int width, int height) {
        File file;
        String key;
        Bitmap bitmap;
        block9: {
            block8: {
                bitmap = null;
                try {
                    if (!AbStrUtil.isEmpty(url)) break block8;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return bitmap;
                }
            }
            if (!AbFileUtil.isCanUseSD() || freeSdSpaceNeededToCache < AbFileUtil.freeSpaceOnSD()) {
                bitmap = AbFileUtil.getBitmapFormURL(url, type, width, height);
                return bitmap;
            }
            if (type != 2 && (width <= 0 || height <= 0)) {
                throw new IllegalArgumentException("\u7f29\u653e\u548c\u88c1\u526a\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            key = AbImageCache.getCacheKey(url, width, height, type);
            File path = Environment.getExternalStorageDirectory();
            File fileDirectory = new File(String.valueOf(path.getAbsolutePath()) + downPathImageDir);
            String suffix = AbFileUtil.getSuffixFromNetUrl(url);
            String fileName = String.valueOf(key) + suffix;
            file = new File(fileDirectory, fileName);
            File fileCache = AbFileCache.getFileFromCache(fileName);
            if (fileCache != null) break block9;
            String downFilePath = AbFileUtil.downFileToSD(url, file.getName());
            if (downFilePath != null) {
                AbFileCache.addFileToCache(fileName, file);
                return AbFileUtil.getBitmapFromSD(file, type, width, height);
            }
            return null;
        }
        bitmap = AbFileUtil.getBitmapFromSD(file, type, width, height);
        if (D) {
            Log.d((String)TAG, (String)("\u4eceSD\u7f13\u5b58\u4e2d\u5f97\u5230\u56fe\u7247:" + key + "," + bitmap));
        }
        return bitmap;
    }

    public static Bitmap getBitmapFromSD(String url, int type, int width, int height) {
        File file;
        block6: {
            block5: {
                Bitmap bit = null;
                try {
                    if (AbFileUtil.isCanUseSD()) break block5;
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return bit;
                }
            }
            if (type != 2 && (width <= 0 || height <= 0)) {
                throw new IllegalArgumentException("\u7f29\u653e\u548c\u88c1\u526a\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            String key = AbImageCache.getCacheKey(url, width, height, type);
            File path = Environment.getExternalStorageDirectory();
            File fileDirectory = new File(String.valueOf(path.getAbsolutePath()) + downPathImageDir);
            String suffix = AbFileUtil.getSuffixFromNetUrl(url);
            String fileName = String.valueOf(key) + suffix;
            file = new File(fileDirectory, fileName);
            if (file.exists()) break block6;
            return null;
        }
        return AbFileUtil.getBitmapFromSD(file, type, width, height);
    }

    public static Bitmap getBitmapFromSD(File file, int type, int newWidth, int newHeight) {
        Bitmap bit;
        block6: {
            block5: {
                bit = null;
                if (AbFileUtil.isCanUseSD()) break block5;
                return null;
            }
            if (type != 2 && (newWidth <= 0 || newHeight <= 0)) {
                throw new IllegalArgumentException("\u7f29\u653e\u548c\u88c1\u526a\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
            }
            if (file.exists()) break block6;
            return null;
        }
        try {
            bit = type == 0 ? AbImageUtil.cutImg(file, newWidth, newHeight) : (type == 1 ? AbImageUtil.scaleImg(file, newWidth, newHeight) : AbImageUtil.originalImg(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bit;
    }

    public static Bitmap getBitmapFromSD(File file) {
        Bitmap bitmap;
        block5: {
            block4: {
                bitmap = null;
                if (AbFileUtil.isCanUseSD()) break block4;
                return null;
            }
            if (file.exists()) break block5;
            return null;
        }
        try {
            bitmap = AbImageUtil.originalImg(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap getBitmapFormByte(byte[] imgByte, String fileName, int type, int newWidth, int newHeight) {
        Bitmap b;
        block34: {
            FileOutputStream fos = null;
            FilterInputStream dis = null;
            ByteArrayInputStream bis = null;
            b = null;
            File file = null;
            try {
                try {
                    if (imgByte != null) {
                        File sdcardDir = Environment.getExternalStorageDirectory();
                        String path = String.valueOf(sdcardDir.getAbsolutePath()) + downPathImageDir;
                        file = new File(String.valueOf(path) + fileName);
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        fos = new FileOutputStream(file);
                        int readLength = 0;
                        bis = new ByteArrayInputStream(imgByte);
                        dis = new DataInputStream(bis);
                        byte[] buffer = new byte[1024];
                        while ((readLength = ((DataInputStream)dis).read(buffer)) != -1) {
                            fos.write(buffer, 0, readLength);
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        fos.flush();
                        b = AbFileUtil.getBitmapFromSD(file, type, newWidth, newHeight);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fos == null) break block34;
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (Exception exception) {}
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {}
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return b;
    }

    public static Bitmap getBitmapFormURL(String url, int type, int newWidth, int newHeight) {
        Bitmap bit;
        block2: {
            bit = null;
            try {
                bit = AbImageUtil.getBitmapFormURL(url, type, newWidth, newHeight);
            }
            catch (Exception e) {
                if (!D) break block2;
                Log.d((String)TAG, (String)("\u4e0b\u8f7d\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage()));
            }
        }
        return bit;
    }

    public static Bitmap getBitmapFormSrc(String src) {
        Bitmap bit;
        block2: {
            bit = null;
            try {
                bit = BitmapFactory.decodeStream((InputStream)AbFileUtil.class.getResourceAsStream(src));
            }
            catch (Exception e) {
                if (!D) break block2;
                Log.d((String)TAG, (String)("\u83b7\u53d6\u56fe\u7247\u5f02\u5e38\uff1a" + e.getMessage()));
            }
        }
        return bit;
    }

    public static int getContentLengthFormUrl(String Url) {
        int mContentLength;
        block3: {
            mContentLength = 0;
            try {
                URL url = new URL(Url);
                HttpURLConnection mHttpURLConnection = (HttpURLConnection)url.openConnection();
                mHttpURLConnection.setConnectTimeout(5000);
                mHttpURLConnection.setRequestMethod("GET");
                mHttpURLConnection.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
                mHttpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
                mHttpURLConnection.setRequestProperty("Referer", Url);
                mHttpURLConnection.setRequestProperty("Charset", "UTF-8");
                mHttpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
                mHttpURLConnection.setRequestProperty("Connection", "Keep-Alive");
                mHttpURLConnection.connect();
                if (mHttpURLConnection.getResponseCode() == 200) {
                    mContentLength = mHttpURLConnection.getContentLength();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!D) break block3;
                Log.d((String)TAG, (String)("\u83b7\u53d6\u957f\u5ea6\u5f02\u5e38\uff1a" + e.getMessage()));
            }
        }
        return mContentLength;
    }

    public static String getRealFileNameFromUrl(String url) {
        String name = null;
        try {
            if (AbStrUtil.isEmpty(url)) {
                return name;
            }
            URL mUrl = new URL(url);
            HttpURLConnection mHttpURLConnection = (HttpURLConnection)mUrl.openConnection();
            mHttpURLConnection.setConnectTimeout(5000);
            mHttpURLConnection.setRequestMethod("GET");
            mHttpURLConnection.setRequestProperty("Accept", "image/gif, image/jpeg, image/pjpeg, image/pjpeg, application/x-shockwave-flash, application/xaml+xml, application/vnd.ms-xpsdocument, application/x-ms-xbap, application/x-ms-application, application/vnd.ms-excel, application/vnd.ms-powerpoint, application/msword, */*");
            mHttpURLConnection.setRequestProperty("Accept-Language", "zh-CN");
            mHttpURLConnection.setRequestProperty("Referer", url);
            mHttpURLConnection.setRequestProperty("Charset", "UTF-8");
            mHttpURLConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 5.2; Trident/4.0; .NET CLR 1.1.4322; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)");
            mHttpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            mHttpURLConnection.connect();
            if (mHttpURLConnection.getResponseCode() == 200) {
                String mine;
                int i = 0;
                while ((mine = mHttpURLConnection.getHeaderField(i)) != null) {
                    Matcher m;
                    if ("content-disposition".equals(mHttpURLConnection.getHeaderFieldKey(i).toLowerCase()) && (m = Pattern.compile(".*filename=(.*)").matcher(mine.toLowerCase())).find()) {
                        return m.group(1).replace("\"", "");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getFileNameFromUrl(String url, HttpResponse response) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String name = null;
        try {
            String suffix = null;
            if (url.lastIndexOf(".") != -1 && ((suffix = url.substring(url.lastIndexOf("."))).indexOf("/") != -1 || suffix.indexOf("?") != -1 || suffix.indexOf("&") != -1)) {
                suffix = null;
            }
            if (suffix == null) {
                String fileName = "unknow.tmp";
                Header[] headers = response.getHeaders("content-disposition");
                int i = 0;
                while (i < headers.length) {
                    Matcher m = Pattern.compile(".*filename=(.*)").matcher(headers[i].getValue());
                    if (m.find()) {
                        fileName = m.group(1).replace("\"", "");
                    }
                    ++i;
                }
                if (fileName != null && fileName.lastIndexOf(".") != -1) {
                    suffix = fileName.substring(fileName.lastIndexOf("."));
                }
            }
            name = String.valueOf(AbMd5.MD5(url)) + suffix;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getFileNameFromUrl(String url) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String name = null;
        try {
            String suffix = null;
            if (url.lastIndexOf(".") != -1 && (suffix = url.substring(url.lastIndexOf("."))).indexOf("/") != -1) {
                suffix = null;
            }
            if (suffix == null) {
                suffix = AbFileUtil.getSuffixFromNetUrl(url);
            }
            name = String.valueOf(AbMd5.MD5(url)) + suffix;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return name;
    }

    public static String getSuffixFromNetUrl(String url) {
        if (AbStrUtil.isEmpty(url)) {
            return null;
        }
        String suffix = ".tmp";
        try {
            String fileName;
            if (url.lastIndexOf(".") != -1 && ((suffix = url.substring(url.lastIndexOf("."))).indexOf("/") != -1 || suffix.indexOf("?") != -1 || suffix.indexOf("&") != -1)) {
                suffix = null;
            }
            if (suffix == null && (fileName = AbFileUtil.getRealFileNameFromUrl(url)) != null && fileName.lastIndexOf(".") != -1) {
                suffix = fileName.substring(fileName.lastIndexOf("."));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suffix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getByteArrayFromSD(String path) {
        byte[] bytes = null;
        ByteArrayOutputStream out = null;
        try {
            File file = new File(path);
            if (!AbFileUtil.isCanUseSD()) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                return null;
            }
            FileInputStream in = new FileInputStream(path);
            out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            int size = 0;
            while (true) {
                if ((size = in.read(buffer)) == -1) {
                    in.close();
                    bytes = out.toByteArray();
                    return bytes;
                }
                out.write(buffer, 0, size);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return bytes;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeByteArrayToSD(String path, byte[] content, boolean create) {
        FileOutputStream fos = null;
        try {
            File file = new File(path);
            if (!AbFileUtil.isCanUseSD()) {
                return;
            }
            if (!file.exists()) {
                if (!create) return;
                File parent = file.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                    file.createNewFile();
                }
            }
            fos = new FileOutputStream(path);
            fos.write(content);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean isCanUseSD() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getDownPathImageDir() {
        return downPathImageDir;
    }

    public static void setDownPathImageDir(String downPathImageDir) {
        AbFileUtil.downPathImageDir = downPathImageDir;
    }

    public static String getDownPathFileDir() {
        return downPathFileDir;
    }

    public static void setDownPathFileDir(String downPathFileDir) {
        AbFileUtil.downPathFileDir = downPathFileDir;
    }

    public static String getFullImageDownPathDir() {
        String pathDir;
        block4: {
            pathDir = null;
            if (AbFileUtil.isCanUseSD()) break block4;
            return null;
        }
        try {
            File fileRoot = Environment.getExternalStorageDirectory();
            File dirFile = new File(String.valueOf(fileRoot.getAbsolutePath()) + downPathImageDir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            pathDir = dirFile.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pathDir;
    }

    public static boolean initFileCache() {
        File[] files;
        block6: {
            block5: {
                AbFileCache.cacheSize = 0;
                if (AbFileUtil.isCanUseSD()) break block5;
                return false;
            }
            File path = Environment.getExternalStorageDirectory();
            File fileDirectory = new File(String.valueOf(path.getAbsolutePath()) + downPathImageDir);
            files = fileDirectory.listFiles();
            if (files != null) break block6;
            return true;
        }
        try {
            int i = 0;
            while (i < files.length) {
                AbFileCache.cacheSize = (int)((long)AbFileCache.cacheSize + files[i].length());
                AbFileCache.addFileToCache(files[i].getName(), files[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean freeCacheFiles() {
        File[] files;
        block6: {
            block5: {
                if (AbFileUtil.isCanUseSD()) break block5;
                return false;
            }
            File path = Environment.getExternalStorageDirectory();
            File fileDirectory = new File(String.valueOf(path.getAbsolutePath()) + downPathImageDir);
            files = fileDirectory.listFiles();
            if (files != null) break block6;
            return true;
        }
        try {
            int removeFactor = (int)(0.4 * (double)files.length + 1.0);
            Arrays.sort(files, new FileLastModifSort());
            int i = 0;
            while (i < removeFactor) {
                AbFileCache.cacheSize = (int)((long)AbFileCache.cacheSize - files[i].length());
                files[i].delete();
                AbFileCache.removeFileFromCache(files[i].getName());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static int freeSpaceOnSD() {
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        double sdFreeMB = (double)stat.getAvailableBlocks() * (double)stat.getBlockSize() / (double)MB;
        return (int)sdFreeMB;
    }

    public static int getFreeSdSpaceNeededToCache() {
        return freeSdSpaceNeededToCache;
    }

    public static void setFreeSdSpaceNeededToCache(int freeSdSpaceNeededToCache) {
        AbFileUtil.freeSdSpaceNeededToCache = freeSdSpaceNeededToCache;
    }

    public static boolean removeAllFileCache() {
        File[] files;
        block6: {
            block5: {
                if (AbFileUtil.isCanUseSD()) break block5;
                return false;
            }
            File path = Environment.getExternalStorageDirectory();
            File fileDirectory = new File(String.valueOf(path.getAbsolutePath()) + downPathImageDir);
            files = fileDirectory.listFiles();
            if (files != null) break block6;
            return true;
        }
        try {
            int i = 0;
            while (i < files.length) {
                files[i].delete();
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String readAssetsByName(Context context, String name, String encoding) {
        String text = null;
        InputStreamReader inputReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                inputReader = new InputStreamReader(context.getAssets().open(name));
                bufReader = new BufferedReader(inputReader);
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = bufReader.readLine()) != null) {
                    buffer.append(line);
                }
                text = new String(buffer.toString().getBytes(), encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static String readRawByName(Context context, int id, String encoding) {
        String text = null;
        InputStreamReader inputReader = null;
        BufferedReader bufReader = null;
        try {
            try {
                inputReader = new InputStreamReader(context.getResources().openRawResource(id));
                bufReader = new BufferedReader(inputReader);
                String line = null;
                StringBuffer buffer = new StringBuffer();
                while ((line = bufReader.readLine()) != null) {
                    buffer.append(line);
                }
                text = new String(buffer.toString().getBytes(), encoding);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                    if (inputReader != null) {
                        inputReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
                if (inputReader != null) {
                    inputReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static class FileLastModifSort
    implements Comparator<File> {
        @Override
        public int compare(File arg0, File arg1) {
            if (arg0.lastModified() > arg1.lastModified()) {
                return 1;
            }
            if (arg0.lastModified() == arg1.lastModified()) {
                return 0;
            }
            return -1;
        }
    }
}

