/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.ab.global.AbAppData;
import com.ab.util.AbMathUtil;
import com.ab.util.dct.FDCT;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class AbImageUtil {
    private static String TAG = "AbImageUtil";
    private static final boolean D = AbAppData.DEBUG;

    public static Bitmap getBitmapFormURL(String imageUrl, int type, int newWidth, int newHeight) {
        Bitmap bm;
        block16: {
            bm = null;
            URLConnection con = null;
            InputStream is = null;
            try {
                try {
                    URL url = new URL(imageUrl);
                    con = url.openConnection();
                    con.setDoInput(true);
                    con.connect();
                    is = con.getInputStream();
                    Bitmap wholeBm = BitmapFactory.decodeStream((InputStream)is, null, null);
                    if (type == 0) {
                        bm = AbImageUtil.cutImg(wholeBm, newWidth, newHeight);
                        break block16;
                    }
                    if (type == 1) {
                        bm = AbImageUtil.scaleImg(wholeBm, newWidth, newHeight);
                        break block16;
                    }
                    bm = wholeBm;
                }
                catch (Exception e) {
                    if (D) {
                        Log.d((String)TAG, (String)e.getMessage());
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return bm;
    }

    public static Bitmap originalImg(File file) {
        Bitmap resizeBmp = null;
        try {
            resizeBmp = BitmapFactory.decodeFile((String)file.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resizeBmp;
    }

    public static Bitmap scaleImg(File file, int newWidth, int newHeight) {
        Bitmap resizeBmp = null;
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("\u7f29\u653e\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)opts);
        int srcWidth = opts.outWidth;
        int srcHeight = opts.outHeight;
        int destWidth = srcWidth;
        int destHeight = srcHeight;
        float scale = 0.0f;
        float scaleWidth = (float)newWidth / (float)srcWidth;
        float scaleHeight = (float)newHeight / (float)srcHeight;
        scale = scaleWidth > scaleHeight ? scaleWidth : scaleHeight;
        if (scale != 0.0f) {
            destWidth = (int)((float)destWidth / scale);
            destHeight = (int)((float)destHeight / scale);
        }
        opts.inPreferredConfig = Bitmap.Config.RGB_565;
        opts.inPurgeable = true;
        opts.inInputShareable = true;
        opts.inSampleSize = scale > 1.0f ? (int)scale : 1;
        opts.outHeight = destHeight;
        opts.outWidth = destWidth;
        opts.inJustDecodeBounds = false;
        opts.inDither = false;
        resizeBmp = BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)opts);
        if (resizeBmp != null && scale != 1.0f) {
            resizeBmp = AbImageUtil.scaleImg(resizeBmp, scale);
        }
        return resizeBmp;
    }

    public static Bitmap scaleImg(Bitmap bitmap, int newWidth, int newHeight) {
        Bitmap resizeBmp = null;
        if (bitmap == null) {
            return null;
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("\u7f29\u653e\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        int srcWidth = bitmap.getWidth();
        int srcHeight = bitmap.getHeight();
        if (srcWidth <= 0 || srcHeight <= 0) {
            return null;
        }
        float scale = 0.0f;
        float scaleWidth = (float)newWidth / (float)srcWidth;
        float scaleHeight = (float)newHeight / (float)srcHeight;
        scale = scaleWidth > scaleHeight ? scaleWidth : scaleHeight;
        if (bitmap != null && scale != 1.0f) {
            resizeBmp = AbImageUtil.scaleImg(bitmap, scale);
        }
        return resizeBmp;
    }

    public static Bitmap scaleImg(Bitmap bitmap, float scale) {
        Bitmap resizeBmp = null;
        try {
            try {
                int bmpW = bitmap.getWidth();
                int bmpH = bitmap.getHeight();
                Matrix mt = new Matrix();
                mt.postScale(scale, scale);
                resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bmpW, (int)bmpH, (Matrix)mt, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (resizeBmp != bitmap) {
                    bitmap.recycle();
                }
            }
        }
        finally {
            if (resizeBmp != bitmap) {
                bitmap.recycle();
            }
        }
        return resizeBmp;
    }

    public static Bitmap cutImg(File file, int newWidth, int newHeight) {
        Bitmap resizeBmp = null;
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("\u88c1\u526a\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)opts);
        int srcWidth = opts.outWidth;
        int srcHeight = opts.outHeight;
        int destWidth = 0;
        int destHeight = 0;
        int cutSrcWidth = newWidth * 2;
        int cutSrcHeight = newHeight * 2;
        double ratio = 0.0;
        if (srcWidth < cutSrcWidth || srcHeight < cutSrcHeight) {
            ratio = 0.0;
            destWidth = srcWidth;
            destHeight = srcHeight;
        } else if (srcWidth > cutSrcWidth) {
            ratio = (double)srcWidth / (double)cutSrcWidth;
            destWidth = cutSrcWidth;
            destHeight = (int)((double)srcHeight / ratio);
        } else if (srcHeight > cutSrcHeight) {
            ratio = (double)srcHeight / (double)cutSrcHeight;
            destHeight = cutSrcHeight;
            destWidth = (int)((double)srcWidth / ratio);
        }
        opts.inPreferredConfig = Bitmap.Config.RGB_565;
        opts.inPurgeable = true;
        opts.inInputShareable = true;
        opts.inSampleSize = ratio > 1.0 ? (int)ratio : 1;
        opts.outHeight = destHeight;
        opts.outWidth = destWidth;
        opts.inJustDecodeBounds = false;
        opts.inDither = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)opts);
        if (bitmap != null) {
            resizeBmp = AbImageUtil.cutImg(bitmap, newWidth, newHeight);
        }
        return resizeBmp;
    }

    public static Bitmap cutImg(Bitmap bitmap, int newWidth, int newHeight) {
        if (bitmap == null) {
            return null;
        }
        if (newWidth <= 0 || newHeight <= 0) {
            throw new IllegalArgumentException("\u88c1\u526a\u56fe\u7247\u7684\u5bbd\u9ad8\u8bbe\u7f6e\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        Bitmap resizeBmp = null;
        try {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            if (width <= 0 || height <= 0) {
                return null;
            }
            try {
                int offsetX = 0;
                int offsetY = 0;
                if (width > newWidth) {
                    offsetX = (width - newWidth) / 2;
                } else {
                    newWidth = width;
                }
                if (height > newHeight) {
                    offsetY = (height - newHeight) / 2;
                } else {
                    newHeight = height;
                }
                resizeBmp = Bitmap.createBitmap((Bitmap)bitmap, (int)offsetX, (int)offsetY, (int)newWidth, (int)newHeight);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (resizeBmp != bitmap) {
                bitmap.recycle();
            }
        }
        return resizeBmp;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)(drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565));
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    public static Drawable bitmapToDrawable(Bitmap bitmap) {
        BitmapDrawable mBitmapDrawable;
        block3: {
            mBitmapDrawable = null;
            if (bitmap != null) break block3;
            return null;
        }
        try {
            mBitmapDrawable = new BitmapDrawable(bitmap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBitmapDrawable;
    }

    public static TransitionDrawable bitmapToTransitionDrawable(Bitmap bitmap) {
        TransitionDrawable mBitmapDrawable;
        block3: {
            mBitmapDrawable = null;
            if (bitmap != null) break block3;
            return null;
        }
        try {
            mBitmapDrawable = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), new BitmapDrawable(bitmap)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBitmapDrawable;
    }

    public static TransitionDrawable drawableToTransitionDrawable(Drawable drawable) {
        TransitionDrawable mBitmapDrawable;
        block3: {
            mBitmapDrawable = null;
            if (drawable != null) break block3;
            return null;
        }
        try {
            mBitmapDrawable = new TransitionDrawable(new Drawable[]{new ColorDrawable(17170445), drawable});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBitmapDrawable;
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap, Bitmap.CompressFormat mCompressFormat, boolean needRecycle) {
        byte[] result;
        block13: {
            result = null;
            ByteArrayOutputStream output = null;
            try {
                try {
                    output = new ByteArrayOutputStream();
                    bitmap.compress(mCompressFormat, 100, (OutputStream)output);
                    result = output.toByteArray();
                    if (needRecycle) {
                        bitmap.recycle();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (output == null) break block13;
                    try {
                        output.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    public static int getByteCount(Bitmap bitmap, Bitmap.CompressFormat mCompressFormat) {
        int size;
        block12: {
            size = 0;
            ByteArrayOutputStream output = null;
            try {
                try {
                    output = new ByteArrayOutputStream();
                    bitmap.compress(mCompressFormat, 100, (OutputStream)output);
                    byte[] result = output.toByteArray();
                    size = result.length;
                    result = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (output == null) break block12;
                    try {
                        output.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return size;
    }

    public static Bitmap bytes2Bimap(byte[] b) {
        Bitmap bitmap = null;
        try {
            if (b.length != 0) {
                bitmap = BitmapFactory.decodeByteArray((byte[])b, (int)0, (int)b.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap imageView2Bitmap(ImageView view) {
        Bitmap bitmap = null;
        try {
            bitmap = Bitmap.createBitmap((Bitmap)view.getDrawingCache());
            view.setDrawingCacheEnabled(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Drawable view2Drawable(View view) {
        BitmapDrawable mBitmapDrawable = null;
        try {
            Bitmap newbmp = AbImageUtil.view2Bitmap(view);
            if (newbmp != null) {
                mBitmapDrawable = new BitmapDrawable(newbmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBitmapDrawable;
    }

    public static Bitmap view2Bitmap(View view) {
        Bitmap bitmap = null;
        try {
            if (view != null) {
                view.setDrawingCacheEnabled(true);
                view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
                view.buildDrawingCache();
                bitmap = view.getDrawingCache();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static byte[] view2Bytes(View view, Bitmap.CompressFormat compressFormat) {
        byte[] b = null;
        try {
            Bitmap bitmap = AbImageUtil.view2Bitmap(view);
            b = AbImageUtil.bitmap2Bytes(bitmap, compressFormat, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, float degrees) {
        Bitmap mBitmap = null;
        try {
            Matrix m = new Matrix();
            m.setRotate(degrees % 360.0f);
            mBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBitmap;
    }

    public static Bitmap rotateBitmapTranslate(Bitmap bitmap, float degrees) {
        Bitmap mBitmap = null;
        try {
            int height;
            int width;
            Matrix matrix = new Matrix();
            if (degrees / 90.0f % 2.0f != 0.0f) {
                width = bitmap.getWidth();
                height = bitmap.getHeight();
            } else {
                width = bitmap.getHeight();
                height = bitmap.getWidth();
            }
            int cx = width / 2;
            int cy = height / 2;
            matrix.preTranslate((float)(-cx), (float)(-cy));
            matrix.postRotate(degrees);
            matrix.postTranslate((float)cx, (float)cy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mBitmap;
    }

    public static Bitmap toRoundBitmap(Bitmap bitmap) {
        float dst_bottom;
        float dst_right;
        float dst_top;
        float dst_left;
        float right;
        float left;
        float bottom;
        float top;
        float roundPx;
        int height;
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        if (width <= (height = bitmap.getHeight())) {
            roundPx = width / 2;
            top = 0.0f;
            bottom = width;
            left = 0.0f;
            right = width;
            height = width;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = width;
            dst_bottom = width;
        } else {
            float clip;
            roundPx = height / 2;
            left = clip = (float)((width - height) / 2);
            right = (float)width - clip;
            top = 0.0f;
            bottom = height;
            width = height;
            dst_left = 0.0f;
            dst_top = 0.0f;
            dst_right = height;
            dst_bottom = height;
        }
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        Rect src = new Rect((int)left, (int)top, (int)right, (int)bottom);
        Rect dst = new Rect((int)dst_left, (int)dst_top, (int)dst_right, (int)dst_bottom);
        RectF rectF = new RectF(dst);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawRoundRect(rectF, roundPx, roundPx, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, src, dst, paint);
        return output;
    }

    public static Bitmap toReflectionBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        try {
            int reflectionGap = 1;
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.preScale(1.0f, -1.0f);
            Bitmap reflectionImage = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)(height / 2), (int)width, (int)(height / 2), (Matrix)matrix, (boolean)false);
            Bitmap bitmapWithReflection = Bitmap.createBitmap((int)width, (int)(height + height / 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmapWithReflection);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            Paint deafaultPaint = new Paint();
            canvas.drawRect(0.0f, (float)height, (float)width, (float)(height + reflectionGap), deafaultPaint);
            canvas.drawBitmap(reflectionImage, 0.0f, (float)(height + reflectionGap), null);
            Paint paint = new Paint();
            LinearGradient shader = new LinearGradient(0.0f, (float)bitmap.getHeight(), 0.0f, (float)(bitmapWithReflection.getHeight() + reflectionGap), 0x70FFFFFF, 0xFFFFFF, Shader.TileMode.CLAMP);
            paint.setShader((Shader)shader);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
            canvas.drawRect(0.0f, (float)height, (float)width, (float)(bitmapWithReflection.getHeight() + reflectionGap), paint);
            bitmap = bitmapWithReflection;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static void releaseBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            try {
                if (!bitmap.isRecycled()) {
                    if (D) {
                        Log.d((String)TAG, (String)("Bitmap\u91ca\u653e" + bitmap.toString()));
                    }
                    bitmap.recycle();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bitmap = null;
        }
    }

    public static void releaseBitmapArray(Bitmap[] bitmaps) {
        if (bitmaps != null) {
            try {
                Bitmap[] bitmapArray = bitmaps;
                int n = bitmaps.length;
                int n2 = 0;
                while (n2 < n) {
                    Bitmap bitmap = bitmapArray[n2];
                    if (bitmap != null && !bitmap.isRecycled()) {
                        if (D) {
                            Log.d((String)TAG, (String)("Bitmap\u91ca\u653e" + bitmap.toString()));
                        }
                        bitmap.recycle();
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getHashCode(Bitmap bitmap) {
        Bitmap temp = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)8, (int)8, (boolean)false);
        int width = temp.getWidth();
        int height = temp.getHeight();
        Log.i((String)"th", (String)("\u5c06\u56fe\u7247\u7f29\u5c0f\u52308x8\u7684\u5c3a\u5bf8:" + width + "*" + height));
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                pixels[i * height + j] = AbImageUtil.rgbToGray(temp.getPixel(i, j));
                ++j;
            }
            ++i;
        }
        AbImageUtil.releaseBitmap(temp);
        int avgPixel = AbMathUtil.average(pixels);
        int[] comps = new int[width * height];
        int i2 = 0;
        while (i2 < comps.length) {
            comps[i2] = pixels[i2] >= avgPixel ? 1 : 0;
            ++i2;
        }
        StringBuffer hashCode = new StringBuffer();
        int i3 = 0;
        while (i3 < comps.length) {
            int result = comps[i3] * (int)Math.pow(2.0, 3.0) + comps[i3 + 1] * (int)Math.pow(2.0, 2.0) + comps[i3 + 2] * (int)Math.pow(2.0, 1.0) + comps[i3 + 2];
            hashCode.append(AbMathUtil.binaryToHex(result));
            i3 += 4;
        }
        String sourceHashCode = hashCode.toString();
        return sourceHashCode;
    }

    public static String getDCTHashCode(Bitmap bitmap) {
        Bitmap temp = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)32, (int)32, (boolean)false);
        int width = temp.getWidth();
        int height = temp.getHeight();
        Log.i((String)"th", (String)("\u5c06\u56fe\u7247\u7f29\u5c0f\u523032x32\u7684\u5c3a\u5bf8:" + width + "*" + height));
        int[] pixels = new int[width * height];
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                pixels[i * height + j] = AbImageUtil.rgbToGray(temp.getPixel(i, j));
                ++j;
            }
            ++i;
        }
        AbImageUtil.releaseBitmap(temp);
        int[][] pxMatrix = AbMathUtil.arrayToMatrix(pixels, width, height);
        double[][] doublePxMatrix = AbMathUtil.intToDoubleMatrix(pxMatrix);
        double[][] dtc = FDCT.fDctTransform(doublePxMatrix);
        double[] dctResult = AbMathUtil.matrixToArray(dtc);
        int avgPixel = AbMathUtil.average(dctResult);
        int[] comps = new int[64];
        int i2 = 0;
        while (i2 < comps.length) {
            comps[i2] = dctResult[i2] >= (double)avgPixel ? 1 : 0;
            ++i2;
        }
        StringBuffer hashCode = new StringBuffer();
        int i3 = 0;
        while (i3 < comps.length) {
            int result = comps[i3] * (int)Math.pow(2.0, 3.0) + comps[i3 + 1] * (int)Math.pow(2.0, 2.0) + comps[i3 + 2] * (int)Math.pow(2.0, 1.0) + comps[i3 + 2];
            hashCode.append(AbMathUtil.binaryToHex(result));
            i3 += 4;
        }
        String sourceHashCode = hashCode.toString();
        return sourceHashCode;
    }

    public static int[] getColorHistogram(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] areaColor = new int[64];
        int i = 0;
        while (i < width) {
            int j = 0;
            while (j < height) {
                int index;
                int pixels = bitmap.getPixel(i, j);
                int alpha = pixels >> 24 & 0xFF;
                int red = pixels >> 16 & 0xFF;
                int green = pixels >> 8 & 0xFF;
                int blue = pixels & 0xFF;
                int redArea = 0;
                int greenArea = 0;
                int blueArea = 0;
                if (red >= 192) {
                    redArea = 3;
                } else if (red >= 128) {
                    redArea = 2;
                } else if (red >= 64) {
                    redArea = 1;
                } else if (red >= 0) {
                    redArea = 0;
                }
                if (green >= 192) {
                    greenArea = 3;
                } else if (green >= 128) {
                    greenArea = 2;
                } else if (green >= 64) {
                    greenArea = 1;
                } else if (green >= 0) {
                    greenArea = 0;
                }
                if (blue >= 192) {
                    blueArea = 3;
                } else if (blue >= 128) {
                    blueArea = 2;
                } else if (blue >= 64) {
                    blueArea = 1;
                } else if (blue >= 0) {
                    blueArea = 0;
                }
                int n = index = redArea * 16 + greenArea * 4 + blueArea;
                areaColor[n] = areaColor[n] + 1;
                ++j;
            }
            ++i;
        }
        return areaColor;
    }

    public static int hammingDistance(String sourceHashCode, String hashCode) {
        int difference = 0;
        int len = sourceHashCode.length();
        int i = 0;
        while (i < len) {
            if (sourceHashCode.charAt(i) != hashCode.charAt(i)) {
                ++difference;
            }
            ++i;
        }
        return difference;
    }

    private static int rgbToGray(int pixels) {
        int _red = pixels >> 16 & 0xFF;
        int _green = pixels >> 8 & 0xFF;
        int _blue = pixels & 0xFF;
        return (int)(0.3 * (double)_red + 0.59 * (double)_green + 0.11 * (double)_blue);
    }

    public static void main(String[] args) {
    }
}

