/*
 * Decompiled with CFR 0.152.
 */
package com.ab.util;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ListView;

public class AbViewUtil {
    public static void setAbsListViewHeight(AbsListView absListView, int lineNumber, int verticalSpace) {
        int totalHeight = AbViewUtil.getAbsListViewHeight(absListView, lineNumber, verticalSpace);
        ViewGroup.LayoutParams params = absListView.getLayoutParams();
        params.height = totalHeight;
        ((ViewGroup.MarginLayoutParams)params).setMargins(0, 0, 0, 0);
        absListView.setLayoutParams(params);
    }

    public static int getAbsListViewHeight(AbsListView absListView, int lineNumber, int verticalSpace) {
        int totalHeight = 0;
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        absListView.measure(w, h);
        ListAdapter mListAdapter = (ListAdapter)absListView.getAdapter();
        if (mListAdapter == null) {
            return totalHeight;
        }
        int count = mListAdapter.getCount();
        if (absListView instanceof ListView) {
            int i = 0;
            while (i < count) {
                View listItem = mListAdapter.getView(i, null, (ViewGroup)absListView);
                listItem.measure(w, h);
                totalHeight += listItem.getMeasuredHeight();
                ++i;
            }
            totalHeight = count == 0 ? verticalSpace : (totalHeight += ((ListView)absListView).getDividerHeight() * (count - 1));
        } else if (absListView instanceof GridView) {
            int remain = count % lineNumber;
            if (remain > 0) {
                remain = 1;
            }
            if (mListAdapter.getCount() == 0) {
                totalHeight = verticalSpace;
            } else {
                View listItem = mListAdapter.getView(0, null, (ViewGroup)absListView);
                listItem.measure(w, h);
                int line = count / lineNumber + remain;
                totalHeight = line * listItem.getMeasuredHeight() + (line - 1) * verticalSpace;
            }
        }
        return totalHeight;
    }

    public static void measureView(View v) {
        if (v == null) {
            return;
        }
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        v.measure(w, h);
    }

    public static int resizeTextSize(int screenWidth, int screenHeight, int textSize) {
        float ratio = 1.0f;
        try {
            float ratioWidth = (float)screenWidth / 480.0f;
            float ratioHeight = (float)screenHeight / 800.0f;
            ratio = Math.min(ratioWidth, ratioHeight);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Math.round((float)textSize * ratio);
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }
}

