/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.text.format.Time;
import android.view.View;
import java.util.List;
import java.util.TimeZone;

public class AbCalendar
extends View {
    private Time mCalendar;
    private Drawable mCaleBg;
    private Drawable mCaleDot;
    private Point mPosYear;
    private List<Drawable> dArrayYear;
    private Point mPosMonth;
    private List<Drawable> dArrayMonth;
    private Point mPosDate;
    private List<Drawable> dArrayDate;
    private Point mPosWeek;
    private List<Drawable> dArrayWeek;
    private int mBgWidth;
    private int mBgHeight;
    private float mDateTextSize;
    private final BroadcastReceiver dateChangedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                String tz = intent.getStringExtra("time-zone");
                AbCalendar.this.mCalendar = new Time(TimeZone.getTimeZone(tz).getID());
            }
            AbCalendar.this.invalidate();
        }
    };
    private boolean mAttached;

    public AbCalendar(Context context, Drawable caleBg, Drawable caleDot, Point posYear, List<Drawable> dYearArray, Point posMonth, List<Drawable> dMonthArray, Point posDate, List<Drawable> dDateArray, Point posWeek, List<Drawable> dWeekArray) {
        super(context);
        this.mCaleBg = caleBg;
        this.mCaleDot = caleDot;
        this.mPosYear = posYear;
        this.dArrayYear = dYearArray;
        this.mPosMonth = posMonth;
        this.dArrayMonth = dMonthArray;
        this.mPosDate = posDate;
        this.dArrayDate = dDateArray;
        this.mPosWeek = posWeek;
        this.dArrayWeek = dWeekArray;
        this.mBgWidth = this.mCaleBg.getIntrinsicWidth();
        this.mBgHeight = this.mCaleBg.getIntrinsicHeight();
        this.mCalendar = new Time();
        this.mDateTextSize = 14.0f;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            IntentFilter intentFilter = new IntentFilter("android.intent.action.DATE_CHANGED");
            this.getContext().registerReceiver(this.dateChangedReceiver, intentFilter);
        }
        this.mCalendar = new Time();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.mAttached = false;
            this.getContext().unregisterReceiver(this.dateChangedReceiver);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float hScale = 1.0f;
        float vScale = 1.0f;
        if (widthMode != 0 && widthSize < this.mBgWidth) {
            hScale = (float)widthSize / (float)this.mBgWidth;
        }
        if (heightMode != 0 && heightSize < this.mBgHeight) {
            vScale = (float)heightSize / (float)this.mBgHeight;
        }
        float scale = Math.min(hScale, vScale);
        this.setMeasuredDimension(this.mBgWidth * (int)scale, this.mBgHeight * (int)scale);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int availableWidth = this.getRight() - this.getLeft();
        int availableHeight = this.getBottom() - this.getTop();
        int x = availableWidth / 2;
        int y = availableHeight / 2;
        Drawable bg = this.mCaleBg;
        int w = bg.getIntrinsicWidth();
        int h = bg.getIntrinsicHeight();
        boolean scaled = false;
        if (availableWidth < w || availableHeight < h) {
            scaled = true;
            float scale = Math.min((float)availableWidth / (float)w, (float)availableHeight / (float)h);
            canvas.save();
            canvas.scale(scale, scale, (float)x, (float)y);
        }
        bg.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        bg.draw(canvas);
        canvas.save();
        this.mCalendar.setToNow();
        if (!this.dArrayYear.isEmpty() && this.dArrayYear.size() > 0 || !this.dArrayMonth.isEmpty() && this.dArrayMonth.size() > 0 || !this.dArrayDate.isEmpty() && this.dArrayDate.size() > 0 || !this.dArrayWeek.isEmpty() && this.dArrayWeek.size() > 0) {
            int bmpW;
            int dotH;
            int dotW;
            int bmpH;
            int bmpW2;
            int pos;
            if (!this.dArrayYear.isEmpty() && this.dArrayYear.size() > 0) {
                String sYear = String.format("%04d", this.mCalendar.year);
                pos = Integer.parseInt(sYear.substring(0, 1));
                Drawable dBmpYear = this.dArrayYear.get(pos);
                bmpW2 = dBmpYear.getIntrinsicWidth();
                bmpH = dBmpYear.getIntrinsicHeight();
                dBmpYear.setBounds(x - w / 2 + this.mPosYear.x, y - h / 2 + this.mPosYear.y, x - w / 2 + this.mPosYear.x + bmpW2, y - h / 2 + this.mPosYear.y + bmpH);
                dBmpYear.draw(canvas);
                pos = Integer.parseInt(sYear.substring(1, 2));
                dBmpYear = this.dArrayYear.get(pos);
                dBmpYear.setBounds(x - w / 2 + this.mPosYear.x + bmpW2, y - h / 2 + this.mPosYear.y, x - w / 2 + this.mPosYear.x + 2 * bmpW2, y - h / 2 + this.mPosYear.y + bmpH);
                dBmpYear.draw(canvas);
                pos = Integer.parseInt(sYear.substring(2, 3));
                dBmpYear = this.dArrayYear.get(pos);
                dBmpYear.setBounds(x - w / 2 + this.mPosYear.x + 2 * bmpW2, y - h / 2 + this.mPosYear.y, x - w / 2 + this.mPosYear.x + 3 * bmpW2, y - h / 2 + this.mPosYear.y + bmpH);
                dBmpYear.draw(canvas);
                pos = Integer.parseInt(sYear.substring(3, 4));
                dBmpYear = this.dArrayYear.get(pos);
                dBmpYear.setBounds(x - w / 2 + this.mPosYear.x + 3 * bmpW2, y - h / 2 + this.mPosYear.y, x - w / 2 + this.mPosYear.x + 4 * bmpW2, y - h / 2 + this.mPosYear.y + bmpH);
                dBmpYear.draw(canvas);
                if (this.mCaleDot != null && this.mPosYear.y == this.mPosMonth.y) {
                    dotW = this.mCaleDot.getIntrinsicWidth();
                    dotH = this.mCaleDot.getIntrinsicHeight();
                    if (dotH < bmpW2) {
                        this.mCaleDot.setBounds(x - w / 2 + this.mPosYear.x + 4 * bmpW2, y - h / 2 + this.mPosYear.y + (bmpH - dotH) / 2, x - w / 2 + this.mPosYear.x + 4 * bmpW2 + dotW, y - h / 2 + this.mPosYear.y + (bmpH - dotH) / 2 + dotH);
                    } else {
                        this.mCaleDot.setBounds(x - w / 2 + this.mPosYear.x + 4 * bmpW2, y - h / 2 + this.mPosYear.y, x - w / 2 + this.mPosYear.x + 4 * bmpW2 + dotW, y - h / 2 + this.mPosYear.y + dotH);
                    }
                    this.mCaleDot.draw(canvas);
                }
            }
            if (!this.dArrayMonth.isEmpty() && this.dArrayMonth.size() > 0) {
                if (this.dArrayMonth.size() > 10) {
                    Drawable dBmpMonth = this.dArrayMonth.get(this.mCalendar.month);
                    bmpW = dBmpMonth.getIntrinsicWidth();
                    int bmpH2 = dBmpMonth.getIntrinsicHeight();
                    dBmpMonth.setBounds(x - w / 2 + this.mPosMonth.x, y - h / 2 + this.mPosMonth.y, x - w / 2 + this.mPosMonth.x + bmpW, y - h / 2 + this.mPosMonth.y + bmpH2);
                    dBmpMonth.draw(canvas);
                } else {
                    String sMonth = String.format("%02d", this.mCalendar.month + 1);
                    pos = Integer.parseInt(sMonth.substring(0, 1));
                    Drawable dBmpMonth = this.dArrayMonth.get(pos);
                    bmpW2 = dBmpMonth.getIntrinsicWidth();
                    bmpH = dBmpMonth.getIntrinsicHeight();
                    dBmpMonth.setBounds(x - w / 2 + this.mPosMonth.x, y - h / 2 + this.mPosMonth.y, x - w / 2 + this.mPosMonth.x + bmpW2, y - h / 2 + this.mPosMonth.y + bmpH);
                    dBmpMonth.draw(canvas);
                    pos = Integer.parseInt(sMonth.substring(1, 2));
                    dBmpMonth = this.dArrayMonth.get(pos);
                    dBmpMonth.setBounds(x - w / 2 + this.mPosMonth.x + bmpW2, y - h / 2 + this.mPosMonth.y, x - w / 2 + this.mPosMonth.x + 2 * bmpW2, y - h / 2 + this.mPosMonth.y + bmpH);
                    dBmpMonth.draw(canvas);
                    if (this.mCaleDot != null && this.mPosMonth.y == this.mPosDate.y) {
                        dotW = this.mCaleDot.getIntrinsicWidth();
                        dotH = this.mCaleDot.getIntrinsicHeight();
                        if (dotH < bmpW2) {
                            this.mCaleDot.setBounds(x - w / 2 + this.mPosMonth.x + 2 * bmpW2, y - h / 2 + this.mPosMonth.y + (bmpH - dotH) / 2, x - w / 2 + this.mPosMonth.x + 2 * bmpW2 + dotW, y - h / 2 + this.mPosMonth.y + (bmpH - dotH) / 2 + dotH);
                        } else {
                            this.mCaleDot.setBounds(x - w / 2 + this.mPosMonth.x + 2 * bmpW2, y - h / 2 + this.mPosMonth.y, x - w / 2 + this.mPosMonth.x + 2 * bmpW2 + dotW, y - h / 2 + this.mPosMonth.y + dotH);
                        }
                        this.mCaleDot.draw(canvas);
                    }
                }
            }
            if (!this.dArrayDate.isEmpty() && this.dArrayDate.size() > 0) {
                String sDate = String.format("%02d", this.mCalendar.monthDay);
                pos = Integer.parseInt(sDate.substring(0, 1));
                Drawable dBmpDate = this.dArrayDate.get(pos);
                bmpW2 = dBmpDate.getIntrinsicWidth();
                bmpH = dBmpDate.getIntrinsicHeight();
                dBmpDate.setBounds(x - w / 2 + this.mPosDate.x, y - h / 2 + this.mPosDate.y, x - w / 2 + this.mPosDate.x + bmpW2, y - h / 2 + this.mPosDate.y + bmpH);
                dBmpDate.draw(canvas);
                pos = Integer.parseInt(sDate.substring(1, 2));
                dBmpDate = this.dArrayDate.get(pos);
                dBmpDate.setBounds(x - w / 2 + this.mPosDate.x + bmpW2, y - h / 2 + this.mPosDate.y, x - w / 2 + this.mPosDate.x + 2 * bmpW2, y - h / 2 + this.mPosDate.y + bmpH);
                dBmpDate.draw(canvas);
            }
            if (!this.dArrayWeek.isEmpty() && this.dArrayWeek.size() > 0) {
                Drawable dBmpWeek = this.dArrayWeek.get(this.mCalendar.weekDay);
                bmpW = dBmpWeek.getIntrinsicWidth();
                int bmpH3 = dBmpWeek.getIntrinsicHeight();
                dBmpWeek.setBounds(x - w / 2 + this.mPosWeek.x, y - h / 2 + this.mPosWeek.y, x - w / 2 + this.mPosWeek.x + bmpW, y - h / 2 + this.mPosWeek.y + bmpH3);
                dBmpWeek.draw(canvas);
            }
        } else {
            Paint textPaint = new Paint(1);
            String day = String.format("%02d", this.mCalendar.monthDay);
            textPaint.setTextAlign(Paint.Align.CENTER);
            textPaint.setTextSize(this.mDateTextSize);
            textPaint.setColor(-16777216);
            int width = this.getWidth();
            int height = this.getHeight();
            Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
            float fontHeight = fontMetrics.bottom - fontMetrics.top;
            float pos_x = width / 2;
            float pos_y = (float)height - ((float)height - fontHeight) / 2.0f - fontMetrics.bottom;
            canvas.drawText(day, pos_x, pos_y, textPaint);
        }
        if (scaled) {
            canvas.restore();
        }
    }

    public float getDateTextSize() {
        return this.mDateTextSize;
    }

    public void setDateTextSize(float dateTextSize) {
        this.mDateTextSize = dateTextSize;
    }
}

