/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.app;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;

public class AbCompassView
extends View {
    private Drawable mCompassDrawable = null;
    private int w = 40;
    private int h = 40;
    private float mDirection = 0.0f;
    private float posCompassX = 20.0f;
    private float posCompassY = 20.0f;

    public AbCompassView(Context context) {
        super(context);
    }

    public AbCompassView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onDraw(Canvas canvas) {
        this.w = canvas.getWidth();
        this.h = canvas.getHeight();
        this.posCompassX = this.w / 2;
        this.posCompassY = this.h / 2;
        this.drawPictures(canvas);
    }

    private void drawPictures(Canvas canvas) {
        if (this.mCompassDrawable != null) {
            this.mCompassDrawable.setBounds(0, 0, this.w, this.h);
            canvas.save();
            canvas.rotate(this.mDirection, this.posCompassX, this.posCompassY);
            this.mCompassDrawable.draw(canvas);
            canvas.restore();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    public float getDirection() {
        return this.mDirection;
    }

    public void setDirection(float direction) {
        this.mDirection = direction;
        this.invalidate();
    }

    public void setCompassDrawable(Drawable drawable) {
        this.mCompassDrawable = drawable;
    }
}

