/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.calendar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import com.ab.view.listener.AbOnItemClickListener;
import java.util.Calendar;

public class CalendarCell
extends View {
    private int textSize = 22;
    private AbOnItemClickListener mOnItemClickListener;
    private Paint pt = new Paint();
    private RectF rect = new RectF();
    private String textDateValue = "";
    private int iDateYear = 0;
    private int iDateMonth = 0;
    private int iDateDay = 0;
    private boolean isSelected = false;
    private boolean isActiveMonth = false;
    private boolean isToday = false;
    private boolean bTouchedDown = false;
    private boolean isHoliday = false;
    private boolean hasRecord = false;
    private int position = 0;
    public static int ANIM_ALPHA_DURATION = 100;
    private int selectCellColor = Color.rgb((int)150, (int)195, (int)70);
    private int bgColor = Color.rgb((int)163, (int)163, (int)163);
    private int numberColor = Color.rgb((int)86, (int)86, (int)86);
    private int cellColor = -1;
    private int notActiveMonthColor = Color.rgb((int)178, (int)178, (int)178);
    private int todayColor = Color.rgb((int)150, (int)200, (int)220);

    public CalendarCell(Context context, int position, int iWidth, int iHeight) {
        super(context);
        this.setFocusable(true);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(iWidth, iHeight));
        this.position = position;
    }

    public Calendar getThisCellDate() {
        Calendar calDate = Calendar.getInstance();
        calDate.clear();
        calDate.set(1, this.iDateYear);
        calDate.set(2, this.iDateMonth);
        calDate.set(5, this.iDateDay);
        return calDate;
    }

    public void setThisCellDate(int iYear, int iMonth, int iDay, Boolean isToday, Boolean isSelected, Boolean isHoliday, int isActiveMonth, boolean hasRecord) {
        this.iDateYear = iYear;
        this.iDateMonth = iMonth;
        this.iDateDay = iDay;
        this.textDateValue = Integer.toString(this.iDateDay);
        this.isActiveMonth = this.iDateMonth == isActiveMonth;
        this.isToday = isToday;
        this.isHoliday = isHoliday;
        this.hasRecord = hasRecord;
        this.isSelected = isSelected;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(this.bgColor);
        this.rect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.rect.inset(0.5f, 0.5f);
        boolean bFocused = this.IsViewFocused();
        this.drawDayView(canvas, bFocused);
        this.drawDayNumber(canvas);
    }

    public boolean IsViewFocused() {
        return this.isFocused() || this.bTouchedDown;
    }

    private void drawDayView(Canvas canvas, boolean bFocused) {
        this.pt.setColor(this.getCellColor());
        canvas.drawRect(this.rect, this.pt);
        if (this.hasRecord) {
            this.createReminder(canvas, -65536);
        }
    }

    public void drawDayNumber(Canvas canvas) {
        this.pt.setTypeface(null);
        this.pt.setAntiAlias(true);
        this.pt.setShader(null);
        this.pt.setFakeBoldText(true);
        this.pt.setTextSize((float)this.textSize);
        this.pt.setColor(this.numberColor);
        this.pt.setUnderlineText(false);
        if (!this.isActiveMonth) {
            this.pt.setColor(this.notActiveMonthColor);
        }
        int iPosX = (int)this.rect.left + ((int)this.rect.width() >> 1) - ((int)this.pt.measureText(this.textDateValue) >> 1);
        int iPosY = (int)((float)(this.getHeight() - (this.getHeight() - this.getTextHeight()) / 2) - this.pt.getFontMetrics().bottom);
        canvas.drawText(this.textDateValue, (float)iPosX, (float)iPosY, this.pt);
    }

    private int getTextHeight() {
        return (int)(-this.pt.ascent() + this.pt.descent());
    }

    public int getCellColor() {
        if (this.isToday) {
            return this.todayColor;
        }
        if (this.isSelected) {
            return this.selectCellColor;
        }
        if (this.isHoliday) {
            return this.cellColor;
        }
        return this.cellColor;
    }

    public void setSelected(boolean selected) {
        if (this.isSelected != selected) {
            this.isSelected = selected;
            this.invalidate();
        }
    }

    public void setHasRecord(boolean hasRecord) {
        if (this.hasRecord != hasRecord) {
            this.hasRecord = hasRecord;
            this.invalidate();
        }
    }

    public void setOnItemClickListener(AbOnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void doItemClick() {
        if (this.mOnItemClickListener != null) {
            this.mOnItemClickListener.onClick(this.position);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean bHandled = false;
        if (event.getAction() == 0) {
            bHandled = true;
            this.bTouchedDown = true;
            this.invalidate();
            CalendarCell.startAlphaAnimIn(this);
        }
        if (event.getAction() == 3) {
            bHandled = true;
            this.bTouchedDown = false;
            this.invalidate();
        }
        if (event.getAction() == 1) {
            bHandled = true;
            this.bTouchedDown = false;
            this.invalidate();
            this.doItemClick();
        }
        return bHandled;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean bResult = super.onKeyDown(keyCode, event);
        if (keyCode == 23 || keyCode == 66) {
            this.doItemClick();
        }
        return bResult;
    }

    public static void startAlphaAnimIn(View view) {
        AlphaAnimation anim = new AlphaAnimation(0.5f, 1.0f);
        anim.setDuration((long)ANIM_ALPHA_DURATION);
        anim.startNow();
        view.startAnimation((Animation)anim);
    }

    public void createReminder(Canvas canvas, int Color2) {
        this.pt.setUnderlineText(true);
        this.pt.setStyle(Paint.Style.FILL_AND_STROKE);
        this.pt.setColor(Color2);
        Path path = new Path();
        path.moveTo(this.rect.right - this.rect.width() / 4.0f, this.rect.top);
        path.lineTo(this.rect.right, this.rect.top);
        path.lineTo(this.rect.right, this.rect.top + this.rect.width() / 4.0f);
        path.lineTo(this.rect.right - this.rect.width() / 4.0f, this.rect.top);
        path.close();
        canvas.drawPath(path, this.pt);
        this.pt.setUnderlineText(true);
    }

    public boolean isActiveMonth() {
        return this.isActiveMonth;
    }
}

