/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.calendar;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.ab.view.calendar.CalendarCell;
import com.ab.view.calendar.CalendarHeader;
import com.ab.view.listener.AbOnItemClickListener;
import java.util.ArrayList;
import java.util.Calendar;

public class CalendarView
extends LinearLayout {
    private String TAG = "CalendarView";
    private Context context;
    private LinearLayout.LayoutParams layoutParamsFW = null;
    private LinearLayout mLinearLayoutHeader = null;
    private LinearLayout mLinearLayoutContent = null;
    private CalendarHeader mCalendarHeader = null;
    private int width = 320;
    private int height = 480;
    private int headerHeight = 45;
    private int rowHeight = 40;
    private int cellWidth = 40;
    public static Calendar calStartDate = Calendar.getInstance();
    private Calendar calToday = Calendar.getInstance();
    private Calendar calSelected = null;
    private Calendar calCalendar = Calendar.getInstance();
    private int currentMonth = 0;
    private int currentYear = 0;
    private int firstDayOfWeek = 1;
    private ArrayList<CalendarCell> mCalendarCells = new ArrayList();
    private AbOnItemClickListener mOnItemClickListener;
    private AbOnItemClickListener mOnDayCellClick = new AbOnItemClickListener(){

        @Override
        public void onClick(int position) {
            CalendarCell mCalendarCell = (CalendarCell)((Object)CalendarView.this.mCalendarCells.get(position));
            if (mCalendarCell.isActiveMonth()) {
                CalendarView.this.calSelected.setTimeInMillis(mCalendarCell.getThisCellDate().getTimeInMillis());
                int i = 0;
                while (i < CalendarView.this.mCalendarCells.size()) {
                    CalendarCell mCalendarCellOther = (CalendarCell)((Object)CalendarView.this.mCalendarCells.get(i));
                    mCalendarCellOther.setSelected(false);
                    ++i;
                }
                mCalendarCell.setSelected(true);
                if (CalendarView.this.mOnItemClickListener != null) {
                    CalendarView.this.mOnItemClickListener.onClick(position);
                }
            }
        }
    };

    public CalendarView(Context context) {
        this(context, null);
    }

    public CalendarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.layoutParamsFW = new LinearLayout.LayoutParams(-1, -2);
        this.setOrientation(1);
        this.setBackgroundColor(Color.rgb((int)255, (int)255, (int)255));
        WindowManager wManager = (WindowManager)context.getSystemService("window");
        Display display = wManager.getDefaultDisplay();
        this.width = display.getWidth();
        this.height = display.getHeight();
        this.mLinearLayoutHeader = new LinearLayout(context);
        this.mLinearLayoutHeader.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.width, this.headerHeight));
        this.mLinearLayoutHeader.setOrientation(1);
        this.mCalendarHeader = new CalendarHeader(context);
        this.mCalendarHeader.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.width, this.headerHeight));
        this.mLinearLayoutHeader.addView((View)this.mCalendarHeader, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.addView((View)this.mLinearLayoutHeader);
        this.mLinearLayoutContent = new LinearLayout(context);
        this.mLinearLayoutContent.setOrientation(1);
        this.addView((View)this.mLinearLayoutContent);
        this.rowHeight = this.cellWidth = (this.width - 20) / 7;
        this.calSelected = Calendar.getInstance();
        this.initRow();
        this.initStartDateForMonth();
        this.initCalendar();
    }

    public void initRow() {
        this.mLinearLayoutContent.removeAllViews();
        this.mCalendarCells.clear();
        int iRow = 0;
        while (iRow < 6) {
            LinearLayout mLinearLayoutRow = new LinearLayout(this.context);
            mLinearLayoutRow.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.width, this.rowHeight));
            mLinearLayoutRow.setOrientation(0);
            int iDay = 0;
            while (iDay < 7) {
                CalendarCell dayCell = new CalendarCell(this.context, iRow * 7 + iDay, this.cellWidth, this.rowHeight);
                dayCell.setOnItemClickListener(this.mOnDayCellClick);
                mLinearLayoutRow.addView((View)dayCell);
                this.mCalendarCells.add(dayCell);
                ++iDay;
            }
            this.mLinearLayoutContent.addView((View)mLinearLayoutRow);
            ++iRow;
        }
    }

    private void initStartDateForMonth() {
        calStartDate.setTimeInMillis(this.calSelected.getTimeInMillis());
        this.currentMonth = calStartDate.get(2);
        this.currentYear = calStartDate.get(1);
        calStartDate.set(5, 1);
        calStartDate.set(11, 0);
        calStartDate.set(12, 0);
        calStartDate.set(13, 0);
        int iDay = 0;
        int iStartDay = this.firstDayOfWeek;
        if (iStartDay == 2 && (iDay = calStartDate.get(7) - 2) < 0) {
            iDay = 6;
        }
        if (iStartDay == 1 && (iDay = calStartDate.get(7) - 1) < 0) {
            iDay = 6;
        }
        calStartDate.add(7, -iDay);
    }

    private void updateCalendar() {
        boolean bIsSelection = this.calSelected.getTimeInMillis() != 0L;
        int iSelectedYear = this.calSelected.get(1);
        int iSelectedMonth = this.calSelected.get(2);
        int iSelectedDay = this.calSelected.get(5);
        boolean isThisMonth = false;
        if (this.calToday.get(1) == iSelectedYear && this.calToday.get(2) == iSelectedMonth) {
            isThisMonth = true;
        }
        this.calCalendar.setTimeInMillis(calStartDate.getTimeInMillis());
        int i = 0;
        while (i < this.mCalendarCells.size()) {
            CalendarCell dayCell = this.mCalendarCells.get(i);
            int iYear = this.calCalendar.get(1);
            int iMonth = this.calCalendar.get(2);
            int iDay = this.calCalendar.get(5);
            int iDayOfWeek = this.calCalendar.get(7);
            boolean bToday = false;
            boolean bSelected = false;
            boolean bHoliday = false;
            boolean hasRecord = false;
            if (this.calToday.get(1) == iYear && this.calToday.get(2) == iMonth && this.calToday.get(5) == iDay) {
                bToday = true;
            }
            if (iDayOfWeek == 7 || iDayOfWeek == 1) {
                bHoliday = true;
            }
            if (iMonth == 0 && iDay == 1) {
                bHoliday = true;
            }
            if (bIsSelection) {
                bSelected = iSelectedDay == iDay && iSelectedMonth == iMonth && iSelectedYear == iYear;
            }
            if (iDay == 1 && isThisMonth) {
                bSelected = false;
            }
            dayCell.setThisCellDate(iYear, iMonth, iDay, bToday, bSelected, bHoliday, this.currentMonth, hasRecord);
            this.calCalendar.add(5, 1);
            ++i;
        }
        this.invalidate();
    }

    private void initCalendar() {
        boolean bIsSelection = this.calSelected.getTimeInMillis() != 0L;
        int iSelectedYear = this.calSelected.get(1);
        int iSelectedMonth = this.calSelected.get(2);
        int iSelectedDay = this.calSelected.get(5);
        this.calCalendar.setTimeInMillis(calStartDate.getTimeInMillis());
        int i = 0;
        while (i < this.mCalendarCells.size()) {
            CalendarCell dayCell = this.mCalendarCells.get(i);
            int iYear = this.calCalendar.get(1);
            int iMonth = this.calCalendar.get(2);
            int iDay = this.calCalendar.get(5);
            int iDayOfWeek = this.calCalendar.get(7);
            boolean bToday = false;
            boolean bSelected = false;
            boolean bHoliday = false;
            if (this.calToday.get(1) == iYear && this.calToday.get(2) == iMonth && this.calToday.get(5) == iDay) {
                bToday = true;
            }
            if (iDayOfWeek == 7 || iDayOfWeek == 1) {
                bHoliday = true;
            }
            if (iMonth == 0 && iDay == 1) {
                bHoliday = true;
            }
            if (bIsSelection) {
                bSelected = iSelectedDay == iDay && iSelectedMonth == iMonth && iSelectedYear == iYear;
            }
            dayCell.setThisCellDate(iYear, iMonth, iDay, bToday, bSelected, bHoliday, this.currentMonth, false);
            this.calCalendar.add(5, 1);
            ++i;
        }
        this.invalidate();
    }

    public void setOnItemClickListener(AbOnItemClickListener mAbOnItemClickListener) {
        this.mOnItemClickListener = mAbOnItemClickListener;
    }

    public void setHeaderHeight(int height) {
        this.headerHeight = height;
        this.mLinearLayoutHeader.removeAllViews();
        this.mCalendarHeader.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.width, this.headerHeight));
        this.mLinearLayoutHeader.addView((View)this.mCalendarHeader, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.invalidate();
    }

    public void setHeaderTextSize(int size) {
        this.mCalendarHeader.setTextSize(size);
        this.invalidate();
    }

    public void rebuildCalendar(Calendar calendar) {
        this.calSelected.setTimeInMillis(calendar.getTimeInMillis());
        this.initRow();
        this.initStartDateForMonth();
        this.updateCalendar();
    }

    public void setHeaderBackgroundResource(int resid) {
        this.mCalendarHeader.setHeaderBackgroundResource(resid);
    }

    public String getStrDateAtPosition(int position) {
        CalendarCell mCalendarCell = this.mCalendarCells.get(position);
        Calendar calendar = mCalendarCell.getThisCellDate();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        return String.valueOf(year) + "-" + month + "-" + day;
    }

    public int getCalendarCellSize() {
        return this.mCalendarCells.size();
    }

    public ArrayList<CalendarCell> getCalendarCells() {
        return this.mCalendarCells;
    }

    public String getCalSelected() {
        int iYear = this.calSelected.get(1);
        int iMonth = this.calSelected.get(2) + 1;
        int iDay = this.calSelected.get(5);
        return String.valueOf(iYear) + "-" + iMonth + "-" + iDay;
    }
}

