/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.carousel;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.ab.util.AbImageUtil;
import com.ab.view.carousel.CarouselItemImage;
import java.util.List;

public class CarouselImageAdapter
extends BaseAdapter {
    private Context mContext;
    private List<Drawable> mDrawables;
    private boolean mReflected = true;
    private CarouselItemImage[] mCarouselImageViews = null;

    public CarouselImageAdapter(Context c, List<Drawable> drawables, boolean reflected) {
        this.mContext = c;
        this.mDrawables = drawables;
        this.mReflected = reflected;
        this.setImages();
    }

    public int getCount() {
        if (this.mDrawables == null) {
            return 0;
        }
        return this.mDrawables.size();
    }

    public Object getItem(int position) {
        return position;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.mCarouselImageViews[position];
    }

    public void setImages() {
        this.mCarouselImageViews = new CarouselItemImage[this.mDrawables.size()];
        int i = 0;
        while (i < this.mDrawables.size()) {
            Drawable drawable = this.mDrawables.get(i);
            Bitmap originalImage = ((BitmapDrawable)drawable).getBitmap();
            if (this.mReflected) {
                originalImage = AbImageUtil.toReflectionBitmap(originalImage);
            }
            CarouselItemImage imageView = new CarouselItemImage(this.mContext);
            imageView.setImageBitmap(originalImage);
            imageView.setIndex(i);
            this.mCarouselImageViews[i] = imageView;
            ++i;
        }
    }
}

