/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.carousel;

import android.content.Context;
import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.view.ContextMenu;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Transformation;
import com.ab.view.carousel.CarouselAdapter;
import com.ab.view.carousel.CarouselItemImage;
import com.ab.view.carousel.CarouselSpinner;
import com.ab.view.carousel.Rotator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CarouselImageView
extends CarouselSpinner
implements GestureDetector.OnGestureListener {
    private static final String TAG = CarouselImageView.class.getSimpleName();
    private static final boolean localLOGV = false;
    private static final int MIN_QUANTITY = 3;
    private static final int MAX_QUANTITY = 12;
    private static final float MAX_THETA = 15.0f;
    private static final int SCROLL_TO_FLING_UNCERTAINTY_TIMEOUT = 250;
    private CarouselAdapter.AdapterContextMenuInfo mContextMenuInfo;
    private int mAnimationDuration = 900;
    private Camera mCamera = new Camera();
    private Runnable mDisableSuppressSelectionChangedRunnable = new Runnable(){

        @Override
        public void run() {
            CarouselImageView.this.mSuppressSelectionChanged = false;
            CarouselImageView.this.selectionChanged();
        }
    };
    private int mDownTouchPosition;
    private View mDownTouchView;
    private FlingRotateRunnable mFlingRunnable = new FlingRotateRunnable();
    private GestureDetector mGestureDetector;
    private int mGravity;
    private boolean mIsFirstScroll;
    private int mMaxQuantity = 12;
    private int mMinQuantity = 3;
    private boolean mReceivedInvokeKeyDown;
    private View mSelectedChild;
    private boolean mShouldCallbackDuringFling = true;
    private boolean mShouldCallbackOnUnselectedItemClick = true;
    private boolean mShouldStopFling;
    private boolean mSuppressSelectionChanged;
    private float mTheta = 0.2617994f;
    private boolean mUseReflection;

    public CarouselImageView(Context context) {
        this(context, null);
    }

    public CarouselImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CarouselImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setChildrenDrawingOrderEnabled(true);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this);
        this.mGestureDetector.setIsLongpressEnabled(true);
        this.setStaticTransformationsEnabled(true);
        this.mAnimationDuration = 400;
        this.mUseReflection = false;
        int selectedItem = 0;
        this.setNextSelectedPositionInt(selectedItem);
    }

    protected int computeHorizontalScrollExtent() {
        return 1;
    }

    protected int computeHorizontalScrollOffset() {
        return this.mSelectedPosition;
    }

    protected int computeHorizontalScrollRange() {
        return this.mItemCount;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.mGestureDetector.onTouchEvent(event);
        int action = event.getAction();
        if (action == 1) {
            this.onUp();
        } else if (action == 3) {
            this.onCancel();
        }
        return retValue;
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenu() {
        if (this.isPressed() && this.mSelectedPosition >= 0) {
            int index = this.mSelectedPosition - this.mFirstPosition;
            View v = this.getChildAt(index);
            return this.dispatchLongPress(v, this.mSelectedPosition, this.mSelectedRowId);
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 21: {
                this.playSoundEffect(1);
                return true;
            }
            case 22: {
                this.playSoundEffect(3);
                return true;
            }
            case 23: 
            case 66: {
                this.mReceivedInvokeKeyDown = true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (this.mReceivedInvokeKeyDown && this.mItemCount > 0) {
                    this.dispatchPress(this.mSelectedChild);
                    this.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CarouselImageView.this.dispatchUnpress();
                        }
                    }, ViewConfiguration.getPressedStateDuration());
                    int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
                    this.performItemClick(this.getChildAt(selectedIndex), this.mSelectedPosition, this.mAdapter.getItemId(this.mSelectedPosition));
                }
                this.mReceivedInvokeKeyDown = false;
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedChild != null) {
            this.mSelectedChild.requestFocus(direction);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.LayoutParams(this.getContext(), attrs);
    }

    public void dispatchSetSelected(boolean selected) {
    }

    protected void dispatchSetPressed(boolean pressed) {
        if (this.mSelectedChild != null) {
            this.mSelectedChild.setPressed(pressed);
        }
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition < 0) {
            return false;
        }
        long longPressId = this.mAdapter.getItemId(longPressPosition);
        return this.dispatchLongPress(originalView, longPressPosition, longPressId);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return event.dispatch((KeyEvent.Callback)this, null, null);
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        ArrayList<CarouselItemImage> sl = new ArrayList<CarouselItemImage>();
        int j = 0;
        while (j < childCount) {
            CarouselItemImage view = (CarouselItemImage)this.getAdapter().getView(j, null, null);
            if (i == 0) {
                view.setDrawn(false);
            }
            sl.add((CarouselItemImage)this.getAdapter().getView(j, null, null));
            ++j;
        }
        Collections.sort(sl);
        int idx = 0;
        for (CarouselItemImage civ : sl) {
            if (civ.isDrawn()) continue;
            civ.setDrawn(true);
            idx = civ.getIndex();
            break;
        }
        return idx;
    }

    protected boolean getChildStaticTransformation(View child, Transformation transformation) {
        transformation.clear();
        transformation.setTransformationType(Transformation.TYPE_MATRIX);
        float centerX = (float)this.getWidth() / 2.0f;
        float centerY = (float)this.getHeight() / 2.0f;
        this.mCamera.save();
        Matrix matrix = transformation.getMatrix();
        this.mCamera.translate(((CarouselItemImage)child).getItemX(), ((CarouselItemImage)child).getItemY(), ((CarouselItemImage)child).getItemZ());
        this.mCamera.getMatrix(matrix);
        matrix.preTranslate(-centerX, -centerY);
        matrix.postTranslate(centerX, centerY);
        float[] values = new float[9];
        matrix.getValues(values);
        this.mCamera.restore();
        Matrix mm = new Matrix();
        mm.setValues(values);
        ((CarouselItemImage)child).setCIMatrix(mm);
        child.invalidate();
        return true;
    }

    @Override
    void layout(int delta, boolean animate) {
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.getCount() == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.detachAllViewsFromParent();
        int count = this.getAdapter().getCount();
        float angleUnit = 360.0f / (float)count;
        float angleOffset = (float)this.mSelectedPosition * angleUnit;
        int i = 0;
        while (i < this.getAdapter().getCount()) {
            float angle = angleUnit * (float)i - angleOffset;
            if (angle < 0.0f) {
                angle += 360.0f;
            }
            this.makeAndAddView(i, angle);
            ++i;
        }
        this.mRecycler.clear();
        this.invalidate();
        this.setNextSelectedPositionInt(this.mSelectedPosition);
        this.checkSelectionChanged();
        this.mNeedSync = false;
        this.updateSelectedItemMetadata();
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    void selectionChanged() {
        if (!this.mSuppressSelectionChanged) {
            super.selectionChanged();
        }
    }

    @Override
    void setSelectedPositionInt(int position) {
        super.setSelectedPositionInt(position);
        super.setNextSelectedPositionInt(position);
        this.updateSelectedItemMetadata();
    }

    public boolean onDown(MotionEvent e) {
        this.mFlingRunnable.stop(false);
        this.mDownTouchPosition = this.pointToPositionImage((int)e.getX(), (int)e.getY());
        if (this.mDownTouchPosition >= 0) {
            this.mDownTouchView = this.getChildAt(this.mDownTouchPosition - this.mFirstPosition);
            this.mDownTouchView.setPressed(true);
        }
        this.mIsFirstScroll = true;
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mShouldCallbackDuringFling) {
            this.removeCallbacks(this.mDisableSuppressSelectionChangedRunnable);
            if (!this.mSuppressSelectionChanged) {
                this.mSuppressSelectionChanged = true;
            }
        }
        this.mFlingRunnable.startUsingVelocity((int)velocityX);
        return true;
    }

    public void onLongPress(MotionEvent e) {
        if (this.mDownTouchPosition < 0) {
            return;
        }
        this.performHapticFeedback(0);
        long id = this.getItemIdAtPosition(this.mDownTouchPosition);
        this.dispatchLongPress(this.mDownTouchView, this.mDownTouchPosition, id);
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.getParent().requestDisallowInterceptTouchEvent(true);
        if (!this.mShouldCallbackDuringFling) {
            if (this.mIsFirstScroll) {
                if (!this.mSuppressSelectionChanged) {
                    this.mSuppressSelectionChanged = true;
                }
                this.postDelayed(this.mDisableSuppressSelectionChangedRunnable, 250L);
            }
        } else if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
        }
        this.trackMotionScroll((int)distanceX);
        this.mIsFirstScroll = false;
        return true;
    }

    public boolean onSingleTapUp(MotionEvent e) {
        if (this.mDownTouchPosition >= 0) {
            if (this.mShouldCallbackOnUnselectedItemClick || this.mDownTouchPosition == this.mSelectedPosition) {
                this.performItemClick(this.mDownTouchView, this.mDownTouchPosition, this.mAdapter.getItemId(this.mDownTouchPosition));
            }
            return true;
        }
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    private void Calculate3DPosition(CarouselItemImage child, int diameter, float angleOffset) {
        float x = -((float)(diameter / 2) * FloatMath.sin((float)(angleOffset *= (float)Math.PI / 180))) + (float)(diameter / 2) - (float)(child.getWidth() / 2);
        float z = (float)(diameter / 2) * (1.0f - FloatMath.cos((float)angleOffset));
        float y = (float)(-this.getHeight() / 2) + z * FloatMath.sin((float)this.mTheta);
        child.setItemX(x);
        child.setItemZ(z);
        child.setItemY(y);
    }

    private int calculateTop(View child, boolean duringLayout) {
        int myHeight = duringLayout ? this.getMeasuredHeight() : this.getHeight();
        int childHeight = duringLayout ? child.getMeasuredHeight() : child.getHeight();
        int childTop = 0;
        switch (this.mGravity) {
            case 48: {
                childTop = this.mSpinnerPadding.top;
                break;
            }
            case 16: {
                int availableSpace = myHeight - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - childHeight;
                childTop = this.mSpinnerPadding.top + availableSpace / 2;
                break;
            }
            case 80: {
                childTop = myHeight - this.mSpinnerPadding.bottom - childHeight;
            }
        }
        return childTop;
    }

    private boolean dispatchLongPress(View view, int position, long id) {
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, this.mDownTouchView, this.mDownTouchPosition, id);
        }
        if (!handled) {
            this.mContextMenuInfo = new CarouselAdapter.AdapterContextMenuInfo(view, position, id);
            handled = super.showContextMenuForChild((View)this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    private void dispatchPress(View child) {
        if (child != null) {
            child.setPressed(true);
        }
        this.setPressed(true);
    }

    private void dispatchUnpress() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            this.getChildAt(i).setPressed(false);
            --i;
        }
        this.setPressed(false);
    }

    private int getCenterOfGallery() {
        return (this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) / 2 + this.getPaddingLeft();
    }

    private static int getCenterOfView(View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    float getLimitedMotionScrollAmount(boolean motionToLeft, float deltaX) {
        int extremeItemPosition = motionToLeft ? this.getCount() - 1 : 0;
        View extremeChild = this.getChildAt(extremeItemPosition - this.getFirstVisiblePosition());
        if (extremeChild == null) {
            return deltaX;
        }
        int extremeChildCenter = CarouselImageView.getCenterOfView(extremeChild);
        int galleryCenter = this.getCenterOfGallery();
        if (motionToLeft ? extremeChildCenter <= galleryCenter : extremeChildCenter >= galleryCenter) {
            return 0.0f;
        }
        int centerDifference = galleryCenter - extremeChildCenter;
        return motionToLeft ? Math.max((float)centerDifference, deltaX) : Math.min((float)centerDifference, deltaX);
    }

    int getLimitedMotionScrollAmount(boolean motionToLeft, int deltaX) {
        int extremeItemPosition = motionToLeft ? this.mItemCount - 1 : 0;
        View extremeChild = this.getChildAt(extremeItemPosition - this.mFirstPosition);
        if (extremeChild == null) {
            return deltaX;
        }
        int extremeChildCenter = CarouselImageView.getCenterOfView(extremeChild);
        int galleryCenter = this.getCenterOfGallery();
        if (motionToLeft ? extremeChildCenter <= galleryCenter : extremeChildCenter >= galleryCenter) {
            return 0;
        }
        int centerDifference = galleryCenter - extremeChildCenter;
        return motionToLeft ? Math.max(centerDifference, deltaX) : Math.min(centerDifference, deltaX);
    }

    private void makeAndAddView(int position, float angleOffset) {
        if (!this.mDataChanged) {
            CarouselItemImage child = (CarouselItemImage)this.mRecycler.get(position);
            if (child != null) {
                this.setUpChild(child, child.getIndex(), angleOffset);
            } else {
                child = (CarouselItemImage)this.mAdapter.getView(position, null, (ViewGroup)this);
                this.setUpChild(child, child.getIndex(), angleOffset);
            }
            return;
        }
        CarouselItemImage child = (CarouselItemImage)this.mAdapter.getView(position, null, (ViewGroup)this);
        this.setUpChild(child, child.getIndex(), angleOffset);
    }

    void onCancel() {
        this.onUp();
    }

    private void onFinishedMovement() {
        if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
            super.selectionChanged();
        }
        this.checkSelectionChanged();
        this.invalidate();
    }

    void onUp() {
        if (this.mFlingRunnable.mRotator.isFinished()) {
            this.scrollIntoSlots();
        }
        this.dispatchUnpress();
    }

    private void scrollIntoSlots() {
        if (this.getChildCount() == 0 || this.mSelectedChild == null) {
            return;
        }
        ArrayList<CarouselItemImage> arr = new ArrayList<CarouselItemImage>();
        int i = 0;
        while (i < this.getAdapter().getCount()) {
            arr.add((CarouselItemImage)this.getAdapter().getView(i, null, null));
            ++i;
        }
        Collections.sort(arr, new Comparator<CarouselItemImage>(){

            @Override
            public int compare(CarouselItemImage c1, CarouselItemImage c2) {
                int a2;
                int a1 = (int)c1.getCurrentAngle();
                if (a1 > 180) {
                    a1 = 360 - a1;
                }
                if ((a2 = (int)c2.getCurrentAngle()) > 180) {
                    a2 = 360 - a2;
                }
                return a1 - a2;
            }
        });
        float angle = ((CarouselItemImage)arr.get(0)).getCurrentAngle();
        if (angle > 180.0f) {
            angle = -(360.0f - angle);
        }
        if (angle != 0.0f) {
            this.mFlingRunnable.startUsingDistance(-angle);
        } else {
            int position = ((CarouselItemImage)arr.get(0)).getIndex();
            this.setSelectedPositionInt(position);
            this.onFinishedMovement();
        }
    }

    void scrollToChild(int i) {
        CarouselItemImage view = (CarouselItemImage)this.getAdapter().getView(i, null, null);
        float angle = view.getCurrentAngle();
        if (angle == 0.0f) {
            return;
        }
        angle = angle > 180.0f ? 360.0f - angle : -angle;
        this.mFlingRunnable.startUsingDistance(angle);
    }

    public void setCallbackDuringFling(boolean shouldCallback) {
        this.mShouldCallbackDuringFling = shouldCallback;
    }

    public void setCallbackOnUnselectedItemClick(boolean shouldCallback) {
        this.mShouldCallbackOnUnselectedItemClick = shouldCallback;
    }

    public void setAnimationDuration(int animationDurationMillis) {
        this.mAnimationDuration = animationDurationMillis;
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    private void setUpChild(CarouselItemImage child, int index, float angleOffset) {
        int d;
        int h;
        int w;
        this.addViewInLayout((View)child, -1, this.generateDefaultLayoutParams());
        child.setSelected(index == this.mSelectedPosition);
        if (this.mInLayout) {
            w = child.getMeasuredWidth();
            h = child.getMeasuredHeight();
            d = this.getMeasuredWidth();
        } else {
            w = child.getMeasuredWidth();
            h = child.getMeasuredHeight();
            d = this.getWidth();
        }
        child.setCurrentAngle(angleOffset);
        child.measure(w, h);
        int childTop = this.calculateTop((View)child, true);
        int childLeft = 0;
        child.layout(childLeft, childTop, w, h);
        this.Calculate3DPosition(child, d, angleOffset);
    }

    void trackMotionScroll(float deltaAngle) {
        if (this.getChildCount() == 0) {
            return;
        }
        int i = 0;
        while (i < this.getAdapter().getCount()) {
            CarouselItemImage child = (CarouselItemImage)this.getAdapter().getView(i, null, null);
            float angle = child.getCurrentAngle();
            angle += deltaAngle;
            while (angle > 360.0f) {
                angle -= 360.0f;
            }
            while (angle < 0.0f) {
                angle += 360.0f;
            }
            child.setCurrentAngle(angle);
            this.Calculate3DPosition(child, this.getWidth(), angle);
            ++i;
        }
        this.mRecycler.clear();
        this.invalidate();
    }

    private void updateSelectedItemMetadata() {
        View oldSelectedChild = this.mSelectedChild;
        this.mSelectedChild = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        View child = this.mSelectedChild;
        if (child == null) {
            return;
        }
        child.setSelected(true);
        child.setFocusable(true);
        if (this.hasFocus()) {
            child.requestFocus();
        }
        if (oldSelectedChild != null) {
            oldSelectedChild.setSelected(false);
            oldSelectedChild.setFocusable(false);
        }
    }

    private class FlingRotateRunnable
    implements Runnable {
        private Rotator mRotator;
        private float mLastFlingAngle;

        public FlingRotateRunnable() {
            this.mRotator = new Rotator(CarouselImageView.this.getContext());
        }

        private void startCommon() {
            CarouselImageView.this.removeCallbacks(this);
        }

        public void startUsingVelocity(float initialVelocity) {
            if (initialVelocity == 0.0f) {
                return;
            }
            this.startCommon();
            this.mLastFlingAngle = 0.0f;
            this.mRotator.fling(initialVelocity);
            CarouselImageView.this.post(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startUsingDistance(float deltaAngle) {
            if (deltaAngle == 0.0f) {
                return;
            }
            this.startCommon();
            this.mLastFlingAngle = 0.0f;
            FlingRotateRunnable flingRotateRunnable = this;
            synchronized (flingRotateRunnable) {
                this.mRotator.startRotate(0.0f, -deltaAngle, CarouselImageView.this.mAnimationDuration);
            }
            CarouselImageView.this.post(this);
        }

        public void stop(boolean scrollIntoSlots) {
            CarouselImageView.this.removeCallbacks(this);
            this.endFling(scrollIntoSlots);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endFling(boolean scrollIntoSlots) {
            FlingRotateRunnable flingRotateRunnable = this;
            synchronized (flingRotateRunnable) {
                this.mRotator.forceFinished(true);
            }
            if (scrollIntoSlots) {
                CarouselImageView.this.scrollIntoSlots();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            float angle;
            boolean more;
            if (CarouselImageView.this.getChildCount() == 0) {
                this.endFling(true);
                return;
            }
            CarouselImageView.this.mShouldStopFling = false;
            FlingRotateRunnable flingRotateRunnable = this;
            synchronized (flingRotateRunnable) {
                Rotator rotator = this.mRotator;
                more = rotator.computeAngleOffset();
                angle = rotator.getCurrAngle();
            }
            float delta = this.mLastFlingAngle - angle;
            CarouselImageView.this.trackMotionScroll(delta);
            if (more && !CarouselImageView.this.mShouldStopFling) {
                this.mLastFlingAngle = angle;
                CarouselImageView.this.post(this);
            } else {
                this.mLastFlingAngle = 0.0f;
                this.endFling(true);
            }
        }
    }
}

