/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.ab.view.chart.LineChart;
import com.ab.view.chart.Point;
import com.ab.view.chart.XYMultipleSeriesDataset;
import com.ab.view.chart.XYMultipleSeriesRenderer;

public class AreaChart
extends LineChart {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "Area";
    private float firstMultiplier;
    private float secondMultiplier;
    private Point p1 = new Point();
    private Point p2 = new Point();
    private Point p3 = new Point();

    public AreaChart() {
        this.firstMultiplier = 0.33f;
        this.secondMultiplier = 1.0f - this.firstMultiplier;
    }

    public AreaChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, float smoothness) {
        super(dataset, renderer);
        this.firstMultiplier = smoothness;
        this.secondMultiplier = 1.0f - this.firstMultiplier;
    }

    @Override
    protected void drawPath(Canvas canvas, float[] points, Paint paint, boolean circular) {
        Path p = new Path();
        float x = points[0];
        float y = points[1];
        p.moveTo(x, y);
        int length = points.length;
        if (circular) {
            length -= 4;
        }
        int i = 0;
        while (i < length) {
            int nextIndex = i + 2 < length ? i + 2 : i;
            int nextNextIndex = i + 4 < length ? i + 4 : nextIndex;
            this.calc(points, this.p1, i, nextIndex, this.secondMultiplier);
            this.p2.setX(points[nextIndex]);
            this.p2.setY(points[nextIndex + 1]);
            this.calc(points, this.p3, nextIndex, nextNextIndex, this.firstMultiplier);
            p.cubicTo(this.p1.getX(), this.p1.getY(), this.p2.getX(), this.p2.getY(), this.p3.getX(), this.p3.getY());
            i += 2;
        }
        if (circular) {
            i = length;
            while (i < length + 4) {
                p.lineTo(points[i], points[i + 1]);
                i += 2;
            }
            p.lineTo(points[0], points[1]);
        }
        canvas.drawPath(p, paint);
    }

    private void calc(float[] points, Point result, int index1, int index2, float multiplier) {
        float p1x = points[index1];
        float p1y = points[index1 + 1];
        float p2x = points[index2];
        float p2y = points[index2 + 1];
        float diffX = p2x - p1x;
        float diffY = p2y - p1y;
        result.setX(p1x + diffX * multiplier);
        result.setY(p1y + diffY * multiplier);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

