/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.GradientDrawable;
import com.ab.view.chart.ClickableArea;
import com.ab.view.chart.SimpleSeriesRenderer;
import com.ab.view.chart.XYChart;
import com.ab.view.chart.XYMultipleSeriesDataset;
import com.ab.view.chart.XYMultipleSeriesRenderer;
import com.ab.view.chart.XYSeries;

public class BarChart
extends XYChart {
    public static final String TYPE = "Bar";
    private static final int SHAPE_WIDTH = 12;
    protected Type mType = Type.DEFAULT;

    BarChart() {
    }

    BarChart(Type type) {
        this.mType = type;
    }

    public BarChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer, Type type) {
        super(dataset, renderer);
        this.mType = type;
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(float[] points, double[] values, float yAxisValue, int seriesIndex, int startIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        int length = points.length;
        ClickableArea[] ret = new ClickableArea[length / 2];
        float halfDiffX = this.getHalfDiffX(points, length, seriesNr);
        int i = 0;
        while (i < length) {
            float x = points[i];
            float y = points[i + 1];
            if (this.mType == Type.STACKED) {
                ret[i / 2] = new ClickableArea(new RectF(x - halfDiffX, y, x + halfDiffX, yAxisValue), values[i], values[i + 1]);
            } else {
                float startX = x - (float)seriesNr * halfDiffX + (float)(seriesIndex * 2) * halfDiffX;
                ret[i / 2] = new ClickableArea(new RectF(startX, y, startX + 2.0f * halfDiffX, yAxisValue), values[i], values[i + 1]);
            }
            i += 2;
        }
        return ret;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, int[] colors, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, int startIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        int length = points.length;
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float halfDiffX = this.getHalfDiffX(points, length, seriesNr);
        int i = 0;
        while (i < length) {
            float x = points[i];
            float y = points[i + 1];
            this.drawBar(canvas, x, yAxisValue, x, y, halfDiffX, seriesNr, seriesIndex, paint);
            i += 2;
        }
        paint.setColor(seriesRenderer.getColor());
    }

    protected void drawBar(Canvas canvas, float xMin, float yMin, float xMax, float yMax, float halfDiffX, int seriesNr, int seriesIndex, Paint paint) {
        int scale = this.mDataset.getSeriesAt(seriesIndex).getScaleNumber();
        if (this.mType == Type.STACKED) {
            this.drawBar(canvas, xMin - halfDiffX, yMax, xMax + halfDiffX, yMin, scale, seriesIndex, paint);
        } else {
            float startX = xMin - (float)seriesNr * halfDiffX + (float)(seriesIndex * 2) * halfDiffX;
            this.drawBar(canvas, startX, yMax, startX + 2.0f * halfDiffX, yMin, scale, seriesIndex, paint);
        }
    }

    private void drawBar(Canvas canvas, float xMin, float yMin, float xMax, float yMax, int scale, int seriesIndex, Paint paint) {
        SimpleSeriesRenderer renderer = this.mRenderer.getSeriesRendererAt(seriesIndex);
        if (renderer.isGradientEnabled()) {
            int gradientMaxColor;
            float minY = (float)this.toScreenPoint(new double[]{0.0, renderer.getGradientStopValue()}, scale)[1];
            float maxY = (float)this.toScreenPoint(new double[]{0.0, renderer.getGradientStartValue()}, scale)[1];
            float gradientMinY = Math.max(minY, Math.min(yMin, yMax));
            float gradientMaxY = Math.min(maxY, Math.max(yMin, yMax));
            int gradientMinColor = renderer.getGradientStopColor();
            int gradientStartColor = gradientMaxColor = renderer.getGradientStartColor();
            int gradientStopColor = gradientMinColor;
            if (yMin < minY) {
                paint.setColor(gradientMinColor);
                canvas.drawRect((float)Math.round(xMin), (float)Math.round(yMin), (float)Math.round(xMax), (float)Math.round(gradientMinY), paint);
            } else {
                gradientStopColor = this.getGradientPartialColor(gradientMinColor, gradientMaxColor, (maxY - gradientMinY) / (maxY - minY));
            }
            if (yMax > maxY) {
                paint.setColor(gradientMaxColor);
                canvas.drawRect((float)Math.round(xMin), (float)Math.round(gradientMaxY), (float)Math.round(xMax), (float)Math.round(yMax), paint);
            } else {
                gradientStartColor = this.getGradientPartialColor(gradientMaxColor, gradientMinColor, (gradientMaxY - minY) / (maxY - minY));
            }
            GradientDrawable gradient = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{gradientStartColor, gradientStopColor});
            gradient.setBounds(Math.round(xMin), Math.round(gradientMinY), Math.round(xMax), Math.round(gradientMaxY));
            gradient.draw(canvas);
        } else {
            if (Math.abs(yMin - yMax) < 1.0f) {
                yMax = yMin < yMax ? yMin + 1.0f : yMin - 1.0f;
            }
            canvas.drawRect((float)Math.round(xMin), (float)Math.round(yMin), (float)Math.round(xMax), (float)Math.round(yMax), paint);
        }
    }

    private int getGradientPartialColor(int minColor, int maxColor, float fraction) {
        int alpha = Math.round(fraction * (float)Color.alpha((int)minColor) + (1.0f - fraction) * (float)Color.alpha((int)maxColor));
        int r = Math.round(fraction * (float)Color.red((int)minColor) + (1.0f - fraction) * (float)Color.red((int)maxColor));
        int g = Math.round(fraction * (float)Color.green((int)minColor) + (1.0f - fraction) * (float)Color.green((int)maxColor));
        int b = Math.round(fraction * (float)Color.blue((int)minColor) + (1.0f - fraction) * (float)Color.blue((int)maxColor));
        return Color.argb((int)alpha, (int)r, (int)g, (int)b);
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries series, SimpleSeriesRenderer renderer, Paint paint, float[] points, int seriesIndex, int startIndex) {
        int seriesNr = this.mDataset.getSeriesCount();
        float halfDiffX = this.getHalfDiffX(points, points.length, seriesNr);
        int i = 0;
        while (i < points.length) {
            int index = startIndex + i / 2;
            double value = series.getY(index);
            if (!this.isNullValue(value)) {
                float x = points[i];
                if (this.mType == Type.DEFAULT) {
                    x += (float)(seriesIndex * 2) * halfDiffX - ((float)seriesNr - 1.5f) * halfDiffX;
                }
                if (value > 0.0) {
                    this.drawText(canvas, this.getLabel(value), x, points[i + 1] - renderer.getChartValuesSpacing(), paint, 0.0f);
                } else if (value < 0.0) {
                    this.drawText(canvas, this.getLabel(value), x, points[i + 1] + renderer.getChartValuesTextSize() + renderer.getChartValuesSpacing() - 3.0f, paint, 0.0f);
                } else if (value == 0.0 && this.mRenderer.isDisplayValue0()) {
                    this.drawText(canvas, this.getLabel(value), x, points[i + 1] - renderer.getChartValuesSpacing(), paint, 0.0f);
                }
            }
            i += 2;
        }
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 12;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        float halfShapeWidth = 6.0f;
        canvas.drawRect(x, y - halfShapeWidth, x + 12.0f, y + halfShapeWidth, paint);
    }

    protected float getHalfDiffX(float[] points, int length, int seriesNr) {
        float halfDiffX;
        int div = length;
        if (length > 2) {
            div = length - 2;
        }
        if ((halfDiffX = (points[length - 2] - points[0]) / (float)div) == 0.0f) {
            halfDiffX = 10.0f;
        }
        if (this.mType != Type.STACKED) {
            halfDiffX /= (float)seriesNr;
        }
        return (float)((double)halfDiffX / ((double)this.getCoeficient() * (1.0 + this.mRenderer.getBarSpacing())));
    }

    protected float getCoeficient() {
        return 1.0f;
    }

    @Override
    protected boolean isRenderNullValues() {
        return true;
    }

    @Override
    public double getDefaultMinimum() {
        return 0.0;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    public static enum Type {
        DEFAULT,
        STACKED;

    }
}

