/*
 * Decompiled with CFR 0.152.
 */
package com.ab.view.chart;

import com.ab.view.chart.XYSeries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CategorySeries
implements Serializable {
    private String mTitle;
    private List<String> mCategories = new ArrayList<String>();
    private List<Double> mValues = new ArrayList<Double>();
    private List<Integer> mColors = new ArrayList<Integer>();
    List<String> mExplains = new ArrayList<String>();

    public CategorySeries(String title) {
        this.mTitle = title;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public synchronized void add(double value) {
        this.add(String.valueOf(this.mCategories.size()), value);
    }

    public synchronized void add(double value, int color) {
        this.add(String.valueOf(this.mCategories.size()), value, color);
    }

    public synchronized void add(double value, int color, String explain) {
        this.add(String.valueOf(this.mCategories.size()), value, color, explain);
    }

    public synchronized void add(String category, double value) {
        this.mCategories.add(category);
        this.mValues.add(value);
    }

    public synchronized void add(String category, double value, int color) {
        this.mCategories.add(category);
        this.mValues.add(value);
        this.mColors.add(color);
    }

    public synchronized void add(String category, double value, int color, String explain) {
        this.mCategories.add(category);
        this.mValues.add(value);
        this.mColors.add(color);
        this.mExplains.add(explain);
    }

    public synchronized void set(int index, String category, double value) {
        this.mCategories.set(index, category);
        this.mValues.set(index, value);
    }

    public synchronized void remove(int index) {
        this.mCategories.remove(index);
        this.mValues.remove(index);
    }

    public synchronized void clear() {
        this.mCategories.clear();
        this.mValues.clear();
    }

    public synchronized double getValue(int index) {
        return this.mValues.get(index);
    }

    public synchronized String getCategory(int index) {
        return this.mCategories.get(index);
    }

    public List<Integer> getColors() {
        return this.mColors;
    }

    public List<String> getExplains() {
        return this.mExplains;
    }

    public synchronized int getItemCount() {
        return this.mCategories.size();
    }

    public XYSeries toXYSeries() {
        XYSeries xySeries = new XYSeries(this.mTitle);
        int i = 0;
        while (i < this.mValues.size()) {
            double value = this.mValues.get(i);
            xySeries.add(i + 1, value, this.mColors.get(i), this.mExplains.get(i));
            ++i;
        }
        return xySeries;
    }
}

